/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.ArrayList;
import tim.prune.cmd.Command;
import tim.prune.data.TrackInfo;

public class CompoundCommand
extends Command {
    private final ArrayList<Command> _commands = new ArrayList();
    private final int _updateFlags;

    public CompoundCommand() {
        this(0);
    }

    public CompoundCommand(int n) {
        super(null);
        this._updateFlags = n;
    }

    protected CompoundCommand(CompoundCommand compoundCommand) {
        super(compoundCommand);
        this._updateFlags = 0;
    }

    public CompoundCommand addCommand(Command command) {
        if (command != null) {
            this._commands.add(command);
        }
        return this;
    }

    @Override
    public int getUpdateFlags() {
        int n = this._updateFlags;
        for (Command command : this._commands) {
            n |= command.getUpdateFlags();
        }
        return n;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        boolean bl = true;
        for (Command command : this._commands) {
            bl &= command.executeCommand(trackInfo);
        }
        return bl;
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        CompoundCommand compoundCommand = new CompoundCommand(this);
        int n = this._commands.size() - 1;
        while (n >= 0) {
            Command command = this._commands.get(n);
            Command command2 = command.makeInverse(trackInfo);
            command.setInverse(command2);
            compoundCommand.addCommand(command2);
            --n;
        }
        return compoundCommand;
    }

    protected CompoundCommand makeInverse(TrackInfo trackInfo, Command ... commandArray) {
        CompoundCommand compoundCommand = new CompoundCommand(this);
        int n = this._commands.size() - 1;
        while (n >= 0) {
            Command command = this._commands.get(n);
            Command command2 = commandArray[n];
            if (command2 == null) {
                command2 = command.makeInverse(trackInfo);
            }
            command.setInverse(command2);
            compoundCommand.addCommand(command2);
            --n;
        }
        return compoundCommand;
    }

    protected Command getCommand(int n) {
        return this._commands.get(n);
    }
}

