/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MigrateTranslation {
    private static String MSGID = "msgid \"";
    private static String MSGSTR = "msgstr \"";

    public static void main(String[] args) {
        try {
            MigrateTranslation.migrateLocale("de", "German", "Germany");
            MigrateTranslation.migrateLocale("da", "Danish", "Denmark");
            MigrateTranslation.migrateLocale("fr", "French", "France");
            MigrateTranslation.migrateLocale("en_GB", "English", "United Kingdom");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void migrateLocale(String locale, String language, String country) throws Exception {
        System.out.println("Migrating locale " + locale);
        String rootDirectoryName = System.getProperty("user.dir");
        String poFileName = String.valueOf(rootDirectoryName) + "/i18n/" + locale + ".po";
        File poFile = new File(poFileName);
        if (!poFile.exists()) {
            System.err.println("Can't find file " + poFileName);
        }
        String propertiesFileName = String.valueOf(rootDirectoryName) + "/res/org/fibs/geotag/geotag.properties";
        Map<String, String> originalMap = MigrateTranslation.storeProperties(propertiesFileName);
        propertiesFileName = String.valueOf(rootDirectoryName) + "/res/org/fibs/geotag/geotag_" + locale + ".properties";
        Map<String, String> localeMap = MigrateTranslation.storeProperties(propertiesFileName);
        Map<String, String> translationMap = MigrateTranslation.buildTranslation(originalMap, localeMap);
        MigrateTranslation.applyTranslation(language, country, translationMap, poFile);
    }

    private static void applyTranslation(String language, String country, Map<String, String> translation, File poFile) throws Exception {
        File tempFile = File.createTempFile(poFile.getName(), null);
        tempFile.deleteOnExit();
        System.out.println(tempFile);
        BufferedWriter tempFileWriter = new BufferedWriter(new FileWriter(tempFile));
        MigrateTranslation.writeHeader(tempFileWriter, language, country);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(poFile));
        String lineFromFile = null;
        StringBuilder msgId = null;
        while ((lineFromFile = bufferedReader.readLine()) != null) {
            if (lineFromFile.startsWith("#")) {
                tempFileWriter.write(lineFromFile);
                tempFileWriter.newLine();
                continue;
            }
            if (lineFromFile.startsWith(MSGID)) {
                msgId = new StringBuilder();
                msgId.append(lineFromFile.substring(MSGID.length(), lineFromFile.length() - 1));
                tempFileWriter.write(lineFromFile);
                tempFileWriter.newLine();
                continue;
            }
            if (msgId != null && lineFromFile.startsWith("\"")) {
                msgId.append(lineFromFile.substring(1, lineFromFile.length() - 1));
                tempFileWriter.write(lineFromFile);
                tempFileWriter.newLine();
                continue;
            }
            if (msgId != null && lineFromFile.startsWith(MSGSTR)) {
                String msgstr = translation.get(msgId.toString());
                if (msgstr != null) {
                    MigrateTranslation.writeMsgstr(tempFileWriter, msgstr);
                    continue;
                }
                tempFileWriter.write(lineFromFile);
                tempFileWriter.newLine();
                continue;
            }
            tempFileWriter.write(lineFromFile);
            tempFileWriter.newLine();
        }
        bufferedReader.close();
        bufferedReader = null;
        tempFileWriter.close();
        MigrateTranslation.overwrite(tempFile, poFile);
    }

    private static void writeHeader(BufferedWriter tempFileWriter, String language, String country) {
        try {
            tempFileWriter.write("msgid \"\"");
            tempFileWriter.newLine();
            tempFileWriter.write("msgstr \"\"");
            tempFileWriter.newLine();
            tempFileWriter.write("\"Project-Id-Version: Geotag\\n\"");
            tempFileWriter.newLine();
            tempFileWriter.write("\"Content-Type: text/plain; charset=utf-8\\n\"");
            tempFileWriter.newLine();
            tempFileWriter.write("\"Content-Transfer-Encoding: 8bit\\n\"");
            tempFileWriter.newLine();
            tempFileWriter.write("\"X-Poedit-Language: " + language + "\\n\"");
            tempFileWriter.newLine();
            tempFileWriter.write("\"X-Poedit-Country: " + country + "\\n\"");
            tempFileWriter.newLine();
            tempFileWriter.write("\"X-Poedit-SourceCharset: utf-8\\n\"");
            tempFileWriter.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeMsgstr(BufferedWriter tempFileWriter, String msgstr) throws IOException {
        if (msgstr.length() < 800 - MSGSTR.length() - 1) {
            tempFileWriter.write(MSGSTR);
            int index = 0;
            while (index < msgstr.length()) {
                char character = msgstr.charAt(index);
                if (character == '\"') {
                    tempFileWriter.write(92);
                }
                tempFileWriter.write(character);
                ++index;
            }
            tempFileWriter.write("\"");
            tempFileWriter.newLine();
        }
    }

    private static void overwrite(File from, File to) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(from));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(to));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
            bufferedReader.close();
            bufferedWriter.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, String> buildTranslation(Map<String, String> from, Map<String, String> to) {
        HashMap<String, String> translationMap = new HashMap<String, String>();
        HashMap<String, String> firstKeyMap = new HashMap<String, String>();
        Set<String> keys = from.keySet();
        for (String key : keys) {
            String originalText = from.get(key);
            String translatedText = to.get(key);
            if (translatedText == null) continue;
            if (translationMap.containsKey(originalText)) {
                String knownTranslation = (String)translationMap.get(originalText);
                if (knownTranslation != null && knownTranslation.equals(translatedText)) continue;
                String firstKey = (String)firstKeyMap.get(originalText);
                System.err.println(String.valueOf(firstKey) + "/" + key + " " + originalText + ": " + knownTranslation + "!=" + translatedText);
                continue;
            }
            translationMap.put(originalText, translatedText);
            firstKeyMap.put(originalText, key);
        }
        return translationMap;
    }

    private static Map<String, String> storeProperties(String fileName) {
        HashMap<String, String> map = new HashMap<String, String>();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(0);
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            if (map.containsKey(key)) {
                System.err.println("Dupicate " + value);
            }
            map.put(key, value);
        }
        return map;
    }
}

