/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.theme;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Polygon;
import javax.swing.border.Border;
import net.infonode.gui.HighlightPainter;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.colorprovider.BackgroundPainterColorProvider;
import net.infonode.gui.colorprovider.ColorBlender;
import net.infonode.gui.colorprovider.ColorMultiplier;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.tabbedpanel.border.OpenContentBorder;
import net.infonode.tabbedpanel.internal.SlopedTabLineBorder;
import net.infonode.tabbedpanel.theme.TabbedPanelTitledTabTheme;
import net.infonode.tabbedpanel.titledtab.TitledTabBorderSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;
import net.infonode.tabbedpanel.titledtab.TitledTabStateProperties;

public class ShapedGradientTheme
extends TabbedPanelTitledTabTheme {
    private static final int CORNER_INSET = 3;
    private ColorProvider highlightColor;
    private ColorProvider lineColor;
    private ColorProvider controlColor;
    private ColorProvider darkControlColor;
    private ColorProvider alternateHighlight;
    private int leftSlopeHeight;
    private int rightSlopeHeight;
    private TabbedPanelProperties tabbedPanelProperties = new TabbedPanelProperties();
    private TitledTabProperties titledTabProperties = new TitledTabProperties();

    public ShapedGradientTheme() {
        this(0.0f, 0.5f);
    }

    public ShapedGradientTheme(float leftSlope, float rightSlope) {
        this(leftSlope, rightSlope, UIManagerColorProvider.TABBED_PANE_DARK_SHADOW, UIManagerColorProvider.TABBED_PANE_HIGHLIGHT);
    }

    public ShapedGradientTheme(float leftSlope, float rightSlope, ColorProvider lineColor, ColorProvider highlightColor) {
        this(leftSlope, rightSlope, 25, lineColor, highlightColor);
    }

    public ShapedGradientTheme(float leftSlope, float rightSlope, int slopeHeight, ColorProvider lineColor, ColorProvider highlightColor) {
        this.leftSlopeHeight = slopeHeight;
        this.rightSlopeHeight = slopeHeight;
        this.highlightColor = highlightColor;
        this.lineColor = lineColor;
        this.controlColor = UIManagerColorProvider.CONTROL_COLOR;
        this.darkControlColor = UIManagerColorProvider.TABBED_PANE_BACKGROUND;
        this.alternateHighlight = highlightColor != null ? new ColorBlender(highlightColor, this.controlColor, 0.3f) : new ColorMultiplier(this.controlColor, 1.2);
        GradientComponentPainter blendedComponentPainter = new GradientComponentPainter(this.alternateHighlight, this.alternateHighlight, this.controlColor, this.controlColor);
        int leftSlopeWidth = (int)(leftSlope * (float)this.leftSlopeHeight);
        int rightSlopeWidth = (int)(rightSlope * (float)this.rightSlopeHeight);
        int highlightedRaised = 2;
        boolean bottomLeftRounded = true;
        boolean topLeftRounded = true;
        boolean topRightRounded = true;
        boolean bottomRightRounded = true;
        this.titledTabProperties.setHighlightedRaised(highlightedRaised).setBorderSizePolicy(TitledTabBorderSizePolicy.EQUAL_SIZE);
        TitledTabStateProperties normalState = this.titledTabProperties.getNormalProperties();
        TitledTabStateProperties highlightState = this.titledTabProperties.getHighlightedProperties();
        TitledTabStateProperties disabledState = this.titledTabProperties.getDisabledProperties();
        TabBorder normalBorder = new TabBorder(lineColor, null, leftSlope, rightSlope, this.leftSlopeHeight, this.rightSlopeHeight, false, topLeftRounded, topRightRounded, false, true, true, highlightedRaised);
        TabBorder highlightBorder = new TabBorder(lineColor, highlightColor, leftSlope, rightSlope, this.leftSlopeHeight, this.rightSlopeHeight, bottomLeftRounded, topLeftRounded, topRightRounded, bottomRightRounded, false, true, highlightedRaised);
        normalState.getComponentProperties().setBorder(normalBorder).setInsets(new Insets(0, 0, 0, 0));
        highlightState.getComponentProperties().setBorder(highlightBorder);
        ColorMultiplier darkControlColor1 = new ColorMultiplier(this.darkControlColor, 1.1);
        ColorMultiplier darkControlColor2 = new ColorMultiplier(this.darkControlColor, 0.92);
        GradientComponentPainter normalComponentPainter = new GradientComponentPainter(darkControlColor1, darkControlColor1, darkControlColor2, darkControlColor2);
        normalState.getShapedPanelProperties().setOpaque(false).setComponentPainter(normalComponentPainter);
        disabledState.getShapedPanelProperties().setComponentPainter(normalComponentPainter);
        if (highlightColor == null) {
            highlightState.getShapedPanelProperties().setComponentPainter(blendedComponentPainter);
        } else {
            highlightState.getShapedPanelProperties().setComponentPainter(new GradientComponentPainter(highlightColor, highlightColor, this.controlColor, this.controlColor));
        }
        Insets insets = normalBorder.getBorderInsets(null);
        int tabSpacing = 1 + insets.left + insets.right - (topLeftRounded ? 3 : 0) - (topRightRounded ? 3 : 0) - (int)(0.2 * (double)(leftSlopeWidth + rightSlopeWidth));
        this.tabbedPanelProperties.setTabSpacing(-tabSpacing).setShadowEnabled(false);
        this.tabbedPanelProperties.getTabAreaComponentsProperties().getComponentProperties().setBorder(new SlopedTabLineBorder(lineColor, highlightColor, false, 0.0f, 0.0f, 0, 0, false, topLeftRounded, topRightRounded, false)).setInsets(new Insets(0, 0, 0, 0));
        this.tabbedPanelProperties.getTabAreaComponentsProperties().getShapedPanelProperties().setComponentPainter(blendedComponentPainter);
        this.tabbedPanelProperties.getTabAreaProperties().getShapedPanelProperties().setOpaque(false);
        this.tabbedPanelProperties.getContentPanelProperties().getComponentProperties().setBorder(new OpenContentBorder(lineColor, lineColor, highlightColor == null ? null : new ColorBlender(highlightColor, BackgroundPainterColorProvider.INSTANCE, HighlightPainter.getBlendFactor(1, 0)), 1));
    }

    @Override
    public String getName() {
        return "Shaped Gradient Theme";
    }

    @Override
    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.tabbedPanelProperties;
    }

    @Override
    public TitledTabProperties getTitledTabProperties() {
        return this.titledTabProperties;
    }

    public ColorProvider getLineColor() {
        return this.lineColor;
    }

    public ColorProvider getHighlightColor() {
        return this.highlightColor;
    }

    public ColorProvider getAlternateHighlightColor() {
        return this.alternateHighlight;
    }

    public ColorProvider getControlColor() {
        return this.controlColor;
    }

    public ColorProvider getDarkControlColor() {
        return this.darkControlColor;
    }

    public Border createTabBorder(ColorProvider lineColor, ColorProvider highlightColor, float leftSlope, float rightSlope, boolean bottomLeftRounded, boolean topLeftRounded, boolean topRightRounded, boolean bottomRightRounded, boolean isNormal, boolean highlightBottomLeftRounded, int raised) {
        return new TabBorder(lineColor, highlightColor, leftSlope, rightSlope, 25, 25, bottomLeftRounded, topLeftRounded, topRightRounded, bottomRightRounded, isNormal, highlightBottomLeftRounded, raised);
    }

    private static class TabBorder
    extends SlopedTabLineBorder {
        private boolean bottomLeftRounded;
        private boolean isNormal;
        private boolean hasLeftSlope;
        private int raised;
        private int cornerInset;

        TabBorder(ColorProvider lineColor, ColorProvider highlightColor, float leftSlope, float rightSlope, int leftHeight, int rightHeight, boolean bottomLeftRounded, boolean topLeftRounded, boolean topRightRounded, boolean bottomRightRounded, boolean isNormal, boolean highlightBottomLeftRounded, int raised) {
            super(lineColor, highlightColor, false, leftSlope, rightSlope, leftHeight, rightHeight, isNormal ? false : bottomLeftRounded, topLeftRounded, topRightRounded, bottomRightRounded);
            this.bottomLeftRounded = bottomLeftRounded;
            this.isNormal = isNormal;
            this.raised = raised;
            this.hasLeftSlope = leftSlope > 0.0f;
            this.cornerInset = highlightBottomLeftRounded ? 3 : 0;
        }

        @Override
        protected Polygon createPolygon(Component c, int width, int height) {
            Polygon p = super.createPolygon(c, width, height);
            if (this.isNormal) {
                int leftX = width / 2;
                boolean first = this.isFirst(c);
                int i = 0;
                while (i < p.npoints) {
                    p.xpoints[i] = p.xpoints[i] < leftX ? p.xpoints[i] + this.raised + (first ? 0 : this.cornerInset) : p.xpoints[i] - this.raised - this.cornerInset;
                    ++i;
                }
            }
            return p;
        }

        @Override
        protected Insets getShapedBorderInsets(Component c) {
            Insets i = super.getShapedBorderInsets(c);
            Insets addInsets = new Insets(0, 0, 0, 1 + this.raised);
            if (this.isNormal && !this.isFirst(c)) {
                addInsets.left += this.cornerInset;
            }
            if (!this.isNormal) {
                addInsets.right -= this.cornerInset;
            }
            return InsetsUtil.add(i, addInsets);
        }

        private boolean isFirst(Component c) {
            Tab tab;
            if (!this.hasLeftSlope && (tab = TabbedUtils.getParentTab(c)) != null && tab.getTabbedPanel() != null) {
                return tab.getTabbedPanel().getTabAt(0) == tab;
            }
            return false;
        }

        @Override
        protected boolean isBottomLeftRounded(Component c) {
            return this.isFirst(c) ? false : this.bottomLeftRounded;
        }
    }
}

