/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute.mindmapmode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.IListModel;
import org.freeplane.features.attribute.mindmapmode.AttributeManagerDialog;

class AttributeRegistryTable
extends JTable {
    private static final Icon checkBoxImage = ResourceController.getResourceController().getIcon("/images/checkbox12.svg");
    private static final ButtonRenderer editButtonRenderer = new ButtonRenderer(AttributeManagerDialog.editButtonImage, TextUtils.getText((String)"attributes_edit.tooltip"));
    private static final long serialVersionUID = 1L;
    private final AttributeManagerDialog.EditListAction editListAction;
    private final ButtonEditor selectAllButtonEditor;
    private final ButtonRenderer selectAllButtonRenderer;

    public AttributeRegistryTable(AttributeManagerDialog.EditListAction editListAction) {
        this.editListAction = editListAction;
        this.getTableHeader().setReorderingAllowed(false);
        this.selectAllButtonRenderer = new ButtonRenderer(checkBoxImage, TextUtils.getText((String)"attributes_select_all.tooltip"));
        this.selectAllButtonEditor = new ButtonEditor(new ToggleAllAction());
        this.setDefaultEditor(IListModel.class, new ButtonEditor(editListAction));
        this.setDefaultRenderer(IListModel.class, editButtonRenderer);
        this.setRowHeight(UITools.getDefaultLabelFont().getSize() * 5 / 4);
        this.setRowSelectionAllowed(false);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (row == 0 && column == 1) {
            return this.selectAllButtonEditor;
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (row == 0 && column == 1) {
            return this.selectAllButtonRenderer;
        }
        TableCellRenderer tableCellRenderer = super.getCellRenderer(row, column);
        if (tableCellRenderer instanceof JLabel) {
            JLabel label = (JLabel)((Object)tableCellRenderer);
            if (row == 0) {
                label.setHorizontalAlignment(0);
            } else {
                label.setHorizontalAlignment(2);
            }
        } else if (tableCellRenderer instanceof JComponent) {
            JComponent label = (JComponent)((Object)tableCellRenderer);
            switch (column) {
                case 1: {
                    label.setToolTipText(TextUtils.getText((String)"attributes_visible.tooltip"));
                    break;
                }
                case 2: {
                    if (row == 0) {
                        label.setToolTipText(TextUtils.getText((String)"attributes_restricted_attributes.tooltip"));
                        break;
                    }
                    label.setToolTipText(TextUtils.getText((String)"attributes_restricted_values.tooltip"));
                }
            }
        }
        return tableCellRenderer;
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        if (column == 3) {
            IListModel list = (IListModel)this.getModel().getValueAt(row, column);
            String title = this.getModel().getValueAt(row, 0).toString();
            String labelText = TextUtils.getText((String)"attribute_list_box_label_text");
            this.editListAction.setListBoxModel(title, labelText, list);
        }
        return super.prepareEditor(editor, row, column);
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        if (dataModel.getColumnCount() >= 1) {
            for (int i = 1; i < this.getColumnCount(); ++i) {
                this.getColumnModel().getColumn(i).setMinWidth(20);
                int prefWidth = this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)this, (Object)this.getColumnName((int)i), (boolean)false, (boolean)false, (int)-1, (int)i).getPreferredSize().width;
                this.getColumnModel().getColumn(i).setPreferredWidth(prefWidth);
            }
        }
    }

    private static class ButtonRenderer
    implements TableCellRenderer {
        private final JButton renderingEditButton;

        public ButtonRenderer(Icon image, String toolTip) {
            this.renderingEditButton = new JButton(image);
            this.renderingEditButton.setFocusable(false);
            this.renderingEditButton.setToolTipText(toolTip);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.renderingEditButton;
        }
    }

    private static class ButtonEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private final JButton editButton;
        private Object value;

        public ButtonEditor(Action action) {
            this.editButton = new JButton(action);
            this.editButton.setFocusable(false);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = value;
            return this.editButton;
        }
    }

    private class ToggleAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ToggleAllAction() {
            super(null, checkBoxImage);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int rowCount = AttributeRegistryTable.this.getRowCount();
            if (rowCount <= 1) {
                return;
            }
            Boolean checked = (Boolean)AttributeRegistryTable.this.getValueAt(1, 1);
            checked = checked == false;
            for (int i = 1; i < rowCount; ++i) {
                AttributeRegistryTable.this.setValueAt(checked, i, 1);
            }
        }
    }
}

