/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.http.Cookie;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketResponse
extends WebResponse {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketResponse.class);
    private final IWebSocketConnection connection;
    private StringBuilder text;
    private ByteArrayOutputStream binary;
    private boolean isRedirect = false;

    public WebSocketResponse(IWebSocketConnection conn) {
        this.connection = conn;
    }

    public void write(CharSequence sequence) {
        if (this.text == null) {
            this.text = new StringBuilder();
        }
        this.text.append(sequence);
    }

    public void write(byte[] array) {
        this.write(array, 0, array.length);
    }

    public void write(byte[] array, int offset, int length) {
        if (this.binary == null) {
            this.binary = new ByteArrayOutputStream();
        }
        this.binary.write(array, offset, length);
    }

    public void close() {
        if (this.connection.isOpen()) {
            try {
                if (this.text != null) {
                    this.connection.sendMessage(this.text.toString());
                    this.text = null;
                } else if (this.binary != null) {
                    byte[] bytes = this.binary.toByteArray();
                    this.connection.sendMessage(bytes, 0, bytes.length);
                    this.binary.close();
                    this.binary = null;
                }
            }
            catch (IOException iox) {
                LOG.error("An error occurred while writing response to WebSocket client.", (Throwable)iox);
            }
        }
        super.close();
    }

    public void reset() {
        this.text = null;
        if (this.binary != null) {
            try {
                this.binary.close();
            }
            catch (IOException iox) {
                LOG.error("An error occurred while resetting the binary content", (Throwable)iox);
            }
            this.binary = null;
        }
        this.isRedirect = false;
        super.reset();
    }

    public String encodeURL(CharSequence url) {
        return ((Object)url).toString();
    }

    public final IWebSocketConnection getContainerResponse() {
        return this.connection;
    }

    public void addCookie(Cookie cookie) {
        throw new UnsupportedOperationException();
    }

    public void clearCookie(Cookie cookie) {
        throw new UnsupportedOperationException();
    }

    public void setHeader(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public void addHeader(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public void setDateHeader(String name, Time date) {
        throw new UnsupportedOperationException();
    }

    public void setContentLength(long length) {
        throw new UnsupportedOperationException();
    }

    public void setContentType(String mimeType) {
        throw new UnsupportedOperationException();
    }

    public void setStatus(int sc) {
        throw new UnsupportedOperationException();
    }

    public void sendError(int sc, String msg) {
        LOG.warn("An HTTP error response in WebSocket communication would not be processed by the browser! If you need to send the error code and message to the client then configure custom WebSocketResponse via WebSocketSettings#newWebSocketResponse() factory method and override #sendError() method to write them in an appropriate format for your application. The ignored error code is '{}' and the message: '{}'.", (Object)sc, (Object)msg);
    }

    public String encodeRedirectURL(CharSequence url) {
        return ((Object)url).toString();
    }

    public void sendRedirect(String url) {
        this.isRedirect = true;
        url = this.encodeRedirectURL(url);
        String ajaxRedirect = "<ajax-response><redirect><![CDATA[" + url + "]]></redirect></ajax-response>";
        this.write(ajaxRedirect);
    }

    public boolean isRedirect() {
        return this.isRedirect;
    }

    public void flush() {
    }
}

