/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings.def;

import java.io.File;
import java.io.IOException;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.settings.IStoreSettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;

public class StoreSettings
implements IStoreSettings {
    private static final int DEFAULT_CACHE_SIZE = 0;
    private static final Bytes DEFAULT_MAX_SIZE_PER_SESSION = Bytes.megabytes((long)10L);
    private static final int DEFAULT_ASYNCHRONOUS_QUEUE_CAPACITY = 100;
    private int inmemoryCacheSize = 0;
    private Bytes maxSizePerSession = DEFAULT_MAX_SIZE_PER_SESSION;
    private File fileStoreFolder = null;
    private int asynchronousQueueCapacity = 100;
    private boolean isAsynchronous = true;

    public StoreSettings(Application application) {
    }

    @Override
    public int getInmemoryCacheSize() {
        return this.inmemoryCacheSize;
    }

    @Override
    public void setInmemoryCacheSize(int inmemoryCacheSize) {
        this.inmemoryCacheSize = inmemoryCacheSize;
    }

    @Override
    public Bytes getMaxSizePerSession() {
        return this.maxSizePerSession;
    }

    @Override
    public void setMaxSizePerSession(Bytes maxSizePerSession) {
        this.maxSizePerSession = (Bytes)Args.notNull((Object)maxSizePerSession, (String)"maxSizePerSession");
    }

    @Override
    public File getFileStoreFolder() {
        if (this.fileStoreFolder == null) {
            if (Application.exists()) {
                this.fileStoreFolder = (File)((WebApplication)Application.get()).getServletContext().getAttribute("javax.servlet.context.tempdir");
            }
            if (this.fileStoreFolder != null) {
                return this.fileStoreFolder;
            }
            try {
                this.fileStoreFolder = File.createTempFile("file-prefix", null).getParentFile();
            }
            catch (IOException e) {
                throw new WicketRuntimeException(e);
            }
        }
        return this.fileStoreFolder;
    }

    @Override
    public void setFileStoreFolder(File fileStoreFolder) {
        this.fileStoreFolder = (File)Args.notNull((Object)fileStoreFolder, (String)"fileStoreFolder");
    }

    @Override
    public int getAsynchronousQueueCapacity() {
        return this.asynchronousQueueCapacity;
    }

    @Override
    public void setAsynchronousQueueCapacity(int queueCapacity) {
        if (queueCapacity < 1) {
            throw new IllegalArgumentException("The capacity of the asynchronous queue should be at least 1.");
        }
        this.asynchronousQueueCapacity = queueCapacity;
    }

    @Override
    public void setAsynchronous(boolean async) {
        this.isAsynchronous = async;
    }

    @Override
    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }
}

