/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wicket.extensions.markup.html.form.select;

import java.util.Arrays;
import java.util.List;

import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;

/**
 */
public class SelectTestPage3 extends WebPage
{

	public Form<Void> form;
	public Select<Integer> select;
	public SelectOptions<Integer> options;

	public SelectTestPage3()
	{
		form = new Form<Void>("form");
		add(form);

		select = new Select<Integer>("select", new Model<Integer>(1));
		form.add(select);

		List<Integer> choices = Arrays.asList(1, 2, 3);

		IOptionRenderer<Integer> renderer = new IOptionRenderer<Integer>() {
			
			@Override
			public IModel<Integer> getModel(Integer value) {
				return Model.of(value);
			}
			
			@Override
			public String getDisplayValue(Integer object) {
				return "<" + object + ">";
			}
		};
		
		select.add(options = new SelectOptions<Integer>("options", new ListModel<Integer>(choices), renderer ));
	}
}
