/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.karaf.bundle.command.BundlesCommand;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.ShellUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

@Command(scope="bundle", name="capabilities", description="Displays OSGi capabilities of a given bundles.")
@Service
public class Capabilities
extends BundlesCommand {
    public static final String NONSTANDARD_SERVICE_NAMESPACE = "service";
    private static final String EMPTY_MESSAGE = "[EMPTY]";
    private static final String UNUSED_MESSAGE = "[UNUSED]";
    @Option(name="--namespace")
    String namespace = "*";

    @Override
    protected Object doExecute(List<Bundle> bundles) throws Exception {
        boolean separatorNeeded = false;
        Pattern ns = Pattern.compile(this.namespace.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*"));
        for (Bundle b : bundles) {
            BundleWiring wiring;
            if (separatorNeeded) {
                System.out.println();
            }
            if ((wiring = (BundleWiring)b.adapt(BundleWiring.class)) != null) {
                String title = b + " provides:";
                System.out.println(title);
                System.out.println(ShellUtil.getUnderlineString((String)title));
                boolean matches = Capabilities.printMatchingCapabilities(wiring, ns);
                if (Capabilities.matchNamespace(ns, NONSTANDARD_SERVICE_NAMESPACE)) {
                    matches |= Capabilities.printServiceCapabilities(b);
                }
                if (!matches) {
                    System.out.println(this.namespace + " [EMPTY]");
                }
            } else {
                System.out.println("Bundle " + b.getBundleId() + " is not resolved.");
            }
            separatorNeeded = true;
        }
        return null;
    }

    @Override
    protected void executeOnBundle(Bundle bundle) throws Exception {
    }

    private static boolean printMatchingCapabilities(BundleWiring wiring, Pattern namespace) {
        List wires = wiring.getProvidedWires(null);
        Map<BundleCapability, List<BundleWire>> aggregateCaps = Capabilities.aggregateCapabilities(namespace, wires);
        List allCaps = wiring.getCapabilities(null);
        boolean matches = false;
        for (BundleCapability cap : allCaps) {
            if (!Capabilities.matchNamespace(namespace, cap.getNamespace())) continue;
            matches = true;
            List<BundleWire> dependents = aggregateCaps.get(cap);
            Object keyAttr = cap.getAttributes().get(cap.getNamespace());
            if (dependents != null) {
                Object msg = keyAttr != null ? cap.getNamespace() + "; " + keyAttr + " " + Capabilities.getVersionFromCapability(cap) : cap.toString();
                msg = (String)msg + " required by:";
                System.out.println((String)msg);
                for (BundleWire wire : dependents) {
                    System.out.println("   " + wire.getRequirerWiring().getBundle());
                }
                continue;
            }
            if (keyAttr != null) {
                System.out.println(cap.getNamespace() + "; " + cap.getAttributes().get(cap.getNamespace()) + " " + Capabilities.getVersionFromCapability(cap) + " [UNUSED]");
                continue;
            }
            System.out.println(cap + " [UNUSED]");
        }
        return matches;
    }

    private static Map<BundleCapability, List<BundleWire>> aggregateCapabilities(Pattern namespace, List<BundleWire> wires) {
        HashMap<BundleCapability, List<BundleWire>> map = new HashMap<BundleCapability, List<BundleWire>>();
        for (BundleWire wire : wires) {
            if (!Capabilities.matchNamespace(namespace, wire.getCapability().getNamespace())) continue;
            map.computeIfAbsent(wire.getCapability(), k -> new ArrayList()).add(wire);
        }
        return map;
    }

    static boolean printServiceCapabilities(Bundle b) {
        boolean matches = false;
        try {
            ServiceReference[] refs = b.getRegisteredServices();
            if (refs != null && refs.length > 0) {
                matches = true;
                for (ServiceReference ref : refs) {
                    String[] keys;
                    System.out.println("service; " + ShellUtil.getValueString((Object)ref.getProperty("objectClass")) + " with properties:");
                    for (String key : keys = ref.getPropertyKeys()) {
                        if (key.equalsIgnoreCase("objectClass")) continue;
                        Object v = ref.getProperty(key);
                        System.out.println("   " + key + " = " + ShellUtil.getValueString((Object)v));
                    }
                    Bundle[] users = ref.getUsingBundles();
                    if (users == null || users.length <= 0) continue;
                    System.out.println("   Used by:");
                    for (Bundle user : users) {
                        System.out.println("      " + user);
                    }
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
        return matches;
    }

    private static String getVersionFromCapability(BundleCapability c) {
        Object o = c.getAttributes().get("version");
        if (o == null) {
            o = c.getAttributes().get("bundle-version");
        }
        return o == null ? "" : o.toString();
    }

    private static boolean matchNamespace(Pattern namespace, String actual) {
        return namespace.matcher(actual).matches();
    }
}

