/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovy.json.JsonBuilder;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.Writable;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import groovy.xml.StreamingMarkupBuilder;
import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.CharSequenceInputStream;
import groovyx.net.http.Form;
import groovyx.net.http.FromServer;
import groovyx.net.http.HttpException;
import groovyx.net.http.ReaderInputStream;
import groovyx.net.http.ToServer;
import groovyx.net.http.TransportingException;
import groovyx.net.http.util.IoUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class NativeHandlers {
    protected static final ThreadLocal<Expanding> tlExpanding = new ThreadLocal<Expanding>(){

        @Override
        protected Expanding initialValue() {
            return new Expanding();
        }
    };

    public static Object success(FromServer fromServer, Object data) {
        return data;
    }

    public static Object failure(FromServer fromServer, Object data) {
        throw new HttpException(fromServer, data);
    }

    public static Object exception(Throwable thrown) {
        RuntimeException rethrow = thrown instanceof RuntimeException ? (RuntimeException)thrown : new RuntimeException(thrown);
        throw rethrow;
    }

    public static class Parsers {
        public static final Charset DEFAULT_CHARSET;
        private static final Logger log;
        public static CatalogResolver catalogResolver;

        public static byte[] streamToBytes(ChainedHttpConfig config, FromServer fromServer) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IoUtils.transfer(fromServer.getInputStream(), baos, true);
            return baos.toByteArray();
        }

        public static String textToString(ChainedHttpConfig config, FromServer fromServer) {
            try {
                int total;
                InputStreamReader reader = new InputStreamReader(fromServer.getInputStream(), fromServer.getCharset());
                Expanding e = tlExpanding.get();
                e.charBuffer.clear();
                while ((total = reader.read(e.charAry)) != -1) {
                    e.append(total);
                }
                e.charBuffer.flip();
                return e.charBuffer.toString();
            }
            catch (IOException ioe) {
                throw new TransportingException(ioe);
            }
        }

        public static Map<String, List<String>> form(ChainedHttpConfig config, FromServer fromServer) {
            return Form.decode(fromServer.getInputStream(), fromServer.getCharset());
        }

        public static GPathResult xml(ChainedHttpConfig config, FromServer fromServer) {
            try {
                XmlSlurper xml = new XmlSlurper();
                xml.setEntityResolver((EntityResolver)catalogResolver);
                xml.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
                xml.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                return xml.parse((Reader)new InputStreamReader(fromServer.getInputStream(), fromServer.getCharset()));
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                throw new TransportingException(ex);
            }
        }

        public static Object json(ChainedHttpConfig config, FromServer fromServer) {
            return new JsonSlurper().parse((Reader)new InputStreamReader(fromServer.getInputStream(), fromServer.getCharset()));
        }

        @Deprecated
        public static void transfer(InputStream istream, OutputStream ostream, boolean close) {
            IoUtils.transfer(istream, ostream, close);
        }

        static {
            block2: {
                DEFAULT_CHARSET = StandardCharsets.UTF_8;
                log = LoggerFactory.getLogger(Parsers.class);
                CatalogManager catalogManager = new CatalogManager();
                catalogManager.setIgnoreMissingProperties(true);
                catalogManager.setUseStaticCatalog(false);
                catalogManager.setRelativeCatalogs(true);
                try {
                    catalogResolver = new CatalogResolver(catalogManager);
                    catalogResolver.getCatalog().parseCatalog(NativeHandlers.class.getResource("/catalog/html.xml"));
                }
                catch (IOException ex) {
                    if (!log.isWarnEnabled()) break block2;
                    log.warn("Could not resolve default XML catalog", (Throwable)ex);
                }
            }
        }
    }

    public static class Encoders {
        private static final Class[] BINARY_TYPES = new Class[]{ByteArrayInputStream.class, InputStream.class, byte[].class, Closure.class};
        private static final Class[] TEXT_TYPES = new Class[]{Closure.class, Writable.class, Reader.class, String.class};
        private static final Class[] FORM_TYPES = new Class[]{Map.class, String.class};
        private static final Class[] XML_TYPES = new Class[]{String.class, StreamingMarkupBuilder.class};

        public static Object checkNull(Object body) {
            if (body == null) {
                throw new NullPointerException("Effective body cannot be null");
            }
            return body;
        }

        public static void checkTypes(Object body, Class<?>[] allowedTypes) {
            Class<?> type = body.getClass();
            for (Class<?> allowed : allowedTypes) {
                if (!allowed.isAssignableFrom(type)) continue;
                return;
            }
            String msg = String.format("Cannot encode bodies of type %s, only bodies of: %s", type.getName(), Arrays.stream(allowedTypes).map(Class::getName).collect(Collectors.joining(", ")));
            throw new IllegalArgumentException(msg);
        }

        public static InputStream readerToStream(Reader r, Charset cs) throws IOException {
            return new ReaderInputStream(r, cs);
        }

        public static InputStream stringToStream(String s, Charset cs) {
            return new CharSequenceInputStream(s, cs);
        }

        public static boolean handleRawUpload(ChainedHttpConfig config, ToServer ts) {
            ChainedHttpConfig.ChainedRequest request = config.getChainedRequest();
            Object body = request.actualBody();
            Charset charset = request.actualCharset();
            try {
                if (body instanceof File) {
                    ts.toServer(new FileInputStream((File)body));
                    return true;
                }
                if (body instanceof Path) {
                    ts.toServer(Files.newInputStream((Path)body, new OpenOption[0]));
                    return true;
                }
                if (body instanceof byte[]) {
                    ts.toServer(new ByteArrayInputStream((byte[])body));
                    return true;
                }
                if (body instanceof InputStream) {
                    ts.toServer((InputStream)body);
                    return true;
                }
                if (body instanceof Reader) {
                    ts.toServer(new ReaderInputStream((Reader)body, charset));
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new TransportingException(e);
            }
        }

        public static void binary(ChainedHttpConfig config, ToServer ts) {
            ChainedHttpConfig.ChainedRequest request = config.getChainedRequest();
            Object body = Encoders.checkNull(request.actualBody());
            if (Encoders.handleRawUpload(config, ts)) {
                return;
            }
            Encoders.checkTypes(body, BINARY_TYPES);
            if (!(body instanceof byte[])) {
                throw new UnsupportedOperationException();
            }
            ts.toServer(new ByteArrayInputStream((byte[])body));
        }

        public static void text(ChainedHttpConfig config, ToServer ts) throws IOException {
            ChainedHttpConfig.ChainedRequest request = config.getChainedRequest();
            if (Encoders.handleRawUpload(config, ts)) {
                return;
            }
            Object body = Encoders.checkNull(request.actualBody());
            Encoders.checkTypes(body, TEXT_TYPES);
            ts.toServer(Encoders.stringToStream(body.toString(), request.actualCharset()));
        }

        public static void form(ChainedHttpConfig config, ToServer ts) {
            ChainedHttpConfig.ChainedRequest request = config.getChainedRequest();
            if (Encoders.handleRawUpload(config, ts)) {
                return;
            }
            Object body = Encoders.checkNull(request.actualBody());
            Encoders.checkTypes(body, FORM_TYPES);
            if (body instanceof String) {
                ts.toServer(Encoders.stringToStream((String)body, request.actualCharset()));
            } else if (body instanceof Map) {
                Map params = (Map)body;
                String encoded = Form.encode(params, request.actualCharset());
                ts.toServer(Encoders.stringToStream(encoded, request.actualCharset()));
            } else {
                throw new UnsupportedOperationException();
            }
        }

        public static void xml(ChainedHttpConfig config, ToServer ts) {
            ChainedHttpConfig.ChainedRequest request = config.getChainedRequest();
            if (Encoders.handleRawUpload(config, ts)) {
                return;
            }
            Object body = Encoders.checkNull(request.actualBody());
            Encoders.checkTypes(body, XML_TYPES);
            if (body instanceof String) {
                ts.toServer(Encoders.stringToStream((String)body, request.actualCharset()));
            } else if (body instanceof Closure) {
                StreamingMarkupBuilder smb = new StreamingMarkupBuilder();
                ts.toServer(Encoders.stringToStream(smb.bind(body).toString(), request.actualCharset()));
            } else {
                throw new UnsupportedOperationException();
            }
        }

        public static void json(ChainedHttpConfig config, ToServer ts) {
            ChainedHttpConfig.ChainedRequest request = config.getChainedRequest();
            if (Encoders.handleRawUpload(config, ts)) {
                return;
            }
            Object body = Encoders.checkNull(request.actualBody());
            String json = body instanceof String || body instanceof GString ? body.toString() : new JsonBuilder(body).toString();
            ts.toServer(Encoders.stringToStream(json, request.actualCharset()));
        }
    }

    protected static class Expanding {
        CharBuffer charBuffer = CharBuffer.allocate(2048);
        final char[] charAry = new char[2048];

        protected Expanding() {
        }

        private void resize(int toWrite) {
            int byAtLeast = toWrite - this.charBuffer.remaining();
            int next = this.charBuffer.capacity() << 1;
            while (next - this.charBuffer.capacity() + this.charBuffer.remaining() < byAtLeast) {
                next <<= 1;
            }
            CharBuffer tmp = CharBuffer.allocate(next);
            this.charBuffer.flip();
            tmp.put(this.charBuffer);
            this.charBuffer = tmp;
        }

        public void append(int total) {
            if (this.charBuffer.remaining() < total) {
                this.resize(total);
            }
            this.charBuffer.put(this.charAry, 0, total);
        }
    }
}

