/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.io.File;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.ReflectionUtils;

public class OSGiDefaultClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public String[] handledClassLoaders() {
        return new String[]{"org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader"};
    }

    @Override
    public ClassLoader getEmbeddedClassLoader(ClassLoader outerClassLoaderInstance) {
        return null;
    }

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classloader, ClasspathOrder classpathOrderOut, LogNode log) {
        Object classpathManager = ReflectionUtils.invokeMethod(classloader, "getClasspathManager", false);
        Object[] entries = (Object[])ReflectionUtils.getFieldVal(classpathManager, "entries", false);
        if (entries != null) {
            for (Object entry : entries) {
                Object bundleFile = ReflectionUtils.invokeMethod(entry, "getBundleFile", false);
                File baseFile = (File)ReflectionUtils.invokeMethod(bundleFile, "getBaseFile", false);
                if (baseFile == null) continue;
                classpathOrderOut.addClasspathElement(baseFile.getPath(), classloader, log);
            }
        }
    }
}

