/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.convert;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.time.YearMonth;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.internal.convert.IMFHistoricalType;
import org.javamoney.moneta.internal.convert.IMFRemoteSearch;

class IMFRemoteSearchCallable
implements Callable<IMFRemoteSearchResult> {
    private static final Logger LOG = Logger.getLogger(IMFRemoteSearch.class.getName());
    private final IMFHistoricalType type;
    private final YearMonth yearMonth;

    IMFRemoteSearchCallable(IMFHistoricalType type, YearMonth yearMonth) {
        this.type = Objects.requireNonNull(type);
        this.yearMonth = Objects.requireNonNull(yearMonth);
    }

    /*
     * Exception decompiling
     */
    @Override
    public IMFRemoteSearchResult call() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URLConnection getConnection() {
        try {
            return new URL(this.type.getUrl(this.yearMonth)).openConnection();
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Failed to load resource from url " + this.type.getUrl(this.yearMonth), e);
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(IMFRemoteSearchCallable.class.getName()).append('{').append(" type: ").append((Object)this.type).append(", yearMonth: ").append(this.yearMonth).append('}');
        return sb.toString();
    }

    class IMFRemoteSearchResult {
        private final IMFHistoricalType type;
        private final InputStream stream;

        IMFRemoteSearchResult(IMFHistoricalType type, InputStream stream) {
            this.type = type;
            this.stream = stream;
        }

        public IMFHistoricalType getType() {
            return this.type;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(IMFRemoteSearchResult.class.getName()).append('{').append(" type: ").append((Object)this.type).append(", stream: ").append(this.stream).append('}');
            return sb.toString();
        }
    }
}

