/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ingest.SimulateProcessorResult;
import org.elasticsearch.ingest.CompoundProcessor;
import org.elasticsearch.ingest.ConditionalProcessor;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.PipelineProcessor;
import org.elasticsearch.ingest.Processor;

public final class TrackingResultProcessor
implements Processor {
    private final Processor actualProcessor;
    private final List<SimulateProcessorResult> processorResultList;
    private final boolean ignoreFailure;

    TrackingResultProcessor(boolean ignoreFailure, Processor actualProcessor, List<SimulateProcessorResult> processorResultList) {
        this.ignoreFailure = ignoreFailure;
        this.processorResultList = processorResultList;
        this.actualProcessor = actualProcessor;
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        block13: {
            Processor processor = this.actualProcessor;
            try {
                if (processor instanceof ConditionalProcessor) {
                    ConditionalProcessor conditionalProcessor = (ConditionalProcessor)processor;
                    if (!conditionalProcessor.evaluate(ingestDocument)) {
                        return ingestDocument;
                    }
                    if (conditionalProcessor.getInnerProcessor() instanceof PipelineProcessor) {
                        processor = conditionalProcessor.getInnerProcessor();
                    }
                }
                if (processor instanceof PipelineProcessor) {
                    PipelineProcessor pipelineProcessor = (PipelineProcessor)processor;
                    Pipeline pipeline = pipelineProcessor.getPipeline();
                    try {
                        IngestDocument ingestDocumentCopy = new IngestDocument(ingestDocument);
                        ingestDocumentCopy.executePipeline(pipelineProcessor.getPipeline());
                    }
                    catch (ElasticsearchException elasticsearchException) {
                        if (elasticsearchException.getCause().getCause() instanceof IllegalStateException) {
                            throw elasticsearchException;
                        }
                    }
                    catch (Exception elasticsearchException) {
                        // empty catch block
                    }
                    CompoundProcessor verbosePipelineProcessor = TrackingResultProcessor.decorate(pipeline.getCompoundProcessor(), this.processorResultList);
                    Pipeline verbosePipeline = new Pipeline(pipeline.getId(), pipeline.getDescription(), pipeline.getVersion(), verbosePipelineProcessor);
                    ingestDocument.executePipeline(verbosePipeline);
                    break block13;
                }
                IngestDocument result = processor.execute(ingestDocument);
                if (result != null) {
                    this.processorResultList.add(new SimulateProcessorResult(processor.getTag(), new IngestDocument(ingestDocument)));
                    break block13;
                }
                this.processorResultList.add(new SimulateProcessorResult(processor.getTag()));
                return null;
            }
            catch (Exception e) {
                if (this.ignoreFailure) {
                    this.processorResultList.add(new SimulateProcessorResult(processor.getTag(), new IngestDocument(ingestDocument), e));
                } else {
                    this.processorResultList.add(new SimulateProcessorResult(processor.getTag(), e));
                }
                throw e;
            }
        }
        return ingestDocument;
    }

    @Override
    public String getType() {
        return this.actualProcessor.getType();
    }

    @Override
    public String getTag() {
        return this.actualProcessor.getTag();
    }

    public static CompoundProcessor decorate(CompoundProcessor compoundProcessor, List<SimulateProcessorResult> processorResultList) {
        ArrayList<Processor> processors = new ArrayList<Processor>(compoundProcessor.getProcessors().size());
        for (Processor processor : compoundProcessor.getProcessors()) {
            if (processor instanceof CompoundProcessor) {
                processors.add(TrackingResultProcessor.decorate((CompoundProcessor)processor, processorResultList));
                continue;
            }
            processors.add(new TrackingResultProcessor(compoundProcessor.isIgnoreFailure(), processor, processorResultList));
        }
        ArrayList<Processor> onFailureProcessors = new ArrayList<Processor>(compoundProcessor.getProcessors().size());
        for (Processor processor : compoundProcessor.getOnFailureProcessors()) {
            if (processor instanceof CompoundProcessor) {
                onFailureProcessors.add(TrackingResultProcessor.decorate((CompoundProcessor)processor, processorResultList));
                continue;
            }
            onFailureProcessors.add(new TrackingResultProcessor(compoundProcessor.isIgnoreFailure(), processor, processorResultList));
        }
        return new CompoundProcessor(compoundProcessor.isIgnoreFailure(), processors, onFailureProcessors);
    }
}

