/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.hazelcast.HazelcastNode;

public class HazelcastInstanceAware {
    protected HazelcastInstance instance;

    public void bind(HazelcastInstance instance) {
        this.instance = instance;
    }

    public void unbind(HazelcastInstance instance) {
        this.instance = null;
    }

    public Node getNode() {
        Cluster cluster = this.instance.getCluster();
        if (cluster != null) {
            Member member = cluster.getLocalMember();
            return new HazelcastNode(member);
        }
        return null;
    }

    public void setNodeAlias(String alias) {
        Cluster cluster = this.instance.getCluster();
        if (cluster != null) {
            Member member = cluster.getLocalMember();
            member.setStringAttribute("alias", alias);
        }
    }

    public HazelcastInstance getInstance() {
        return this.instance;
    }

    public void setInstance(HazelcastInstance instance) {
        this.instance = instance;
    }
}

