/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.migration.impl;

import java.io.IOException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.karaf.shell.api.console.Session;
import org.apache.unomi.shell.migration.Migration;
import org.apache.unomi.shell.migration.utils.ConsoleUtils;
import org.apache.unomi.shell.migration.utils.HttpRequestException;
import org.apache.unomi.shell.migration.utils.HttpUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Component;

@Component
public class MigrationTo122
implements Migration {
    private CloseableHttpClient httpClient;
    private Session session;
    private String esAddress;

    @Override
    public Version getFromVersion() {
        return null;
    }

    @Override
    public Version getToVersion() {
        return new Version("1.2.2");
    }

    @Override
    public String getDescription() {
        return "Delete old index template";
    }

    @Override
    public void execute(Session session, CloseableHttpClient httpClient, String esAddress, BundleContext bundleContext) throws IOException {
        this.httpClient = httpClient;
        this.session = session;
        this.esAddress = esAddress;
        this.deleteOldIndexTemplate();
    }

    private void deleteOldIndexTemplate() throws IOException {
        String oldMonthlyIndexTemplate = "context_monthlyindex";
        try {
            ConsoleUtils.printMessage(this.session, "Deleting old monthly index template " + oldMonthlyIndexTemplate);
            HttpUtils.executeDeleteRequest(this.httpClient, this.esAddress + "/_template/" + oldMonthlyIndexTemplate, null);
        }
        catch (HttpRequestException e) {
            if (e.getCode() == 404) {
                ConsoleUtils.printMessage(this.session, "Old monthly index template not found, skipping deletion");
            }
            throw e;
        }
    }
}

