/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.utils;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nonapi.io.github.classgraph.utils.FileUtils;

public class FastPathResolver {
    private static final Pattern percentMatcher = Pattern.compile("([%][0-9a-fA-F][0-9a-fA-F])+");
    private static final boolean WINDOWS = File.separatorChar == '\\';

    private static void translateSeparator(String path, int startIdx, int endIdx, boolean stripFinalSeparator, StringBuilder buf) {
        for (int i = startIdx; i < endIdx; ++i) {
            char c = path.charAt(i);
            if (c == '\\' || c == '/') {
                int prevChar;
                if (i >= endIdx - 1 && stripFinalSeparator) continue;
                int n = prevChar = buf.length() == 0 ? 0 : (int)buf.charAt(buf.length() - 1);
                if (prevChar == 47) continue;
                buf.append('/');
                continue;
            }
            buf.append(c);
        }
    }

    private static void unescapePercentEncoding(String path, int startIdx, int endIdx, StringBuilder buf) {
        if (endIdx - startIdx == 3 && path.charAt(startIdx + 1) == '2' && path.charAt(startIdx + 2) == '0') {
            buf.append(' ');
        } else {
            byte[] bytes = new byte[(endIdx - startIdx) / 3];
            int i = startIdx;
            int j = 0;
            while (i < endIdx) {
                int digit1;
                char c1 = path.charAt(i + 1);
                char c2 = path.charAt(i + 2);
                int n = c1 >= '0' && c1 <= '9' ? c1 - 48 : (digit1 = c1 >= 'a' && c1 <= 'f' ? c1 - 97 + 10 : c1 - 65 + 10);
                int digit2 = c2 >= '0' && c2 <= '9' ? c2 - 48 : (c2 >= 'a' && c2 <= 'f' ? c2 - 97 + 10 : c2 - 65 + 10);
                bytes[j] = (byte)(digit1 << 4 | digit2);
                i += 3;
                ++j;
            }
            String str = new String(bytes, StandardCharsets.UTF_8);
            for (int i2 = 0; i2 < str.length(); ++i2) {
                char c = str.charAt(i2);
                if (c == '/') {
                    buf.append("%2F");
                    continue;
                }
                if (c == '\\') {
                    buf.append("%5C");
                    continue;
                }
                if (c < ' ') {
                    buf.append('%');
                    buf.append(c >= '\u0010' ? (char)'1' : '0');
                    int l = c & 0xF;
                    buf.append((char)(l >= 10 ? 97 + l : 48 + l));
                    continue;
                }
                buf.append(c);
            }
        }
    }

    public static String normalizePath(String path, boolean isFileOrJarURL) {
        int prevEndMatchIdx;
        boolean hasPercent;
        boolean bl = hasPercent = path.indexOf(37) >= 0;
        if (!hasPercent && path.indexOf(92) < 0 && !path.endsWith("/")) {
            return path;
        }
        int len = path.length();
        StringBuilder buf = new StringBuilder();
        if (hasPercent && isFileOrJarURL) {
            prevEndMatchIdx = 0;
            Matcher matcher = percentMatcher.matcher(path);
            while (matcher.find()) {
                int startMatchIdx = matcher.start();
                int endMatchIdx = matcher.end();
                FastPathResolver.translateSeparator(path, prevEndMatchIdx, startMatchIdx, false, buf);
                FastPathResolver.unescapePercentEncoding(path, startMatchIdx, endMatchIdx, buf);
                prevEndMatchIdx = endMatchIdx;
            }
        } else {
            FastPathResolver.translateSeparator(path, 0, len, true, buf);
            return buf.toString();
        }
        FastPathResolver.translateSeparator(path, prevEndMatchIdx, len, true, buf);
        return buf.toString();
    }

    public static String resolve(String resolveBasePath, String relativePath) {
        String pathStr;
        if (relativePath == null || relativePath.isEmpty()) {
            return resolveBasePath == null ? "" : resolveBasePath;
        }
        String prefix = "";
        boolean isAbsolutePath = false;
        boolean isFileOrJarURL = false;
        int startIdx = 0;
        if (relativePath.regionMatches(true, startIdx, "jar:", 0, 4)) {
            startIdx += 4;
            isFileOrJarURL = true;
        }
        if (relativePath.regionMatches(true, startIdx, "http://", 0, 7)) {
            startIdx += 7;
            prefix = "http://";
            isAbsolutePath = true;
        } else if (relativePath.regionMatches(true, startIdx, "https://", 0, 8)) {
            startIdx += 8;
            prefix = "https://";
            isAbsolutePath = true;
        } else if (relativePath.regionMatches(true, startIdx, "jrt:", 0, 5)) {
            startIdx += 4;
            prefix = "jrt:";
            isAbsolutePath = true;
        } else if (relativePath.regionMatches(true, startIdx, "file:", 0, 5)) {
            startIdx += 5;
            if (WINDOWS) {
                if (relativePath.startsWith("\\\\\\\\", startIdx) || relativePath.startsWith("////", startIdx)) {
                    startIdx += 4;
                    prefix = "//";
                    isAbsolutePath = true;
                } else if (relativePath.startsWith("\\\\", startIdx)) {
                    startIdx += 2;
                }
            }
            if (relativePath.startsWith("//", startIdx)) {
                startIdx += 2;
            }
            isFileOrJarURL = true;
        } else if (WINDOWS && (relativePath.startsWith("//") || relativePath.startsWith("\\\\"))) {
            startIdx += 2;
            prefix = "//";
            isAbsolutePath = true;
        }
        if (WINDOWS) {
            if (relativePath.length() - startIdx > 2 && Character.isLetter(relativePath.charAt(startIdx)) && relativePath.charAt(startIdx + 1) == ':') {
                isAbsolutePath = true;
            } else if (relativePath.length() - startIdx > 3 && (relativePath.charAt(startIdx) == '/' || relativePath.charAt(startIdx) == '\\') && Character.isLetter(relativePath.charAt(startIdx + 1)) && relativePath.charAt(startIdx + 2) == ':') {
                isAbsolutePath = true;
                ++startIdx;
            }
        }
        if (relativePath.length() - startIdx > 1 && (relativePath.charAt(startIdx) == '/' || relativePath.charAt(startIdx) == '\\')) {
            isAbsolutePath = true;
        }
        if (!(pathStr = FastPathResolver.normalizePath(startIdx == 0 ? relativePath : relativePath.substring(startIdx), isFileOrJarURL)).equals("/")) {
            if (pathStr.endsWith("/")) {
                pathStr = pathStr.substring(0, pathStr.length() - 1);
            }
            if (pathStr.endsWith("!")) {
                pathStr = pathStr.substring(0, pathStr.length() - 1);
            }
            if (pathStr.endsWith("/")) {
                pathStr = pathStr.substring(0, pathStr.length() - 1);
            }
            if (pathStr.isEmpty()) {
                pathStr = "/";
            }
        }
        String resolveBasePathSanitized = isAbsolutePath || resolveBasePath == null || resolveBasePath.isEmpty() ? null : FileUtils.sanitizeEntryPath(resolveBasePath, false);
        String pathStrSanitized = FileUtils.sanitizeEntryPath(pathStr, false);
        String pathResolved = resolveBasePathSanitized == null || resolveBasePathSanitized.isEmpty() ? pathStrSanitized : resolveBasePath + (resolveBasePath.endsWith("/") || pathStrSanitized.isEmpty() ? "" : "/") + pathStrSanitized;
        return prefix.isEmpty() ? pathResolved : prefix + pathResolved;
    }

    public static String resolve(String pathStr) {
        return FastPathResolver.resolve(null, pathStr);
    }
}

