/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast;

import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import org.apache.karaf.cellar.core.Dispatcher;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventConsumer;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventTransportFactory;
import org.apache.karaf.cellar.core.utils.CombinedClassLoader;
import org.apache.karaf.cellar.hazelcast.HazelcastInstanceAware;
import org.apache.karaf.cellar.hazelcast.QueueConsumer;
import org.apache.karaf.cellar.hazelcast.QueueProducer;
import org.apache.karaf.cellar.hazelcast.TopicConsumer;
import org.apache.karaf.cellar.hazelcast.TopicProducer;
import org.osgi.service.cm.ConfigurationAdmin;

public class HazelcastEventTransportFactory
extends HazelcastInstanceAware
implements EventTransportFactory {
    private Dispatcher dispatcher;
    private CombinedClassLoader combinedClassLoader;
    private ConfigurationAdmin configurationAdmin;

    public EventProducer getEventProducer(String name, Boolean pubsub) {
        if (pubsub.booleanValue()) {
            ITopic topic = this.instance.getTopic("org.apache.karaf.cellar.event.topic." + name);
            TopicProducer producer = new TopicProducer();
            producer.setInstance(this.instance);
            producer.setTopic((ITopic<Event>)topic);
            producer.setNode(this.getNode());
            producer.setConfigurationAdmin(this.configurationAdmin);
            producer.init();
            return producer;
        }
        IQueue queue = this.instance.getQueue("org.apache.karaf.cellar.event.queue." + name);
        QueueProducer producer = new QueueProducer();
        producer.setQueue(queue);
        producer.setNode(this.getNode());
        producer.setConfigurationAdmin(this.configurationAdmin);
        producer.init();
        return producer;
    }

    public EventConsumer getEventConsumer(String name, Boolean pubsub) {
        if (pubsub.booleanValue()) {
            ITopic topic = this.instance.getTopic("org.apache.karaf.cellar.event.topic." + name);
            TopicConsumer consumer = new TopicConsumer();
            consumer.setTopic(topic);
            consumer.setInstance(this.instance);
            consumer.setNode(this.getNode());
            consumer.setDispatcher(this.dispatcher);
            consumer.setConfigurationAdmin(this.configurationAdmin);
            consumer.init();
            return consumer;
        }
        IQueue queue = this.instance.getQueue("org.apache.karaf.cellar.event.queue." + name);
        QueueConsumer consumer = new QueueConsumer(this.combinedClassLoader);
        consumer.setQueue(queue);
        consumer.setNode(this.getNode());
        consumer.setDispatcher(this.dispatcher);
        consumer.setConfigurationAdmin(this.configurationAdmin);
        consumer.init();
        return consumer;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public CombinedClassLoader getCombinedClassLoader() {
        return this.combinedClassLoader;
    }

    public void setCombinedClassLoader(CombinedClassLoader combinedClassLoader) {
        this.combinedClassLoader = combinedClassLoader;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

