/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.web;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.EventsCollectorRequest;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.PrivacyService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.apache.unomi.web.Changes;
import org.apache.unomi.web.HttpUtils;
import org.apache.unomi.web.ServletCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsCollectorServlet
extends HttpServlet {
    private static final long serialVersionUID = 2008054804885122957L;
    private static final Logger logger = LoggerFactory.getLogger((String)EventsCollectorServlet.class.getName());
    private String profileIdCookieName = "context-profile-id";
    private EventService eventService;
    private ProfileService profileService;
    private PrivacyService privacyService;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        logger.info("Event collector servlet initialized.");
    }

    public void destroy() {
        super.destroy();
        logger.info("Event collector servlet shutdown.");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doEvent(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doEvent(req, resp);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpUtils.setupCORSHeaders((HttpServletRequest)request, (ServletResponse)response);
        response.flushBuffer();
    }

    private void doEvent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String cookieProfileId;
        EventsCollectorRequest eventsCollectorRequest;
        Date timestamp = new Date();
        if (request.getParameter("timestamp") != null) {
            timestamp.setTime(Long.parseLong(request.getParameter("timestamp")));
        }
        HttpUtils.setupCORSHeaders((HttpServletRequest)request, (ServletResponse)response);
        String payload = HttpUtils.getPayload((HttpServletRequest)request);
        if (payload == null) {
            response.sendError(400, "Check logs for more details");
            logger.error("No event payload found for request, aborting !");
            return;
        }
        ObjectMapper mapper = CustomObjectMapper.getObjectMapper();
        JsonFactory factory = mapper.getFactory();
        try {
            eventsCollectorRequest = (EventsCollectorRequest)mapper.readValue(factory.createParser(payload), EventsCollectorRequest.class);
        }
        catch (Exception e) {
            response.sendError(400, "Check logs for more details");
            logger.error("Cannot read payload " + payload, (Throwable)e);
            return;
        }
        if (eventsCollectorRequest == null || eventsCollectorRequest.getEvents() == null) {
            response.sendError(400, "Check logs for more details");
            logger.error("No events found in payload");
            return;
        }
        String sessionId = eventsCollectorRequest.getSessionId();
        if (sessionId == null) {
            sessionId = request.getParameter("sessionId");
        }
        Session session = null;
        if (sessionId != null) {
            session = this.profileService.loadSession(sessionId, timestamp);
        }
        Profile profile = null;
        if (session == null) {
            String scope = "systemscope";
            for (Event event : eventsCollectorRequest.getEvents()) {
                if (!StringUtils.isNotBlank((CharSequence)event.getEventType())) continue;
                if (StringUtils.isNotBlank((CharSequence)event.getScope()) && !event.getScope().equals("systemscope")) {
                    scope = event.getScope();
                    break;
                }
                if (event.getSource() == null || !StringUtils.isNotBlank((CharSequence)event.getSource().getScope()) || event.getSource().getScope().equals("systemscope")) continue;
                scope = event.getSource().getScope();
                break;
            }
            if (StringUtils.isNotBlank((CharSequence)(cookieProfileId = ServletCommon.getProfileIdCookieValue((HttpServletRequest)request, (String)this.profileIdCookieName)))) {
                profile = this.profileService.load(cookieProfileId);
            }
            if (profile == null) {
                profile = new Profile("temp_" + UUID.randomUUID().toString());
                profile.setProperty("firstVisit", (Object)timestamp);
            }
        } else {
            Profile sessionProfile = session.getProfile();
            if (sessionProfile.getItemId() != null) {
                profile = this.profileService.load(sessionProfile.getItemId());
                if (profile == null || profile instanceof Persona) {
                    response.sendError(400, "Check logs for more details");
                    logger.error("No valid profile found or persona found for profileId={}, aborting request !", (Object)session.getProfileId());
                    return;
                }
            } else {
                cookieProfileId = ServletCommon.getProfileIdCookieValue((HttpServletRequest)request, (String)this.profileIdCookieName);
                if (StringUtils.isNotBlank((CharSequence)cookieProfileId)) {
                    profile = this.profileService.load(cookieProfileId);
                }
                if (profile == null) {
                    response.sendError(400, "Check logs for more details");
                    logger.error("No valid profile found or persona found for profileId={}, aborting request !", (Object)session.getProfileId());
                    return;
                }
            }
        }
        Changes changesObject = ServletCommon.handleEvents((List)eventsCollectorRequest.getEvents(), (Session)session, (Profile)profile, (ServletRequest)request, (ServletResponse)response, (Date)timestamp, (PrivacyService)this.privacyService, (EventService)this.eventService);
        int changes = changesObject.getChangeType();
        profile = changesObject.getProfile();
        if ((changes & 4) == 4) {
            this.profileService.save(profile);
        }
        if ((changes & 2) == 2 && session != null) {
            this.profileService.saveSession(session);
        }
        if ((changes & 1) == 1) {
            String errorMessage = "Error processing events. Total number of processed events: " + changesObject.getProcessedItems() + "/" + eventsCollectorRequest.getEvents().size();
            response.sendError(500, errorMessage);
            return;
        }
        response.setContentType("application/json");
        PrintWriter responseWriter = response.getWriter();
        responseWriter.append("{\"updated\":" + changes + "}");
        responseWriter.flush();
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setPrivacyService(PrivacyService privacyService) {
        this.privacyService = privacyService;
    }

    public void setProfileIdCookieName(String profileIdCookieName) {
        this.profileIdCookieName = profileIdCookieName;
    }
}

