/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.web;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.ContextRequest;
import org.apache.unomi.api.ContextResponse;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.PersonaSession;
import org.apache.unomi.api.PersonaWithSessions;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.PersonalizationService;
import org.apache.unomi.api.services.PrivacyService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.api.services.RulesService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.apache.unomi.web.Changes;
import org.apache.unomi.web.HttpUtils;
import org.apache.unomi.web.ServletCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextServlet
extends HttpServlet {
    private static final long serialVersionUID = 2928875830103325238L;
    private static final Logger logger = LoggerFactory.getLogger((String)ContextServlet.class.getName());
    private static final int MAX_COOKIE_AGE_IN_SECONDS = 31536000;
    private String profileIdCookieName = "context-profile-id";
    private String profileIdCookieDomain;
    private int profileIdCookieMaxAgeInSeconds = 31536000;
    private ProfileService profileService;
    private EventService eventService;
    private RulesService rulesService;
    private PrivacyService privacyService;
    private PersonalizationService personalizationService;
    private ConfigSharingService configSharingService;
    private boolean sanitizeConditions = Boolean.parseBoolean(System.getProperty("org.apache.unomi.security.personalization.sanitizeConditions", "true"));

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.configSharingService.setProperty("profileIdCookieName", (Object)this.profileIdCookieName);
        this.configSharingService.setProperty("profileIdCookieDomain", (Object)this.profileIdCookieDomain);
        this.configSharingService.setProperty("profileIdCookieMaxAgeInSeconds", (Object)this.profileIdCookieMaxAgeInSeconds);
        logger.info("ContextServlet initialized.");
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter responseWriter;
        Date timestamp = new Date();
        if (request.getParameter("timestamp") != null) {
            timestamp.setTime(Long.parseLong(request.getParameter("timestamp")));
        }
        HttpUtils.setupCORSHeaders((HttpServletRequest)request, (ServletResponse)response);
        String httpMethod = request.getMethod();
        if ("options".equals(httpMethod.toLowerCase())) {
            response.flushBuffer();
            if (logger.isDebugEnabled()) {
                logger.debug("OPTIONS request received. No context will be returned.");
            }
            return;
        }
        Persona profile = null;
        PersonaSession session = null;
        String personaId = request.getParameter("personaId");
        if (personaId != null) {
            PersonaWithSessions personaWithSessions = this.profileService.loadPersonaWithSessions(personaId);
            if (personaWithSessions == null) {
                logger.error("Couldn't find persona with id=" + personaId);
                profile = null;
            } else {
                profile = personaWithSessions.getPersona();
                session = personaWithSessions.getLastSession();
            }
        }
        ContextRequest contextRequest = null;
        String scope = null;
        String sessionId = null;
        String profileId = null;
        String stringPayload = HttpUtils.getPayload((HttpServletRequest)request);
        if (stringPayload != null) {
            ObjectMapper mapper = CustomObjectMapper.getObjectMapper();
            JsonFactory factory = mapper.getFactory();
            try {
                contextRequest = (ContextRequest)mapper.readValue(factory.createParser(stringPayload), ContextRequest.class);
            }
            catch (Exception e) {
                response.sendError(400, "Check logs for more details");
                logger.error("Cannot read payload " + stringPayload, (Throwable)e);
                return;
            }
            if (contextRequest.getSource() != null) {
                scope = contextRequest.getSource().getScope();
            }
            sessionId = contextRequest.getSessionId();
            profileId = contextRequest.getProfileId();
        }
        if (sessionId == null) {
            sessionId = request.getParameter("sessionId");
        }
        if (profileId == null) {
            profileId = ServletCommon.getProfileIdCookieValue((HttpServletRequest)request, (String)this.profileIdCookieName);
        }
        if (profileId == null && sessionId == null && personaId == null) {
            response.sendError(400, "Check logs for more details");
            logger.error("Couldn't find profileId, sessionId or personaId in incoming request! Stopped processing request. See debug level for more information");
            if (logger.isDebugEnabled()) {
                logger.debug("Request dump: {}", (Object)HttpUtils.dumpRequestInfo((HttpServletRequest)request));
            }
            return;
        }
        int changes = 0;
        if (profile == null) {
            Persona sessionProfile;
            boolean invalidateSession;
            boolean invalidateProfile;
            boolean profileCreated = false;
            boolean bl = invalidateProfile = request.getParameter("invalidateProfile") != null ? new Boolean(request.getParameter("invalidateProfile")) : false;
            if (profileId == null || invalidateProfile) {
                profile = this.createNewProfile(null, (ServletResponse)response, timestamp);
                profileCreated = true;
            } else {
                profile = this.profileService.load(profileId);
                if (profile == null) {
                    profile = this.createNewProfile(profileId, (ServletResponse)response, timestamp);
                    profileCreated = true;
                } else {
                    Changes changesObject = this.checkMergedProfile((ServletResponse)response, (Profile)profile, (Session)session);
                    changes |= changesObject.getChangeType();
                    profile = changesObject.getProfile();
                }
            }
            boolean bl2 = invalidateSession = request.getParameter("invalidateSession") != null ? new Boolean(request.getParameter("invalidateSession")) : false;
            if (StringUtils.isNotBlank((CharSequence)sessionId) && !invalidateSession && (session = this.profileService.loadSession(sessionId, timestamp)) != null) {
                Boolean requireAnonymousBrowsing;
                sessionProfile = session.getProfile();
                boolean anonymousSessionProfile = sessionProfile.isAnonymousProfile();
                if (!(profile.isAnonymousProfile() || anonymousSessionProfile || profile.getItemId().equals(sessionProfile.getItemId()))) {
                    profile = this.profileService.load(sessionProfile.getItemId());
                    if (profile != null) {
                        HttpUtils.sendProfileCookie((Profile)profile, (ServletResponse)response, (String)this.profileIdCookieName, (String)this.profileIdCookieDomain, (int)this.profileIdCookieMaxAgeInSeconds);
                    } else {
                        logger.warn("Couldn't load profile {} referenced in session {}", (Object)sessionProfile.getItemId(), (Object)session.getItemId());
                    }
                }
                if (!(requireAnonymousBrowsing = this.privacyService.isRequireAnonymousBrowsing((Profile)profile)).booleanValue() || !anonymousSessionProfile) {
                    if (requireAnonymousBrowsing.booleanValue() && !anonymousSessionProfile) {
                        sessionProfile = this.privacyService.getAnonymousProfile((Profile)profile);
                        session.setProfile((Profile)sessionProfile);
                        changes |= 2;
                    } else if (!requireAnonymousBrowsing.booleanValue() && anonymousSessionProfile) {
                        sessionProfile = profile;
                        session.setProfile((Profile)sessionProfile);
                        changes |= 2;
                    } else if (!requireAnonymousBrowsing.booleanValue() && !anonymousSessionProfile) {
                        sessionProfile = profile;
                        if (!session.getProfileId().equals(sessionProfile.getItemId())) {
                            changes |= 2;
                        }
                        session.setProfile((Profile)sessionProfile);
                    }
                }
            }
            if (session == null || invalidateSession) {
                Object object = sessionProfile = this.privacyService.isRequireAnonymousBrowsing((Profile)profile) != false ? this.privacyService.getAnonymousProfile((Profile)profile) : profile;
                if (StringUtils.isNotBlank((CharSequence)sessionId)) {
                    session = new Session(sessionId, (Profile)sessionProfile, timestamp, scope);
                    changes |= 2;
                    Event event = new Event("sessionCreated", (Session)session, (Profile)profile, scope, null, (Item)session, timestamp);
                    if (sessionProfile.isAnonymousProfile()) {
                        event.setProfileId(null);
                    }
                    event.getAttributes().put("http_request", request);
                    event.getAttributes().put("http_response", response);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Received event {} for profile={} session={} target={} timestamp={}", new Object[]{event.getEventType(), profile.getItemId(), session.getItemId(), event.getTarget(), timestamp});
                    }
                    changes |= this.eventService.send(event);
                }
            }
            if (profileCreated) {
                changes |= 4;
                Event profileUpdated = new Event("profileUpdated", (Session)session, (Profile)profile, scope, null, (Item)profile, timestamp);
                profileUpdated.setPersistent(false);
                profileUpdated.getAttributes().put("http_request", request);
                profileUpdated.getAttributes().put("http_response", response);
                if (logger.isDebugEnabled()) {
                    logger.debug("Received event {} for profile={} {} target={} timestamp={}", new Object[]{profileUpdated.getEventType(), profile.getItemId(), " session=" + (session != null ? session.getItemId() : null), profileUpdated.getTarget(), timestamp});
                }
                changes |= this.eventService.send(profileUpdated);
            }
        }
        ContextResponse contextResponse = new ContextResponse();
        contextResponse.setProfileId(profile.getItemId());
        if (session != null) {
            contextResponse.setSessionId(session.getItemId());
        } else if (sessionId != null) {
            contextResponse.setSessionId(sessionId);
        }
        if (contextRequest != null) {
            Changes changesObject = this.handleRequest(contextRequest, (Session)session, (Profile)profile, contextResponse, (ServletRequest)request, (ServletResponse)response, timestamp);
            changes |= changesObject.getChangeType();
            profile = changesObject.getProfile();
        }
        if ((changes & 4) == 4) {
            this.profileService.save((Profile)profile);
            contextResponse.setProfileId(profile.getItemId());
        }
        if ((changes & 2) == 2 && session != null) {
            this.profileService.saveSession((Session)session);
            contextResponse.setSessionId(session.getItemId());
        }
        if ((changes & 1) == 1) {
            response.setStatus(500);
        }
        String extension = request.getRequestURI().substring(request.getRequestURI().lastIndexOf(".") + 1);
        boolean noScript = "json".equals(extension);
        String contextAsJSONString = CustomObjectMapper.getObjectMapper().writeValueAsString((Object)contextResponse);
        response.setCharacterEncoding("UTF-8");
        if (noScript) {
            responseWriter = response.getWriter();
            response.setContentType("application/json");
            IOUtils.write((String)contextAsJSONString, (Writer)responseWriter);
        } else {
            responseWriter = response.getWriter();
            ((Writer)responseWriter).append("window.digitalData = window.digitalData || {};\n").append("var cxs = ").append(contextAsJSONString).append(";\n");
        }
        ((Writer)responseWriter).flush();
    }

    private Changes checkMergedProfile(ServletResponse response, Profile profile, Session session) {
        int changes = 0;
        if (profile.getMergedWith() != null && !this.privacyService.isRequireAnonymousBrowsing(profile).booleanValue() && !profile.isAnonymousProfile()) {
            Profile currentProfile = profile;
            String masterProfileId = profile.getMergedWith();
            Profile masterProfile = this.profileService.load(masterProfileId);
            if (masterProfile != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Current profile was merged with profile {}, replacing profile in session", (Object)masterProfileId);
                }
                profile = masterProfile;
                if (session != null) {
                    session.setProfile(profile);
                    changes = 2;
                }
                HttpUtils.sendProfileCookie((Profile)profile, (ServletResponse)response, (String)this.profileIdCookieName, (String)this.profileIdCookieDomain, (int)this.profileIdCookieMaxAgeInSeconds);
            } else {
                logger.warn("Couldn't find merged profile {}, falling back to profile {}", (Object)masterProfileId, (Object)currentProfile.getItemId());
                profile = currentProfile;
                profile.setMergedWith(null);
                changes = 4;
            }
        }
        return new Changes(changes, profile);
    }

    private Changes handleRequest(ContextRequest contextRequest, Session session, Profile profile, ContextResponse data, ServletRequest request, ServletResponse response, Date timestamp) {
        List personalizations;
        Changes changes = ServletCommon.handleEvents((List)contextRequest.getEvents(), (Session)session, (Profile)profile, (ServletRequest)request, (ServletResponse)response, (Date)timestamp, (PrivacyService)this.privacyService, (EventService)this.eventService);
        data.setProcessedEvents(changes.getProcessedItems());
        profile = changes.getProfile();
        if (contextRequest.isRequireSegments()) {
            data.setProfileSegments(profile.getSegments());
        }
        if (contextRequest.getRequiredProfileProperties() != null) {
            HashMap profileProperties = new HashMap(profile.getProperties());
            if (!contextRequest.getRequiredProfileProperties().contains("*")) {
                profileProperties.keySet().retainAll(contextRequest.getRequiredProfileProperties());
            }
            data.setProfileProperties(profileProperties);
        }
        if (session != null) {
            data.setSessionId(session.getItemId());
            if (contextRequest.getRequiredSessionProperties() != null) {
                HashMap sessionProperties = new HashMap(session.getProperties());
                if (!contextRequest.getRequiredSessionProperties().contains("*")) {
                    sessionProperties.keySet().retainAll(contextRequest.getRequiredSessionProperties());
                }
                data.setSessionProperties(sessionProperties);
            }
        }
        this.processOverrides(contextRequest, profile, session);
        List filterNodes = contextRequest.getFilters();
        if (filterNodes != null) {
            data.setFilteringResults(new HashMap());
            for (PersonalizationService.PersonalizedContent personalizedContent : this.sanitizePersonalizedContentObjects(filterNodes)) {
                data.getFilteringResults().put(personalizedContent.getId(), this.personalizationService.filter(profile, session, personalizedContent));
            }
        }
        if ((personalizations = contextRequest.getPersonalizations()) != null) {
            data.setPersonalizations(new HashMap());
            for (PersonalizationService.PersonalizationRequest personalization : this.sanitizePersonalizations(personalizations)) {
                data.getPersonalizations().put(personalization.getId(), this.personalizationService.personalizeList(profile, session, personalization));
            }
        }
        if (!(profile instanceof Persona)) {
            data.setTrackedConditions(this.rulesService.getTrackedConditions(contextRequest.getSource()));
        } else {
            data.setTrackedConditions(Collections.emptySet());
        }
        data.setAnonymousBrowsing(this.privacyService.isRequireAnonymousBrowsing(profile).booleanValue());
        data.setConsents(profile.getConsents());
        return changes;
    }

    private void processOverrides(ContextRequest contextRequest, Profile profile, Session session) {
        if (profile instanceof Persona && contextRequest.getProfileOverrides() != null) {
            if (contextRequest.getProfileOverrides().getScores() != null) {
                profile.setScores(contextRequest.getProfileOverrides().getScores());
            }
            if (contextRequest.getProfileOverrides().getSegments() != null) {
                profile.setSegments(contextRequest.getProfileOverrides().getSegments());
            }
            if (contextRequest.getProfileOverrides().getProperties() != null) {
                profile.setProperties(contextRequest.getProfileOverrides().getProperties());
            }
            if (contextRequest.getSessionPropertiesOverrides() != null && session != null) {
                session.setProperties(contextRequest.getSessionPropertiesOverrides());
            }
        }
    }

    private Profile createNewProfile(String existingProfileId, ServletResponse response, Date timestamp) {
        String profileId = existingProfileId;
        if (profileId == null) {
            profileId = UUID.randomUUID().toString();
        }
        Profile profile = new Profile(profileId);
        profile.setProperty("firstVisit", (Object)timestamp);
        HttpUtils.sendProfileCookie((Profile)profile, (ServletResponse)response, (String)this.profileIdCookieName, (String)this.profileIdCookieDomain, (int)this.profileIdCookieMaxAgeInSeconds);
        return profile;
    }

    public void destroy() {
        logger.info("Context servlet shutdown.");
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setRulesService(RulesService rulesService) {
        this.rulesService = rulesService;
    }

    public void setProfileIdCookieDomain(String profileIdCookieDomain) {
        this.profileIdCookieDomain = profileIdCookieDomain;
    }

    public void setProfileIdCookieName(String profileIdCookieName) {
        this.profileIdCookieName = profileIdCookieName;
    }

    public void setProfileIdCookieMaxAgeInSeconds(int profileIdCookieMaxAgeInSeconds) {
        this.profileIdCookieMaxAgeInSeconds = profileIdCookieMaxAgeInSeconds;
    }

    public void setPrivacyService(PrivacyService privacyService) {
        this.privacyService = privacyService;
    }

    public void setPersonalizationService(PersonalizationService personalizationService) {
        this.personalizationService = personalizationService;
    }

    public void setConfigSharingService(ConfigSharingService configSharingService) {
        this.configSharingService = configSharingService;
    }

    private List<PersonalizationService.PersonalizedContent> sanitizePersonalizedContentObjects(List<PersonalizationService.PersonalizedContent> personalizedContentObjects) {
        if (!this.sanitizeConditions) {
            return personalizedContentObjects;
        }
        ArrayList<PersonalizationService.PersonalizedContent> result = new ArrayList<PersonalizationService.PersonalizedContent>();
        for (PersonalizationService.PersonalizedContent personalizedContentObject : personalizedContentObjects) {
            boolean foundInvalidCondition = false;
            if (personalizedContentObject.getFilters() != null) {
                for (PersonalizationService.Filter filter : personalizedContentObject.getFilters()) {
                    if (this.sanitizeCondition(filter.getCondition()) != null) continue;
                    foundInvalidCondition = true;
                    break;
                }
            }
            if (foundInvalidCondition) continue;
            result.add(personalizedContentObject);
        }
        return result;
    }

    private List<PersonalizationService.PersonalizationRequest> sanitizePersonalizations(List<PersonalizationService.PersonalizationRequest> personalizations) {
        if (!this.sanitizeConditions) {
            return personalizations;
        }
        ArrayList<PersonalizationService.PersonalizationRequest> result = new ArrayList<PersonalizationService.PersonalizationRequest>();
        for (PersonalizationService.PersonalizationRequest personalizationRequest : personalizations) {
            List personalizedContents = this.sanitizePersonalizedContentObjects(personalizationRequest.getContents());
            if (personalizedContents == null || personalizedContents.size() <= 0) continue;
            result.add(personalizationRequest);
        }
        return result;
    }

    private Condition sanitizeCondition(Condition condition) {
        LinkedHashMap newParameterValues = new LinkedHashMap();
        for (Map.Entry parameterEntry : condition.getParameterValues().entrySet()) {
            Object sanitizedValue = this.sanitizeValue(parameterEntry.getValue());
            if (sanitizedValue != null) {
                newParameterValues.put(parameterEntry.getKey(), parameterEntry.getValue());
                continue;
            }
            return null;
        }
        return condition;
    }

    private Object sanitizeValue(Object value) {
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.startsWith("script::") || stringValue.startsWith("parameter::")) {
                logger.warn("Scripting detected in context request with value {}, filtering out...", value);
                return null;
            }
            return stringValue;
        }
        if (value instanceof List) {
            List values = (List)value;
            ArrayList<Object> newValues = new ArrayList<Object>();
            for (Object listObject : values) {
                Object newObject = this.sanitizeValue(listObject);
                if (newObject == null) continue;
                newValues.add(newObject);
            }
            return values;
        }
        if (value instanceof Map) {
            LinkedHashMap newMap = new LinkedHashMap();
            ((Map)value).forEach((key, value1) -> {
                Object newObject = this.sanitizeValue(value1);
                if (newObject != null) {
                    newMap.put(key, newObject);
                }
            });
            return newMap;
        }
        if (value instanceof Condition) {
            return this.sanitizeCondition((Condition)value);
        }
        return value;
    }
}

