/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FormPanel
extends JPanel {
    private static final long serialVersionUID = 6935744171267722900L;
    private static final double[] weights = new double[]{0.0, 0.0, 0.0, 0.0};
    private static final int[] anchors = new int[]{12, 18, 12, 18};
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    private Insets regularInsets = new Insets(1, 4, 1, 4);
    private Insets checkBoxInsets = new Insets(1, 0, 1, 0);
    private int nrColumns = 2;
    protected JPanel gridBagPanel;
    protected int componentIndex = 0;

    public FormPanel(int nrColumns) {
        this();
        this.nrColumns = nrColumns;
    }

    public FormPanel() {
        this.setLayout(new BorderLayout());
        this.gridBagPanel = new JPanel();
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gridBagPanel.setLayout(this.gbl);
        this.add((Component)this.gridBagPanel, "North");
    }

    public void add(JComponent c) {
        this.gbc.insets = c instanceof JCheckBox ? this.checkBoxInsets : this.regularInsets;
        this.gbc.gridx = this.componentIndex % this.nrColumns;
        this.gbc.gridy = this.componentIndex / this.nrColumns;
        this.gbc.anchor = anchors[this.gbc.gridx];
        this.gbc.weightx = weights[this.gbc.gridx];
        this.gridBagPanel.add((Component)c, this.gbc);
        ++this.componentIndex;
    }

    @Override
    public void setEnabled(boolean onOff) {
        super.setEnabled(onOff);
        Component[] components = this.gridBagPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(onOff);
        }
    }

    public int getNrComponents() {
        return this.componentIndex;
    }

    protected String getCaptionFromName(String name) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0) {
                sb.append(String.valueOf(c).toUpperCase());
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                sb.append(" ");
            }
            sb.append(c);
        }
        sb.append(':');
        return sb.toString();
    }
}

