/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;

public class PrependIterator
implements AxisIterator {
    NodeInfo start;
    AxisIterator base;
    int position = 0;

    public PrependIterator(NodeInfo nodeInfo, AxisIterator axisIterator) {
        this.start = nodeInfo;
        this.base = axisIterator;
    }

    public boolean moveNext() {
        return this.next() != null;
    }

    public Item next() {
        if (this.position == 0) {
            this.position = 1;
            return this.start;
        }
        Item item = this.base.next();
        this.position = item == null ? -1 : ++this.position;
        return item;
    }

    public Item current() {
        if (this.position() == 1) {
            return this.start;
        }
        if (this.position < 1) {
            return null;
        }
        return this.base.current();
    }

    public int position() {
        return this.position;
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        return ((NodeInfo)this.current()).iterateAxis(by, nodeTest);
    }

    public Value atomize() throws XPathException {
        return ((NodeInfo)this.current()).atomize();
    }

    public CharSequence getStringValue() {
        return ((NodeInfo)this.current()).getStringValueCS();
    }

    public SequenceIterator getAnother() {
        return new PrependIterator(this.start, this.base);
    }

    public int getProperties() {
        return 0;
    }
}

