/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.jd.wi;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.container.common.MessageBuffer;
import org.apache.uima.ducc.container.common.Standardize;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.ILogger;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.container.jd.wi.IProcessStatistics;
import org.apache.uima.ducc.container.jd.wi.IWorkItem;
import org.apache.uima.ducc.container.jd.wi.IWorkItemStatistics;
import org.apache.uima.ducc.container.jd.wi.WorkItemStatistics;

public class ProcessStatistics
implements IProcessStatistics {
    private static Logger logger = Logger.getLogger(ProcessStatistics.class, IComponent.Id.JD.name());
    private AtomicLong dispatch = new AtomicLong(0L);
    private AtomicLong done = new AtomicLong(0L);
    private AtomicLong error = new AtomicLong(0L);
    private AtomicLong preempt = new AtomicLong(0L);
    private AtomicLong retry = new AtomicLong(0L);
    private IWorkItemStatistics wis = new WorkItemStatistics();

    private void loggit(String location, IWorkItem wi) {
        MessageBuffer mb = new MessageBuffer();
        mb.append(Standardize.Label.seqNo.get() + wi.getMetaCas().getSystemKey());
        mb.append(Standardize.Label.dispatch.get() + this.dispatch.get());
        mb.append(Standardize.Label.done.get() + this.done.get());
        mb.append(Standardize.Label.error.get() + this.error.get());
        mb.append(Standardize.Label.preempt.get() + this.preempt.get());
        mb.append(Standardize.Label.retry.get() + this.retry.get());
        logger.debug(location, ILogger.null_id, mb.toString());
    }

    @Override
    public void dispatch(IWorkItem wi) {
        String location = "dispatch";
        this.dispatch.incrementAndGet();
        this.loggit(location, wi);
    }

    @Override
    public void done(IWorkItem wi) {
        String location = "done";
        this.dispatch.decrementAndGet();
        this.done.incrementAndGet();
        this.wis.ended(wi);
        this.loggit(location, wi);
    }

    @Override
    public void error(IWorkItem wi) {
        String location = "error";
        this.dispatch.decrementAndGet();
        this.error.incrementAndGet();
        this.loggit(location, wi);
    }

    @Override
    public void preempt(IWorkItem wi) {
        String location = "preempt";
        this.dispatch.decrementAndGet();
        this.preempt.incrementAndGet();
        this.loggit(location, wi);
    }

    @Override
    public void retry(IWorkItem wi) {
        String location = "retry";
        this.dispatch.decrementAndGet();
        this.retry.incrementAndGet();
        this.loggit(location, wi);
    }

    @Override
    public long getCountDispatch() {
        return this.dispatch.get();
    }

    @Override
    public long getCountDone() {
        return this.done.get();
    }

    @Override
    public long getCountError() {
        return this.error.get();
    }

    @Override
    public long getCountPreempt() {
        return this.preempt.get();
    }

    @Override
    public long getCountRetry() {
        return this.retry.get();
    }

    @Override
    public long getMillisAvg() {
        return this.wis.getMillisAvg();
    }

    @Override
    public long getMillisMax() {
        return this.wis.getMillisMax();
    }

    @Override
    public long getMillisMin() {
        return this.wis.getMillisMin();
    }

    @Override
    public long getMillisStdDev() {
        return this.wis.getMillisStdDev();
    }
}

