/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.common;

public class SynchronizedStats {
    long num = 0L;
    double sum = 0.0;
    double sumsqrs = 0.0;
    double min = Double.MAX_VALUE;
    double max = Double.MIN_VALUE;
    Object mux = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(double d) {
        Object object = this.mux;
        synchronized (object) {
            ++this.num;
            this.sum += d;
            this.sumsqrs += d * d;
            if (d < this.min) {
                this.min = d;
            }
            if (d > this.max) {
                this.max = d;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNum() {
        Object object = this.mux;
        synchronized (object) {
            return this.num;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSum() {
        Object object = this.mux;
        synchronized (object) {
            return this.sum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMax() {
        Object object = this.mux;
        synchronized (object) {
            return this.max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMin() {
        Object object = this.mux;
        synchronized (object) {
            return this.min;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMean() {
        Object object = this.mux;
        synchronized (object) {
            if (this.num == 0L) {
                return Double.NaN;
            }
            return this.sum / (double)this.num;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStandardDeviation1() {
        Object object = this.mux;
        synchronized (object) {
            if (this.num == 0L) {
                return Double.NaN;
            }
            return Math.sqrt(((double)this.num * this.sumsqrs - this.sum * this.sum) / (double)this.num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getStandardDeviation() {
        Object object = this.mux;
        synchronized (object) {
            if (this.num == 0L) {
                return Double.NaN;
            }
            return Math.sqrt((this.sumsqrs - this.sum * this.sum / (double)this.num) / (double)(this.num - 1L));
        }
    }

    public static void main(String[] args) {
        SynchronizedStats s = new SynchronizedStats();
        s.addValue(1.0);
        s.addValue(2.0);
        s.addValue(3.0);
        System.out.println("max:" + s.getMax());
        System.out.println("min:" + s.getMin());
        System.out.println("avg:" + s.getMean());
        System.out.println("dev:" + s.getStandardDeviation());
    }
}

