/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues.atomic;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.jctools.queues.QueueProgressIndicators;
import org.jctools.queues.atomic.SequencedAtomicReferenceArrayQueue;

public class MpmcAtomicArrayQueue<E>
extends SequencedAtomicReferenceArrayQueue<E>
implements QueueProgressIndicators {
    private final AtomicLong producerIndex = new AtomicLong();
    private final AtomicLong consumerIndex = new AtomicLong();

    public MpmcAtomicArrayQueue(int capacity) {
        super(MpmcAtomicArrayQueue.validateCapacity(capacity));
    }

    private static int validateCapacity(int capacity) {
        if (capacity < 2) {
            throw new IllegalArgumentException("Minimum size is 2");
        }
        return capacity;
    }

    @Override
    public boolean offer(E e) {
        long currentProducerIndex;
        int seqOffset;
        AtomicLongArray sBuffer;
        int mask;
        block3: {
            if (null == e) {
                throw new NullPointerException();
            }
            mask = this.mask;
            int capacity = mask + 1;
            sBuffer = this.sequenceBuffer;
            long cIndex = Long.MAX_VALUE;
            while (true) {
                long seq;
                long delta;
                if ((delta = (seq = this.lvSequence(sBuffer, seqOffset = MpmcAtomicArrayQueue.calcSequenceOffset(currentProducerIndex = this.lvProducerIndex(), mask))) - currentProducerIndex) == 0L) {
                    if (!this.casProducerIndex(currentProducerIndex, currentProducerIndex + 1L)) continue;
                    break block3;
                }
                if (delta < 0L && currentProducerIndex - (long)capacity <= cIndex && currentProducerIndex - (long)capacity <= (cIndex = this.lvConsumerIndex())) break;
            }
            return false;
        }
        int elementOffset = this.calcElementOffset(currentProducerIndex, mask);
        this.spElement(elementOffset, e);
        this.soSequence(sBuffer, seqOffset, currentProducerIndex + 1L);
        return true;
    }

    @Override
    public E poll() {
        long currentConsumerIndex;
        int seqOffset;
        int mask;
        AtomicLongArray lSequenceBuffer;
        block2: {
            lSequenceBuffer = this.sequenceBuffer;
            mask = this.mask;
            long pIndex = -1L;
            while (true) {
                long seq;
                long delta;
                if ((delta = (seq = this.lvSequence(lSequenceBuffer, seqOffset = MpmcAtomicArrayQueue.calcSequenceOffset(currentConsumerIndex = this.lvConsumerIndex(), mask))) - (currentConsumerIndex + 1L)) == 0L) {
                    if (!this.casConsumerIndex(currentConsumerIndex, currentConsumerIndex + 1L)) continue;
                    break block2;
                }
                if (delta < 0L && currentConsumerIndex >= pIndex && currentConsumerIndex == (pIndex = this.lvProducerIndex())) break;
            }
            return null;
        }
        int offset = this.calcElementOffset(currentConsumerIndex, mask);
        Object e = this.lpElement(offset);
        this.spElement(offset, null);
        this.soSequence(lSequenceBuffer, seqOffset, currentConsumerIndex + (long)mask + 1L);
        return e;
    }

    @Override
    public E peek() {
        long currConsumerIndex;
        Object e;
        while ((e = this.lpElement(this.calcElementOffset(currConsumerIndex = this.lvConsumerIndex()))) == null && currConsumerIndex != this.lvProducerIndex()) {
        }
        return e;
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    protected final long lvProducerIndex() {
        return this.producerIndex.get();
    }

    protected final boolean casProducerIndex(long expect, long newValue) {
        return this.producerIndex.compareAndSet(expect, newValue);
    }

    protected final long lvConsumerIndex() {
        return this.consumerIndex.get();
    }

    protected final boolean casConsumerIndex(long expect, long newValue) {
        return this.consumerIndex.compareAndSet(expect, newValue);
    }
}

