/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.launcher;

import org.apache.uima.ducc.agent.launcher.CommandBuilder;
import org.apache.uima.ducc.agent.launcher.ICommand;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.transport.cmdline.ICommandLine;
import org.apache.uima.ducc.transport.cmdline.NonJavaCommandLine;

public class SigTermCommand
implements ICommand {
    private static final String SIGTERM = "-15";
    private final String[] sigTermCmdLine;
    private final DuccLogger logger;
    private final ManagedProcess deployProcess;

    public SigTermCommand(ManagedProcess managedProcess, DuccLogger logger) {
        NonJavaCommandLine cmdL = new NonJavaCommandLine("/bin/kill");
        this.logger = logger;
        this.deployProcess = managedProcess;
        cmdL.addArgument(SIGTERM);
        cmdL.addArgument(this.deployProcess.getPid());
        this.sigTermCmdLine = CommandBuilder.deployableStopCommand((ICommandLine)cmdL, managedProcess);
    }

    @Override
    public Integer call() {
        String methodName = "SigTermCommand.call";
        ProcessBuilder processBuilder = new ProcessBuilder(this.sigTermCmdLine);
        try {
            StringBuilder sb = new StringBuilder("--->Killing Process ");
            sb.append(" Using command line:");
            int inx = 0;
            for (String cmdPart : this.sigTermCmdLine) {
                sb.append("\n\t[").append(inx++).append("]").append(cmdPart);
            }
            this.logger.info(methodName, this.deployProcess.getDuccId(), new Object[]{sb.toString()});
            Process process = processBuilder.start();
            this.deployProcess.drainProcessStreams(process, this.logger, System.out, true);
            return process.waitFor();
        }
        catch (Exception e) {
            this.logger.warn(methodName, null, (Throwable)e, new Object[0]);
            return -1;
        }
    }
}

