/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.deploy;

import java.util.List;
import org.apache.uima.ducc.agent.deploy.ServiceStateNotificationAdapter;
import org.apache.uima.ducc.common.IDuccUser;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.agent.IUimaPipelineAEComponent;
import org.apache.uima.ducc.transport.agent.ProcessStateUpdate;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.ProcessStateUpdateDuccEvent;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public class ServiceAdapter
implements ServiceStateNotificationAdapter {
    DuccLogger logger = DuccLogger.getLogger(this.getClass(), (String)"UIMA AS Service");
    private DuccEventDispatcher dispatcher;
    private String pid = null;
    private String duccProcessId;
    private IProcessState.ProcessState state;
    private String endpoint;
    private Object stateLock = new Object();

    public ServiceAdapter(DuccEventDispatcher dispatcher, String duccProcessId, String endpoint) {
        this.dispatcher = dispatcher;
        this.duccProcessId = duccProcessId;
        this.endpoint = endpoint;
    }

    @Override
    public void notifyAgentWithStatus(IProcessState.ProcessState state) {
        this.notifyAgentWithStatus(state, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAgentWithStatus(IProcessState.ProcessState state, String message) {
        Object object = this.stateLock;
        synchronized (object) {
            this.state = state;
            if (this.pid == null) {
                this.pid = Utils.getPID();
            }
            ProcessStateUpdate processUpdate = null;
            processUpdate = message == null ? new ProcessStateUpdate(state, this.pid, this.duccProcessId, null) : new ProcessStateUpdate(state, this.pid, this.duccProcessId, message, null);
            if (this.endpoint != null) {
                processUpdate.setSocketEndpoint(this.endpoint);
            }
            this.notifyAgentWithStatus(processUpdate);
        }
    }

    public void notifyAgentWithStatus(ProcessStateUpdate state) {
        try {
            ProcessStateUpdateDuccEvent duccEvent = new ProcessStateUpdateDuccEvent(state);
            this.logger.info("notifyAgentWithStatus", null, new Object[]{" >>>>>>> UIMA AS Service Deployed - PID:" + this.pid});
            if (this.endpoint != null) {
                state.setSocketEndpoint(this.endpoint);
            }
            this.dispatcher.dispatch((DuccEvent)duccEvent, System.getenv(IDuccUser.EnvironmentVariable.DUCC_IP.value()));
            String jmx = state.getProcessJmxUrl() == null ? "N/A" : state.getProcessJmxUrl();
            this.logger.info("notifyAgentWithStatus", null, new Object[]{"... UIMA AS Service Deployed - PID:" + this.pid + ". Service State: " + state + ". JMX Url:" + jmx + " Dispatched State Update Event to Agent with IP:" + System.getenv(IDuccUser.EnvironmentVariable.DUCC_IP.value())});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAgentWithStatus(List<IUimaPipelineAEComponent> pipeline) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state.equals((Object)IProcessState.ProcessState.Initializing)) {
                try {
                    ProcessStateUpdate processUpdate = new ProcessStateUpdate(this.state, this.pid, this.duccProcessId, null, pipeline);
                    this.notifyAgentWithStatus(processUpdate);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void stop() throws Exception {
        this.dispatcher.stop();
    }
}

