/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.commons.lang.SerializationUtils;
import org.apache.uima.ducc.agent.Agent;
import org.apache.uima.ducc.agent.ProcessLifecycleController;
import org.apache.uima.ducc.agent.RogueProcessReaper;
import org.apache.uima.ducc.agent.config.AgentConfiguration;
import org.apache.uima.ducc.agent.event.AgentEventListener;
import org.apache.uima.ducc.agent.event.ProcessLifecycleObserver;
import org.apache.uima.ducc.agent.launcher.CGroupsManager;
import org.apache.uima.ducc.agent.launcher.DefunctProcessDetector;
import org.apache.uima.ducc.agent.launcher.Launcher;
import org.apache.uima.ducc.agent.launcher.ManagedProcess;
import org.apache.uima.ducc.agent.launcher.SigKillCommand;
import org.apache.uima.ducc.agent.launcher.SigTermCommand;
import org.apache.uima.ducc.agent.metrics.collectors.NodeUsersCollector;
import org.apache.uima.ducc.agent.processors.ProcessMetricsProcessor;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.admin.event.DuccAdminEvent;
import org.apache.uima.ducc.common.admin.event.DuccAdminEventQuiesceAndStop;
import org.apache.uima.ducc.common.admin.event.DuccAdminEventStop;
import org.apache.uima.ducc.common.admin.event.DuccAdminEventStopMetrics;
import org.apache.uima.ducc.common.boot.DuccDaemonRuntimeProperties;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.node.metrics.NodeUsersInfo;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.IDuccLoggerComponents;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.common.utils.id.IDuccId;
import org.apache.uima.ducc.transport.agent.IUimaPipelineAEComponent;
import org.apache.uima.ducc.transport.agent.ProcessStateUpdate;
import org.apache.uima.ducc.transport.cmdline.ICommandLine;
import org.apache.uima.ducc.transport.cmdline.NonJavaCommandLine;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.apache.uima.ducc.transport.event.AgentProcessLifecycleReportDuccEvent;
import org.apache.uima.ducc.transport.event.DaemonDuccEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.NodeInventoryUpdateDuccEvent;
import org.apache.uima.ducc.transport.event.ProcessStateUpdateDuccEvent;
import org.apache.uima.ducc.transport.event.common.DuccProcess;
import org.apache.uima.ducc.transport.event.common.DuccReservation;
import org.apache.uima.ducc.transport.event.common.DuccReservationMap;
import org.apache.uima.ducc.transport.event.common.DuccUserReservation;
import org.apache.uima.ducc.transport.event.common.IDuccJobDeployment;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.common.IResourceState;
import org.apache.uima.ducc.transport.event.common.ITimeWindow;
import org.apache.uima.ducc.transport.event.common.ProcessMemoryAssignment;
import org.apache.uima.ducc.transport.event.common.TimeWindow;

public class NodeAgent
extends AbstractDuccComponent
implements Agent,
ProcessLifecycleObserver {
    public static DuccLogger logger = DuccLogger.getLogger(NodeAgent.class, (String)"Agent");
    private static DuccId jobid = null;
    public static int SIGKILL = 9;
    public static int SIGTERM = 15;
    public static AtomicLong logCounter = new AtomicLong();
    public static String cgroupFailureReason;
    private Map<DuccId, IDuccProcess> inventory = new ConcurrentHashMap<DuccId, IDuccProcess>();
    private Semaphore inventorySemaphore = new Semaphore(1);
    List<ManagedProcess> deployedProcesses = new ArrayList<ManagedProcess>();
    private NodeIdentity nodeIdentity;
    private Launcher launcher;
    public AgentConfiguration configurationFactory;
    private static Semaphore agentLock;
    private DuccEventDispatcher commonProcessDispatcher;
    private DuccEventDispatcher ORDispatcher;
    private Object monitor = new Object();
    boolean duccLingExists = false;
    boolean runWithDuccLing = false;
    private List<DuccUserReservation> reservations = new ArrayList<DuccUserReservation>();
    private Semaphore reservationsSemaphore = new Semaphore(1);
    private volatile boolean stopping = false;
    private Object stopLock = new Object();
    private RogueProcessReaper rogueProcessReaper = new RogueProcessReaper(logger, 5, 10);
    public volatile boolean useCgroups = false;
    public CGroupsManager cgroupsManager = null;
    public Node node = null;
    public volatile boolean excludeAPs = false;
    public int shareQuantum;
    private boolean agentVirtual = System.getProperty("ducc.agent.virtual") != null;
    private boolean agentRealOnly = true;
    public boolean pageSizeFetched = false;
    public int pageSize = 4096;
    public int cpuClockRate = 100;
    public int numProcessors = 0;
    ExecutorService defunctDetectorExecutor = Executors.newCachedThreadPool();
    private AgentEventListener eventListener;
    public volatile boolean receivedDuccState = false;
    private String stateChangeEndpoint;
    long maxTimeToWaitForProcessToStop = 60000L;

    public void setStateChangeEndpoint(String stateChangeEndpoint) {
        this.stateChangeEndpoint = stateChangeEndpoint;
    }

    public NodeAgent() {
        super("Agent", null);
    }

    public NodeAgent(NodeIdentity ni) {
        this();
        this.nodeIdentity = ni;
        Utils.findDuccHome();
        if (this.configurationFactory.processStopTimeout != null) {
            this.maxTimeToWaitForProcessToStop = Long.valueOf(this.configurationFactory.processStopTimeout);
        }
    }

    public long getLastORSequence() {
        long lastORSequence = 0L;
        if (this.eventListener != null) {
            lastORSequence = this.eventListener.getLastSequence();
        }
        return lastORSequence;
    }

    public AgentEventListener getEventListener() {
        return this.eventListener;
    }

    public void setAgentEventListener(AgentEventListener listener) {
        this.eventListener = listener;
    }

    public boolean isVirtual() {
        boolean retVal = this.agentVirtual;
        if (this.agentRealOnly) {
            retVal = false;
        }
        return retVal;
    }

    private void stateChange(DuccEvent.EventType eventType) {
        String methodName = "stateChange";
        try {
            IDuccLoggerComponents.Daemon daemon = IDuccLoggerComponents.Daemon.Agent;
            NodeIdentity nodeIdentity = new NodeIdentity();
            DaemonDuccEvent ev = new DaemonDuccEvent(daemon, eventType, nodeIdentity);
            this.ORDispatcher.dispatch(this.stateChangeEndpoint, (DuccEvent)ev, "");
            logger.info(methodName, null, new Object[]{this.stateChangeEndpoint, eventType.name(), nodeIdentity.getCanonicalName()});
        }
        catch (Exception e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
    }

    public DuccEventDispatcher getProcessLifecycleReportDispatcher() {
        return this.ORDispatcher;
    }

    private void sendProcessLifecycleEventReport(IDuccProcess process, AgentProcessLifecycleReportDuccEvent.LifecycleEvent lifecycleEvent) {
        String location = "sendProcessLifecycleEventReport";
        try {
            NodeIdentity nodeIdentity = this.getIdentity();
            AgentProcessLifecycleReportDuccEvent duccEvent = new AgentProcessLifecycleReportDuccEvent(process, nodeIdentity, lifecycleEvent);
            DuccEventDispatcher dispatcher = this.getProcessLifecycleReportDispatcher();
            dispatcher.dispatch((DuccEvent)duccEvent);
            StringBuffer sb = new StringBuffer();
            sb.append("id:" + process.getDuccId().toString() + " ");
            sb.append("lifecycleEvent:" + lifecycleEvent.name() + " ");
            String args = sb.toString().trim();
            logger.info(location, jobid, new Object[]{args});
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void processDeploy(ManagedProcess mp) {
        String location = "processDeploy";
        if (mp != null) {
            if (this.deployedProcesses.contains(mp)) {
                String args = "mp:" + mp.getProcessId();
                logger.error(location, jobid, new Object[]{args});
            } else {
                String args = "mp:" + mp.getProcessId();
                logger.debug(location, jobid, new Object[]{args});
                this.deployedProcesses.add(mp);
                IDuccProcess process = mp.getDuccProcess();
                this.sendProcessLifecycleEventReport(process, AgentProcessLifecycleReportDuccEvent.LifecycleEvent.Launch);
            }
        } else {
            String args = "mp:" + mp;
            logger.error(location, jobid, new Object[]{args});
        }
    }

    private void processUndeploy(ManagedProcess mp, Iterator<ManagedProcess> it) {
        String location = "processUndeploy";
        if (mp != null) {
            if (!this.deployedProcesses.contains(mp)) {
                String args = "mp:" + mp.getProcessId();
                logger.error(location, jobid, new Object[]{args});
            } else {
                String args = "mp:" + mp.getProcessId();
                logger.debug(location, jobid, new Object[]{args});
                IDuccProcess process = mp.getDuccProcess();
                this.sendProcessLifecycleEventReport(process, AgentProcessLifecycleReportDuccEvent.LifecycleEvent.Terminate);
            }
        } else {
            String args = "mp:" + mp;
            logger.error(location, jobid, new Object[]{args});
        }
    }

    public NodeAgent(NodeIdentity nodeIdentity, Launcher launcher, CamelContext context, AgentConfiguration factory) throws Exception {
        super("Agent", context);
        String cgroups;
        Utils.findDuccHome();
        this.agentVirtual = System.getProperty("ducc.agent.virtual") != null;
        this.nodeIdentity = nodeIdentity;
        this.launcher = launcher;
        this.configurationFactory = factory;
        this.commonProcessDispatcher = factory.getCommonProcessDispatcher(context);
        this.ORDispatcher = factory.getORDispatcher(context);
        this.pageSize = this.getOSPageSize();
        this.numProcessors = this.getNodeProcessors();
        logger.info("NodeAgent", null, new Object[]{"OS Page Size:" + this.pageSize});
        this.cpuClockRate = this.getOSClockRate();
        logger.info("NodeAgent", null, new Object[]{"OS Clock Rate:" + this.cpuClockRate});
        if (System.getProperty("ducc.rm.share.quantum") != null && System.getProperty("ducc.rm.share.quantum").trim().length() > 0) {
            this.shareQuantum = Integer.parseInt(System.getProperty("ducc.rm.share.quantum").trim());
        }
        String cgUtilsPath = null;
        boolean excludeNodeFromCGroups = false;
        if (!this.isVirtual() && (cgroups = System.getProperty("ducc.agent.launcher.cgroups.enable")) != null) {
            if (cgroups.equalsIgnoreCase("true")) {
                logger.info("nodeAgent", null, new Object[]{"ducc.properties [ducc.agent.launcher.cgroups.enable=true]"});
                String exclusionFile = System.getProperty("ducc.agent.exclusion.file");
                if (exclusionFile != null) {
                    logger.info("nodeAgent", null, new Object[]{"Ducc configured with cgroup node exclusion file - ducc.properties [ducc.agent.exclusion.file=" + exclusionFile + "]"});
                    NodeExclusionParser exclusionParser = new NodeExclusionParser();
                    exclusionParser.parse(exclusionFile);
                    excludeNodeFromCGroups = exclusionParser.cgroupsExcluded();
                    this.excludeAPs = exclusionParser.apExcluded();
                    if (excludeNodeFromCGroups) {
                        logger.info("nodeAgent", null, new Object[]{"------- Node Explicitly Excluded From Using CGroups. Check File:" + exclusionFile});
                        cgroupFailureReason = "------- Node Explicitly Excluded From Using CGroups. Check File:" + exclusionFile;
                    }
                    System.out.println("excludeNodeFromCGroups=" + excludeNodeFromCGroups + " excludeAPs=" + this.excludeAPs);
                } else {
                    logger.info("nodeAgent", null, new Object[]{"Agent node *not* excluded from using cgroups"});
                }
                if (!excludeNodeFromCGroups) {
                    logger.info("nodeAgent", null, new Object[]{"Testing cgroups to check if runtime utilities (cgexec) exist in expected locations in the filesystem"});
                    String cgroupsUtilsDirs = System.getProperty("ducc.agent.launcher.cgroups.utils.dir");
                    if (cgroupsUtilsDirs == null) {
                        cgUtilsPath = "/usr/bin";
                    } else {
                        String[] paths;
                        for (String path : paths = cgroupsUtilsDirs.split(",")) {
                            File file = new File(path.trim() + "/cgexec");
                            if (!file.exists()) continue;
                            cgUtilsPath = path;
                            break;
                        }
                    }
                    String cgroupsBaseDir = this.fetchCgroupsBaseDir("/proc/mounts");
                    if (cgUtilsPath == null) {
                        this.useCgroups = false;
                        logger.info("nodeAgent", null, new Object[]{"------- CGroups Disabled - Unable to Find Cgroups Utils Directory. Add/Modify ducc.agent.launcher.cgroups.utils.dir property in ducc.properties"});
                    } else if (cgroupsBaseDir == null || cgroupsBaseDir.trim().length() == 0) {
                        this.useCgroups = false;
                        logger.info("nodeAgent", null, new Object[]{"------- CGroups Disabled - Unable to Find Cgroups Root Directory in /proc/mounts"});
                    } else {
                        logger.info("nodeAgent", null, new Object[]{"Agent found cgroups runtime in " + cgUtilsPath + " cgroups base dir=" + cgroupsBaseDir});
                        String cgroupsSubsystems = "memory,cpu";
                        long maxTimeToWaitForProcessToStop = 60000L;
                        if (this.configurationFactory.processStopTimeout != null) {
                            maxTimeToWaitForProcessToStop = Long.valueOf(this.configurationFactory.processStopTimeout);
                        }
                        this.cgroupsManager = new CGroupsManager(cgUtilsPath, cgroupsBaseDir, cgroupsSubsystems, logger, maxTimeToWaitForProcessToStop);
                        this.cgroupsManager.configure(this);
                        if (this.cgroupsManager.cgroupExists(cgroupsBaseDir)) {
                            logger.info("nodeAgent", null, new Object[]{"Agent found cgroup base directory in " + cgroupsBaseDir});
                            try {
                                String containerId = "test";
                                this.cgroupsManager.validator(cgroupsBaseDir, containerId, System.getProperty("user.name"), false).cgcreate().cgset(100L);
                                this.cgroupsManager.destroyContainer(containerId, System.getProperty("user.name"), SIGKILL);
                                this.useCgroups = true;
                            }
                            catch (CGroupsManager.CGroupsException ee) {
                                logger.info("nodeAgent", null, (Throwable)ee, new Object[0]);
                                cgroupFailureReason = ee.getMessage();
                                this.useCgroups = false;
                            }
                            if (this.useCgroups) {
                                try {
                                    this.cgroupsManager.cleanup();
                                }
                                catch (Exception e) {
                                    logger.error("nodeAgent", null, (Throwable)e, new Object[0]);
                                    this.useCgroups = false;
                                    logger.info("nodeAgent", null, new Object[]{"Agent cgroup cleanup failed on this machine base directory in " + cgroupsBaseDir + ". Check if cgroups is installed on this node, Agent has correct permissions (consistent with cgconfig.conf), and the cgroup daemon is running"});
                                    cgroupFailureReason = "------- CGroups Not Working on this Machine";
                                }
                            } else {
                                logger.info("nodeAgent", null, new Object[]{"Agent cgroup test failed on this machine base directory in " + cgroupsBaseDir + ". Check if cgroups is installed on this node, Agent has correct permissions (consistent with cgconfig.conf), and the cgroup daemon is running"});
                                cgroupFailureReason = "------- CGroups Not Working on this Machine";
                            }
                        } else {
                            logger.info("nodeAgent", null, new Object[]{"Agent failed to find cgroup base directory in " + cgroupsBaseDir + ". Check if cgroups is installed on this node and the cgroup daemon is running"});
                            cgroupFailureReason = "------- CGroups Not Installed on this Machine";
                        }
                    }
                }
            }
        } else {
            logger.info("nodeAgent", null, new Object[]{"------- CGroups Not Enabled on this Machine"});
            cgroupFailureReason = "------- CGroups Not Enabled on this Machine - check ducc.properties: ducc.agent.launcher.cgroups.enable ";
        }
        factory.startNodeMetrics(this);
        logger.info("nodeAgent", null, new Object[]{"CGroup Support=" + this.useCgroups + " excludeNodeFromCGroups=" + excludeNodeFromCGroups + " excludeAPs=" + this.excludeAPs + " CGroups utils Dir:" + cgUtilsPath});
        String useSpawn = System.getProperty("ducc.agent.launcher.use.ducc_spawn");
        if (useSpawn != null && useSpawn.toLowerCase().equals("true")) {
            this.runWithDuccLing = true;
            String c_launcher_path = Utils.resolvePlaceholderIfExists((String)System.getProperty("ducc.agent.launcher.ducc_spawn_path"), (Properties)System.getProperties());
            try {
                File duccLing = new File(c_launcher_path);
                if (duccLing.exists()) {
                    this.duccLingExists = true;
                }
            }
            catch (Exception e) {
                logger.info("nodeAgent", null, new Object[]{"------- Agent failed while checking for existence of ducc_ling", e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchCgroupsBaseDir(String mounts) {
        String cbaseDir = null;
        BufferedReader br = null;
        try {
            FileInputStream fis = new FileInputStream(mounts);
            br = new BufferedReader(new InputStreamReader(fis));
            String line = null;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
                if (!line.trim().startsWith("cgroup")) continue;
                String[] cgroupsInfo = line.split(" ");
                if (cgroupsInfo[1].trim().equals("/cgroup")) {
                    cbaseDir = cgroupsInfo[1].trim();
                } else {
                    if (!cgroupsInfo[1].trim().endsWith("/memory")) continue;
                    cbaseDir = cgroupsInfo[1].substring(0, cgroupsInfo[1].indexOf("/memory"));
                }
                break;
            }
        }
        catch (Exception e) {
            logger.info("nodeAgent", null, new Object[]{"------- Agent failed while checking for existence of ducc_ling", e});
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        return cbaseDir;
    }

    public int getNodeProcessors() {
        return this.runOSCommand(new String[]{"/usr/bin/getconf", "_NPROCESSORS_ONLN"});
    }

    @Override
    public int getOSPageSize() {
        return this.runOSCommand(new String[]{"/usr/bin/getconf", "PAGESIZE"});
    }

    public int getOSClockRate() {
        return this.runOSCommand(new String[]{"/usr/bin/getconf", "CLK_TCK"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runOSCommand(String[] cmd) {
        InputStreamReader in = null;
        BufferedReader reader = null;
        int retVal = 0;
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(cmd);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            in = new InputStreamReader(p.getInputStream());
            reader = new BufferedReader(in);
            String line = null;
            while ((line = reader.readLine()) != null) {
                retVal = Integer.parseInt(line.trim());
            }
        }
        catch (Exception e) {
            logger.error("runOSCommand", null, (Throwable)e, new Object[0]);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return retVal;
    }

    public void setNodeInfo(Node node) {
        this.node = node;
    }

    public Node getNodeInfo() {
        return this.node;
    }

    public int getNodeTotalNumberOfShares() {
        int shareQuantum = 0;
        int shares = 1;
        if (System.getProperty("ducc.rm.share.quantum") != null && System.getProperty("ducc.rm.share.quantum").trim().length() > 0) {
            shareQuantum = Integer.parseInt(System.getProperty("ducc.rm.share.quantum").trim());
            shares = (int)this.getNodeInfo().getNodeMetrics().getNodeMemory().getMemTotal() / shareQuantum;
            if (this.getNodeInfo().getNodeMetrics().getNodeMemory().getMemTotal() % (long)shareQuantum > 0L) {
                ++shares;
            }
        }
        return shares;
    }

    public void start(DuccService service) throws Exception {
        super.start(service, null);
        String methodName = "start";
        String name = this.nodeIdentity.getShortName();
        String ip = this.nodeIdentity.getIp();
        String jmxUrl = this.getProcessJmxUrl();
        DuccDaemonRuntimeProperties.getInstance().bootAgent(name, ip, jmxUrl);
        String key = "ducc.broker.url";
        String value = System.getProperty(key);
        logger.info(methodName, null, new Object[]{key + "=" + value});
        this.stateChange(DuccEvent.EventType.BOOT);
    }

    public DuccEventDispatcher getEventDispatcherForRemoteProcess() {
        return this.commonProcessDispatcher;
    }

    public boolean duccLingExists() {
        return this.duccLingExists;
    }

    public void duccLingExists(boolean duccLingExists) {
        this.duccLingExists = duccLingExists;
    }

    public boolean runWithDuccLing() {
        return this.runWithDuccLing;
    }

    public void runWithDuccLing(boolean runWithDuccLing) {
        this.runWithDuccLing = runWithDuccLing;
    }

    @Override
    public Map<DuccId, IDuccProcess> getInventoryCopy() {
        Object deepCopy = null;
        try {
            this.inventorySemaphore.acquire();
            deepCopy = SerializationUtils.clone((Serializable)((ConcurrentHashMap)this.inventory));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.inventorySemaphore.release();
        }
        return (Map)deepCopy;
    }

    @Override
    public Map<DuccId, IDuccProcess> getInventoryRef() {
        return this.inventory;
    }

    private boolean invalidCommand(ICommandLine commandLine) {
        if (commandLine != null) {
            if (commandLine.getExecutable() != null && commandLine.getExecutable().length() > 0) {
                return false;
            }
            if (commandLine.getCommandLine() != null && commandLine.getCommandLine().length > 0) {
                return false;
            }
        }
        return true;
    }

    private boolean isProcessDeallocated(IDuccProcess process) {
        return process.getProcessState().equals((Object)IProcessState.ProcessState.Undefined) && process.isDeallocated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeDownProcessWithNoJob(ProcessLifecycleController lifecycleController, List<IDuccJobDeployment> jobDeploymentList) {
        String methodName = "takeDownProcessWithNoJob";
        try {
            this.inventorySemaphore.acquire();
            ArrayList<IDuccProcess> purgeList = new ArrayList<IDuccProcess>();
            boolean hasAjob = false;
            for (Map.Entry<DuccId, IDuccProcess> processEntry : this.getInventoryRef().entrySet()) {
                if (jobDeploymentList.isEmpty()) {
                    logger.info(methodName, null, new Object[]{"...Agent Process:" + processEntry.getValue().getDuccId() + " Not in JobDeploymentList. Ducc Currently Has No Jobs Running"});
                    hasAjob = false;
                } else {
                    for (IDuccJobDeployment job : jobDeploymentList) {
                        if (job.getJdProcess() != null && processEntry.getValue().getDuccId().equals((Object)job.getJdProcess().getDuccId())) {
                            hasAjob = true;
                            break;
                        }
                        for (IDuccProcess jProcess : job.getJpProcessList()) {
                            if (!processEntry.getValue().getDuccId().equals((Object)jProcess.getDuccId())) continue;
                            hasAjob = true;
                            break;
                        }
                        if (!hasAjob) continue;
                        break;
                    }
                }
                if (!hasAjob) {
                    if (this.isAlive(processEntry.getValue())) {
                        logger.error(methodName, null, new Object[]{"<<<<<<<<< Stopping Process with no Job Assignement (Ghost Process) - DuccId:" + processEntry.getValue().getDuccId() + " PID:" + processEntry.getValue().getPID()});
                        processEntry.getValue().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.JPHasNoActiveJob.toString());
                        lifecycleController.stopProcess(processEntry.getValue());
                        continue;
                    }
                    purgeList.add(processEntry.getValue());
                    continue;
                }
                hasAjob = false;
            }
            for (IDuccProcess processToPurge : purgeList) {
                logger.error(methodName, null, new Object[]{"XXXXXXXXXX Purging Process:" + processToPurge.getDuccId() + " Process State:" + processToPurge.getProcessState() + " Process Resource State:" + processToPurge.getResourceState()});
                this.getInventoryRef().remove(processToPurge.getDuccId());
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.inventorySemaphore.release();
        }
    }

    private void stopProcessIfAlive(IDuccProcess process, ProcessLifecycleController lifecycleController) {
        String methodName = "stopProcessIfAlive";
        if (this.isAlive(process)) {
            logger.error(methodName, null, new Object[]{"<<<<<<<<< Stopping Process with no Job Assignement (Ghost Process) - DuccId:" + process.getDuccId() + " PID:" + process.getPID()});
            process.setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.JPHasNoActiveJob.toString());
            lifecycleController.stopProcess(process);
        } else {
            logger.error(methodName, null, new Object[]{"XXXXXXXXXX Purging Process:" + process.getDuccId() + " Process State:" + process.getProcessState() + " Process Resource State:" + process.getResourceState()});
            this.getInventoryRef().remove(process.getDuccId());
            Iterator<ManagedProcess> it = this.deployedProcesses.iterator();
            while (it.hasNext()) {
                ManagedProcess deployedProcess = it.next();
                if (!deployedProcess.getDuccProcess().getDuccId().equals((Object)process.getDuccId())) continue;
                it.remove();
                break;
            }
            logger.info(methodName, null, new Object[]{"After Purge Inventory size:" + this.inventory.size() + " deployedProcesses size:" + this.deployedProcesses.size()});
        }
    }

    private boolean validProcess(IDuccProcess process, List<IDuccJobDeployment> jobDeploymentList) {
        for (IDuccJobDeployment job : jobDeploymentList) {
            if (job.getJdProcess() != null && process.getDuccId().equals((Object)job.getJdProcess().getDuccId())) {
                return true;
            }
            for (IDuccProcess jProcess : job.getJpProcessList()) {
                if (!process.getDuccId().equals((Object)jProcess.getDuccId())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeDownProcessWithNoJobV2(ProcessLifecycleController lifecycleController, List<IDuccJobDeployment> jobDeploymentList) {
        String methodName = "takeDownProcessWithNoJobV2";
        try {
            this.inventorySemaphore.acquire();
            for (Map.Entry<DuccId, IDuccProcess> processEntry : this.getInventoryRef().entrySet()) {
                if (!jobDeploymentList.isEmpty() && this.validProcess(processEntry.getValue(), jobDeploymentList)) continue;
                logger.info(methodName, null, new Object[]{"...Agent Process:" + processEntry.getValue().getDuccId() + " Not in OR JobDeploymentList"});
                this.stopProcessIfAlive(processEntry.getValue(), lifecycleController);
            }
        }
        catch (Exception e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        finally {
            this.inventorySemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcileProcessStateAndTakeAction(ProcessLifecycleController lifecycleController, IDuccProcess process, ICommandLine commandLine, IDuccStandardInfo info, ProcessMemoryAssignment processMemoryAssignment, DuccId workDuccId, boolean isPreemptable) {
        String methodName = "reconcileProcessStateAndTakeAction";
        try {
            this.inventorySemaphore.acquire();
            if (this.getInventoryRef().containsKey(process.getDuccId())) {
                IDuccProcess agentManagedProcess = this.getInventoryRef().get(process.getDuccId());
                if (this.isAlive(agentManagedProcess) && process.isDeallocated()) {
                    if (this.stopping && isPreemptable) {
                        logger.info(methodName, workDuccId, new Object[]{">>>>>>>> Agent is stopping - process with PID:" + process.getPID() + " is stopping"});
                        return;
                    }
                    agentManagedProcess.setResourceState(IResourceState.ResourceState.Deallocated);
                    logger.info(methodName, workDuccId, new Object[]{"<<<<<<<< Agent Stopping Process:" + process.getDuccId() + " PID:" + process.getPID() + " Reason: Ducc Deallocated the Process."});
                    lifecycleController.stopProcess(agentManagedProcess);
                }
            } else {
                this.getInventoryRef().put(process.getDuccId(), process);
                if (process.isDeallocated()) {
                    process.setProcessState(IProcessState.ProcessState.Stopped);
                } else if (process.getResourceState().equals((Object)IResourceState.ResourceState.Allocated)) {
                    if (process.getProcessState().equals((Object)IProcessState.ProcessState.Initializing) || process.getProcessState().equals((Object)IProcessState.ProcessState.Running)) {
                        process.setProcessState(IProcessState.ProcessState.Failed);
                    } else if (this.invalidCommand(commandLine)) {
                        process.setProcessState(IProcessState.ProcessState.Failed);
                        logger.info(methodName, workDuccId, new Object[]{"Rejecting Process Start Request. Command line not provided for Process ID:" + process.getDuccId()});
                        process.setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.CommandLineMissing.name());
                    } else {
                        if (this.stopping) {
                            process.setProcessState(IProcessState.ProcessState.Rejected);
                            logger.info(methodName, workDuccId, new Object[]{">>>>>>> Agent Rejected Process:" + process.getDuccId() + " Start Request - Agent is stopping"});
                            return;
                        }
                        process.setProcessState(IProcessState.ProcessState.Starting);
                        logger.info(methodName, workDuccId, new Object[]{">>>>>>> Agent Starting Process:" + process.getDuccId() + " Process State:" + process.getProcessState() + " Process Resource State:" + process.getResourceState()});
                        lifecycleController.startProcess(process, commandLine, info, workDuccId, processMemoryAssignment, isPreemptable);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(methodName, workDuccId, (Throwable)e, new Object[0]);
        }
        finally {
            this.inventorySemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStartProcess(IDuccProcess process, ICommandLine commandLine, IDuccStandardInfo info, DuccId workDuccId, boolean isPreemptable) {
        String methodName = "doStartProcess";
        try {
            this.inventorySemaphore.acquire();
            if (this.getInventoryRef().containsKey(process.getDuccId())) {
                logger.error(methodName, null, new Object[]{"Rejecting Process Start Request. Process with a Ducc ID:" + process.getDuccId() + " is already in agent's inventory."});
                return;
            }
            this.startProcess(process, commandLine, info, workDuccId, new ProcessMemoryAssignment(), isPreemptable);
        }
        catch (InterruptedException e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        finally {
            this.inventorySemaphore.release();
        }
    }

    private boolean isProcessRunning(IDuccProcess process) {
        return process.getProcessState().equals((Object)IProcessState.ProcessState.Running) || process.getProcessState().equals((Object)IProcessState.ProcessState.Initializing);
    }

    private boolean isOverSwapLimit(IDuccProcess process) {
        for (ManagedProcess deployedProcess : this.deployedProcesses) {
            if (!deployedProcess.getDuccProcess().getDuccId().equals((Object)process.getDuccId()) || process.getSwapUsage() <= deployedProcess.getMaxSwapThreshold()) continue;
            return true;
        }
        return false;
    }

    private long getSwapOverLimit(IDuccProcess process) {
        long overLimit = 0L;
        for (ManagedProcess deployedProcess : this.deployedProcesses) {
            if (!deployedProcess.getDuccProcess().getDuccId().equals((Object)process.getDuccId())) continue;
            overLimit = deployedProcess.getMaxSwapThreshold() - process.getSwapUsage();
        }
        if (overLimit < 0L) {
            overLimit = 0L;
        }
        return overLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killProcessDueToLowSwapSpace(long minSwapThreshold) {
        String methodName = "killProcessDueToLowSwapSpace";
        IDuccProcess biggestProcess = null;
        try {
            this.inventorySemaphore.acquire();
            for (Map.Entry<DuccId, IDuccProcess> processEntry : this.getInventoryRef().entrySet()) {
                if (!this.isProcessRunning(processEntry.getValue()) || !this.isOverSwapLimit(processEntry.getValue()) || biggestProcess != null && this.getSwapOverLimit(biggestProcess) >= this.getSwapOverLimit(processEntry.getValue())) continue;
                biggestProcess = processEntry.getValue();
            }
        }
        catch (InterruptedException e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        finally {
            this.inventorySemaphore.release();
        }
        if (biggestProcess != null) {
            biggestProcess.setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.LowSwapSpace.toString());
            logger.info(methodName, null, new Object[]{"Stopping Process:" + biggestProcess.getDuccId() + " PID:" + biggestProcess.getPID() + " Due to a low swap space. Process' RSS exceeds configured swap threshold of " + minSwapThreshold + " Defined in ducc.properties. Check ducc.node.min.swap.threshold property"});
            this.stopProcess(biggestProcess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptThreadInWaitFor(String pid) throws Exception {
        String methodName = "interruptZombieProcess";
        Object object = this.monitor;
        synchronized (object) {
            for (ManagedProcess dProcess : this.deployedProcesses) {
                if (dProcess.getPid() == null || !dProcess.getPid().equals(pid)) continue;
                Future<?> future = dProcess.getFuture();
                if (future == null || future.isDone() || future.isCancelled()) break;
                future.cancel(true);
                logger.info(methodName, dProcess.getDuccProcess().getDuccId(), new Object[]{"Interrupted Thread - Zombie Process with PID:" + dProcess.getPid()});
                break;
            }
        }
    }

    @Override
    public void startProcess(IDuccProcess process, ICommandLine commandLine, IDuccStandardInfo info, DuccId workDuccId, ProcessMemoryAssignment processMemoryAssignment, boolean isPreemptable) {
        String methodName = "startProcess";
        try {
            this.getInventoryRef().put(process.getDuccId(), process);
            if (this.invalidCommand(commandLine)) {
                process.setProcessState(IProcessState.ProcessState.Failed);
                logger.info(methodName, null, new Object[]{"Rejecting Process Start Request. Command line not provided for Process ID:" + process.getDuccId()});
            } else if (this.isProcessDeallocated(process)) {
                process.setProcessState(IProcessState.ProcessState.Stopped);
                logger.info(methodName, null, new Object[]{"Rejecting Process Start Request. Process ID:" + process.getDuccId() + " hava already been deallocated due to Shrink"});
            } else {
                this.deployProcess(process, commandLine, info, workDuccId, processMemoryAssignment, isPreemptable);
            }
        }
        catch (Exception e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
    }

    public boolean isAlive(IDuccProcess invProcess) {
        return invProcess.getProcessState().equals((Object)IProcessState.ProcessState.Initializing) || invProcess.getProcessState().equals((Object)IProcessState.ProcessState.Running) || invProcess.getProcessState().equals((Object)IProcessState.ProcessState.Stopping) || invProcess.getProcessState().equals((Object)IProcessState.ProcessState.Starting) || invProcess.getProcessState().equals((Object)IProcessState.ProcessState.Started);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStopProcess(IDuccProcess process) {
        String methodName = "stopProcess";
        try {
            this.inventorySemaphore.acquire();
            this.stopProcess(process);
        }
        catch (InterruptedException e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        finally {
            this.inventorySemaphore.release();
        }
    }

    @Override
    public void stopProcess(IDuccProcess process) {
        String methodName = "stopProcess";
        try {
            IDuccProcess invProcess = null;
            invProcess = this.getInventoryRef().get(process.getDuccId());
            if (invProcess != null && this.isAlive(invProcess)) {
                logger.info(methodName, null, new Object[]{"Undeploing Process with PID:" + process.getPID()});
                this.undeployProcess(process);
            } else if (invProcess == null) {
                logger.info(methodName, null, new Object[]{"Agent received Stop request for a process which is not in the Agent's inventory. It looks like this Agent was killed along with its child processes. Adding stale process to the inventory. PID:" + process.getPID() + " DuccId:" + process.getDuccId() + ""});
                if (process.getProcessState() != IProcessState.ProcessState.Stopped && process.getProcessState() != IProcessState.ProcessState.Failed && process.getProcessState() != IProcessState.ProcessState.InitializationTimeout && process.getProcessState() != IProcessState.ProcessState.FailedInitialization) {
                    process.setProcessState(IProcessState.ProcessState.Stopped);
                }
                this.getInventoryRef().put(process.getDuccId(), process);
            }
        }
        catch (Exception e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
    }

    private boolean addProcessMemoryCollector(String pid) {
        for (Route route : super.getContext().getRoutes()) {
            if (!route.getId().equals(pid)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeProcess(IDuccProcess process) throws Exception {
        String methodName = "purgeProcess";
        DuccId key = null;
        String pid = "";
        try {
            this.inventorySemaphore.acquire();
            for (Map.Entry<DuccId, IDuccProcess> processEntry : this.getInventoryRef().entrySet()) {
                if (!processEntry.getKey().equals((Object)process.getDuccId())) continue;
                key = processEntry.getKey();
                pid = processEntry.getValue().getPID();
                break;
            }
            if (key != null) {
                this.getInventoryRef().remove(key);
                logger.info(methodName, null, new Object[]{">>>> Agent Purged Process with PID:" + pid});
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.inventorySemaphore.release();
        }
        Iterator<ManagedProcess> it = this.deployedProcesses.iterator();
        while (it.hasNext()) {
            ManagedProcess deployedProcess = it.next();
            if (!deployedProcess.getDuccProcess().getDuccId().equals((Object)process.getDuccId())) continue;
            this.processUndeploy(deployedProcess, it);
            break;
        }
    }

    private boolean changeState(IProcessState.ProcessState state) {
        switch (state) {
            case FailedInitialization: 
            case InitializationTimeout: 
            case Stopped: 
            case Stopping: {
                return false;
            }
            case Starting: 
            case Started: 
            case Initializing: 
            case Running: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProcessStatus(ProcessStateUpdateDuccEvent duccEvent) throws Exception {
        String methodName = "updateProcessStatus";
        try {
            this.inventorySemaphore.acquire();
            for (Map.Entry<DuccId, IDuccProcess> processEntry : this.getInventoryRef().entrySet()) {
                Object millis;
                ITimeWindow tw;
                if (!processEntry.getKey().getUnique().equals(duccEvent.getDuccProcessId())) continue;
                if (duccEvent.getPid() != null && processEntry.getValue().getPID() == null) {
                    processEntry.getValue().setPID(duccEvent.getPid());
                }
                if (duccEvent.getProcessJmxUrl() != null && processEntry.getValue().getProcessJmxUrl() == null) {
                    processEntry.getValue().setProcessJmxUrl(duccEvent.getProcessJmxUrl());
                }
                if ((tw = processEntry.getValue().getTimeWindowInit()) != null && tw.getEnd() == null && !duccEvent.getState().equals((Object)IProcessState.ProcessState.Initializing)) {
                    tw.setEnd(TimeStamp.getCurrentMillis());
                    if (duccEvent.getState().equals((Object)IProcessState.ProcessState.Running)) {
                        TimeWindow twr = new TimeWindow();
                        millis = TimeStamp.getCurrentMillis();
                        processEntry.getValue().setTimeWindowRun((ITimeWindow)twr);
                        twr.setStart((String)millis);
                    }
                }
                ManagedProcess deployedProcess = null;
                millis = this.monitor;
                synchronized (millis) {
                    for (ManagedProcess dProcess : this.deployedProcesses) {
                        if (!dProcess.getDuccProcess().getDuccId().getUnique().equals(duccEvent.getDuccProcessId())) continue;
                        deployedProcess = dProcess;
                        break;
                    }
                }
                if (processEntry.getValue().getProcessState() != IProcessState.ProcessState.Running && duccEvent.getState().equals((Object)IProcessState.ProcessState.Running) && deployedProcess != null) {
                    deployedProcess.stopInitializationTimer();
                }
                logger.info(methodName, null, new Object[]{">>>> Agent Handling Process Update - Ducc Id: " + processEntry.getValue().getDuccId() + " PID:" + processEntry.getValue().getPID() + " Status:" + duccEvent.getState() + " Deallocated:" + processEntry.getValue().isDeallocated()});
                if (deployedProcess != null && deployedProcess.getSocketEndpoint() == null && duccEvent.getServiceEdnpoint() != null) {
                    deployedProcess.setSocketEndpoint(duccEvent.getServiceEdnpoint());
                }
                if (deployedProcess != null && deployedProcess.killAfterLaunch()) {
                    logger.info(methodName, null, new Object[]{">>>> Process Ducc Id:" + processEntry.getValue().getDuccId() + " Was Previously Tagged for Kill While It Was Starting"});
                    this.undeployProcess(processEntry.getValue());
                } else if (deployedProcess != null && deployedProcess.doKill() && deployedProcess.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Stopped)) {
                    deployedProcess.getDuccProcess().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.KilledByDucc.toString());
                } else {
                    if (deployedProcess != null && (deployedProcess.doKill() || deployedProcess.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Failed) || deployedProcess.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Killed))) {
                        return;
                    }
                    if (this.changeState(processEntry.getValue().getProcessState())) {
                        logger.info(methodName, null, new Object[]{"=============== PID:" + processEntry.getValue().getPID() + " Changing State - current state:" + processEntry.getValue().getProcessState() + " New State:" + duccEvent.getState()});
                        processEntry.getValue().setProcessState(duccEvent.getState());
                    }
                }
                if (this.addProcessMemoryCollector(duccEvent.getPid()) && (duccEvent.getState().equals((Object)IProcessState.ProcessState.Initializing) || duccEvent.getState().equals((Object)IProcessState.ProcessState.Running))) {
                    if (duccEvent.getState().equals((Object)IProcessState.ProcessState.Running) && processEntry.getValue().getUimaPipelineComponents() != null && processEntry.getValue().getUimaPipelineComponents().size() > 0) {
                        processEntry.getValue().getUimaPipelineComponents().clear();
                        if (duccEvent.getUimaPipeline() != null) {
                            duccEvent.getUimaPipeline().clear();
                        }
                    }
                } else if (duccEvent.getState().equals((Object)IProcessState.ProcessState.Stopped) || duccEvent.getState().equals((Object)IProcessState.ProcessState.Failed) || duccEvent.getState().equals((Object)IProcessState.ProcessState.Killed)) {
                    if (deployedProcess.getMetricsProcessor() != null) {
                        deployedProcess.getMetricsProcessor().close();
                    }
                    logger.info(methodName, null, new Object[]{"----------- Agent Stopped ProcessMemoryUsagePollingRouter for Process:" + duccEvent.getPid()});
                } else if (duccEvent.getState().equals((Object)IProcessState.ProcessState.FailedInitialization)) {
                    logger.info(methodName, null, new Object[]{">>>> Agent Handling Process FailedInitialization. PID:" + duccEvent.getPid()});
                    deployedProcess.getDuccProcess().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.FailedInitialization.toString());
                    deployedProcess.getDuccProcess().setProcessState(IProcessState.ProcessState.Stopping);
                    deployedProcess.setStopping();
                    deployedProcess.kill();
                    logger.info(methodName, null, new Object[]{">>>> Agent Handling Process FailedInitialization. PID:" + duccEvent.getPid() + " Killing Process"});
                    this.undeployProcess(processEntry.getValue());
                } else if (duccEvent.getState().equals((Object)IProcessState.ProcessState.InitializationTimeout)) {
                    deployedProcess.getDuccProcess().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.InitializationTimeout.toString());
                    deployedProcess.getDuccProcess().setProcessState(IProcessState.ProcessState.Stopping);
                    deployedProcess.setStopping();
                    deployedProcess.kill();
                    logger.info(methodName, null, new Object[]{">>>> Agent Handling Process InitializationTimeout. PID:" + duccEvent.getPid() + " Killing Process"});
                    this.undeployProcess(processEntry.getValue());
                } else if (duccEvent.getState().equals((Object)IProcessState.ProcessState.Stopping)) {
                    if (duccEvent.getMessage() != null && duccEvent.getMessage().equals(IDuccProcess.ReasonForStoppingProcess.ExceededErrorThreshold.toString())) {
                        processEntry.getValue().setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.ExceededErrorThreshold.toString());
                    }
                    if (!deployedProcess.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Stopped) && !deployedProcess.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Stopping)) {
                        deployedProcess.getDuccProcess().setProcessState(IProcessState.ProcessState.Stopping);
                        deployedProcess.setStopping();
                    }
                }
                if (duccEvent.getUimaPipeline() != null) {
                    StringBuffer buffer = new StringBuffer("\t\tUima Pipeline -");
                    for (IUimaPipelineAEComponent uimaAeState : duccEvent.getUimaPipeline()) {
                        buffer.append("\n\t\tAE:").append(uimaAeState.getAeName()).append(" state:").append(uimaAeState.getAeState()).append(" InitTime:").append(uimaAeState.getInitializationTime() / 1000L).append(" secs. Thread:").append(uimaAeState.getAeThreadId());
                    }
                    logger.info(methodName, null, new Object[]{buffer.toString()});
                    ((DuccProcess)processEntry.getValue()).setUimaPipelineComponents(duccEvent.getUimaPipeline());
                }
                return;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.inventorySemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployProcess(IDuccProcess process, ICommandLine commandLine, IDuccStandardInfo info, DuccId workDuccId, ProcessMemoryAssignment processMemoryAssignment, boolean preemptable) {
        String methodName = "deployProcess";
        Object object = this.monitor;
        synchronized (object) {
            boolean deployProcess = true;
            for (ManagedProcess deployedProcess : this.deployedProcesses) {
                if (!deployedProcess.getDuccId().equals((Object)process.getDuccId())) continue;
                deployProcess = false;
                break;
            }
            if (deployProcess) {
                try {
                    logger.info(methodName, workDuccId, new Object[]{"Agent [" + this.getIdentity().getIp() + "] Deploying Process - DuccID:" + process.getDuccId().getFriendly() + " Unique DuccID:" + process.getDuccId().getUnique() + " Node Assignment:" + process.getNodeIdentity().getIp() + " Process Memory Assignment:" + processMemoryAssignment + " MBs"});
                    TimeWindow tw = new TimeWindow();
                    tw.setStart(TimeStamp.getCurrentMillis());
                    tw.setEnd(null);
                    process.setTimeWindowInit((ITimeWindow)tw);
                    ManagedProcess managedProcess = new ManagedProcess(process, commandLine, this, logger, processMemoryAssignment, preemptable);
                    managedProcess.setProcessInfo(info);
                    managedProcess.setWorkDuccId(workDuccId);
                    ManagedProcess deployedProcess = this.launcher.launchProcess(this, this.getIdentity(), process, commandLine, this, managedProcess);
                    this.processDeploy(deployedProcess);
                }
                catch (Exception e) {
                    logger.error(methodName, null, (Throwable)e, new Object[0]);
                }
            } else {
                logger.info(methodName, workDuccId, new Object[]{"Ignoring duplicate request to start process - DuccID:" + process.getDuccId().getFriendly() + " Unique DuccID:" + process.getDuccId().getUnique()});
            }
        }
    }

    private boolean runnable(ManagedProcess process) {
        return process.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Initializing) || process.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Starting) || process.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Started) || process.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Running);
    }

    private boolean stopChildProcesses(boolean quiesceMode) {
        String methodName = "stopNow";
        boolean wait = false;
        try {
            for (ManagedProcess deployedProcess : this.deployedProcesses) {
                String pid = deployedProcess.getDuccProcess().getPID();
                logger.info(methodName, null, new Object[]{"....Process:" + pid + " is JD=" + deployedProcess.isJd() + " Preemptable:" + deployedProcess.isPreemptable()});
                if (quiesceMode && !deployedProcess.isPreemptable() || deployedProcess.isStopping() || pid == null || pid.trim().length() == 0 || !this.runnable(deployedProcess)) continue;
                logger.info(methodName, null, new Object[]{"....Stopping Process - DuccId:" + deployedProcess.getDuccProcess().getDuccId() + " PID:" + pid + " Sending SIGTERM Process State:" + deployedProcess.getDuccProcess().getProcessState().toString() + " Process Type:" + deployedProcess.getDuccProcess().getProcessType() + " Uima AS:" + deployedProcess.isUimaAs() + " Preemtable:" + deployedProcess.isPreemptable()});
                wait = true;
                deployedProcess.setStopPriority(ManagedProcess.StopPriority.DONT_WAIT);
                ExecutorService executor = Executors.newSingleThreadExecutor();
                executor.execute(new ProcessRunner(deployedProcess));
            }
        }
        catch (Exception e) {
            logger.warn(methodName, null, (Throwable)e, new Object[0]);
        }
        return wait;
    }

    private void killChildProcesses(boolean killOnlyUimaAs, boolean quiesce) {
        String methodName = "killChildProcesses";
        try {
            if (this.useCgroups) {
                logger.info(methodName, null, new Object[]{"CgroupsManager.cleanup() before "});
                if (killOnlyUimaAs) {
                    HashSet<String> pidsToKill = new HashSet<String>();
                    for (ManagedProcess p : this.deployedProcesses) {
                        if (p.isPreemptable() || p.getPid() == null || !p.isUimaAs()) continue;
                        pidsToKill.add(p.getPid());
                    }
                    if (!pidsToKill.isEmpty()) {
                        logger.info(methodName, null, new Object[]{">>>>>>>> Found " + pidsToKill.size() + " UIMA-AS processes still running - killing all non-preemptables via kill -9"});
                        this.cgroupsManager.cleanupPids(pidsToKill);
                    }
                } else {
                    HashSet<String> pidsToKill = new HashSet<String>();
                    for (ManagedProcess p : this.deployedProcesses) {
                        if (quiesce || p.isPreemptable() || p.getPid() == null || !p.isUimaAs()) continue;
                        pidsToKill.add(p.getPid());
                    }
                    this.cgroupsManager.cleanupPids(pidsToKill);
                }
                logger.info(methodName, null, new Object[]{"CgroupsManager.cleanup() after "});
            } else {
                for (ManagedProcess deployedProcess : this.deployedProcesses) {
                    NonJavaCommandLine cmdLine;
                    String pid = deployedProcess.getDuccProcess().getPID();
                    if (quiesce && !deployedProcess.isPreemptable() || pid == null || pid.trim().length() == 0 || !this.runnable(deployedProcess)) continue;
                    logger.info(methodName, null, new Object[]{"....Stopping Process - DuccId:" + deployedProcess.getDuccProcess().getDuccId() + " PID:" + pid + " Sending SIGKILL Process State:" + deployedProcess.getDuccProcess().getProcessState().toString()});
                    if (Utils.isWindows()) {
                        cmdLine = new NonJavaCommandLine("taskkill");
                        cmdLine.addArgument("/PID");
                    } else {
                        cmdLine = new NonJavaCommandLine("/bin/kill");
                        cmdLine.addArgument("-9");
                    }
                    cmdLine.addArgument(pid);
                    deployedProcess.setStopping();
                    deployedProcess.setStopPriority(ManagedProcess.StopPriority.DONT_WAIT);
                    this.launcher.launchProcess(this, this.getIdentity(), deployedProcess.getDuccProcess(), (ICommandLine)cmdLine, this, deployedProcess);
                }
            }
        }
        catch (Exception e) {
            logger.warn(methodName, null, (Throwable)e, new Object[0]);
        }
    }

    private void handleSigTermTimeout(ManagedProcess deployedProcess) {
        String methodName = "handleSigTermTimeout";
        if (!deployedProcess.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Stopped)) {
            logger.info(methodName, deployedProcess.getDuccId(), new Object[]{"------------ Agent Timed-out Waiting for Process with PID:" + deployedProcess.getDuccProcess().getPID() + " to Stop. Process State:" + deployedProcess.getDuccProcess().getProcessState() + " .Process did not stop in allotted time of " + this.maxTimeToWaitForProcessToStop + " millis"});
            logger.info(methodName, deployedProcess.getDuccId(), new Object[]{">>>>>>>>>>>>>>> Killing Process:" + deployedProcess.getDuccProcess().getPID() + " .Process State:" + deployedProcess.getDuccProcess().getProcessState()});
        }
        SigKillCommand sigKillCommand = new SigKillCommand(deployedProcess, logger);
        this.launcher.launchOSCommand(sigKillCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployProcess(IDuccProcess process) {
        String methodName = "undeployProcess";
        Object object = this.monitor;
        synchronized (object) {
            ManagedProcess deployedProcess = this.getDeployedProcess((IDuccId)process.getDuccId());
            if (Objects.isNull(deployedProcess)) {
                logger.info(methodName, null, new Object[]{".... Process - DuccId:" + process.getDuccId() + " PID:" + process.getPID() + " Not in Agent's inventory. Adding to the inventory with state=Stopped"});
                process.setProcessState(IProcessState.ProcessState.Stopped);
                this.inventory.put(process.getDuccId(), process);
                this.processDeploy(new ManagedProcess(process, null, this, logger, new ProcessMemoryAssignment(), true));
                return;
            }
            if (Objects.isNull(deployedProcess.getPid())) {
                if (!deployedProcess.getDuccProcess().getProcessState().equals((Object)IProcessState.ProcessState.Stopped)) {
                    logger.info(methodName, deployedProcess.getDuccId(), new Object[]{".... Process - Ducc ID:" + deployedProcess.getDuccId() + " Has Not Started Yet. PID Not Available. Tagging Process For Kill When It Reports Status"});
                    deployedProcess.killAfterLaunch(true);
                }
                return;
            }
            SigTermCommand sigTermCommand = new SigTermCommand(deployedProcess, logger);
            deployedProcess.setStopping();
            try {
                logger.info(methodName, deployedProcess.getDuccId(), new Object[]{"------------ Agent Starting Killer Timer Task For Process with PID:" + deployedProcess.getDuccProcess().getPID() + " Process State: " + deployedProcess.getDuccProcess().getProcessState()});
                this.launcher.launchOSCommand(sigTermCommand);
                Future<?> future = deployedProcess.getFuture();
                future.get(this.maxTimeToWaitForProcessToStop, TimeUnit.MILLISECONDS);
                logger.info(methodName, deployedProcess.getDuccId(), new Object[]{">>>>>>>>>>>>> Process with PID:" + deployedProcess.getDuccProcess().getPID() + " Terminated"});
            }
            catch (TimeoutException e) {
                logger.info(methodName, deployedProcess.getDuccId(), new Object[]{">>>>>>>>> Timed Out Waiting For Process To Terminate After SIGTERM Was Sent"});
                this.handleSigTermTimeout(deployedProcess);
            }
            catch (Exception e) {
                logger.error(methodName, deployedProcess.getDuccId(), (Throwable)e, new Object[0]);
            }
            try {
                this.monitor.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isProcessRunning(deployedProcess.getDuccProcess())) {
                this.defunctDetectorExecutor.execute(new DefunctProcessDetector(deployedProcess, logger));
            }
            logger.info(methodName, deployedProcess.getDuccId(), new Object[]{"Inventory size:" + this.inventory.size() + " deployedProcesses size:" + this.deployedProcesses.size()});
        }
    }

    @Override
    public NodeIdentity getIdentity() {
        return this.nodeIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onProcessExit(IDuccProcess process) {
        String methodName = "onProcessExit";
        if (process == null) {
            return;
        }
        try {
            ProcessStateUpdate processStateUpdate = new ProcessStateUpdate(process.getProcessState(), process.getPID(), process.getDuccId().getUnique());
            ProcessStateUpdateDuccEvent event = new ProcessStateUpdateDuccEvent(processStateUpdate);
            if (process.getPID() != null && super.getContext().getRoute(process.getPID()) != null) {
                try {
                    super.getContext().stopRoute(process.getPID());
                }
                catch (Exception e) {
                    logger.error(methodName, null, new Object[]{"....Unable to stop Camel route for PID:" + process.getPID()});
                }
                super.getContext().removeRoute(process.getPID());
                StringBuilder sb = new StringBuilder("\n");
                logger.info(methodName, null, new Object[]{"Removed Camel Route from Context for PID:" + process.getPID()});
                for (Route route : super.getContext().getRoutes()) {
                    sb.append("Camel Context - RouteId:" + route.getId() + "\n");
                }
                logger.info(methodName, null, new Object[]{sb.toString()});
            }
            this.updateProcessStatus(event);
        }
        catch (Exception e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void onJPInitTimeout(IDuccProcess process, long timeout) {
        String methodName = "onJPInitTimeout";
        try {
            System.out.println("--------- Agent Timedout While Waiting For JP (PID:" + process.getPID() + ") to initialize. The JP exceeded configured timeout of " + timeout / 60000L + " minutes");
            ProcessStateUpdate processStateUpdate = new ProcessStateUpdate(IProcessState.ProcessState.InitializationTimeout, process.getPID(), process.getDuccId().getUnique());
            ProcessStateUpdateDuccEvent event = new ProcessStateUpdateDuccEvent(processStateUpdate);
            this.updateProcessStatus(event);
        }
        catch (Exception e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
    }

    public void shutdown(String reason) {
        String methodName = "shutdown";
        for (ManagedProcess deployedProcess : this.deployedProcesses) {
            try {
                this.undeployProcess(deployedProcess.getDuccProcess());
            }
            catch (Exception e) {
                logger.error(methodName, null, (Throwable)e, new Object[0]);
            }
        }
    }

    public static void lock() throws Exception {
        agentLock.acquire();
    }

    public static void unlock() throws Exception {
        agentLock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isManagedProcess(Set<NodeUsersCollector.ProcessInfo> processList, NodeUsersCollector.ProcessInfo cpi) {
        Object object = this.monitor;
        synchronized (object) {
            for (ManagedProcess deployedProcess : this.deployedProcesses) {
                String dppid;
                if (deployedProcess.getDuccProcess() == null || (dppid = deployedProcess.getDuccProcess().getPID()) != null && !dppid.equals(String.valueOf(cpi.getPid()))) continue;
                return true;
            }
            for (NodeUsersCollector.ProcessInfo pi : processList) {
                if (pi.getPid() != cpi.getPPid() || pi.getChildren().size() <= 0) continue;
                return this.isManagedProcess(pi.getChildren(), pi);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRogueProcess(String uid, Set<NodeUsersCollector.ProcessInfo> processList, NodeUsersCollector.ProcessInfo cpi) throws Exception {
        Object object = this.monitor;
        synchronized (object) {
            if (this.useCgroups && this.cgroupsManager.isPidInCGroup(String.valueOf(cpi.getPid()))) {
                return false;
            }
            boolean foundDeployedProcessWithNoPID = false;
            for (ManagedProcess deployedProcess : this.deployedProcesses) {
                if (deployedProcess.getDuccProcess() == null) continue;
                if (deployedProcess.getDuccProcess().getPID() == null) {
                    foundDeployedProcessWithNoPID = true;
                    break;
                }
                String dppid = deployedProcess.getDuccProcess().getPID();
                if (dppid == null || !dppid.equals(String.valueOf(cpi.getPid()))) continue;
                return false;
            }
            if (foundDeployedProcessWithNoPID) {
                return false;
            }
            if (cpi.getPPid() == 1) {
                this.interruptThreadInWaitFor(String.valueOf(cpi.getPid()));
                return true;
            }
            return this.isParentProcessRogue(processList, cpi);
        }
    }

    private boolean isParentProcessRogue(Set<NodeUsersCollector.ProcessInfo> processList, NodeUsersCollector.ProcessInfo cpi) {
        for (NodeUsersCollector.ProcessInfo pi : processList) {
            if (pi.getPid() == cpi.getPPid()) {
                return pi.isRogue();
            }
            if (pi.getChildren().size() <= 0) continue;
            return this.isParentProcessRogue(pi.getChildren(), cpi);
        }
        return true;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public void quiesceAndStop() throws Exception {
        this.stop(true, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean quiesce, long waitTimeInSecs) throws Exception {
        Object object = this.stopLock;
        synchronized (object) {
            logger.info("stop", null, new Object[]{"Agent stop() - quiesce:" + quiesce});
            if (this.stopping) {
                return;
            }
            this.stopping = true;
            this.stateChange(DuccEvent.EventType.SHUTDOWN);
            boolean wait = this.stopChildProcesses(quiesce);
            if (quiesce) {
                logger.info("stop", null, new Object[]{"Agent stopping managed processes"});
                long waitTime = 60L;
                try {
                    waitTime = Long.valueOf(this.configurationFactory.processStopTimeout);
                    waitTime /= 1000L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.waitForChildProcessesToTerminateAndKill(wait, waitTime, true, quiesce);
                logger.info("stop", null, new Object[]{">>>>>>>>>>>> stop() waitForChildProcessesToTerminateAndKill() completed"});
                this.waitForChildProcessesToTerminate(false);
                logger.info("stop", null, new Object[]{">>>>>>>>>>>> stop() waitForChildProcessesToTerminate() completed"});
            } else {
                logger.info("stop", null, new Object[]{"Agent stopping managed processes with reaper delay of " + waitTimeInSecs + " secs"});
                this.waitForChildProcessesToTerminateAndKill(wait, waitTimeInSecs, false, quiesce);
            }
            NodeInventoryUpdateDuccEvent duccEvent = new NodeInventoryUpdateDuccEvent(this.inventory, this.getLastORSequence(), this.getIdentity());
            this.ORDispatcher.dispatch((DuccEvent)duccEvent);
            logger.info("stop", null, new Object[]{"Agent published final inventory"});
            logger.info("stop", null, new Object[]{"Stopping Publishing Metrics and Inventory"});
            this.configurationFactory.stop();
            logger.info("stop", null, new Object[]{"Reaper thread finished - calling super.stop()"});
            super.stop();
        }
    }

    public void stop() throws Exception {
        this.stop(false, 60L);
    }

    private void waitForChildProcessesToTerminateAndKill(boolean wait, long waitTimeInSecs, boolean killJustUimaAs, boolean quiesce) throws Exception {
        if (wait && !this.deployedProcesses.isEmpty()) {
            logger.info("waitForChildProcessesToTerminateAndKill", null, new Object[]{"Agent Sent SIGTERM to ALL Non-Preemptable Child Processes - Number of Deployed Processes:" + this.deployedProcesses.size()});
            Timer timer = new Timer(true);
            logger.info("waitForChildProcessesToTerminateAndKill", null, new Object[]{"Waiting", waitTimeInSecs, " secs before sending kill -9 to all ***non-preemptable*** child processes still running"});
            CountDownLatch completionLatch = new CountDownLatch(1);
            timer.schedule((TimerTask)new KillTimerTask(completionLatch, killJustUimaAs, quiesce), waitTimeInSecs * 1000L);
            completionLatch.await();
        }
        this.stopLock.wait(1000L);
        logger.info("waitForChildProcessesToTerminateAndKill", null, new Object[]{"Done"});
    }

    private void waitForChildProcessesToTerminate(boolean quiesceMode) throws Exception {
        logger.info("waitForChildProcessesToTerminate", null, new Object[]{"Agent Sent SIGTERM to Child Processes - Waiting for them to Quiesce - Number of Deployed Processes:" + this.deployedProcesses.size()});
        for (ManagedProcess p : this.deployedProcesses) {
            if (quiesceMode && p.isUimaAs()) continue;
            p.getFuture().get();
        }
    }

    public Future<?> getDeployedJPFuture(IDuccId duccId) {
        for (ManagedProcess deployedProcess : this.deployedProcesses) {
            if (!deployedProcess.getDuccId().equals((Object)duccId)) continue;
            return deployedProcess.getFuture();
        }
        return null;
    }

    public ManagedProcess getDeployedProcess(IDuccId duccId) {
        for (ManagedProcess deployedProcess : this.deployedProcesses) {
            if (!deployedProcess.getDuccId().equals((Object)duccId)) continue;
            return deployedProcess;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReservations(List<DuccUserReservation> reserves) throws Exception {
        try {
            this.reservationsSemaphore.acquire();
            if (reserves != null) {
                this.reservations.clear();
                DuccReservationMap reserveMap = new DuccReservationMap();
                for (DuccUserReservation r : reserves) {
                    reserveMap.clear();
                    for (Map.Entry entry : r.getUserReservations().entrySet()) {
                        if (!Utils.isThisNode((String)this.getIdentity().getIp(), (String)((IDuccReservation)entry.getValue()).getNodeIdentity().getIp())) continue;
                        reserveMap.addReservation((IDuccReservation)entry.getValue());
                    }
                    if (reserveMap.getMap().size() <= 0) continue;
                    DuccUserReservation reserve = new DuccUserReservation(r.getUserId(), r.getReserveID(), (IDuccReservationMap)reserveMap);
                    this.reservations.add(reserve);
                }
            }
            logger.debug("setReservations", null, new Object[]{"+++++++++++ Copied User Reservations - List Size:" + this.reservations.size()});
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.reservationsSemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DuccId> getUserReservations(String uid) {
        ArrayList<DuccId> reservationIds;
        block6: {
            reservationIds = new ArrayList<DuccId>();
            try {
                this.reservationsSemaphore.acquire();
                if (this.reservations == null) break block6;
                for (DuccUserReservation r : this.reservations) {
                    if (!r.getUserId().equals(uid)) continue;
                    for (Map.Entry entry : r.getUserReservations().entrySet()) {
                        reservationIds.add(((IDuccReservation)entry.getValue()).getDuccId());
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.reservationsSemaphore.release();
            }
        }
        return reservationIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyAllUserReservations(TreeMap<String, NodeUsersInfo> map) {
        try {
            this.reservationsSemaphore.acquire();
            if (this.reservations != null) {
                logger.debug("copyAllUserReservations", null, new Object[]{"+++++++++++ Copying User Reservations - List Size:" + this.reservations.size()});
                for (DuccUserReservation r : this.reservations) {
                    if ("System".equals(r.getUserId())) continue;
                    NodeUsersInfo nui = null;
                    if (map.containsKey(r.getUserId())) {
                        nui = map.get(r.getUserId());
                    } else {
                        nui = new NodeUsersInfo(r.getUserId());
                        map.put(r.getUserId(), nui);
                    }
                    nui.addReservation(r.getReserveID());
                }
            } else {
                logger.debug("copyAllUserReservations", null, new Object[]{" ***********  No Reservations"});
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.reservationsSemaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean userHasReservation(String uid) throws Exception {
        try {
            this.reservationsSemaphore.acquire();
            for (DuccUserReservation r : this.reservations) {
                if (!r.getUserId().equals(uid)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.reservationsSemaphore.release();
        }
        return false;
    }

    public Object deepCopy(Object original) throws Exception {
        try (ObjectInputStream ois = null;){
            Object copy;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(original);
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ois = new ObjectInputStream(bis);
            Object object = copy = ois.readObject();
            return object;
        }
    }

    @Override
    public RogueProcessReaper getRogueProcessReaper() {
        return this.rogueProcessReaper;
    }

    public static void main(String[] args) {
        try {
            NodeIdentity node = new NodeIdentity(InetAddress.getLocalHost().getHostAddress(), InetAddress.getLocalHost().getHostName());
            NodeAgent agent = new NodeAgent(node);
            ArrayList<DuccUserReservation> reserves = new ArrayList<DuccUserReservation>();
            DuccReservationMap reserveMap = new DuccReservationMap();
            DuccReservationMap reserveMap2 = new DuccReservationMap();
            NodeIdentity ni1 = node;
            NodeIdentity ni2 = new NodeIdentity("111.111.111.111", "node100");
            NodeIdentity ni3 = node;
            NodeIdentity ni4 = new NodeIdentity("222.222.222.222", "node102");
            DuccId id1 = new DuccId(100L);
            DuccId id2 = new DuccId(101L);
            DuccId id3 = new DuccId(102L);
            DuccId id4 = new DuccId(103L);
            DuccReservation reservation1 = new DuccReservation(id1, ni1, 1L);
            reserveMap.addReservation((IDuccReservation)reservation1);
            DuccReservation reservation2 = new DuccReservation(id2, ni2, 1L);
            reserveMap.addReservation((IDuccReservation)reservation2);
            DuccReservation reservation4 = new DuccReservation(id4, ni4, 1L);
            reserveMap.addReservation((IDuccReservation)reservation4);
            DuccReservation reservation3 = new DuccReservation(id3, ni3, 1L);
            reserveMap2.addReservation((IDuccReservation)reservation3);
            DuccUserReservation reserve = new DuccUserReservation("joe", (IDuccId)new DuccId(500L), (IDuccReservationMap)reserveMap);
            DuccUserReservation reserve2 = new DuccUserReservation("jane", (IDuccId)new DuccId(500L), (IDuccReservationMap)reserveMap2);
            reserves.add(reserve);
            reserves.add(reserve2);
            agent.setReservations(reserves);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DuccLogger getLogger() {
        return logger;
    }

    private void handleQuiesceAndStopEvent(DuccAdminEventQuiesceAndStop event) {
        logger.info("handleQuiesceAndStopEvent", null, new Object[]{"... Agent Received an Admin Request to Stop"});
        try {
            this.stop(true, -1L);
        }
        catch (Exception e) {
            logger.info("handleQuiesceAndStopEvent", null, (Throwable)e, new Object[0]);
        }
    }

    private void handleStopEvent(DuccAdminEventStop event) {
        logger.info("handleStopEvent", null, new Object[]{"... Agent Received an Admin Request to Stop"});
        try {
            this.stop(false, event.getTimeout());
        }
        catch (Exception e) {
            logger.info("handleStopEvent", null, (Throwable)e, new Object[0]);
        }
    }

    private void handleStopPublishingEvent(DuccAdminEventStopMetrics event) {
        if (this.isThisTargetNode(this.getTargetNodes(event.getTargets()))) {
            logger.info("handleStopPublishingEvent", null, new Object[]{"... Agent Received an Admin Request to Stop Metrics Collection and Publishing"});
            this.configurationFactory.stopMetricsRoute();
            logger.info("handleStopPublishingEvent", null, new Object[]{"... Agent Stopped Metrics Collection and Publishing"});
        }
    }

    private String[] getTargetNodes(String targets) {
        logger.info("getTargetNodes", null, new Object[]{" Targets for Admin Command:" + targets});
        return targets.split(",");
    }

    private boolean isThisTargetNode(String[] nodes) {
        for (String targetNode : nodes) {
            if (!Utils.isMachineNameMatch((String)targetNode.trim(), (String)this.getIdentity().getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private boolean isTarget(String[] targets) {
        for (String target : targets) {
            String[] targetParts = target.trim().split("@");
            logger.info("isTarget", null, new Object[]{" Targets for Admin Command:" + target + " This agent canonical identity:" + this.getIdentity().getCanonicalName() + " short name:" + this.getIdentity().getShortName()});
            if (!"agent".equals(targetParts[0]) || !Utils.isMachineNameMatch((String)targetParts[1].trim(), (String)this.getIdentity().getShortName())) continue;
            return true;
        }
        return false;
    }

    public void handleAdminEvent(final DuccAdminEvent event) throws Exception {
        Thread t = new Thread(){

            @Override
            public void run() {
                if (event instanceof DuccAdminEventStop) {
                    if (NodeAgent.this.isTarget(NodeAgent.this.getTargetNodes(((DuccAdminEventStop)event).getTargets()))) {
                        NodeAgent.this.handleStopEvent((DuccAdminEventStop)event);
                    }
                } else if (event instanceof DuccAdminEventQuiesceAndStop) {
                    if (NodeAgent.this.isTarget(NodeAgent.this.getTargetNodes(((DuccAdminEventQuiesceAndStop)event).getTargets()))) {
                        logger.info("handleAdminEvent", null, new Object[]{"Node a target for quiesce"});
                        NodeAgent.this.handleQuiesceAndStopEvent((DuccAdminEventQuiesceAndStop)event);
                    }
                } else if (event instanceof DuccAdminEventStopMetrics) {
                    NodeAgent.this.handleStopPublishingEvent((DuccAdminEventStopMetrics)event);
                } else {
                    logger.info("handleAdminEvent", null, new Object[]{"... Agent Received Unexpected Message of Type:" + event.getClass().getName()});
                }
            }
        };
        t.start();
    }

    static {
        agentLock = new Semaphore(1);
    }

    private class KillTimerTask
    extends TimerTask {
        private CountDownLatch completionLatch;
        private boolean killJustUimaAs;
        private boolean quiesce;

        public KillTimerTask(CountDownLatch completionLatch, boolean killOnlyUimaAs, boolean quiesce) {
            this.completionLatch = completionLatch;
            this.killJustUimaAs = killOnlyUimaAs;
            this.quiesce = quiesce;
        }

        @Override
        public void run() {
            try {
                NodeAgent.this.killChildProcesses(this.killJustUimaAs, this.quiesce);
            }
            finally {
                this.completionLatch.countDown();
            }
        }
    }

    private class NodeExclusionParser {
        private boolean excludeNodeFromCGroups = false;
        private boolean excludeAP = false;

        private NodeExclusionParser() {
        }

        public void parse(String exclFile) throws Exception {
            String line;
            File exclusionFile = new File(exclFile);
            if (!exclusionFile.exists()) {
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(exclusionFile));
            NodeIdentity node = NodeAgent.this.getIdentity();
            String nodeName = node.getShortName();
            while ((line = br.readLine()) != null) {
                String[] parsedExclusions;
                if (!line.startsWith(nodeName)) continue;
                String exclusions = line.substring(line.indexOf("=") + 1);
                for (String exclusion : parsedExclusions = exclusions.split(",")) {
                    if (exclusion.trim().equals("cgroup")) {
                        this.excludeNodeFromCGroups = true;
                        continue;
                    }
                    if (!exclusion.trim().equals("ap")) continue;
                    this.excludeAP = true;
                }
            }
            br.close();
        }

        public boolean apExcluded() {
            return this.excludeAP;
        }

        public boolean cgroupsExcluded() {
            return this.excludeNodeFromCGroups;
        }
    }

    public class ProcessMemoryUsageRoute
    extends RouteBuilder {
        private NodeAgent agent;
        private IDuccProcess process;
        private ManagedProcess managedProcess;

        public ProcessMemoryUsageRoute(NodeAgent agent, IDuccProcess process, ManagedProcess managedProcess) {
            this.process = process;
            this.managedProcess = managedProcess;
            this.agent = agent;
        }

        public void configure() throws Exception {
            ProcessMetricsProcessor nmp = NodeAgent.this.configurationFactory.processMetricsProcessor(this.agent, this.process, this.managedProcess);
            int fixedRate = NodeAgent.this.configurationFactory.getNodeInventoryPublishDelay();
            this.from("timer:processMemPollingTimer?fixedRate=true&delay=100&period=" + fixedRate).routeId(this.process.getPID()).autoStartup(true).process((Processor)nmp);
        }
    }

    class ProcessRunner
    implements Runnable {
        ManagedProcess deployedProcess;

        public ProcessRunner(ManagedProcess deployedProcess) {
            this.deployedProcess = deployedProcess;
        }

        @Override
        public void run() {
            NodeAgent.this.stopProcess(this.deployedProcess.getDuccProcess());
        }
    }

    static enum SIGNAL {
        SIGTERM("-15"),
        SIGKILL("-9");

        String signal = "";

        private SIGNAL(String kind) {
            this.signal = kind;
        }

        public String get() {
            return this.signal;
        }
    }

    class AgentStreamConsumer
    implements Runnable {
        private InputStream theStream;

        AgentStreamConsumer(InputStream is) {
            this.theStream = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String methodName = "AgentStreamConsumer.run";
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(this.theStream));
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    StringBuffer outputBuffer = new StringBuffer();
                    outputBuffer.append(line + "\n");
                }
            }
            catch (Throwable t) {
                logger.warn(methodName, null, t, new Object[0]);
                t.printStackTrace();
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception line) {}
            }
        }
    }
}

