/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.rm.scheduler.IEntity;
import org.apache.uima.ducc.rm.scheduler.IRmJob;
import org.apache.uima.ducc.rm.scheduler.IScheduler;
import org.apache.uima.ducc.rm.scheduler.Machine;
import org.apache.uima.ducc.rm.scheduler.NodePool;
import org.apache.uima.ducc.rm.scheduler.ResourceClass;
import org.apache.uima.ducc.rm.scheduler.RmJob;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;
import org.apache.uima.ducc.rm.scheduler.SchedulingException;
import org.apache.uima.ducc.rm.scheduler.SchedulingUpdate;
import org.apache.uima.ducc.rm.scheduler.Share;
import org.apache.uima.ducc.rm.scheduler.User;

public class NodepoolScheduler
implements IScheduler,
SchedConstants {
    DuccLogger logger = DuccLogger.getLogger(NodepoolScheduler.class, (String)"RM");
    Map<ResourceClass, ResourceClass> resourceClasses;
    Map<IRmJob, IRmJob> needyJobs = new TreeMap<IRmJob, IRmJob>(new JobByTimeSorter());
    NodePool globalNodepool;
    Object[] classes;
    SchedulingUpdate schedulingUpdate;
    SchedConstants.EvictionPolicy evictionPolicy = SchedConstants.EvictionPolicy.SHRINK_BY_MACHINE;
    int fragmentationThreshold = 2;
    boolean do_defragmentation = true;
    boolean use_global_allotment = true;
    int global_allotment = Integer.MAX_VALUE;
    int scheduling_quantum;

    NodepoolScheduler() {
    }

    @Override
    public void setClasses(Map<ResourceClass, ResourceClass> prclasses) {
        this.resourceClasses = prclasses;
        HashMap sorter = new HashMap();
        for (ResourceClass pcl : prclasses.values()) {
            ResourceClass prev;
            ArrayList<ResourceClass> cl = (ArrayList<ResourceClass>)sorter.get(pcl.getPriority());
            if (cl == null) {
                cl = new ArrayList<ResourceClass>();
                sorter.put(pcl.getPriority(), cl);
            }
            if (cl.size() > 0 && (prev = (ResourceClass)cl.get(0)).getPolicy() != pcl.getPolicy()) {
                throw new SchedulingException(null, "Scheduling policy must match for same-priority classes: class " + prev.getName() + " : " + pcl.getName());
            }
            cl.add(pcl);
        }
        ArrayList keys = new ArrayList();
        keys.addAll(sorter.keySet());
        Collections.sort(keys);
        this.classes = new Object[sorter.size()];
        int ndx = 0;
        for (Integer k : keys) {
            this.classes[ndx++] = sorter.get(k);
        }
        this.fragmentationThreshold = SystemPropertyResolver.getIntProperty((String)"ducc.rm.fragmentation.threshold", (int)this.fragmentationThreshold);
        this.do_defragmentation = SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.defragmentation", (boolean)this.do_defragmentation);
        this.use_global_allotment = SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.use_global_allotment", (boolean)this.use_global_allotment);
        this.global_allotment = SystemPropertyResolver.getIntProperty((String)"ducc.rm.global_allotment", (int)this.global_allotment);
    }

    @Override
    public void setNodePool(NodePool np) {
        this.globalNodepool = np;
        this.scheduling_quantum = np.getShareQuantum() >> 20;
    }

    @Override
    public void setEvictionPolicy(SchedConstants.EvictionPolicy ep) {
        this.evictionPolicy = ep;
    }

    boolean validSingleAllotment(IRmJob j) {
        String methodName = "validAllotment";
        if (this.use_global_allotment) {
            int shares;
            long sharesInGB;
            User u = j.getUser();
            int lim = u.getOverrideLimit();
            if (lim < 0) {
                lim = this.global_allotment;
            }
            if ((sharesInGB = (long)(((shares = u.countNPShares()) + j.getShareOrder()) * this.scheduling_quantum)) > (long)lim) {
                this.schedulingUpdate.defer(j, "Deferred because allotment of " + lim + "GB is exceeded by user " + j.getUserName());
                this.logger.info(methodName, j.getId(), new Object[]{"Deferred because allotment of " + lim + "GB is exceeded by user " + j.getUserName()});
                return false;
            }
        } else {
            ResourceClass rc = j.getResourceClass();
            if (rc.allotmentExceeded(j)) {
                this.schedulingUpdate.defer(j, "Deferred because allotment of " + rc.getAllotment(j) + "GB is exceeded by user " + j.getUserName());
                this.logger.info(methodName, j.getId(), new Object[]{"Deferred because allotment of " + rc.getAllotment(j) + "GB is exceeded by user " + j.getUserName()});
                return false;
            }
        }
        return true;
    }

    int getAllotmentForJob(IRmJob j) {
        String methodName = "getAllotmentForJob";
        User u = j.getUser();
        int order = j.getShareOrder();
        int wanted = j.getJobCap();
        this.logger.info(methodName, j.getId(), new Object[]{"Job cap", this.nSharesToString(wanted, order)});
        int allotment_in_gb = u.getOverrideLimit();
        if (allotment_in_gb < 0) {
            allotment_in_gb = this.global_allotment;
        }
        int user_allotment = allotment_in_gb / this.scheduling_quantum;
        int allocated = u.countNPShares();
        this.logger.info(methodName, j.getId(), new Object[]{"Current NP allocation for user", allocated, "qshares", allocated * this.scheduling_quantum, "GB", "user_allotment", user_allotment, "user_allotment in GB", allotment_in_gb});
        int additional = Math.max(0, user_allotment - allocated);
        int additional_processes = additional / order;
        this.logger.info(methodName, j.getId(), new Object[]{"Additional Nshares allowed for request:", this.nSharesToString(additional_processes, order)});
        if (additional_processes == 0) {
            if (j.countNShares() == 0) {
                this.schedulingUpdate.defer(j, "Deferred because allotment of " + allotment_in_gb + "GB is exceeded.");
                this.logger.info(methodName, j.getId(), new Object[]{"Deferred because allotment of", allotment_in_gb, "GB is exceeded."});
            } else {
                this.logger.info(methodName, j.getId(), new Object[]{"Allotment of", allotment_in_gb, "GB caps request. Return with", allocated, "qshares allocated."});
            }
            return j.countNShares();
        }
        int allowed = j.countNShares() + additional_processes;
        if (allowed < wanted) {
            this.logger.info(methodName, j.getId(), new Object[]{"Capping job on allotment: ", allotment_in_gb + " GB. Remaining allowed nshares [", allowed, "] wanted [", wanted, "]"});
        }
        this.logger.info(methodName, j.getId(), new Object[]{"Allowed", this.nSharesToString(allowed, order), "wanted", this.nSharesToString(wanted, order)});
        return Math.min(wanted, allowed);
    }

    private void reworknShares(int[] vshares, int[] nshares) {
        int len = vshares.length;
        System.arraycopy(vshares, 0, nshares, 0, len);
        for (int o = 1; o < len; ++o) {
            for (int p = o + 1; p < len; ++p) {
                if (nshares[p] == 0) continue;
                int n = o;
                nshares[n] = nshares[n] + p / o * nshares[p];
            }
        }
    }

    void doShareSplits(int[] vmach, long count, int order) {
        block0: for (int o = order; o < vmach.length; ++o) {
            while (vmach[o] > 0) {
                int given = o / order;
                int residual = o % order;
                if (count >= (long)given) {
                    count -= (long)given;
                    if (residual > 0) {
                        int n = residual;
                        vmach[n] = vmach[n] + 1;
                    }
                } else {
                    int leftover;
                    int n = leftover = o - (int)count * order;
                    vmach[n] = vmach[n] + 1;
                    count = 0L;
                }
                int n = o;
                vmach[n] = vmach[n] - 1;
                if (count != 0L) continue;
                break block0;
            }
        }
    }

    void removeSharesByOrder(int[] vmach, int[] nshares, long count, int order) {
        if (count == 0L) {
            return;
        }
        int f = 1;
        while (f * order < vmach.length) {
            int fo = f * order;
            if (vmach[fo] > 0) {
                long available = vmach[fo] * f;
                long given = Math.min(count, available);
                int remaining = (int)(available - given);
                vmach[fo] = remaining * order / fo;
                int residual = remaining * order % fo;
                if (residual > 0) {
                    int n = residual;
                    vmach[n] = vmach[n] + 1;
                }
                count -= given;
            }
            if (count == 0L) break;
            ++f;
        }
        if (count > 0L) {
            this.doShareSplits(vmach, count, order);
        }
        this.reworknShares(vmach, nshares);
    }

    String nSharesToString(int shares, int order) {
        return String.format("%dQ%d", shares, shares * order);
    }

    String qSharesToString(int shares, int order) {
        String o = null;
        o = order == 0 ? "-" : Integer.toString(shares / order);
        return String.format("%sQ%d", o, shares);
    }

    private String fmtArray(int[] array) {
        Object[] vals = new Object[array.length];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append("%3s ");
            vals[i] = Integer.toString(array[i]);
        }
        return String.format(sb.toString(), vals);
    }

    /*
     * WARNING - void declaration
     */
    protected void apportion_qshares(List<IEntity> entities, int[] vshares, String descr) {
        String methodName = "apportion_qshares";
        boolean shares_given = false;
        int maxorder = this.globalNodepool.getMaxOrder();
        int[] nshares = this.globalNodepool.makeArray();
        if (entities.size() == 0) {
            return;
        }
        Collections.sort(entities, entities.get(0).getApportionmentSorter());
        this.reworknShares(vshares, nshares);
        ArrayList<IEntity> working = new ArrayList<IEntity>();
        working.addAll(entities);
        HashMap<IEntity, int[]> given_by_order = new HashMap<IEntity, int[]>();
        HashMap<IEntity, Integer> deserved = new HashMap<IEntity, Integer>();
        StringBuffer enames = null;
        StringBuffer eweights = null;
        this.logger.info(methodName, null, new Object[]{descr, "RmCounter Start"});
        this.logger.info(methodName, null, new Object[]{descr, "maxorder = ", this.globalNodepool.getMaxOrder()});
        enames = new StringBuffer();
        eweights = new StringBuffer();
        for (IEntity e : working) {
            int[] gbo2 = this.globalNodepool.makeArray();
            e.setGivenByOrder(gbo2);
            given_by_order.put(e, gbo2);
            deserved.put(e, 0);
            enames.append(e.getName());
            enames.append(" ");
            eweights.append(Integer.toString(e.getShareWeight()));
            eweights.append(" ");
        }
        this.logger.info(methodName, null, new Object[]{descr, "entity_names = ", enames.toString()});
        this.logger.info(methodName, null, new Object[]{descr, "weights      = ", eweights.toString()});
        for (IEntity e : working) {
            this.logger.info(methodName, null, new Object[]{descr, "wantedby." + e.getName() + " = ", this.fmtArray(e.getWantedByOrder())});
        }
        this.logger.info(methodName, null, new Object[]{descr, "vmachines =", this.fmtArray(vshares)});
        this.logger.info(methodName, null, new Object[]{descr, "RmCounter End"});
        int pass = 0;
        do {
            void var17_35;
            this.logger.trace(methodName, null, new Object[]{descr, "----------------------- Pass", pass++, "------------------------------"});
            this.logger.trace(methodName, null, new Object[]{descr, "vshares", this.fmtArray(vshares)});
            this.logger.trace(methodName, null, new Object[]{descr, "nshares", this.fmtArray(nshares)});
            shares_given = false;
            HashMap<IEntity, Integer> given_per_round = new HashMap<IEntity, Integer>();
            int allweights = 0;
            for (IEntity iEntity : working) {
                allweights += iEntity.getShareWeight();
                given_per_round.put(iEntity, 0);
            }
            int all_qshares = nshares[1];
            for (IEntity e3 : working) {
                int base_fs = (int)Math.floor((double)nshares[1] * ((double)e3.getShareWeight() / (double)allweights));
                double d_base_fs = (double)nshares[1] * ((double)e3.getShareWeight() / (double)allweights);
                deserved.put(e3, base_fs);
                all_qshares -= base_fs;
                this.logger.trace(methodName, null, new Object[]{descr, e3.getName(), "Wanted  :", this.fmtArray(e3.getWantedByOrder())});
                this.logger.trace(methodName, null, new Object[]{descr, e3.getName(), "deserved:", base_fs, d_base_fs});
            }
            this.logger.trace(methodName, null, new Object[]{descr, "Leftover after giving deserved:" + all_qshares});
            if (all_qshares > 0) {
                for (IEntity e : working) {
                    deserved.put(e, (Integer)deserved.get(e) + 1);
                    if (--all_qshares != 0) continue;
                    break;
                }
            }
            for (IEntity e : working) {
                this.logger.trace(methodName, null, new Object[]{descr, String.format("Final deserved by %15s: int[%3d] (after bonus)", e.getName(), deserved.get(e))});
            }
            int n = maxorder;
            while (var17_35 > 0) {
                int total_taken = 0;
                if (nshares[var17_35] == 0) {
                    this.logger.trace(methodName, null, new Object[]{descr, "O " + (int)var17_35 + " no shares to give, moving on."});
                } else {
                    for (IEntity e4 : working) {
                        int[] wbo = e4.getWantedByOrder();
                        int[] gbo3 = (int[])given_by_order.get(e4);
                        if (wbo[var17_35] == 0) {
                            this.logger.trace(methodName, null, new Object[]{descr, "O", (int)var17_35, "Entity", e4.getName(), "nothing wanted at this order, moving on."});
                            continue;
                        }
                        double dgiven = (double)nshares[var17_35] * ((double)e4.getShareWeight() / (double)allweights) * (double)var17_35;
                        int des = (Integer)deserved.get(e4);
                        int gpr = (Integer)given_per_round.get(e4);
                        int mpr = Math.max(0, des - gpr);
                        int tgiven = Math.min(mpr, (int)Math.ceil(dgiven));
                        int cap = e4.calculateCap();
                        this.logger.trace(methodName, null, new Object[]{descr, "O", (int)var17_35, ":", e4.getName(), "Before caps, given", tgiven, "cap", cap});
                        if (gbo3[0] >= cap) {
                            this.logger.trace(methodName, null, new Object[]{descr, "O", (int)var17_35, "Entity", e4.getName(), "cap prevents further allocation."});
                            continue;
                        }
                        int given = tgiven / var17_35;
                        int rgiven = tgiven % var17_35;
                        if (rgiven > 0 && given == 0) {
                            ++given;
                            given = Math.min(given, nshares[var17_35]);
                        }
                        if (given + gbo3[0] > cap) {
                            given = Math.max(0, cap - gbo3[0]);
                        }
                        int taken = Math.min(given, wbo[var17_35]);
                        taken = Math.min(taken, nshares[var17_35] - total_taken);
                        this.logger.trace(methodName, null, new Object[]{descr, "O", (int)var17_35, ":", e4.getName(), "After  caps,", " dgiven Q[", dgiven, "] given N[", given, "] taken N[", taken, "]"});
                        void v0 = var17_35;
                        gbo3[v0] = gbo3[v0] + taken;
                        gbo3[0] = gbo3[0] + taken;
                        void v1 = var17_35;
                        wbo[v1] = wbo[v1] - taken;
                        wbo[0] = wbo[0] - taken;
                        total_taken += taken;
                        given_per_round.put(e4, (Integer)given_per_round.get(e4) + taken * var17_35);
                    }
                    if (total_taken > 0) {
                        shares_given = true;
                    }
                    this.removeSharesByOrder(vshares, nshares, total_taken, (int)var17_35);
                    for (IEntity e : working) {
                        int gpr;
                        int des = (Integer)deserved.get(e);
                        int got_all = Math.max(0, des - (gpr = ((Integer)given_per_round.get(e)).intValue()));
                        if (got_all != 0) continue;
                        allweights -= e.getShareWeight();
                    }
                    if (allweights <= 0) break;
                }
                --var17_35;
            }
            Iterator iterator = working.iterator();
            while (iterator.hasNext()) {
                IEntity e5 = (IEntity)iterator.next();
                if (e5.getWantedByOrder()[0] != 0 && e5.getGivenByOrder()[0] < e5.calculateCap()) continue;
                iterator.remove();
            }
            Iterator iterator2 = working.iterator();
            while (iterator2.hasNext()) {
                IEntity e6 = (IEntity)iterator2.next();
                int[] wbo = e6.getWantedByOrder();
                boolean purge = true;
                for (int o = maxorder; o > 0; --o) {
                    if (wbo[o] <= 0 || nshares[o] <= 0) continue;
                    purge = false;
                    break;
                }
                if (!purge) continue;
                iterator2.remove();
            }
            if (!this.logger.isTrace()) continue;
            this.logger.trace(methodName, null, new Object[]{descr, "Survivors at end of pass:"});
            for (IEntity e7 : working) {
                this.logger.trace(methodName, null, new Object[]{descr, e7.toString()});
            }
        } while (shares_given);
        if (this.logger.isTrace()) {
            this.logger.info(methodName, null, new Object[]{descr, "Final before bonus:"});
            for (IEntity e : entities) {
                int[] gbo4 = e.getGivenByOrder();
                this.logger.info(methodName, null, new Object[]{descr, String.format("%12s %s", e.getName(), this.fmtArray(gbo4))});
            }
        }
        boolean given = true;
        while (nshares[1] > 0 && given) {
            given = false;
            for (IEntity e : entities) {
                int[] nArray = e.getGivenByOrder();
                for (int o = maxorder; o > 0; --o) {
                    if (!e.canUseBonus(o) || vshares[o] <= 0) continue;
                    int n = o;
                    nArray[n] = nArray[n] + 1;
                    nArray[0] = nArray[0] + 1;
                    this.removeSharesByOrder(vshares, nshares, 1L, o);
                    given = true;
                }
            }
        }
        this.logger.debug(methodName, null, new Object[]{descr, "Final apportionment:"});
        for (IEntity e : entities) {
            int[] nArray = e.getGivenByOrder();
            this.logger.debug(methodName, null, new Object[]{descr, String.format("%12s gbo %s", e.getName(), this.fmtArray(nArray))});
        }
        this.logger.debug(methodName, null, new Object[]{descr, "vshares", this.fmtArray(vshares)});
        this.logger.debug(methodName, null, new Object[]{descr, "nshares", this.fmtArray(nshares)});
    }

    /*
     * WARNING - void declaration
     */
    protected void countClassShares(NodePool np, List<ResourceClass> rcs) {
        String methodName = "countClassShares";
        if (this.logger.isDebug()) {
            StringBuffer sb = new StringBuffer("Counting for nodepool ");
            sb.append(np.getId());
            sb.append(" - classes -");
            for (ResourceClass resourceClass : rcs) {
                sb.append(" ");
                sb.append(resourceClass.getName());
            }
            this.logger.debug(methodName, null, new Object[]{sb.toString()});
        }
        int[] vshares = np.cloneVMachinesByOrder();
        ArrayList<IEntity> l = new ArrayList<IEntity>();
        l.addAll(rcs);
        for (IEntity e : l) {
            e.initWantedByOrder((ResourceClass)e);
        }
        this.apportion_qshares(l, vshares, methodName);
        boolean bl = false;
        for (ResourceClass rc : rcs) {
            var6_9 += rc.getShareWeight();
        }
        for (ResourceClass rc : rcs) {
            void var6_9;
            int fair_share = (int)Math.floor((double)np.countTotalShares() * ((double)rc.getShareWeight() / (double)var6_9));
            rc.setPureFairShare(fair_share);
        }
    }

    protected boolean countUserShares(ResourceClass rc) {
        String methodName = "countUserShares";
        HashMap<IRmJob, IRmJob> allJobs = rc.getAllJobs();
        if (allJobs.size() == 0) {
            return false;
        }
        int[] vshares = rc.getGivenByOrder();
        HashMap<User, User> users = new HashMap<User, User>();
        for (IRmJob j : allJobs.values()) {
            User u = j.getUser();
            if (users.containsKey(u)) continue;
            u.initWantedByOrder(rc);
            users.put(u, u);
        }
        ArrayList<IEntity> l = new ArrayList<IEntity>();
        l.addAll(users.values());
        this.apportion_qshares(l, vshares, methodName);
        int pure_share = rc.getPureFairShare();
        int fs = (int)Math.floor((double)pure_share / (double)users.size());
        for (User u : users.values()) {
            u.setPureFairShare(fs);
        }
        return true;
    }

    private void countJobShares(ResourceClass rc) {
        String methodName = "countJobShares";
        HashMap<User, HashMap<IRmJob, IRmJob>> userJobs = rc.getAllJobsByUser();
        for (User u : userJobs.keySet()) {
            HashMap<IRmJob, IRmJob> jobs = userJobs.get(u);
            if (jobs.size() == 0) continue;
            int[] vshares = u.getGivenByOrder();
            ArrayList<IEntity> l = new ArrayList<IEntity>();
            l.addAll(jobs.values());
            for (IEntity e : l) {
                e.initWantedByOrder(rc);
            }
            this.apportion_qshares(l, vshares, methodName);
            int pure_share = u.getPureFairShare();
            int fs = (int)Math.floor((double)pure_share / (double)jobs.size());
            for (IRmJob j : jobs.values()) {
                j.setPureFairShare(fs);
            }
        }
    }

    private List<ResourceClass> gatherRcs(NodePool np, List<ResourceClass> eligible) {
        ArrayList<ResourceClass> ret = new ArrayList<ResourceClass>();
        String npn = np.getId();
        for (ResourceClass rc : eligible) {
            String rcnpn = rc.getNodepoolName();
            if (rcnpn == null || rc.countJobs() == 0 || !rcnpn.equals(npn)) continue;
            ret.add(rc);
        }
        return ret;
    }

    protected List<ResourceClass> traverseNodepoolsForCounts(NodePool np, List<ResourceClass> eligible) {
        List<ResourceClass> myRcs = this.gatherRcs(np, eligible);
        boolean hasJobs = myRcs.size() > 0;
        List<NodePool> subpools = np.getChildrenAscending();
        for (NodePool subpool : subpools) {
            List<ResourceClass> subrc = this.traverseNodepoolsForCounts(subpool, eligible);
            myRcs.addAll(subrc);
        }
        if (hasJobs) {
            this.countClassShares(np, myRcs);
        }
        return myRcs;
    }

    protected void updateNodepools(NodePool np, ArrayList<ResourceClass> rcs) {
        List<NodePool> subpools = np.getChildrenAscending();
        for (NodePool nodePool : subpools) {
            ArrayList<ResourceClass> cls = new ArrayList<ResourceClass>();
            String npn = nodePool.getId();
            int njobs = 0;
            for (ResourceClass rc : rcs) {
                String rcnpn = rc.getNodepoolName();
                if (rcnpn == null || !rc.getNodepoolName().equals(npn)) continue;
                cls.add(rc);
                njobs += rc.countJobs();
            }
            if (njobs <= 0) continue;
            this.updateNodepools(nodePool, cls);
        }
        if (np == this.globalNodepool) {
            ArrayList<ResourceClass> tmp = new ArrayList<ResourceClass>();
            for (ResourceClass rc : rcs) {
                if (!rc.getNodepoolName().equals(this.globalNodepool.getId())) continue;
                tmp.add(rc);
            }
            rcs = tmp;
        }
        for (ResourceClass resourceClass : rcs) {
            if (resourceClass.countJobs() == 0) continue;
            resourceClass.updateNodepool(np);
        }
    }

    private void howMuchFairShare(ArrayList<ResourceClass> rcs) {
        String methodName = "howMuchFairShare";
        if (this.logger.isTrace()) {
            this.logger.info(methodName, null, new Object[]{"Scheduling FAIR SHARE for these classes:"});
            this.logger.info(methodName, null, new Object[]{"   ", ResourceClass.getHeader()});
            this.logger.info(methodName, null, new Object[]{"   ", ResourceClass.getDashes()});
            for (ResourceClass pc : rcs) {
                this.logger.info(methodName, null, new Object[]{"   ", pc.toString()});
            }
        }
        ArrayList<ResourceClass> eligible = new ArrayList<ResourceClass>();
        Collections.sort(rcs, new ClassByWeightSorter());
        for (ResourceClass rc : rcs) {
            HashMap<IRmJob, IRmJob> jobs = rc.getAllJobs();
            this.logger.debug(methodName, null, new Object[]{"Schedule class", rc.getName()});
            rc.clearShares();
            if (jobs.size() == 0) {
                this.logger.debug(methodName, null, new Object[]{"No jobs to schedule in class ", rc.getName()});
                continue;
            }
            eligible.add(rc);
            for (IRmJob j : jobs.values()) {
                this.logger.info(methodName, j.getId(), new Object[]{"Scheduling job in class ", rc.getName(), ":", j.toString()});
            }
        }
        if (eligible.size() == 0) {
            return;
        }
        this.traverseNodepoolsForCounts(this.globalNodepool, eligible);
        this.updateNodepools(this.globalNodepool, eligible);
        for (ResourceClass rc : rcs) {
            if (!rc.hasSharesGiven()) {
                for (IRmJob j : rc.getAllJobs().values()) {
                    j.clearShares();
                    j.undefer();
                }
                continue;
            }
            if (!this.countUserShares(rc)) continue;
            this.countJobShares(rc);
        }
    }

    protected boolean jobInClass(ArrayList<ResourceClass> rcs, IRmJob j) {
        for (ResourceClass rc : rcs) {
            if (j.getResourceClass() != rc) continue;
            return true;
        }
        return false;
    }

    protected void expandNeedyJobs(NodePool np, ArrayList<ResourceClass> rcs) {
        ResourceClass rc;
        String methodName = "expandNeedyJobs";
        if (this.needyJobs.size() == 0) {
            return;
        }
        this.logger.trace(methodName, null, new Object[]{"Enter: needyJobs.size =", this.needyJobs.size()});
        List<NodePool> subpools = np.getChildrenAscending();
        for (NodePool subpool : subpools) {
            this.expandNeedyJobs(subpool, rcs);
        }
        ArrayList<IRmJob> fair_share_jobs = new ArrayList<IRmJob>();
        ArrayList<IRmJob> fixed_share_jobs = new ArrayList<IRmJob>();
        ArrayList<IRmJob> reservations = new ArrayList<IRmJob>();
        ArrayList<IRmJob> removeList = new ArrayList<IRmJob>();
        for (IRmJob j : this.needyJobs.values()) {
            if (j.isCompleted()) {
                removeList.add(j);
                continue;
            }
            rc = j.getResourceClass();
            if (rc == null) {
                removeList.add(j);
                continue;
            }
            if (!this.jobInClass(rcs, j) || rc.getNodepool() != np) continue;
            switch (rc.getPolicy()) {
                case FAIR_SHARE: {
                    fair_share_jobs.add(j);
                    break;
                }
                case FIXED_SHARE: {
                    fixed_share_jobs.add(j);
                    break;
                }
                case RESERVE: {
                    reservations.add(j);
                }
            }
            removeList.add(j);
        }
        for (IRmJob j : removeList) {
            this.needyJobs.remove(j);
        }
        Collections.sort(reservations, new JobByTimeSorter());
        this.logger.debug(methodName, null, new Object[]{"NP[", np.getId(), "Expand needy reservations.", this.listJobSet(reservations)});
        for (IRmJob j : reservations) {
            rc = j.getResourceClass();
            np.findMachines(j, rc);
        }
        Collections.sort(fixed_share_jobs, new JobByTimeSorter());
        this.logger.debug(methodName, null, new Object[]{"NP[", np.getId(), "Expand needy fixed.", this.listJobSet(fixed_share_jobs)});
        for (IRmJob j : fixed_share_jobs) {
            if (np.findShares(j, false) <= 0) continue;
            for (Share s : j.getPendingShares().values()) {
                s.setFixed();
                this.logger.info(methodName, j.getId(), new Object[]{"Assign:", s});
            }
        }
        Collections.sort(fair_share_jobs, new JobByTimeSorter());
        this.logger.debug(methodName, null, new Object[]{"NP[", np.getId(), "Expand needy jobs.", this.listJobSet(fair_share_jobs)});
        np.doExpansion(fair_share_jobs);
        this.logger.trace(methodName, null, new Object[]{"Exit : needyJobs.size =", this.needyJobs.size()});
    }

    protected void traverseNodepoolsForExpansion(NodePool np, ArrayList<ResourceClass> rcs) {
        String methodName = "traverseNodepoolsForExpansion";
        List<NodePool> subpools = np.getChildrenAscending();
        StringBuffer sb = new StringBuffer();
        for (NodePool sp : subpools) {
            sb.append(sp.getId());
            sb.append(" ");
        }
        this.logger.info(methodName, null, new Object[]{np.getId(), "Doing expansions in this order:", sb.toString()});
        for (NodePool subpool : subpools) {
            this.traverseNodepoolsForExpansion(subpool, rcs);
        }
        ArrayList<ResourceClass> cls = new ArrayList<ResourceClass>();
        String npn = np.getId();
        int njobs = 0;
        for (ResourceClass rc : rcs) {
            String rcnpn = rc.getNodepoolName();
            if (rcnpn == null || !rc.getNodepoolName().equals(npn)) continue;
            cls.add(rc);
            njobs += rc.countJobs();
        }
        if (njobs == 0) {
            return;
        }
        ArrayList<IRmJob> jobs = new ArrayList<IRmJob>();
        for (ResourceClass rc : cls) {
            jobs.addAll(rc.getAllJobs().values());
        }
        Collections.sort(jobs, new JobByTimeSorter());
        np.doExpansion(jobs);
    }

    protected void whatOfFairShare(ArrayList<ResourceClass> rcs) {
        String methodName = "whatOfFairShare";
        ArrayList<ResourceClass> eligible = new ArrayList<ResourceClass>();
        Collections.sort(rcs, new ClassByWeightSorter());
        for (ResourceClass rc : rcs) {
            HashMap<IRmJob, IRmJob> jobs = rc.getAllJobs();
            this.logger.debug(methodName, null, new Object[]{"Schedule class", rc.getName()});
            if (jobs.size() == 0) {
                this.logger.debug(methodName, null, new Object[]{"No jobs to schedule in class ", rc.getName()});
                continue;
            }
            eligible.add(rc);
            for (IRmJob j : jobs.values()) {
                this.logger.info(methodName, j.getId(), new Object[]{"Scheduling job in class ", rc.getName(), ":", j.countNSharesGiven(), "shares given, order", j.getShareOrder()});
            }
        }
        if (eligible.size() == 0) {
            return;
        }
        this.traverseNodepoolsForExpansion(this.globalNodepool, eligible);
    }

    void howMuchFixed(ArrayList<ResourceClass> rcs) {
        Cloneable jobs;
        String methodName = "howMuchFixed";
        if (this.logger.isTrace()) {
            this.logger.info(methodName, null, new Object[]{"Scheduling FIXED SHARE for these classes:"});
            this.logger.info(methodName, null, new Object[]{"   ", ResourceClass.getHeader()});
            this.logger.info(methodName, null, new Object[]{"   ", ResourceClass.getDashes()});
            for (ResourceClass pc : rcs) {
                this.logger.info(methodName, null, new Object[]{"   ", pc.toString()});
            }
        }
        int total_jobs = 0;
        for (ResourceClass rc : rcs) {
            jobs = rc.getAllJobs();
            total_jobs += ((HashMap)jobs).size();
        }
        if (total_jobs == 0) {
            return;
        }
        for (ResourceClass rc : rcs) {
            jobs = rc.getAllJobsSorted(new JobByTimeSorter());
            Iterator iterator = ((ArrayList)jobs).iterator();
            block6: while (iterator.hasNext()) {
                IRmJob j = (IRmJob)iterator.next();
                this.logger.info(methodName, j.getId(), new Object[]{"Scheduling job to class:", rc.getName()});
                j.clearShares();
                j.undefer();
                switch (j.getDuccType()) {
                    case Job: {
                        this.countFixedForJob(j, rc);
                        continue block6;
                    }
                }
                this.countSingleFixedProcess(j, rc);
            }
        }
    }

    void countFixedForJob(IRmJob j, ResourceClass rc) {
        String methodName = "countFixedForJob";
        this.logger.info(methodName, j.getId(), new Object[]{"Counting shares for", j.getShortType() + "." + j.getId()});
        NodePool np = rc.getNodepool();
        int order = j.getShareOrder();
        int available = np.countLocalNSharesByOrder(order);
        this.logger.info(methodName, j.getId(), new Object[]{"available shares of order", order, "in np:", available});
        if (available == 0) {
            if (j.countNShares() == 0) {
                if (np.countFixable(j) > 0) {
                    this.schedulingUpdate.defer(j, "Deferred because insufficient resources are availble.");
                    this.logger.info(methodName, j.getId(), new Object[]{"Deferring, insufficient shares available. NP", np.getId(), "available[", np.countNSharesByOrder(order), "]"});
                } else {
                    this.schedulingUpdate.defer(j, "Deferred because no hosts in class " + rc.getName() + " have sufficient memory to accomodate the request.");
                    this.logger.info(methodName, j.getId(), new Object[]{"Deferring, no machines big enough for the request. NP", np.getId(), "available[", np.countNSharesByOrder(order), "]"});
                }
                return;
            }
            this.logger.info(methodName, j.getId(), new Object[]{"Nodepool is out of shares: NP", np.getId(), "available[", np.countNSharesByOrder(order), "]"});
        }
        int granted = this.getAllotmentForJob(j);
        this.logger.info(methodName, j.getId(), new Object[]{"+++++ nodepool", np.getId(), "class", rc.getName(), "order", order, "shares", this.nSharesToString(granted, order)});
        int[] gbo = this.globalNodepool.makeArray();
        gbo[order] = granted;
        j.setGivenByOrder(gbo);
        np.countOutNSharesByOrder(order, granted - j.countNShares());
    }

    void countSingleFixedProcess(IRmJob j, ResourceClass rc) {
        String methodName = "countSingleFixedProcess";
        this.logger.info(methodName, j.getId(), new Object[]{"Counting shares for", j.getShortType() + "." + j.getId(), "in class", rc.getName()});
        NodePool np = rc.getNodepool();
        if (j.isCompleted()) {
            return;
        }
        if (j.countNShares() > 0) {
            this.logger.info(methodName, j.getId(), new Object[]{"[stable]", "assigned", j.countNShares(), "processes, ", j.countNShares() * j.getShareOrder(), "QS"});
            int[] gbo = this.globalNodepool.makeArray();
            gbo[j.getShareOrder()] = 1;
            j.setGivenByOrder(gbo);
            return;
        }
        int order = j.getShareOrder();
        if (np.countLocalNSharesByOrder(order) == 0) {
            if (np.countFixable(j) > 0) {
                this.schedulingUpdate.defer(j, "Deferred  because insufficient resources are availble.");
                this.logger.info(methodName, j.getId(), new Object[]{"Deferring, insufficient shares available. NP", np.getId(), "available[", np.countNSharesByOrder(order), "]"});
            } else {
                this.schedulingUpdate.defer(j, "Deferred because no hosts in class " + rc.getName() + " have sufficient memory to accomodate the request.");
                this.logger.info(methodName, j.getId(), new Object[]{"Deferring, no machines big enough for the request. NP", np.getId(), "available[", np.countNSharesByOrder(order), "]"});
            }
            return;
        }
        if (!this.validSingleAllotment(j)) {
            return;
        }
        this.logger.info(methodName, j.getId(), new Object[]{"+++++ nodepool", np.getId(), "class", rc.getName(), "order", order, "shares", this.nSharesToString(1, order)});
        int[] gbo = this.globalNodepool.makeArray();
        gbo[order] = 1;
        j.setGivenByOrder(gbo);
        np.countOutNSharesByOrder(order, 1);
    }

    protected void whatOfFixedShare(ArrayList<ResourceClass> rcs) {
        String methodName = "whatOfFixedShare";
        for (ResourceClass rc : rcs) {
            ArrayList<IRmJob> jobs = rc.getAllJobsSorted(new JobByTimeSorter());
            NodePool np = rc.getNodepool();
            for (IRmJob j : jobs) {
                if (j.countNShares() == j.countNSharesGiven() || j.isRefused() || j.isDeferred() || j.isCompleted()) continue;
                int order = j.getShareOrder();
                int count = j.countNSharesGiven();
                if (np.findSharesHorizontal(j) > 0) {
                    for (Share s : j.getPendingShares().values()) {
                        s.setFixed();
                    }
                    this.logger.info(methodName, j.getId(), new Object[]{"Assign(H):", this.nSharesToString(count, order)});
                }
                if (j.countNShares() == 0 && np.findSharesVertical(j) > 0) {
                    for (Share s : j.getPendingShares().values()) {
                        s.setFixed();
                    }
                    this.logger.info(methodName, j.getId(), new Object[]{"Assign(V):", this.nSharesToString(count, order)});
                }
                if (j.countNShares() != 0) continue;
                j.setReason("Waiting for preemptions.");
            }
        }
    }

    private void howMuchReserve(ArrayList<ResourceClass> rcs) {
        Cloneable jobs;
        String methodName = "howMuchreserve";
        if (this.logger.isTrace()) {
            this.logger.info(methodName, null, new Object[]{"Calculating counts for RESERVATION for these classes:"});
            this.logger.info(methodName, null, new Object[]{"   ", ResourceClass.getHeader()});
            this.logger.info(methodName, null, new Object[]{"   ", ResourceClass.getDashes()});
            for (ResourceClass pc : rcs) {
                this.logger.info(methodName, null, new Object[]{"   ", pc.toString()});
            }
        }
        int total_jobs = 0;
        for (ResourceClass rc : rcs) {
            jobs = rc.getAllJobs();
            total_jobs += ((HashMap)jobs).size();
        }
        if (total_jobs == 0) {
            return;
        }
        for (ResourceClass rc : rcs) {
            jobs = rc.getAllJobsSorted(new JobByTimeSorter());
            Iterator iterator = ((ArrayList)jobs).iterator();
            block6: while (iterator.hasNext()) {
                IRmJob j = (IRmJob)iterator.next();
                j.clearShares();
                j.undefer();
                switch (j.getDuccType()) {
                    case Job: {
                        this.countReservationForJob(j, rc);
                        continue block6;
                    }
                }
                this.countSingleReservation(j, rc);
            }
        }
    }

    void countReservationForJob(IRmJob j, ResourceClass rc) {
        String methodName = "countReservationForJob";
        this.logger.info(methodName, j.getId(), new Object[]{"Counting full machines for", j.getShortType() + "." + j.getId()});
        NodePool np = rc.getNodepool();
        int available = np.countReservables(j);
        if (available == 0) {
            if (j.countNShares() == 0) {
                this.schedulingUpdate.defer(j, "Deferred because there are no hosts of the correct size in class " + rc.getName());
                this.logger.info(methodName, j.getId(), new Object[]{"Deferred because no hosts of correct size. NP", np.getId()});
            } else {
                this.logger.info(methodName, j.getId(), new Object[]{"Nodepool is out of shares: NP", np.getId()});
            }
            return;
        }
        int granted = this.getAllotmentForJob(j);
        int needed = granted - j.countNShares();
        int freeable = 0;
        if (needed > 0 && (freeable = np.countFreeableMachines(j, needed)) + j.countNShares() == 0) {
            this.schedulingUpdate.defer(j, "Deferred because resources are exhausted.");
            this.logger.warn(methodName, j.getId(), new Object[]{"Deferred because resources are exhausted in nodepool " + np.getId()});
            return;
        }
        this.logger.info(methodName, j.getId(), new Object[]{"Request is granted a machine for reservation."});
        int[] gbo = this.globalNodepool.makeArray();
        int order = j.getShareOrder();
        gbo[order] = freeable + j.countNShares();
        j.setGivenByOrder(gbo);
    }

    void countSingleReservation(IRmJob j, ResourceClass rc) {
        String methodName = "countSingleReservation";
        this.logger.info(methodName, j.getId(), new Object[]{"Counting shares for", j.getShortType() + "." + j.getId(), "in class", rc.getName()});
        NodePool np = rc.getNodepool();
        if (j.countNShares() > 0) {
            this.logger.info(methodName, j.getId(), new Object[]{"[stable]", "assigned", j.countNShares(), "processes, ", j.countNShares() * j.getShareOrder(), "QS"});
            int[] gbo = this.globalNodepool.makeArray();
            gbo[j.getShareOrder()] = 1;
            j.setGivenByOrder(gbo);
            return;
        }
        if (!this.validSingleAllotment(j)) {
            return;
        }
        if (np.countReservables(j) == 0) {
            this.schedulingUpdate.defer(j, "Deferred because there are no hosts of the correct size in class " + rc.getName());
            this.logger.warn(methodName, j.getId(), new Object[]{"Deferred because requested memory " + j.getMemory() + " does not match any machine."});
            return;
        }
        if (np.countFreeableMachines(j, 1) == 0) {
            this.schedulingUpdate.defer(j, "Deferred because resources are exhausted.");
            this.logger.warn(methodName, j.getId(), new Object[]{"Deferred because resources are exhausted in nodepool " + np.getId()});
            return;
        }
        this.logger.info(methodName, j.getId(), new Object[]{"Request is granted a machine for reservation."});
        int[] gbo = this.globalNodepool.makeArray();
        int order = j.getShareOrder();
        gbo[order] = 1;
        j.setGivenByOrder(gbo);
    }

    private void whatOfReserve(ArrayList<ResourceClass> rcs) {
        String methodName = "whatOfToReserve";
        for (ResourceClass rc : rcs) {
            NodePool np = rc.getNodepool();
            ArrayList<IRmJob> jobs = rc.getAllJobsSorted(new JobByTimeSorter());
            for (IRmJob j : jobs) {
                if (j.isRefused() || j.isDeferred() || j.isCompleted()) continue;
                try {
                    np.findMachines(j, rc);
                }
                catch (Exception e) {
                    this.logger.error(methodName, j.getId(), new Object[]{"Reservation issues:", e});
                    continue;
                }
                if (j.countNShares() != 0) continue;
                j.setReason("Waiting for preemptions.");
            }
        }
    }

    protected void accountForNonPreemptable() {
        for (ResourceClass rc : this.resourceClasses.values()) {
            switch (rc.getPolicy()) {
                case FAIR_SHARE: {
                    break;
                }
                case FIXED_SHARE: 
                case RESERVE: {
                    NodePool np = rc.getNodepool();
                    HashMap<IRmJob, IRmJob> jobs = rc.getAllJobs();
                    for (IRmJob j : jobs.values()) {
                        HashMap<Share, Share> shares = j.getAssignedShares();
                        np.accountForShares(shares);
                    }
                    break;
                }
            }
        }
    }

    protected void accountForFairShare() {
        for (ResourceClass rc : this.resourceClasses.values()) {
            if (rc.getPolicy() != SchedConstants.Policy.FAIR_SHARE) continue;
            NodePool np = rc.getNodepool();
            HashMap<IRmJob, IRmJob> jobs = rc.getAllJobs();
            for (IRmJob j : jobs.values()) {
                HashMap<Share, Share> shares = j.getAssignedShares();
                np.accountForShares(shares);
            }
        }
    }

    protected void findHowMuch(ArrayList<ResourceClass> rcs) {
        switch (rcs.get(0).getPolicy()) {
            case FAIR_SHARE: {
                this.howMuchFairShare(rcs);
                break;
            }
            case FIXED_SHARE: {
                this.howMuchFixed(rcs);
                break;
            }
            case RESERVE: {
                this.howMuchReserve(rcs);
            }
        }
    }

    protected void doEvictions(NodePool nodepool) {
        String methodName = "doEvictions";
        for (NodePool np : nodepool.getChildrenDescending()) {
            this.logger.debug(methodName, null, new Object[]{"Recurse to", np.getId(), "from", nodepool.getId()});
            this.doEvictions(np);
            this.logger.debug(methodName, null, new Object[]{"Return from", np.getId(), "proceeding with logic for", nodepool.getId()});
        }
        int[] neededByOrder = this.globalNodepool.makeArray();
        HashMap<IRmJob, Integer> overages = new HashMap<IRmJob, Integer>();
        for (ResourceClass cl : this.resourceClasses.values()) {
            if (!cl.getNodepoolName().equals(nodepool.getId()) || cl.getAllJobs().size() <= 0) continue;
            HashMap<IRmJob, IRmJob> jobs = cl.getAllJobs();
            String npn = cl.getNodepoolName();
            this.logger.info(methodName, null, new Object[]{String.format("%7s %7s %6s %5s  (%s)", "Counted", "Current", "Needed", "Order", npn)});
            for (IRmJob j : jobs.values()) {
                int counted = j.countNSharesGiven();
                int current = j.countNShares();
                int needed = counted - current;
                int order = j.getShareOrder();
                if (needed < 0) {
                    overages.put(j, -needed);
                    continue;
                }
                this.logger.info(methodName, j.getId(), new Object[]{String.format("%7d %7d %6d %5d", counted, current, needed, order)});
                int n = order;
                neededByOrder[n] = neededByOrder[n] + needed;
            }
        }
        for (IRmJob j : overages.keySet()) {
            j.shrinkBy((Integer)overages.get(j));
        }
    }

    boolean compatibleNodepools(Share candidate, IRmJob needy) {
        Machine m = candidate.getMachine();
        ResourceClass nrc = needy.getResourceClass();
        NodePool np = nrc.getNodepool();
        return np.containsMachine(m);
    }

    boolean compatibleNodepools(ResourceClass potential, IRmJob needy) {
        ResourceClass nrc = needy.getResourceClass();
        NodePool pp = potential.getNodepool();
        NodePool np = nrc.getNodepool();
        return np.containsSubpool(pp) || pp.containsSubpool(np);
    }

    String listJobSet(Map<IRmJob, IRmJob> jobs) {
        if (jobs.size() == 0) {
            return "NONE";
        }
        StringBuffer sb = new StringBuffer("[");
        for (IRmJob j : jobs.keySet()) {
            sb.append(j.getId());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    String listJobSet(List<IRmJob> jobs) {
        if (jobs.size() == 0) {
            return "NONE";
        }
        StringBuffer sb = new StringBuffer("[");
        for (IRmJob j : jobs) {
            sb.append(j.getId());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    boolean clearShare(Share s, IRmJob nj) {
        String methodName = "clearShare";
        IRmJob rich_j = s.getJob();
        if (s.isPending()) {
            if (s.getShareOrder() == nj.getShareOrder()) {
                this.logger.debug(methodName, nj.getId(), new Object[]{"Reassign expanded share", s.toString(), "from", rich_j.getId()});
                Machine m = s.getMachine();
                m.reassignShare(s, nj);
                rich_j.cancelPending(s);
                nj.assignShare(s);
                return false;
            }
            this.logger.debug(methodName, nj.getId(), new Object[]{"Canceling expansion share", s.toString(), "from", rich_j.getId()});
            rich_j.cancelPending(s);
            Machine m = s.getMachine();
            m.removeShare(s);
            return true;
        }
        this.logger.debug(methodName, nj.getId(), new Object[]{"Donate", s.toString(), "from", rich_j.getId()});
        rich_j.shrinkByOne(s);
        return false;
    }

    int takeFromTheRich(IRmJob nj, int needed, TreeMap<User, User> users_by_wealth, HashMap<User, TreeMap<IRmJob, IRmJob>> jobs_by_user) {
        String methodName = "takeFromTheRich";
        HashMap<IRmJob, IRmJob> candidateJobs = new HashMap<IRmJob, IRmJob>();
        TreeMap<Machine, Object> eligibleMachines = new TreeMap<Machine, Object>(new EligibleMachineSorter());
        for (TreeMap<IRmJob, IRmJob> jobs : jobs_by_user.values()) {
            candidateJobs.putAll(jobs);
        }
        int given = 0;
        int orderNeeded = nj.getShareOrder();
        ResourceClass cl = nj.getResourceClass();
        String npname = cl.getNodepoolName();
        NodePool np = this.globalNodepool.getSubpool(npname);
        HashMap<Node, Machine> machines = np.getAllMachines();
        block1: for (Object m : machines.values()) {
            if (((Machine)m).getShareOrder() < orderNeeded) {
                this.logger.debug(methodName, nj.getId(), new Object[]{"Bypass ", ((Machine)m).getId(), ": too small for request of order", orderNeeded});
                continue;
            }
            if (nj.getSchedulingPolicy() == SchedConstants.Policy.RESERVE) {
                if (((Machine)m).getShareOrder() != orderNeeded) {
                    this.logger.debug(methodName, nj.getId(), new Object[]{"Bypass ", ((Machine)m).getId(), ": RESERVE policy requires exact match for order", orderNeeded});
                    continue;
                }
                Collection<Share> shares = ((Machine)m).getActiveShares().values();
                for (Share share : shares) {
                    if (candidateJobs.containsKey(share.getJob())) continue;
                    this.logger.debug(methodName, nj.getId(), new Object[]{"Bypass ", ((Machine)m).getId(), ": for reservation, machine contains non-candidate job", share.getJob().getId()});
                    continue block1;
                }
            }
            HashMap<Share, Share> as = ((Machine)m).getActiveShares();
            int g = ((Machine)m).getVirtualShareOrder();
            for (Share s3 : as.values()) {
                IRmJob j = s3.getJob();
                if (!s3.isForceable() || !candidateJobs.containsKey(j)) continue;
                g += j.getShareOrder();
            }
            if (g >= orderNeeded) {
                this.logger.info(methodName, nj.getId(), new Object[]{"Candidate machine:", ((Machine)m).getId()});
                eligibleMachines.put((Machine)m, m);
                continue;
            }
            this.logger.info(methodName, nj.getId(), new Object[]{"Not a candidate, insufficient free space + candidate shares:", ((Machine)m).getId()});
        }
        this.logger.info(methodName, nj.getId(), new Object[]{"Found", eligibleMachines.size(), "machines to be searched in this order:"});
        StringBuffer buf = new StringBuffer();
        for (Machine m : eligibleMachines.keySet()) {
            buf.append(m.getId());
            buf.append(" ");
        }
        this.logger.info(methodName, nj.getId(), new Object[]{"Eligible machines:", buf.toString()});
        int given_per_round = 0;
        do {
            int g = 0;
            given_per_round = 0;
            block6: for (Machine machine : eligibleMachines.keySet()) {
                IRmJob j;
                ArrayList<Share> sh = new ArrayList<Share>();
                sh.addAll(machine.getActiveShares().values());
                Collections.sort(sh, new ShareByWealthSorter());
                g = machine.getVirtualShareOrder();
                ArrayList<Share> potentialShares = new ArrayList<Share>();
                for (Share s : sh) {
                    j = s.getJob();
                    if (s.isForceable() && candidateJobs.containsKey(j)) {
                        g += s.getShareOrder();
                        if (s.getShareOrder() == orderNeeded) {
                            potentialShares.add(0, s);
                        } else {
                            potentialShares.add(s);
                        }
                    }
                    if (g < orderNeeded) continue;
                    break;
                }
                if (g < orderNeeded) continue;
                this.logger.debug(methodName, nj.getId(), new Object[]{"Clearing shares: g[", g, "], orderNeeded[", orderNeeded, "]"});
                g = machine.getVirtualShareOrder();
                for (Share s : potentialShares) {
                    j = s.getJob();
                    User u = j.getUser();
                    ++given_per_round;
                    this.clearShare(s, nj);
                    u.subtractWealth(s.getShareOrder());
                    this.logger.debug(methodName, nj.getId(), new Object[]{"Clearing share", s, "order[", s.getShareOrder(), "]: g[", g += s.getShareOrder(), "], orderNeeded[", orderNeeded, "]"});
                    if (g < orderNeeded) continue;
                    break block6;
                }
            }
            if (given_per_round > 0) {
                HashMap<Machine, Object> tmp = new HashMap<Machine, Object>();
                tmp.putAll(eligibleMachines);
                eligibleMachines.clear();
                for (Machine m : tmp.keySet()) {
                    eligibleMachines.put(m, m);
                }
                this.logger.debug(methodName, nj.getId(), new Object[]{"LOOPEND: given[", given += g / orderNeeded, "] g[", g, "] orderNeeded[", orderNeeded, "]"});
            }
            this.logger.debug(methodName, nj.getId(), new Object[]{"Given_per_round", given_per_round, "given", given, "needed", needed});
        } while (given_per_round > 0 && given < needed);
        if (nj.countNShares() == 0) {
            nj.setReason("Waiting for defragmentation.");
        }
        return given;
    }

    void doFinalEvictions(HashMap<IRmJob, Integer> needy) {
        String methodName = "doFinalEvictions";
        for (IRmJob j : needy.keySet()) {
            this.logger.debug(methodName, j.getId(), new Object[]{"Will attempt to have space made for", needy.get(j), "processes"});
        }
        for (IRmJob nj : needy.keySet()) {
            int priority_needy = nj.getSchedulingPriority();
            TreeMap<IRmJob, IRmJob> rich_candidates = new TreeMap<IRmJob, IRmJob>(new FragmentationSorter());
            TreeMap<IRmJob, IRmJob> poor_candidates = new TreeMap<IRmJob, IRmJob>(new FragmentationSorter());
            for (ResourceClass rc : this.resourceClasses.values()) {
                if (rc.getPolicy() == SchedConstants.Policy.RESERVE || rc.getPolicy() == SchedConstants.Policy.FIXED_SHARE) continue;
                if (!this.compatibleNodepools(rc, nj)) {
                    this.logger.debug(methodName, nj.getId(), new Object[]{"Skipping class", rc.getName(), "vs job class", nj.getResourceClass().getName(), "because of incompatible nodepools."});
                    continue;
                }
                int priority_candidate = rc.getPriority();
                boolean use_expanded_pool = false;
                if (priority_needy > priority_candidate) {
                    this.logger.debug(methodName, nj.getId(), new Object[]{"Jobs in class", rc.getName(), "are not candidates because better priority: [", priority_candidate, "vs", priority_needy, "]"});
                    continue;
                }
                if (priority_needy < priority_candidate) {
                    this.logger.debug(methodName, nj.getId(), new Object[]{"Needy job has better priority than jobs in class", rc.getName(), "[", priority_candidate, "vs", priority_needy, "]. Using expanded pool."});
                    use_expanded_pool = true;
                }
                HashMap<IRmJob, IRmJob> jobs = rc.getAllJobs();
                for (IRmJob j : jobs.values()) {
                    int nshares = j.countNShares();
                    int qshares = nshares * j.getShareOrder();
                    if (nshares == 0) {
                        this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is not a candidate because it has no share."});
                        continue;
                    }
                    if (needy.containsKey(j)) {
                        if (use_expanded_pool) {
                            this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is a backup candidate because it's needy."});
                            poor_candidates.put(j, j);
                            continue;
                        }
                        this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is a not a candidate because it's needy."});
                        continue;
                    }
                    if (!j.isInitialized()) {
                        if (use_expanded_pool) {
                            this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is a backup candidate because it's not initialized yet."});
                            poor_candidates.put(j, j);
                            continue;
                        }
                        this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is not a candidate because it's not initialized yet."});
                        continue;
                    }
                    if (nshares < this.fragmentationThreshold) {
                        if (use_expanded_pool) {
                            this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is a backup candidate because below frag threshold. nshares[", nshares, "] qshares[", qshares, "] threshold[", this.fragmentationThreshold, "]"});
                            poor_candidates.put(j, j);
                            continue;
                        }
                        this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is not a candidate because below frag threshold. nshares[", nshares, "] qshares[", qshares, "] threshold[", this.fragmentationThreshold, "]"});
                        continue;
                    }
                    this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is a candidate with processes[", nshares, "] qshares[", qshares, "]"});
                    rich_candidates.put(j, j);
                }
            }
            HashMap<User, TreeMap<IRmJob, IRmJob>> jobs_by_user = new HashMap<User, TreeMap<IRmJob, IRmJob>>();
            TreeMap<User, User> users_by_wealth = new TreeMap<User, User>(new UserByWealthSorter());
            this.collectWealth(rich_candidates, users_by_wealth, jobs_by_user);
            int needed = needy.get(nj);
            this.logger.debug(methodName, nj.getId(), new Object[]{"Needy job looking for", needed, "more processes of O[", nj.getShareOrder(), "]"});
            needed -= this.takeFromTheRich(nj, needed, users_by_wealth, jobs_by_user);
            if (needed <= 0) {
                this.logger.info(methodName, nj.getId(), new Object[]{"Satisfied needs of job by taking from the rich."});
                continue;
            }
            if (poor_candidates.size() > 0) {
                this.logger.info(methodName, nj.getId(), new Object[]{"Could not clear sufficient space from rich candidates.  Retrying with all candidates."});
                jobs_by_user.clear();
                users_by_wealth.clear();
                rich_candidates.putAll(poor_candidates);
                this.collectWealth(rich_candidates, users_by_wealth, jobs_by_user);
                needed -= this.takeFromTheRich(nj, needed, users_by_wealth, jobs_by_user);
                if (needed <= 0) {
                    this.logger.info(methodName, nj.getId(), new Object[]{"Satisfied needs of job by taking from all candidates."});
                    continue;
                }
            }
            this.logger.info(methodName, nj.getId(), new Object[]{"Could not get enough from the rich. Asked for", needy.get(nj), "still needing", needed});
            nj.setReason("Waiting for defragmentation.");
        }
    }

    void collectWealth(TreeMap<IRmJob, IRmJob> candidates, TreeMap<User, User> users_by_wealth, HashMap<User, TreeMap<IRmJob, IRmJob>> jobs_by_user) {
        HashMap<User, Integer> shares_by_user = new HashMap<User, Integer>();
        for (IRmJob j : candidates.values()) {
            User u = j.getUser();
            if (shares_by_user.get(u) == null) {
                shares_by_user.put(u, 0);
            }
            shares_by_user.put(u, (Integer)shares_by_user.get(u) + j.countNShares() * j.getShareOrder());
            TreeMap<IRmJob, IRmJob> ujobs = jobs_by_user.get(u);
            if (ujobs == null) {
                ujobs = new TreeMap(new JobByShareSorter());
                jobs_by_user.put(u, ujobs);
            }
            ujobs.put(j, j);
        }
        for (User u : shares_by_user.keySet()) {
            u.setShareWealth((Integer)shares_by_user.get(u));
            users_by_wealth.put(u, u);
        }
    }

    void getNodepools(NodePool top, List<NodePool> nodepools) {
        for (NodePool np : top.getChildren().values()) {
            this.getNodepools(np, nodepools);
        }
        nodepools.add(top);
    }

    void detectFragmentation(HashMap<IRmJob, Integer> needed_by_job) {
        int[] nmach;
        String id;
        int npi;
        Map jobmap;
        Object vmach;
        String methodName = "detectFragmentation";
        if (this.logger.isDebug()) {
            this.logger.debug(methodName, null, new Object[]{"vMachines:", this.fmtArray(this.globalNodepool.cloneVMachinesByOrder())});
        }
        ArrayList<NodePool> poollist = new ArrayList<NodePool>();
        this.getNodepools(this.globalNodepool, poollist);
        NodePool[] allPools = poollist.toArray(new NodePool[poollist.size()]);
        if (this.logger.isDebug()) {
            StringBuffer sb = new StringBuffer("Nodepools:");
            for (NodePool np : allPools) {
                sb.append(np.getId());
                sb.append(" ");
            }
            this.logger.debug(methodName, null, new Object[]{sb.toString()});
        }
        HashMap<String, Object> vshares = new HashMap<String, Object>();
        HashMap<String, int[]> nshares = new HashMap<String, int[]>();
        HashMap jobs = new HashMap();
        for (int npi2 = 0; npi2 < allPools.length; ++npi2) {
            NodePool np;
            np = allPools[npi2];
            String id2 = np.getId();
            vmach = this.globalNodepool.makeArray();
            int[] nmach2 = this.globalNodepool.makeArray();
            jobmap = new HashMap();
            vshares.put(id2, vmach);
            nshares.put(id2, nmach2);
            jobs.put(id2, jobmap);
        }
        boolean must_defrag = false;
        String headerfmt = "%14s %20s %6s %4s %7s %6s %2s";
        String datafmt = "%14s %20s %6d %4d %7d %6d %2d";
        vmach = this.resourceClasses.values().iterator();
        while (vmach.hasNext()) {
            ResourceClass rc = (ResourceClass)vmach.next();
            HashMap<IRmJob, IRmJob> allJobs = rc.getAllJobs();
            String npn = rc.getNodepoolName();
            Map jobmap2 = (Map)jobs.get(npn);
            if (allJobs.size() == 0) continue;
            this.logger.info(methodName, null, new Object[]{String.format(headerfmt, "Nodepool", "User", "PureFS", "NSh", "Counted", "Needed", "O"), "Class:", rc.getName()});
            for (IRmJob j : allJobs.values()) {
                if (j.isRefused() || j.isDeferred()) continue;
                int counted = j.countNSharesGiven();
                int current = j.countNShares();
                int needed = counted - current;
                int order = j.getShareOrder();
                if (j.getSchedulingPolicy() == SchedConstants.Policy.FAIR_SHARE) {
                    if (current >= this.fragmentationThreshold) {
                        needed = 0;
                    } else if (current >= j.getPureFairShare()) {
                        needed = 0;
                    } else if (needed < 0) {
                        needed = 0;
                    } else if (needed > 0) {
                        needed = Math.min(needed, this.fragmentationThreshold);
                        jobmap2.put(j, needed);
                        must_defrag = true;
                    }
                } else if (needed > 0) {
                    jobmap2.put(j, needed);
                    must_defrag = true;
                }
                this.logger.info(methodName, j.getId(), new Object[]{String.format(datafmt, npn, j.getUser().getName(), j.getPureFairShare(), current, counted, needed, order), needed > 0 ? "POTENTIALLY NEEDY" : ""});
            }
        }
        if (!must_defrag) {
            return;
        }
        for (npi = 0; npi < allPools.length; ++npi) {
            NodePool np = allPools[npi];
            HashMap<Node, Machine> machs = np.getAllMachinesForPool();
            for (Machine m : machs.values()) {
                int free = m.countFreedUpShares();
                if (free == 0) continue;
                this.logger.trace(methodName, null, new Object[]{"Freed shares", free, "on machine", m.getId(), "in nodepool", np.getId()});
                for (NodePool npj = np; npj != null; npj = npj.getParent()) {
                    String id_j = npj.getId();
                    int[] vmach_j = (int[])vshares.get(id_j);
                    if (free >= vmach_j.length) {
                        this.logger.warn(methodName, null, new Object[]{"Nodepool", id_j, "has a maximum size of", vmach_j.length - 1, "but the computed free space is", free});
                        free = vmach_j.length - 1;
                    }
                    this.logger.trace(methodName, null, new Object[]{"Update v before: NP[", id_j, "] v:", this.fmtArray(vmach_j)});
                    int n = free;
                    vmach_j[n] = vmach_j[n] + 1;
                    this.logger.trace(methodName, null, new Object[]{"Update v after : NP[", id_j, "] v:", this.fmtArray(vmach_j)});
                }
            }
        }
        for (npi = 0; npi < allPools.length; ++npi) {
            id = allPools[npi].getId();
            int[] vmach2 = (int[])vshares.get(id);
            nmach = (int[])nshares.get(id);
            this.reworknShares(vmach2, nmach);
            if (!this.logger.isInfo()) continue;
            this.logger.info(methodName, null, new Object[]{"NP", id, "After check: virtual    free Space", this.fmtArray(vmach2)});
            this.logger.info(methodName, null, new Object[]{"NP", id, "After check: cumulative free Space", this.fmtArray(nmach)});
        }
        for (npi = 0; npi < allPools.length; ++npi) {
            id = allPools[npi].getId();
            jobmap = (Map)jobs.get(id);
            if (jobmap.size() == 0) continue;
            nmach = (int[])nshares.get(id);
            for (IRmJob j : jobmap.keySet()) {
                int needed = (Integer)jobmap.get(j);
                int order = j.getShareOrder();
                int available = nmach[order];
                int to_remove = 0;
                this.needyJobs.put(j, j);
                if (available >= needed) {
                    to_remove = needed = 0;
                } else {
                    to_remove = available;
                    needed -= to_remove;
                }
                if (to_remove > 0) {
                    NodePool np;
                    for (NodePool npj = np = allPools[npi]; npj != null; npj = npj.getParent()) {
                        String id_j = npj.getId();
                        int[] vmach_j = (int[])vshares.get(id_j);
                        int[] nmach_j = (int[])nshares.get(id_j);
                        this.removeSharesByOrder(vmach_j, nmach_j, to_remove, order);
                    }
                }
                if (needed <= 0) continue;
                needed_by_job.put(j, needed);
                this.logger.info(methodName, j.getId(), new Object[]{String.format("NP: %10s User: %10s Pure fs: %3d needed %3d O[%d] %s", id, j.getUser().getName(), j.getPureFairShare(), needed, order, "ACTUALLY NEEDY")});
            }
        }
    }

    void insureFullEviction() {
        String methodName = "insureFullEviction";
        int jobcount = 0;
        for (ResourceClass rc : this.resourceClasses.values()) {
            if (rc.getPolicy() == SchedConstants.Policy.RESERVE) continue;
            jobcount += rc.countJobs();
        }
        if (jobcount == 0) {
            return;
        }
        HashMap<IRmJob, Integer> needy = new HashMap<IRmJob, Integer>();
        this.detectFragmentation(needy);
        if (needy.size() == 0) {
            this.logger.info(methodName, null, new Object[]{"No needy jobs, defragmentation bypassed."});
            return;
        }
        this.logger.info(methodName, null, new Object[]{"NEEDY JOBS DETECTED"});
        this.doFinalEvictions(needy);
    }

    protected void findWhatOf(ArrayList<ResourceClass> rcs) {
        switch (rcs.get(0).getPolicy()) {
            case FAIR_SHARE: {
                this.whatOfFairShare(rcs);
                break;
            }
            case FIXED_SHARE: {
                this.whatOfFixedShare(rcs);
                break;
            }
            case RESERVE: {
                this.whatOfReserve(rcs);
            }
        }
    }

    void setSchedulingUpdate(ArrayList<ResourceClass> rcs) {
        for (ResourceClass rc : rcs) {
            HashMap<IRmJob, IRmJob> jobs = rc.getAllJobs();
            for (IRmJob j : jobs.values()) {
                if (j.isRefused()) continue;
                if (j.isExpanded()) {
                    this.schedulingUpdate.addExpandedJob(j);
                }
                if (j.isShrunken()) {
                    this.schedulingUpdate.addShrunkenJob(j);
                }
                if (j.isStable() && !j.isReservation()) {
                    this.schedulingUpdate.addStableJob(j);
                }
                if (j.isDormant()) {
                    this.schedulingUpdate.addDormantJob(j);
                }
                if (!j.isReservation()) continue;
                this.schedulingUpdate.addReservation(j);
            }
        }
    }

    private void resetNodepools() {
        int maxorder = 0;
        for (ResourceClass rc : this.resourceClasses.values()) {
            maxorder = Math.max(maxorder, rc.getMaxJobOrder());
        }
        this.globalNodepool.reset(maxorder);
    }

    @Override
    public void schedule(SchedulingUpdate upd) {
        ArrayList rcs;
        int i;
        String methodName = "schedule";
        int jobcount = 0;
        for (ResourceClass rc : this.resourceClasses.values()) {
            HashMap<IRmJob, IRmJob> allJobs = rc.getAllJobs();
            jobcount += allJobs.size();
            for (IRmJob j : allJobs.values()) {
                j.initJobCap();
            }
        }
        if (jobcount == 0) {
            this.logger.debug(methodName, null, new Object[]{"No jobs to schedule under nodepool", this.globalNodepool.getId()});
            return;
        }
        if (this.logger.isDebug()) {
            this.logger.info(methodName, null, new Object[]{"Machine occupancy before schedule"});
            this.globalNodepool.queryMachines();
        }
        this.schedulingUpdate = upd;
        this.resetNodepools();
        this.accountForNonPreemptable();
        for (i = 0; i < this.classes.length; ++i) {
            rcs = (ArrayList)this.classes[i];
            this.findHowMuch(rcs);
        }
        this.resetNodepools();
        this.accountForNonPreemptable();
        this.accountForFairShare();
        if (this.logger.isTrace()) {
            this.globalNodepool.queryMachines();
        }
        for (i = 0; i < this.classes.length; ++i) {
            rcs = (ArrayList)this.classes[i];
            this.expandNeedyJobs(this.globalNodepool, rcs);
        }
        for (i = 0; i < this.classes.length; ++i) {
            rcs = (ArrayList)this.classes[i];
            this.findWhatOf(rcs);
        }
        this.doEvictions(this.globalNodepool);
        if (this.do_defragmentation) {
            this.insureFullEviction();
        }
        for (i = 0; i < this.classes.length; ++i) {
            rcs = (ArrayList)this.classes[i];
            this.setSchedulingUpdate(rcs);
        }
        this.globalNodepool.resetPreemptables();
    }

    private static class ShareByWealthSorter
    implements Comparator<Share> {
        private ShareByWealthSorter() {
        }

        @Override
        public int compare(Share s1, Share s2) {
            if (s1.equals(s2)) {
                return 0;
            }
            int s1wealth = 0;
            int s2wealth = 0;
            IRmJob j1 = s1.getJob();
            User u1 = j1.getUser();
            s1wealth = u1.getShareWealth();
            IRmJob j2 = s2.getJob();
            User u2 = j2.getUser();
            s2wealth = u2.getShareWealth();
            if (s2wealth == s1wealth) {
                return RmJob.compareInvestment(s1, s2);
            }
            return s2wealth - s1wealth;
        }
    }

    private static class EligibleMachineSorter
    implements Comparator<Machine> {
        private EligibleMachineSorter() {
        }

        @Override
        public int compare(Machine m1, Machine m2) {
            long m2mem;
            if (m1.equals(m2)) {
                return 0;
            }
            int m1wealth = 0;
            int m2wealth = 0;
            HashMap<Share, Share> sh1 = m1.getActiveShares();
            for (Object s : sh1.values()) {
                IRmJob j = ((Share)s).getJob();
                User u = j.getUser();
                m1wealth = Math.max(m1wealth, u.getShareWealth());
            }
            HashMap<Share, Share> sh2 = m2.getActiveShares();
            for (Share s : sh2.values()) {
                IRmJob j = s.getJob();
                User u = j.getUser();
                m2wealth = Math.max(m2wealth, u.getShareWealth());
            }
            if (m1wealth != m2wealth) {
                return m2wealth - m1wealth;
            }
            long m1mem = m1.getMemory();
            if (m1mem == (m2mem = m2.getMemory())) {
                return -1;
            }
            return (int)(m2mem - m1mem);
        }
    }

    private static class FragmentationSorter
    implements Comparator<IRmJob> {
        private FragmentationSorter() {
        }

        @Override
        public int compare(IRmJob j1, IRmJob j2) {
            int o2;
            if (j1.equals(j2)) {
                return 0;
            }
            int p1 = j1.getPureFairShare();
            int p2 = j2.getPureFairShare();
            int c1 = j1.countNShares() * j1.getShareOrder();
            int c2 = j2.countNShares() * j2.getShareOrder();
            int o1 = Math.max(0, c1 - p1);
            if (o1 < (o2 = Math.max(0, c2 - p2))) {
                return 1;
            }
            if (o1 > o2) {
                return -1;
            }
            if (c1 < c2) {
                return 1;
            }
            if (c1 > c2) {
                return -1;
            }
            return -1;
        }
    }

    private static class JobByShareSorter
    implements Comparator<IRmJob> {
        private JobByShareSorter() {
        }

        @Override
        public int compare(IRmJob j1, IRmJob j2) {
            int s2;
            if (j1.equals(j2)) {
                return 0;
            }
            int s1 = j1.countNShares() * j1.getShareOrder();
            if (s1 == (s2 = j2.countNShares() * j2.getShareOrder())) {
                return -1;
            }
            return s2 - s1;
        }
    }

    private static class UserByWealthSorter
    implements Comparator<User> {
        private UserByWealthSorter() {
        }

        @Override
        public int compare(User u1, User u2) {
            int w2;
            if (u1.equals(u2)) {
                return 0;
            }
            int w1 = u1.getShareWealth();
            if (w1 == (w2 = u2.getShareWealth())) {
                return -1;
            }
            return w2 - w1;
        }
    }

    private static class ClassByWeightSorter
    implements Comparator<ResourceClass> {
        private ClassByWeightSorter() {
        }

        @Override
        public int compare(ResourceClass r1, ResourceClass r2) {
            if (r1 == r2) {
                return 0;
            }
            return r2.getShareWeight() - r1.getShareWeight();
        }
    }

    private static class JobByTimeSorter
    implements Comparator<IRmJob> {
        private JobByTimeSorter() {
        }

        @Override
        public int compare(IRmJob j1, IRmJob j2) {
            if (j1.equals(j2)) {
                return 0;
            }
            if (j1.getTimestamp() == j2.getTimestamp()) {
                return j2.getShareOrder() - j1.getShareOrder();
            }
            return (int)(j1.getTimestamp() - j2.getTimestamp());
        }
    }
}

