/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.persistence.access;

import java.util.Map;
import org.apache.uima.ducc.common.head.IDuccHead;
import org.apache.uima.ducc.common.persistence.rm.IDbJob;
import org.apache.uima.ducc.common.persistence.rm.IDbShare;
import org.apache.uima.ducc.common.persistence.rm.IRmPersistence;
import org.apache.uima.ducc.common.persistence.rm.RmPersistenceFactory;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.rm.DuccHead;
import org.apache.uima.ducc.rm.persistence.access.IPersistenceAccess;

public class PersistenceAccess
implements IPersistenceAccess {
    private static String COMPONENT_NAME = "RM";
    private static DuccId jobid = null;
    private static DuccLogger logger = DuccLogger.getLogger(PersistenceAccess.class, (String)COMPONENT_NAME);
    private static IPersistenceAccess persistenceAccess = new PersistenceAccess();
    private static String bypass = "bypass";
    private IDuccHead dh = DuccHead.getInstance();
    private IRmPersistence rm_persistence = RmPersistenceFactory.getInstance((String)this.getClass().getName(), (String)COMPONENT_NAME);

    public static IPersistenceAccess getInstance() {
        return persistenceAccess;
    }

    private PersistenceAccess() {
    }

    private boolean is_master() {
        String location = "is_master";
        boolean retVal = this.dh.is_ducc_head_virtual_master();
        logger.debug(location, jobid, new Object[]{retVal});
        return retVal;
    }

    @Override
    public void setNodeProperty(String id, IRmPersistence.RmNodes key, Object value) throws Exception {
        String location = "setNodeProperty";
        if (this.is_master()) {
            this.rm_persistence.setNodeProperty(id, key, value);
        } else {
            logger.debug(location, jobid, new Object[]{bypass, id, key, value});
        }
    }

    @Override
    public void setNodeProperties(String id, Object ... properties) throws Exception {
        String location = "setNodeProperties";
        if (this.is_master()) {
            this.rm_persistence.setNodeProperties(id, properties);
        } else {
            logger.debug(location, jobid, new Object[]{bypass, id});
        }
    }

    @Override
    public void addAssignment(String id, DuccId jobid, IDbShare share, int quantum, String jobtype) throws Exception {
        String location = "addAssignment";
        if (this.is_master()) {
            this.rm_persistence.addAssignment(id, jobid, share, quantum, jobtype);
        } else {
            logger.debug(location, jobid, new Object[]{bypass, id, jobid, share, quantum, jobtype});
        }
    }

    @Override
    public void removeAssignment(String id, DuccId jobid, IDbShare share) throws Exception {
        String location = "removedAssignment";
        if (this.is_master()) {
            this.rm_persistence.removeAssignment(id, jobid, share);
        } else {
            logger.debug(location, jobid, new Object[]{bypass, id, jobid, share});
        }
    }

    @Override
    public void createMachine(String id, Map<IRmPersistence.RmNodes, Object> props) throws Exception {
        String location = "createMachine";
        if (this.is_master()) {
            this.rm_persistence.createMachine(id, props);
        } else {
            logger.debug(location, jobid, new Object[]{bypass, id});
        }
    }

    @Override
    public void clear() throws Exception {
        String location = "clear";
        if (this.is_master()) {
            this.rm_persistence.clear();
        } else {
            logger.debug(location, jobid, new Object[]{bypass});
        }
    }

    @Override
    public void close() {
        String location = "close";
        if (this.is_master()) {
            this.rm_persistence.close();
        } else {
            logger.debug(location, jobid, new Object[]{bypass});
        }
    }

    @Override
    public void addJob(IDbJob j) throws Exception {
        String location = "addJob";
        if (this.is_master()) {
            this.rm_persistence.addJob(j);
        } else {
            logger.debug(location, jobid, new Object[]{bypass, j});
        }
    }

    @Override
    public void deleteJob(IDbJob j) throws Exception {
        String location = "deleteJob";
        if (this.is_master()) {
            this.rm_persistence.deleteJob(j);
        } else {
            logger.debug(location, jobid, new Object[]{bypass, j});
        }
    }

    @Override
    public void updateDemand(IDbJob j) throws Exception {
        String location = "updateDemand";
        if (this.is_master()) {
            this.rm_persistence.updateDemand(j);
        } else {
            logger.debug(location, jobid, new Object[]{bypass, j});
        }
    }

    @Override
    public void updateShare(String node, DuccId shareid, DuccId jobid, long investment, String state, long init_time, long pid) throws Exception {
        String location = "updateShare";
        if (this.is_master()) {
            this.rm_persistence.updateShare(node, shareid, jobid, investment, state, init_time, pid);
        } else {
            logger.debug(location, jobid, new Object[]{bypass, node, shareid, jobid, investment, state, init_time, pid});
        }
    }

    @Override
    public void setFixed(String node, DuccId shareId, DuccId jobId, boolean val) throws Exception {
        String location = "setFixed";
        if (this.is_master()) {
            this.rm_persistence.setFixed(node, shareId, jobId, val);
        } else {
            logger.debug(location, jobId, new Object[]{bypass, node, shareId, jobId, val});
        }
    }

    @Override
    public void setPurged(String node, DuccId shareId, DuccId jobId, boolean val) throws Exception {
        String location = "setPurged";
        if (this.is_master()) {
            this.rm_persistence.setPurged(node, shareId, jobId, val);
        } else {
            logger.debug(location, jobId, new Object[]{bypass, node, shareId, jobId, val});
        }
    }

    @Override
    public void setEvicted(String node, DuccId shareId, DuccId jobId, boolean val) throws Exception {
        String location = "setEvicted";
        if (this.is_master()) {
            this.rm_persistence.setEvicted(node, shareId, jobId, val);
        } else {
            logger.debug(location, jobId, new Object[]{bypass, node, shareId, jobId, val});
        }
    }
}

