/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.uima.ducc.cli.AServicePing;
import org.apache.uima.ducc.cli.ServiceStatistics;
import org.apache.uima.ducc.common.IServiceStatistics;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.sm.UimaAsServiceMonitor;

public class UimaAsPing
extends AServicePing {
    private String endpoint;
    private String brokerURI;
    private int meta_timeout;
    private String broker_host;
    private int broker_jmx_port;
    private UimaAsServiceMonitor monitor;
    private String nodeIp;
    private String pid;
    private Connection connection;
    private Session producerSession;
    private MessageProducer producer;
    private Session consumerSession;
    private TemporaryQueue consumerDestination;
    private MessageConsumer consumer;
    private boolean failover = false;

    public void init(String args, String ep) throws Exception {
        this.monitor = null;
        if (args == null) {
            this.meta_timeout = 5000;
            this.broker_jmx_port = 1099;
        } else {
            String lines = args.replace(',', '\n');
            DuccProperties props = new DuccProperties();
            props.load((Reader)new StringReader(lines));
            this.meta_timeout = props.getIntProperty("meta-timeout", 5000);
            if ("none".equals(props.getProperty("broker-jmx-port"))) {
                return;
            }
            this.broker_jmx_port = props.getIntProperty("broker-jmx-port", 1099);
        }
        String[] tokens = ep.split(":", 3);
        this.endpoint = tokens[1];
        this.brokerURI = tokens[2];
        if (this.brokerURI.startsWith("failover:")) {
            this.failover = true;
            return;
        }
        try {
            URI uri = new URI(this.brokerURI);
            this.broker_host = uri.getHost();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid broker URL '" + this.brokerURI + "'");
        }
        this.doLog("init", new Object[]{"Initializing UimaAsServiceMonitor: endpoint:" + this.endpoint + " broker_host:" + this.broker_host + " broker_jmx_port:" + this.broker_jmx_port});
        this.monitor = new UimaAsServiceMonitor(this.endpoint, this.broker_host, this.broker_jmx_port);
    }

    private void initJMS() throws JMSException {
        String methodName = "initJMS";
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerURI);
        this.connection = factory.createConnection();
        this.connection.start();
        this.doLog(methodName, new Object[]{"Connection started"});
        this.producerSession = this.connection.createSession(false, 1);
        Queue producerQueue = this.producerSession.createQueue(this.endpoint);
        this.producer = this.producerSession.createProducer((Destination)producerQueue);
        this.consumerSession = this.connection.createSession(false, 1);
        this.consumerDestination = this.consumerSession.createTemporaryQueue();
        this.consumer = this.consumerSession.createConsumer((Destination)this.consumerDestination);
        this.doLog(methodName, new Object[]{"Created queues and sessions"});
    }

    public void stop() {
        try {
            if (this.producerSession != null) {
                this.producerSession.close();
            }
            if (this.consumerSession != null) {
                this.consumerSession.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        if (this.monitor != null) {
            this.monitor.stop();
        }
    }

    void evaluateService(IServiceStatistics stats) {
        try {
            if (this.monitor != null) {
                this.monitor.collect();
                long cc = this.monitor.getProducerCount();
                if (cc > 0L) {
                    this.last_use = System.currentTimeMillis();
                }
            }
            stats.setHealthy(true);
        }
        catch (Throwable t) {
            this.doLog("evaluateService", new Object[]{"EXCEPTION::::" + this.serializeThrowable(t)});
            stats.setHealthy(false);
            this.monitor.setJmxFailure(t.getMessage());
        }
    }

    private String serializeThrowable(Throwable t) {
        String msg = "";
        if (t != null) {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream();
            PrintStream pstream = new PrintStream(bstream);
            t.printStackTrace(pstream);
            pstream.close();
            msg = bstream.toString();
        }
        return msg;
    }

    public long getLastUse() {
        return this.last_use;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceStatistics getStatistics() {
        String methodName = "getStatistics";
        this.doLog(methodName, new Object[]{"***********************************************"});
        ServiceStatistics statistics = new ServiceStatistics(false, false, "<NA>");
        String failure_reason = null;
        this.nodeIp = "N/A";
        this.pid = "N/A";
        this.evaluateService((IServiceStatistics)statistics);
        ExecutorService executor = null;
        Throwable excp = null;
        boolean gmfail = false;
        Future<Boolean> future = null;
        try {
            this.initJMS();
            TextMessage msg = this.producerSession.createTextMessage();
            msg.setStringProperty("MessageFrom", this.consumerDestination.getQueueName());
            msg.setStringProperty("ServerURI", this.brokerURI);
            msg.setIntProperty("MessageType", 3000);
            msg.setIntProperty("Command", 2001);
            msg.setJMSReplyTo((Destination)this.consumerDestination);
            msg.setText("");
            this.doLog(methodName, new Object[]{"Sending getMeta request to " + this.endpoint + " at " + this.brokerURI});
            this.producer.send((Message)msg);
            long startTime = System.currentTimeMillis();
            executor = Executors.newSingleThreadExecutor();
            future = executor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ActiveMQTextMessage serviceInfoReply = (ActiveMQTextMessage)UimaAsPing.this.consumer.receive();
                    UimaAsPing.this.nodeIp = serviceInfoReply.getStringProperty("ServerIP");
                    UimaAsPing.this.pid = serviceInfoReply.getStringProperty("ProcessPID");
                    UimaAsPing.this.consumer.receive();
                    return true;
                }
            });
            future.get(this.meta_timeout, TimeUnit.MILLISECONDS);
            future.cancel(true);
            long replyTime = System.currentTimeMillis() - startTime;
            statistics.setAlive(true);
            statistics.setHealthy(statistics.isHealthy());
            statistics.setInfo("Get-meta took " + replyTime + " msecs.");
            this.doLog(methodName, new Object[]{"Reply received in ", replyTime, " ms"});
            gmfail = false;
        }
        catch (ExecutionException e) {
            excp = e;
            gmfail = true;
            statistics.setHealthy(false);
            statistics.setAlive(false);
            statistics.setInfo("Ping error: " + e);
            this.doLog(methodName, new Object[]{null, "Error while awaiting getmeta reply from ", this.nodeIp, "PID", this.pid});
            if (future != null) {
                future.cancel(true);
            }
        }
        catch (InterruptedException e) {
            excp = e;
            gmfail = true;
            statistics.setHealthy(false);
            statistics.setAlive(false);
            statistics.setInfo("Ping error: " + e);
            this.doLog(methodName, new Object[]{null, "Thread interrupted while waiting for getmeta reply from ", this.nodeIp, "PID", this.pid});
            if (future != null) {
                future.cancel(true);
            }
        }
        catch (TimeoutException e) {
            excp = e;
            gmfail = true;
            statistics.setHealthy(false);
            statistics.setAlive(false);
            statistics.setInfo("Ping error: " + e);
            this.doLog(methodName, new Object[]{null, "Get-Meta timeout (" + this.meta_timeout + " ms) from ", this.nodeIp, "PID", this.pid});
            if (future != null) {
                future.cancel(true);
            }
        }
        catch (JMSException e) {
            excp = e;
            gmfail = true;
            statistics.setHealthy(false);
            statistics.setAlive(false);
            statistics.setInfo("Ping error: " + (Object)((Object)e));
        }
        finally {
            this.stop();
            if (executor != null) {
                executor.shutdownNow();
            }
        }
        if (gmfail || excp != null) {
            failure_reason = "Cannot issue getMeta to: " + this.endpoint + ":" + this.brokerURI;
            if (excp != null) {
                failure_reason = excp.getCause() == null ? failure_reason + ": " + excp.toString() : failure_reason + ": " + excp.getCause();
            }
            this.doLog(methodName, new Object[]{failure_reason});
        }
        if (this.monitor == null) {
            if (failure_reason != null) {
                statistics.setInfo(failure_reason);
            } else if (this.failover) {
                statistics.setInfo("(JMX statistics not available for failover protocol)");
            } else {
                statistics.setInfo("Ping to " + this.nodeIp + ": " + this.pid + " ok. (JMX disabled.)");
            }
        } else {
            this.monitor.setSource(this.nodeIp, this.pid, gmfail, failure_reason);
            statistics.setInfo(this.monitor.format());
        }
        return statistics;
    }
}

