/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.progress.jmx;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressListener;

public class LegacyJMXProgressSupport
implements ProgressListener {
    protected static final Pattern SESSION_FAILED_MATCHER = Pattern.compile("Repair session .* for range .* failed with error .*|Repair command .* failed with error .*");
    protected static final Pattern SESSION_SUCCESS_MATCHER = Pattern.compile("Repair session .* for range .* finished");
    private final AtomicLong notificationSerialNumber = new AtomicLong();
    private final ObjectName jmxObjectName;
    private final NotificationBroadcasterSupport broadcaster;

    public LegacyJMXProgressSupport(NotificationBroadcasterSupport broadcaster, ObjectName jmxObjectName) {
        this.broadcaster = broadcaster;
        this.jmxObjectName = jmxObjectName;
    }

    @Override
    public void progress(String tag, ProgressEvent event) {
        Optional<int[]> legacyUserData;
        if (tag.startsWith("repair:") && (legacyUserData = LegacyJMXProgressSupport.getLegacyUserdata(tag, event)).isPresent()) {
            Notification jmxNotification = new Notification("repair", (Object)this.jmxObjectName, this.notificationSerialNumber.incrementAndGet(), event.getMessage());
            jmxNotification.setUserData(legacyUserData.get());
            this.broadcaster.sendNotification(jmxNotification);
        }
    }

    protected static Optional<int[]> getLegacyUserdata(String tag, ProgressEvent event) {
        Optional<ActiveRepairService.Status> status = LegacyJMXProgressSupport.getStatus(event);
        if (status.isPresent()) {
            int[] result = new int[]{LegacyJMXProgressSupport.getCmd(tag), status.get().ordinal()};
            return Optional.of(result);
        }
        return Optional.empty();
    }

    protected static Optional<ActiveRepairService.Status> getStatus(ProgressEvent event) {
        switch (event.getType()) {
            case START: {
                return Optional.of(ActiveRepairService.Status.STARTED);
            }
            case COMPLETE: {
                return Optional.of(ActiveRepairService.Status.FINISHED);
            }
            case ERROR: 
            case PROGRESS: {
                if (SESSION_FAILED_MATCHER.matcher(event.getMessage()).matches()) {
                    return Optional.of(ActiveRepairService.Status.SESSION_FAILED);
                }
                if (!SESSION_SUCCESS_MATCHER.matcher(event.getMessage()).matches()) break;
                return Optional.of(ActiveRepairService.Status.SESSION_SUCCESS);
            }
        }
        return Optional.empty();
    }

    protected static int getCmd(String tag) {
        return Integer.parseInt(tag.split(":")[1]);
    }
}

