/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.sm;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.sm.ServiceDependency;

public class ServiceMap
extends ConcurrentHashMap<DuccId, ServiceDependency>
implements Serializable {
    public void addService(DuccId duccId, ServiceDependency services) {
        super.put(duccId, services);
    }

    public void removeService(DuccId duccId) {
        super.remove(duccId);
    }

    public synchronized void removeAll(Set<DuccId> ids) {
        for (DuccId o : ids) {
            super.remove(o);
        }
    }

    public synchronized String toPrint() {
        StringBuffer sb = new StringBuffer("Service Map\n");
        if (this.size() == 0) {
            sb.append("[empty]\n");
        } else {
            for (DuccId id : this.keySet()) {
                ServiceDependency svc = (ServiceDependency)this.get(id);
                sb.append("Job ");
                sb.append(id.toString());
                sb.append(" Service state ");
                sb.append(svc.getState().toString());
                Map<String, String> msgs = svc.getMessages();
                if (msgs != null) {
                    for (String s : msgs.keySet()) {
                        sb.append(" [");
                        sb.append(s);
                        sb.append(" : ");
                        sb.append(msgs.get(s));
                        sb.append("] ");
                    }
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

