/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common.history;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.uima.ducc.common.DuccEnvironmentHelper;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.Pair;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.IOHelper;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.common.history.DeserializerObjectInputStream;
import org.apache.uima.ducc.transport.event.common.history.IHistoryPersistenceManager;

public class HistoryPersistenceManager
implements IHistoryPersistenceManager {
    private DuccLogger logger = DuccService.getDuccLogger((String)HistoryPersistenceManager.class.getName());
    private String historyDirectory_jobs = IDuccEnv.DUCC_HISTORY_JOBS_DIR;
    private String historyDirectory_reservations = IDuccEnv.DUCC_HISTORY_RESERVATIONS_DIR;
    private String historyDirectory_services = IDuccEnv.DUCC_HISTORY_SERVICES_DIR;
    private String dwj = "dwj";
    private String dwr = "dwr";
    private String dws = "dws";

    HistoryPersistenceManager() {
        this.mkdirs();
    }

    @Override
    public boolean init(DuccLogger logger) {
        this.logger = logger;
        return true;
    }

    private void mkdirs() {
        IOHelper.mkdirs((String)this.historyDirectory_jobs);
        IOHelper.mkdirs((String)this.historyDirectory_reservations);
        IOHelper.mkdirs((String)this.historyDirectory_services);
    }

    private String normalize(String id) {
        String retVal = id;
        return retVal;
    }

    private ObjectInputStream getObjectInputStream(FileInputStream fis) throws SecurityException, IOException {
        ObjectInputStream retVal = null;
        retVal = DuccEnvironmentHelper.isTolerateSerialVersionUidMismatch() ? new DeserializerObjectInputStream(fis) : new ObjectInputStream(fis);
        return retVal;
    }

    @Override
    public void saveJob(IDuccWorkJob duccWorkJob) throws IOException {
        String id = this.normalize("" + duccWorkJob.getDuccId().getFriendly());
        String fileName = this.historyDirectory_jobs + File.separator + id + "." + this.dwj;
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        fos = new FileOutputStream(fileName);
        out = new ObjectOutputStream(fos);
        out.writeObject(duccWorkJob);
        out.close();
    }

    @Override
    public List<IDuccWorkJob> restoreJobs(long max) throws Exception {
        String methodName = "restoreJobs";
        ArrayList<Long> allJobs = new ArrayList<Long>();
        File folder = new File(this.historyDirectory_jobs);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                String name;
                if (!listOfFiles[i].isFile() || !(name = listOfFiles[i].getName()).endsWith("." + this.dwj)) continue;
                int ndx = name.indexOf(".");
                try {
                    allJobs.add(Long.parseLong(name.substring(0, ndx)));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.logger.warn(methodName, null, new Object[]{"Job file", name, ": cannot extract ducc id.  Not restored."});
                }
            }
        }
        max = Math.min((long)allJobs.size(), max);
        Collections.sort(allJobs);
        ArrayList<IDuccWorkJob> ret = new ArrayList<IDuccWorkJob>((int)max);
        for (int i = allJobs.size() - 1; i >= 0; --i) {
            ret.add(this.restoreJob((Long)allJobs.get(i)));
        }
        return ret;
    }

    @Override
    public IDuccWorkJob restoreJob(long duccid) throws Exception {
        String location = "jobRestore";
        IDuccWorkJob job = null;
        try {
            String fileName = "" + duccid + "." + this.dwj;
            this.logger.trace(location, new DuccId(duccid), new Object[]{fileName});
            FileInputStream fis = null;
            ObjectInputStream in = null;
            fis = new FileInputStream(this.historyDirectory_jobs + File.separator + fileName);
            in = this.getObjectInputStream(fis);
            job = (IDuccWorkJob)in.readObject();
            in.close();
        }
        catch (Exception e) {
            this.logger.error(location, new DuccId(duccid), (Throwable)e, new Object[0]);
        }
        return job;
    }

    @Override
    public void saveReservation(IDuccWorkReservation duccWorkReservation) throws Exception {
        String id = this.normalize("" + duccWorkReservation.getDuccId().getFriendly());
        String fileName = this.historyDirectory_reservations + File.separator + id + "." + this.dwr;
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        fos = new FileOutputStream(fileName);
        out = new ObjectOutputStream(fos);
        out.writeObject(duccWorkReservation);
        out.close();
    }

    @Override
    public IDuccWorkReservation restoreReservation(long duccid) throws Exception {
        String location = "reservationRestore";
        IDuccWorkReservation reservation = null;
        try {
            FileInputStream fis = null;
            ObjectInputStream in = null;
            String fileName = "" + duccid + "." + this.dwr;
            this.logger.trace(location, new DuccId(duccid), new Object[]{fileName});
            fis = new FileInputStream(this.historyDirectory_reservations + File.separator + fileName);
            in = this.getObjectInputStream(fis);
            reservation = (IDuccWorkReservation)in.readObject();
            in.close();
        }
        catch (Exception e) {
            this.logger.error(location, new DuccId(duccid), (Throwable)e, new Object[0]);
        }
        return reservation;
    }

    @Override
    public List<IDuccWorkReservation> restoreReservations(long max) throws Exception {
        String methodName = "restoreReservations";
        ArrayList<Long> allReservations = new ArrayList<Long>();
        File folder = new File(this.historyDirectory_reservations);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                String name;
                if (!listOfFiles[i].isFile() || !(name = listOfFiles[i].getName()).endsWith("." + this.dwr)) continue;
                int ndx = name.indexOf(".");
                try {
                    allReservations.add(Long.parseLong(name.substring(0, ndx)));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.logger.warn(methodName, null, new Object[]{"Reservation file", name, ": cannot extract ducc id.  Not restored."});
                }
            }
        }
        max = Math.min((long)allReservations.size(), max);
        Collections.sort(allReservations);
        ArrayList<IDuccWorkReservation> ret = new ArrayList<IDuccWorkReservation>((int)max);
        for (int i = allReservations.size() - 1; i >= 0; --i) {
            ret.add(this.restoreReservation((Long)allReservations.get(i)));
        }
        return ret;
    }

    @Override
    public void saveService(IDuccWorkService duccWorkService) throws Exception {
        String id = this.normalize("" + duccWorkService.getDuccId().getFriendly());
        String fileName = this.historyDirectory_services + File.separator + id + "." + this.dws;
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        fos = new FileOutputStream(fileName);
        out = new ObjectOutputStream(fos);
        out.writeObject(duccWorkService);
        out.close();
    }

    @Override
    public IDuccWorkService restoreService(long duccid) throws Exception {
        String location = "restoreService";
        IDuccWorkService service = null;
        try {
            FileInputStream fis = null;
            ObjectInputStream in = null;
            String fileName = "" + duccid + "." + this.dws;
            this.logger.trace(location, new DuccId(duccid), new Object[]{fileName});
            fis = new FileInputStream(this.historyDirectory_services + File.separator + fileName);
            in = this.getObjectInputStream(fis);
            service = (IDuccWorkService)in.readObject();
            in.close();
        }
        catch (Exception e) {
            this.logger.error(location, new DuccId(duccid), (Throwable)e, new Object[0]);
        }
        return service;
    }

    @Override
    public List<IDuccWorkService> restoreServices(long max) throws Exception {
        String methodName = "restoreServices";
        ArrayList<Long> allServices = new ArrayList<Long>();
        File folder = new File(this.historyDirectory_services);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                String name;
                if (!listOfFiles[i].isFile() || !(name = listOfFiles[i].getName()).endsWith("." + this.dws)) continue;
                int ndx = name.indexOf(".");
                try {
                    allServices.add(Long.parseLong(name.substring(0, ndx)));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.logger.warn(methodName, null, new Object[]{"Reservation file", name, ": cannot extract ducc id.  Not restored."});
                }
            }
        }
        max = Math.min((long)allServices.size(), max);
        Collections.sort(allServices);
        ArrayList<IDuccWorkService> ret = new ArrayList<IDuccWorkService>((int)max);
        for (int i = allServices.size() - 1; i >= 0; --i) {
            ret.add(this.restoreService((Long)allServices.get(i)));
        }
        return ret;
    }

    @Override
    public List<IDuccWorkService> restoreArbitraryProcesses(long max) throws Exception {
        return null;
    }

    public void serviceSave(IDuccWorkService duccWorkService) throws IOException {
        String id = this.normalize("" + duccWorkService.getDuccId().getFriendly());
        String fileName = this.historyDirectory_services + File.separator + id + "." + this.dws;
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        fos = new FileOutputStream(fileName);
        out = new ObjectOutputStream(fos);
        out.writeObject(duccWorkService);
        out.close();
    }

    public IDuccWorkService serviceRestore(String fileName) {
        return this.serviceRestore(fileName, Verbosity.SPEAK);
    }

    private IDuccWorkService serviceRestore(String fileName, Verbosity level) {
        String methodName = "serviceRestore";
        IDuccWorkService service = null;
        try {
            this.logger.trace(methodName, null, new Object[]{"restore:" + fileName});
            FileInputStream fis = null;
            ObjectInputStream in = null;
            fis = new FileInputStream(this.historyDirectory_services + File.separator + fileName);
            in = this.getObjectInputStream(fis);
            service = (IDuccWorkService)in.readObject();
            in.close();
        }
        catch (Exception e) {
            switch (level) {
                case QUIET: {
                    break;
                }
                case SPEAK: {
                    this.logger.warn(methodName, null, new Object[]{"unable to restore:" + fileName});
                }
            }
        }
        return service;
    }

    public ArrayList<String> serviceList() {
        ArrayList<String> retVal = new ArrayList<String>();
        File folder = new File(this.historyDirectory_services);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                String name;
                if (!listOfFiles[i].isFile() || !(name = listOfFiles[i].getName()).endsWith("." + this.dws)) continue;
                retVal.add(name);
            }
        }
        return retVal;
    }

    public ArrayList<IDuccWorkService> serviceRestore() throws IOException, ClassNotFoundException {
        ArrayList<IDuccWorkService> retVal = new ArrayList<IDuccWorkService>();
        ArrayList<String> serviceFileNames = this.serviceList();
        ListIterator<String> listIterator = serviceFileNames.listIterator();
        while (listIterator.hasNext()) {
            String fileName = listIterator.next();
            IDuccWorkService service = this.serviceRestore(fileName);
            if (service == null) continue;
            retVal.add(service);
        }
        return retVal;
    }

    public IDuccWorkService serviceRestore(DuccId duccId) {
        String fileName = duccId.getFriendly() + "." + this.dws;
        return this.serviceRestore(fileName, Verbosity.QUIET);
    }

    @Override
    public boolean checkpoint(DuccWorkMap m, Map<DuccId, DuccId> processToJob) throws Exception {
        return false;
    }

    @Override
    public Pair<DuccWorkMap, Map<DuccId, DuccId>> restore() throws Exception {
        return null;
    }

    private static int doJobs(HistoryPersistenceManager hpm) throws Exception {
        List<IDuccWorkJob> duccWorkJobs = hpm.restoreJobs(-1L);
        ListIterator<IDuccWorkJob> listIterator = duccWorkJobs.listIterator();
        int acc = 0;
        while (listIterator.hasNext()) {
            IDuccWorkJob duccWorkJob = listIterator.next();
            System.out.println(duccWorkJob.getId());
            ++acc;
        }
        return acc;
    }

    private static int doReservations(HistoryPersistenceManager hpm) throws Exception {
        List<IDuccWorkReservation> duccWorkReservations = hpm.restoreReservations(-1L);
        ListIterator<IDuccWorkReservation> listIterator = duccWorkReservations.listIterator();
        int acc = 0;
        while (listIterator.hasNext()) {
            IDuccWorkReservation duccWorkReservation = listIterator.next();
            System.out.println(duccWorkReservation.getId());
            ++acc;
        }
        return acc;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        String ducc_home = Utils.findDuccHome();
        if (ducc_home == null) {
            System.out.println("DUCC_HOME not set in environment");
            return;
        }
        if (ducc_home.trim().length() == 0) {
            System.out.println("DUCC_HOME not set in environment");
            return;
        }
        int reservations = 0;
        try {
            HistoryPersistenceManager hpm = new HistoryPersistenceManager();
            int jobs = HistoryPersistenceManager.doJobs(hpm);
            System.out.println("jobs: " + jobs);
            reservations = HistoryPersistenceManager.doReservations(hpm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("reservations: " + reservations);
    }

    private static enum Verbosity {
        QUIET,
        SPEAK;

    }
}

