/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.common;

import java.util.Date;
import java.util.TimeZone;
import org.apache.uima.ducc.common.utils.SynchronizedSimpleDateFormat;
import org.apache.uima.ducc.transport.event.common.IDuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.ITimeWindow;

public class TimeWindow
implements ITimeWindow {
    private static final long serialVersionUID = 1L;
    private String timeStart = null;
    private String timeEnd = null;

    @Override
    public String getStart() {
        return this.timeStart;
    }

    public String getStart(String time) {
        String retVal = this.timeStart;
        if (retVal == null) {
            retVal = time;
        }
        return retVal;
    }

    @Override
    public void setStart(String time) {
        this.timeStart = time;
    }

    @Override
    public long getStartLong() {
        long retVal = -1L;
        try {
            retVal = Long.parseLong(this.getStart());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public void setStartLong(long time) {
        this.setStart(String.valueOf(time));
    }

    @Override
    public String getEnd() {
        return this.timeEnd;
    }

    public String getEnd(String time) {
        String retVal = this.timeEnd;
        if (retVal == null) {
            retVal = time;
        }
        return retVal;
    }

    @Override
    public void setEnd(String time) {
        this.timeEnd = time;
    }

    @Override
    public long getEndLong() {
        long retVal = -1L;
        try {
            retVal = Long.parseLong(this.getEnd());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public void setEndLong(long time) {
        this.setEnd(String.valueOf(time));
    }

    @Override
    public String getDiff() {
        return "" + this.getElapsedMillis();
    }

    @Override
    public String getElapsed() {
        String elapsed = "";
        long elapsedTime = Long.valueOf(this.getDiff());
        SynchronizedSimpleDateFormat dateFormat = new SynchronizedSimpleDateFormat("HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        elapsed = dateFormat.format(new Date(elapsedTime));
        return elapsed;
    }

    @Override
    public String getElapsed(IDuccWorkJob job) {
        String retVal = null;
        if (this.isEstimated()) {
            long tmax;
            long t0;
            long current = System.currentTimeMillis();
            long elapsed = this.getElapsedMillis();
            IDuccStandardInfo stdInfo = job.getStandardInfo();
            long t1 = stdInfo.getDateOfCompletionMillis();
            if (t1 == 0L) {
                t1 = current;
            }
            if ((t0 = stdInfo.getDateOfSubmissionMillis()) == 0L) {
                t0 = current;
            }
            if (elapsed > (tmax = t1 - t0)) {
                elapsed = t1 - this.getStartLong();
            }
            SynchronizedSimpleDateFormat dateFormat = new SynchronizedSimpleDateFormat("HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            retVal = dateFormat.format(new Date(elapsed));
        } else {
            retVal = this.getElapsed();
        }
        return retVal;
    }

    @Override
    public long getElapsedMillis() {
        String t0 = this.getStart();
        String t1 = this.getEnd();
        String t = "" + System.currentTimeMillis();
        if (t0 == null) {
            t0 = t;
        }
        if (t1 == null) {
            t1 = t;
        }
        Long l1 = Long.valueOf(t1);
        Long l0 = Long.valueOf(t0);
        Long diff = l1 - l0;
        return diff;
    }

    @Override
    public boolean isEstimated() {
        boolean retVal = false;
        if (this.getStart() == null) {
            retVal = true;
        } else if (this.getEnd() == null) {
            retVal = true;
        }
        return retVal;
    }
}

