/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.configuration.jp;

import java.io.File;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.http.client.methods.HttpPost;
import org.apache.uima.ducc.common.IDuccUser;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.component.IJobProcessor;
import org.apache.uima.ducc.common.container.FlagsHelper;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.ps.net.iface.IMetaTaskTransaction;
import org.apache.uima.ducc.transport.configuration.jp.AgentSession;
import org.apache.uima.ducc.transport.configuration.jp.DuccHttpClient;
import org.apache.uima.ducc.transport.configuration.jp.HttpWorkerThread;
import org.apache.uima.ducc.transport.configuration.jp.JmxAEProcessInitMonitor;
import org.apache.uima.ducc.transport.configuration.jp.JobProcessConfiguration;
import org.apache.uima.ducc.transport.configuration.jp.UimaServiceThreadFactory;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public class JobProcessComponent
extends AbstractDuccComponent
implements IJobProcessor {
    private String jmxConnectString = "";
    private AgentSession agent = null;
    protected IProcessState.ProcessState currentState = IProcessState.ProcessState.Undefined;
    protected static DuccLogger logger;
    protected String saxonJarPath;
    protected String dd2SpringXslPath;
    protected String dd;
    private int timeout = 30000;
    private int threadSleepTime = 60000;
    private CountDownLatch workerThreadCount = null;
    private CountDownLatch threadReadyCount = null;
    private AtomicInteger maxFrameworkFailures = null;
    ScheduledThreadPoolExecutor executor = null;
    ExecutorService tpe = null;
    Lock stateLock = new ReentrantLock();
    private volatile boolean uimaASJob = false;
    Map<String, IMetaTaskTransaction> transactionMap = new ConcurrentHashMap<String, IMetaTaskTransaction>();
    static final Lock lock;
    private DuccHttpClient httpClient = null;
    private Object processorInstance = null;

    public JobProcessComponent(String componentName, CamelContext ctx, JobProcessConfiguration jpc) {
        super(componentName, ctx);
        this.jmxConnectString = super.getProcessJmxUrl();
    }

    public void setProcessor(Object pc, String[] args) {
        this.processorInstance = pc;
    }

    public void setState(IProcessState.ProcessState state) {
        this.setState(state, super.getProcessJmxUrl());
    }

    public void setState(IProcessState.ProcessState state, String message) {
        if (this.isInTerminalState()) {
            return;
        }
        try {
            this.stateLock.lock();
            if (message == null) {
                message = super.getProcessJmxUrl();
            }
            if (!state.name().equals(this.currentState.name())) {
                this.currentState = state.equals((Object)IProcessState.ProcessState.Stopping) && (this.currentState.equals((Object)IProcessState.ProcessState.Initializing) || this.currentState.equals((Object)IProcessState.ProcessState.Undefined) || this.currentState.equals((Object)IProcessState.ProcessState.Started) || this.currentState.equals((Object)IProcessState.ProcessState.Starting)) ? IProcessState.ProcessState.FailedInitialization : state;
                logger.info("setState", null, new Object[]{"Notifying Agent New State::::" + this.currentState.name()});
                if (this.agent != null) {
                    this.agent.notify(this.currentState, message);
                }
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void setThreadSleepTime(int sleepTime) {
        this.threadSleepTime = sleepTime;
    }

    public void setMaxFrameworkFailures(int limit) throws Exception {
        this.maxFrameworkFailures = new AtomicInteger(limit);
    }

    public int getThreadSleepTime() {
        return this.threadSleepTime;
    }

    protected void setDD(String dd) {
        this.dd = dd;
    }

    public void setDd2SpringXslPath(String dd2SpringXslPath) {
        this.dd2SpringXslPath = dd2SpringXslPath;
    }

    public void setSaxonJarPath(String saxonJarPath) {
        this.saxonJarPath = saxonJarPath;
    }

    protected void setAgentSession(AgentSession session) {
        this.agent = session;
    }

    public String getProcessJmxUrl() {
        return this.jmxConnectString;
    }

    public DuccLogger getLogger() {
        try {
            lock.lock();
            if (logger == null) {
                logger = new DuccLogger(JobProcessComponent.class);
            }
        }
        finally {
            lock.unlock();
        }
        return logger;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void resetInvestment(String key) throws Exception {
        if (this.httpClient != null && this.transactionMap.containsKey(key)) {
            IMetaTaskTransaction transaction = this.transactionMap.get(key);
            HttpPost postMethod = new HttpPost(this.httpClient.getJdUrl());
            transaction.getMetaTask().setUserSpaceTask(null);
            transaction.setType(IMetaTaskTransaction.Type.InvestmentReset);
            while (this.isRunning()) {
                try {
                    logger.info("resetInvestment", null, new Object[]{"User Requested Investment Reset - sending request to JD - WI:" + transaction.getMetaTask().getSystemKey() + " user key:" + key});
                    this.httpClient.execute(transaction, postMethod);
                    break;
                }
                catch (SocketTimeoutException e) {
                    logger.info("resetInvestment", null, new Object[]{"Timeout while waiting for Investment Reset response from JD - retrying - WI:" + transaction.getMetaTask().getSystemKey()});
                }
                catch (Exception e) {
                    logger.info("resetInvestment", null, new Object[]{"Error while trying send Investment Reset request to JD. Returning to the caller (no retries) WI:" + transaction.getMetaTask().getSystemKey()});
                    logger.info("resetInvestment", null, (Throwable)e, new Object[0]);
                    throw new RuntimeException("Unable to deliver Investment Reset request to JD due to " + e.getCause().getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(DuccService service, String[] args) throws Exception {
        super.start(service, args);
        try {
            if (args == null || args.length == 0 || args[0] == null || args[0].trim().length() == 0) {
                logger.warn("start", null, new Object[]{"Missing Deployment Descriptor - the JP Requires argument. Add DD for UIMA-AS job or AE descriptor for UIMA jobs"});
                throw new RuntimeException("Missing Deployment Descriptor - the JP Requires argument. Add DD for UIMA-AS job or AE descriptor for UIMA jobs");
            }
            String jpThreadCount = System.getProperty(FlagsHelper.Name.JpThreadCount.pname());
            Method m = ((Object)((Object)this)).getClass().getDeclaredMethod("resetInvestment", String.class);
            service.registerInvestmentResetCallback((Object)this, m);
            String processJmxUrl = super.getProcessJmxUrl();
            logger.info("start", null, new Object[]{"-Dducc.deploy.JpUniqueId=" + System.getProperty(IDuccUser.DashD.DUCC_ID_PROCESS_UNIQUE.value()) + " Environment Var:DUCC_PROCESS_UNIQUEID=" + System.getProperty(IDuccUser.EnvironmentVariable.DUCC_PROCESS_UNIQUEID.value())});
            this.agent.notify(IProcessState.ProcessState.Initializing, processJmxUrl);
            try {
                String[] jpArgs;
                this.executor = new ScheduledThreadPoolExecutor(1);
                this.executor.prestartAllCoreThreads();
                JmxAEProcessInitMonitor monitor = new JmxAEProcessInitMonitor(this.agent);
                this.executor.scheduleAtFixedRate(monitor, 20L, 30L, TimeUnit.SECONDS);
                String jobType = System.getProperty(FlagsHelper.Name.JpType.pname());
                if ("uima-as".equals(jobType)) {
                    this.uimaASJob = true;
                    if (!new File(args[0]).canRead()) {
                        String userdd = FlagsHelper.getInstance().getJpDd();
                        this.getLogger().info("start", null, new Object[]{"Replacing inaccessible DD " + args[0] + " by the user specified " + userdd});
                        args[0] = userdd;
                    }
                    jpArgs = new String[]{"-dd", args[0], "-saxonURL", this.saxonJarPath, "-xslt", this.dd2SpringXslPath, "-t", jpThreadCount};
                } else if ("uima".equals(jobType)) {
                    jpArgs = new String[]{"-aed", args[0], "-t", jpThreadCount};
                } else if ("user".equals(jobType)) {
                    jpArgs = args;
                } else {
                    throw new RuntimeException("Unsupported JP deployment mode. Check a value provided for -D" + FlagsHelper.Name.JpType.pname() + ". Supported modes: [uima-as|uima|user]");
                }
                Properties props = new Properties();
                Method initMethod = this.processorInstance.getClass().getSuperclass().getDeclaredMethod("initialize", Properties.class, String[].class);
                int scaleout = (Integer)initMethod.invoke(this.processorInstance, props, jpArgs);
                this.getLogger().info("start", null, new Object[]{"Ducc JP JobType=" + jobType});
                this.httpClient = new DuccHttpClient(this);
                String jdURL = "";
                try {
                    jdURL = System.getProperty(FlagsHelper.Name.JdURL.pname());
                    this.httpClient.initialize(jdURL);
                    logger.info("start", null, new Object[]{"The JP Connected To JD Using URL " + this.httpClient.getJdUrl()});
                }
                catch (Exception ee) {
                    if (ee.getCause() != null && ee instanceof ConnectException) {
                        logger.error("start", null, new Object[]{"JP Process Unable To Connect to the JD Using Provided URL:" + jdURL + " Unable to Continue - Shutting Down JP"});
                    }
                    throw ee;
                }
                this.threadReadyCount = new CountDownLatch(scaleout);
                UimaServiceThreadFactory tf = new UimaServiceThreadFactory(Thread.currentThread().getThreadGroup());
                this.workerThreadCount = new CountDownLatch(scaleout);
                this.tpe = Executors.newFixedThreadPool(scaleout, tf);
                this.getLogger().info("start", null, new Object[]{"Starting " + scaleout + " Process Threads - JMX Connect String:" + processJmxUrl});
                Future[] threadHandles = new Future[scaleout];
                for (int j = 0; j < scaleout; ++j) {
                    threadHandles[j] = this.tpe.submit(new HttpWorkerThread(this, this.httpClient, this.processorInstance, this.workerThreadCount, this.threadReadyCount, this.transactionMap, this.maxFrameworkFailures));
                }
                this.threadReadyCount.await();
                if (!this.isInTerminalState()) {
                    this.setState(IProcessState.ProcessState.Running, processJmxUrl);
                    try {
                        monitor.updateAgentWhenRunning();
                        this.executor.shutdown();
                    }
                    catch (Exception ee) {
                        logger.error("start", null, (Throwable)ee, new Object[0]);
                    }
                }
                for (Future future : threadHandles) {
                    future.get();
                }
            }
            catch (Exception ee) {
                logger.error("start", null, (Throwable)ee, new Object[0]);
                this.getLogger().info("start", null, new Object[]{">>> Failed to Deploy UIMA Service. Check UIMA Log for Details"});
                this.setState(IProcessState.ProcessState.FailedInitialization);
            }
            finally {
                if (this.executor != null) {
                    this.executor.shutdownNow();
                }
                if (this.tpe != null) {
                    this.tpe.shutdown();
                    this.tpe.awaitTermination(0L, TimeUnit.MILLISECONDS);
                }
                if (this.workerThreadCount != null) {
                    this.workerThreadCount.await();
                    Method useThreadAffinityMethod = this.processorInstance.getClass().getDeclaredMethod("useThreadAffinity", new Class[0]);
                    boolean useThreadAffinity = (Boolean)useThreadAffinityMethod.invoke(this.processorInstance, new Object[0]);
                    if (!useThreadAffinity) {
                        Method stopMethod = this.processorInstance.getClass().getSuperclass().getDeclaredMethod("stop", new Class[0]);
                        stopMethod.invoke(this.processorInstance, new Object[0]);
                    }
                }
                this.stop();
            }
        }
        catch (Exception e) {
            this.setState(IProcessState.ProcessState.FailedInitialization);
            logger.error("start", null, (Throwable)e, new Object[0]);
            this.stop();
        }
    }

    public boolean isRunning() {
        this.stateLock.lock();
        try {
            boolean bl = this.currentState.equals((Object)IProcessState.ProcessState.Running);
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public boolean isUimaASJob() {
        return this.uimaASJob;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isInTerminalState() {
        this.stateLock.lock();
        try {
            switch (this.currentState) {
                case Stopping: 
                case Stopped: 
                case FailedInitialization: 
                case Failed: 
                case InitializationTimeout: 
                case Killed: {
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void stop() {
        this.setState(IProcessState.ProcessState.Stopping);
        if (super.isStopping()) {
            return;
        }
        try {
            if (this.workerThreadCount != null) {
                this.workerThreadCount.await();
            }
            logger.info("stop", null, new Object[]{"... JobProcessComponent - All Worker Threads Exited run()"});
            if (this.executor != null) {
                this.executor.shutdownNow();
            }
            if (this.tpe != null) {
                this.tpe.shutdown();
                this.tpe.awaitTermination(0L, TimeUnit.MILLISECONDS);
            }
            if (this.agent != null) {
                this.agent.stop();
            }
            if (this.httpClient != null) {
                this.httpClient.stop();
            }
        }
        catch (Exception e) {
            logger.error("stop", null, (Throwable)e, new Object[0]);
        }
        finally {
            try {
                super.stop();
            }
            catch (Exception exception) {}
        }
    }

    static {
        lock = new ReentrantLock();
    }
}

