/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.cmdline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.cmdline.ICommandLine;

public abstract class ACommandLine
implements ICommandLine {
    private static final long serialVersionUID = 1L;
    protected String executable;
    protected List<String> args = new ArrayList<String>();
    protected String workingDirectory;
    protected String logDirectory;
    protected Map<String, String> environment = new HashMap<String, String>();

    public ACommandLine(String executable) {
        this.executable = executable;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    @Override
    public void addArgument(String arg) {
        this.args.add(Utils.resolvePlaceholderIfExists((String)arg, (Properties)System.getProperties()));
    }

    @Override
    public List<String> getArguments() {
        return this.args;
    }

    public void addEnvVar(String key, String value) {
        this.environment.put(key, Utils.resolvePlaceholderIfExists((String)value, (Properties)System.getProperties()));
    }

    public String getEnvVar(String key) {
        return this.environment.get(key);
    }

    public void addEnvironment(Map<String, String> env) {
        this.environment.putAll(env);
    }

    public Map<String, String> getEnvironment() {
        String osArch = System.getProperty("os.arch");
        for (Map.Entry<String, String> ent : this.environment.entrySet()) {
            ent.setValue(ent.getValue().replace("${DUCC_OS_ARCH}", osArch));
        }
        return this.environment;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setLogDirectory(String logDirectory) {
        this.logDirectory = logDirectory;
    }

    @Override
    public String getLogDirectory() {
        return this.logDirectory;
    }

    protected <A> A[] concatAllArrays(A[] first, A[] ... next) {
        int totalLength = first.length;
        for (A[] array : next) {
            totalLength += array.length;
        }
        A[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (A[] array : next) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.args == null ? 0 : this.args.hashCode());
        result = 31 * result + (this.environment == null ? 0 : this.environment.hashCode());
        result = 31 * result + (this.executable == null ? 0 : this.executable.hashCode());
        result = 31 * result + (this.workingDirectory == null ? 0 : this.workingDirectory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ACommandLine other = (ACommandLine)obj;
        if (this.args == null ? other.args != null : !this.args.equals(other.args)) {
            return false;
        }
        if (this.environment == null ? other.environment != null : !this.environment.equals(other.environment)) {
            return false;
        }
        if (this.executable == null ? other.executable != null : !this.executable.equals(other.executable)) {
            return false;
        }
        return !(this.workingDirectory == null ? other.workingDirectory != null : !this.workingDirectory.equals(other.workingDirectory));
    }

    @Override
    public void addOption(String opt) {
    }

    @Override
    public List<String> getOptions() {
        return null;
    }
}

