/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.hazelcast.session;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.nio.serialization.Serializer;
import java.io.IOException;
import org.eclipse.jetty.hazelcast.session.HazelcastSessionDataStore;
import org.eclipse.jetty.hazelcast.session.SessionDataSerializer;
import org.eclipse.jetty.server.session.AbstractSessionDataStoreFactory;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionDataStore;
import org.eclipse.jetty.server.session.SessionDataStoreFactory;
import org.eclipse.jetty.server.session.SessionHandler;

public class HazelcastSessionDataStoreFactory
extends AbstractSessionDataStoreFactory
implements SessionDataStoreFactory {
    private String hazelcastInstanceName = "JETTY_DISTRIBUTED_SESSION_INSTANCE";
    private boolean onlyClient;
    private String configurationLocation;
    private String mapName = "jetty-distributed-session-map";
    private HazelcastInstance hazelcastInstance;
    private MapConfig mapConfig;

    public SessionDataStore getSessionDataStore(SessionHandler handler) throws Exception {
        HazelcastSessionDataStore hazelcastSessionDataStore = new HazelcastSessionDataStore();
        if (this.hazelcastInstance == null) {
            try {
                if (this.onlyClient) {
                    if (this.configurationLocation == null) {
                        ClientConfig config = new ClientConfig();
                        SerializerConfig sc = new SerializerConfig().setImplementation((Serializer)new SessionDataSerializer()).setTypeClass(SessionData.class);
                        config.getSerializationConfig().addSerializerConfig(sc);
                        this.hazelcastInstance = HazelcastClient.newHazelcastClient((ClientConfig)config);
                    } else {
                        this.hazelcastInstance = HazelcastClient.newHazelcastClient((ClientConfig)new XmlClientConfigBuilder(this.configurationLocation).build());
                    }
                } else {
                    Config config;
                    if (this.configurationLocation == null) {
                        SerializerConfig sc = new SerializerConfig().setImplementation((Serializer)new SessionDataSerializer()).setTypeClass(SessionData.class);
                        config = new Config();
                        config.getSerializationConfig().addSerializerConfig(sc);
                        if (this.mapConfig == null) {
                            this.mapConfig = new MapConfig();
                            this.mapConfig.setName(this.mapName);
                        } else {
                            this.mapName = this.mapConfig.getName();
                        }
                        config.addMapConfig(this.mapConfig);
                    } else {
                        config = new XmlConfigBuilder(this.configurationLocation).build();
                    }
                    config.setInstanceName(this.hazelcastInstanceName);
                    this.hazelcastInstance = Hazelcast.getOrCreateHazelcastInstance((Config)config);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        hazelcastSessionDataStore.setSessionDataMap((IMap<String, SessionData>)this.hazelcastInstance.getMap(this.mapName));
        hazelcastSessionDataStore.setGracePeriodSec(this.getGracePeriodSec());
        hazelcastSessionDataStore.setSavePeriodSec(this.getSavePeriodSec());
        return hazelcastSessionDataStore;
    }

    public boolean isOnlyClient() {
        return this.onlyClient;
    }

    public void setOnlyClient(boolean onlyClient) {
        this.onlyClient = onlyClient;
    }

    public String getConfigurationLocation() {
        return this.configurationLocation;
    }

    public void setConfigurationLocation(String configurationLocation) {
        this.configurationLocation = configurationLocation;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public void setMapConfig(MapConfig mapConfig) {
        this.mapConfig = mapConfig;
    }

    public String getHazelcastInstanceName() {
        return this.hazelcastInstanceName;
    }

    public void setHazelcastInstanceName(String hazelcastInstanceName) {
        this.hazelcastInstanceName = hazelcastInstanceName;
    }
}

