/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server.nodeviz;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeConfiguration;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.SizeBytes;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.common.utils.Version;
import org.apache.uima.ducc.transport.event.OrchestratorStateDuccEvent;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkExecutable;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.ws.DuccMachinesData;
import org.apache.uima.ducc.ws.IListenerOrchestrator;
import org.apache.uima.ducc.ws.MachineInfo;
import org.apache.uima.ducc.ws.server.DuccListeners;
import org.apache.uima.ducc.ws.server.nodeviz.Markup;
import org.apache.uima.ducc.ws.server.nodeviz.VisualizedHost;
import org.apache.uima.ducc.ws.types.NodeId;

public class NodeViz
implements IListenerOrchestrator {
    private static DuccLogger logger = DuccLogger.getLogger(NodeViz.class);
    private DuccMachinesData machineData;
    private String visualization;
    private long update_interval = 60000L;
    static int default_quantum = 4;
    private String version = "1.1.0";
    static String wshost = "";
    static String wsport = "42133";
    static boolean strip_domain = true;

    public NodeViz() {
        String methodName = "NodeViz";
        this.update_interval = SystemPropertyResolver.getLongProperty((String)"ducc.viz.update.interval", (long)this.update_interval);
        default_quantum = SystemPropertyResolver.getIntProperty((String)"ducc.rm.share.quantum", (int)default_quantum);
        wshost = SystemPropertyResolver.getStringProperty((String)"ducc.ws.node", (String)System.getProperty("ducc.head"));
        wsport = SystemPropertyResolver.getStringProperty((String)"ducc.ws.port", (String)wsport);
        strip_domain = SystemPropertyResolver.getBooleanProperty((String)"ducc.ws.visualization.strip.domain", (boolean)true);
        logger.info(methodName, null, new Object[]{"------------------------------------------------------------------------------------"});
        logger.info(methodName, null, new Object[]{"Node Visualization starting:"});
        logger.info(methodName, null, new Object[]{"    DUCC home               : ", System.getProperty("DUCC_HOME")});
        logger.info(methodName, null, new Object[]{"    ActiveMQ URL            : ", System.getProperty("ducc.broker.url")});
        logger.info(methodName, null, new Object[]{"Default Quantum             : ", default_quantum});
        logger.info(methodName, null, new Object[]{"Viz update Interval         : ", this.update_interval});
        logger.info(methodName, null, new Object[]{"Web Server Host             : ", wshost});
        logger.info(methodName, null, new Object[]{"Web Server Port             : ", wsport});
        logger.info(methodName, null, new Object[]{"Strip Domains               : ", strip_domain});
        logger.info(methodName, null, new Object[]{""});
        logger.info(methodName, null, new Object[]{"    JVM                     : ", System.getProperty("java.vendor") + " " + System.getProperty("java.version")});
        logger.info(methodName, null, new Object[]{"    JAVA_HOME               : ", System.getProperty("java.home")});
        logger.info(methodName, null, new Object[]{"    JVM Path                : ", System.getProperty("ducc.jvm")});
        logger.info(methodName, null, new Object[]{"    JMX URL                 : ", System.getProperty("ducc.jmx.url")});
        logger.info(methodName, null, new Object[]{""});
        logger.info(methodName, null, new Object[]{"    OS Architecture         : ", System.getProperty("os.arch")});
        logger.info(methodName, null, new Object[]{""});
        logger.info(methodName, null, new Object[]{"    DUCC Version            : ", Version.version()});
        logger.info(methodName, null, new Object[]{"    Vizualization Version   : ", this.version});
        logger.info(methodName, null, new Object[]{"------------------------------------------------------------------------------------"});
        DuccListeners.getInstance().register(this);
        this.machineData = DuccMachinesData.getInstance();
        this.visualization = "<html><p>Waiting for node updates ...</p></html>";
    }

    public String getVisualization() {
        String methodName = "getVisualization";
        logger.debug(methodName, null, new Object[]{"Request for visualization"});
        return this.visualization;
    }

    public void generateVisualization(OrchestratorStateDuccEvent ev) {
        String methodName = "generateVisualization";
        HashMap<String, VisualizedHost> hosts = new HashMap<String, VisualizedHost>();
        DuccMachinesData machinesData = DuccMachinesData.getInstance();
        IDuccWorkMap jobmap = ev.getWorkMap();
        int job_gb = 0;
        int service_gb = 0;
        int pop_gb = 0;
        int reservation_gb = 0;
        String class_definitions = SystemPropertyResolver.getStringProperty((String)"ducc.rm.class.definitions", (String)"scheduler.classes");
        String user_registry = SystemPropertyResolver.getStringProperty((String)"ducc.rm.user.registry", (String)"ducc.users");
        class_definitions = System.getProperty("DUCC_HOME") + "/resources/" + class_definitions;
        NodeConfiguration nc = new NodeConfiguration(class_definitions, null, user_registry, logger);
        try {
            nc.readConfiguration();
        }
        catch (Exception e) {
            logger.error(methodName, null, new Object[]{"Cannot read node configuration.  Some information may not be quite right."});
        }
        block13: for (Object o : jobmap.values()) {
            IDuccWork iDuccWork = (IDuccWork)o;
            IDuccTypes.DuccType type = iDuccWork.getDuccType();
            String service_endpoint = null;
            String service_id = null;
            if (type == IDuccTypes.DuccType.Service) {
                IDuccWorkService dws = (IDuccWorkService)iDuccWork;
                if (dws.getServiceDeploymentType() == IDuccWorkService.ServiceDeploymentType.other) {
                    type = IDuccTypes.DuccType.Pop;
                } else {
                    service_endpoint = dws.getServiceEndpoint();
                    service_id = dws.getServiceId();
                }
            }
            if (!iDuccWork.isSchedulable()) {
                logger.debug(methodName, iDuccWork.getDuccId(), new Object[]{"Ignoring unschedulable work:", iDuccWork.getDuccType(), ":", iDuccWork.getStateObject()});
                continue;
            }
            IDuccStandardInfo si = iDuccWork.getStandardInfo();
            IDuccSchedulingInfo sti = iDuccWork.getSchedulingInfo();
            String user = si.getUser();
            String duccid = service_id == null ? Long.toString(iDuccWork.getDuccId().getFriendly()) : service_id;
            int jobmem = (int)(sti.getMemorySizeAllocatedInBytes() / SizeBytes.GB);
            String sclass = sti.getSchedulingClass();
            int quantum = default_quantum;
            try {
                quantum = nc.getQuantumForClass(sclass);
            }
            catch (Exception e) {
                logger.warn(methodName, null, new Object[]{"Cannot find scheduling class or quantum for " + sclass + ". Using default quantum of " + default_quantum});
            }
            int qshares = jobmem / quantum;
            if (jobmem % quantum != 0) {
                ++qshares;
            }
            switch (type) {
                case Job: 
                case Pop: 
                case Service: {
                    IDuccWorkExecutable de = (IDuccWorkExecutable)iDuccWork;
                    IDuccProcessMap pm = de.getProcessMap();
                    logger.debug(methodName, iDuccWork.getDuccId(), new Object[]{"Receive:", type, iDuccWork.getStateObject(), "processes[", pm.size() + "]"});
                    for (IDuccProcess proc : pm.values()) {
                        String pid = proc.getPID();
                        IProcessState.ProcessState state = proc.getProcessState();
                        Node n = proc.getNode();
                        logger.debug(methodName, iDuccWork.getDuccId(), new Object[]{n == null ? "N/A" : n.getNodeIdentity().getCanonicalName(), "Process[", pid, "] state [", state, "] is complete[", proc.isComplete(), "]"});
                        if (proc.isComplete()) continue;
                        switch (type) {
                            case Job: {
                                job_gb += jobmem;
                                break;
                            }
                            case Pop: {
                                pop_gb += jobmem;
                                break;
                            }
                            case Service: {
                                service_gb += jobmem;
                                break;
                            }
                        }
                        NodeIdentity ni = n.getNodeIdentity();
                        NodeId nodeId = new NodeId(ni.getCanonicalName());
                        MachineInfo mi = machinesData.getMachineInfoForNodeid(nodeId);
                        if (mi != null) {
                            String key = NodeViz.strip(n.getNodeIdentity().getCanonicalName());
                            VisualizedHost vh = (VisualizedHost)hosts.get(key);
                            if (vh == null) {
                                vh = new VisualizedHost(mi, quantum);
                                hosts.put(key, vh);
                            }
                            vh.addWork(type, user, duccid, jobmem, qshares, service_endpoint);
                            continue;
                        }
                        String message = nodeId.getShortName() + " not found?";
                        logger.debug(methodName, iDuccWork.getDuccId(), new Object[]{message});
                    }
                    continue block13;
                }
                case Reservation: {
                    IDuccWorkExecutable de = (IDuccWorkReservation)iDuccWork;
                    IDuccReservationMap rm = de.getReservationMap();
                    logger.debug(methodName, iDuccWork.getDuccId(), new Object[]{"Receive:", type, iDuccWork.getStateObject(), "processes[", rm.size(), "] Completed:", iDuccWork.isCompleted()});
                    reservation_gb += jobmem;
                    for (IDuccReservation r : rm.values()) {
                        Node n = r.getNode();
                        if (n == null) {
                            logger.debug(methodName, iDuccWork.getDuccId(), new Object[]{"Node [N/A] mem[N/A"});
                            continue;
                        }
                        if (n.getNodeIdentity() == null) {
                            logger.debug(methodName, iDuccWork.getDuccId(), new Object[]{"NodeIdentity [N/A] mem[N/A"});
                            continue;
                        }
                        NodeIdentity ni = n.getNodeIdentity();
                        NodeId nodeId = new NodeId(ni.getCanonicalName());
                        MachineInfo mi = machinesData.getMachineInfoForNodeid(nodeId);
                        if (mi != null) {
                            String key = NodeViz.strip(n.getNodeIdentity().getCanonicalName());
                            VisualizedHost vh = (VisualizedHost)hosts.get(key);
                            if (vh == null) {
                                vh = new VisualizedHost(mi, quantum);
                                hosts.put(key, vh);
                            }
                            vh.addWork(type, user, duccid, jobmem, qshares, null);
                            continue;
                        }
                        String message = nodeId.getShortName() + " not found?";
                        logger.debug(methodName, iDuccWork.getDuccId(), new Object[]{message});
                    }
                    continue block13;
                }
                default: {
                    logger.warn(methodName, iDuccWork.getDuccId(), new Object[]{"Received work of type ?", iDuccWork.getDuccType()});
                }
            }
        }
        logger.debug(methodName, null, new Object[]{"Generateing visualizaiton"});
        Map<MachineInfo, NodeId> m = this.machineData.getMachines();
        for (Map.Entry entry : m.entrySet()) {
            String key;
            MachineInfo mi = (MachineInfo)entry.getKey();
            if (mi == null) continue;
            VisualizedHost[] s = mi.getName();
            if (!mi.getStatus().equals("up") || hosts.containsKey(key = NodeViz.strip((String)s))) continue;
            VisualizedHost vh = new VisualizedHost(mi, nc.getQuantumForNode((String)s));
            hosts.put(key, vh);
        }
        int total_gb = 0;
        Markup markup = new Markup();
        VisualizedHost[] sorted = hosts.values().toArray(new VisualizedHost[hosts.size()]);
        Arrays.sort(sorted, new HostSorter());
        for (VisualizedHost vh : sorted) {
            vh.toSvg(markup);
            total_gb += vh.countRam();
        }
        String page = markup.close();
        int unoccupied_gb = total_gb - (job_gb + pop_gb + service_gb + reservation_gb);
        this.visualization = "<html><div id=\"viz-header\" style=\"text-align:center\">Sort By <i onclick=\"ducc_viz_node_sorter('size')\" id=\"ducc-viz-sort-size\" style=\"color:red\">Size </i><i onclick=\"ducc_viz_node_sorter('name')\" id=\"ducc-viz-sort-name\"\">Name</i></br><b>Memory Available:</b> " + total_gb + "GB, <b>In use: </b><b><i>Jobs:</i></b> " + job_gb + "GB, <b><i>Services:</i></b> " + service_gb + "GB, <b><i>Managed Reservations:</i></b> " + pop_gb + "GB, <b><i>Reservations:</i></b> " + reservation_gb + "GB, <b><i>Unoccupied:</i></b> " + unoccupied_gb + "GB</div><br><div id=\"nodelist\" style=\"background-color:eeeeee;padding:3\">" + page + "</div><script>ducc_viz_onreload();</script></html>";
        hosts = null;
    }

    static String strip(String n) {
        int ndx;
        if (strip_domain && (ndx = n.indexOf(".")) >= 0) {
            n = n.substring(0, ndx);
        }
        return n;
    }

    @Override
    public void update(OrchestratorStateDuccEvent ev) {
        String methodName = "update";
        logger.debug(methodName, null, new Object[]{"Received Orchestrator Event"});
        this.generateVisualization(ev);
    }

    private static class HostSorter
    implements Comparator<VisualizedHost> {
        private HostSorter() {
        }

        @Override
        public int compare(VisualizedHost h1, VisualizedHost h2) {
            if (h1 == h2) {
                return 0;
            }
            if (h1.equals(h2)) {
                return 0;
            }
            if (h2.mem_reserve == h1.mem_reserve) {
                return h1.name.compareTo(h2.name);
            }
            return h2.mem_reserve - h1.mem_reserve;
        }
    }
}

