/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.ducc.common.CancelReasons;
import org.apache.uima.ducc.common.NodeConfiguration;
import org.apache.uima.ducc.common.SizeBytes;
import org.apache.uima.ducc.common.boot.DuccDaemonRuntimeProperties;
import org.apache.uima.ducc.common.head.IDuccHead;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.jd.files.IWorkItemState;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceMetricsSummaryItem;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceMetricsSummaryMap;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceSummary;
import org.apache.uima.ducc.common.jd.files.perf.UimaStatistic;
import org.apache.uima.ducc.common.system.SystemState;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesHelper;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.DuccSchedulerClasses;
import org.apache.uima.ducc.common.utils.IDuccLoggerComponents;
import org.apache.uima.ducc.common.utils.InetHelper;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.Version;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.authentication.DuccWebAdministrators;
import org.apache.uima.ducc.transport.Constants;
import org.apache.uima.ducc.transport.agent.IUimaPipelineAEComponent;
import org.apache.uima.ducc.transport.event.ProcessInfo;
import org.apache.uima.ducc.transport.event.cli.SpecificationProperties;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.ws.DuccDaemonsData;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.DuccDataHelper;
import org.apache.uima.ducc.ws.DuccHead;
import org.apache.uima.ducc.ws.DuccMachinesData;
import org.apache.uima.ducc.ws.MachineInfo;
import org.apache.uima.ducc.ws.authentication.DuccAsUser;
import org.apache.uima.ducc.ws.authentication.DuccAuthenticator;
import org.apache.uima.ducc.ws.helper.BrokerHelper;
import org.apache.uima.ducc.ws.helper.DatabaseHelper;
import org.apache.uima.ducc.ws.helper.DiagnosticsHelper;
import org.apache.uima.ducc.ws.registry.IServicesRegistry;
import org.apache.uima.ducc.ws.registry.ServiceInterpreter;
import org.apache.uima.ducc.ws.registry.ServicesRegistry;
import org.apache.uima.ducc.ws.registry.ServicesRegistryMapPayload;
import org.apache.uima.ducc.ws.registry.sort.IServiceAdapter;
import org.apache.uima.ducc.ws.registry.sort.ServicesSortCache;
import org.apache.uima.ducc.ws.server.AlienTextFile;
import org.apache.uima.ducc.ws.server.DuccAbstractHandler;
import org.apache.uima.ducc.ws.server.DuccCookies;
import org.apache.uima.ducc.ws.server.DuccFile;
import org.apache.uima.ducc.ws.server.DuccHandlerUtils;
import org.apache.uima.ducc.ws.server.DuccWebProperties;
import org.apache.uima.ducc.ws.server.DuccWebServer;
import org.apache.uima.ducc.ws.server.DuccWebServerHelper;
import org.apache.uima.ducc.ws.server.DuccWebSessionManager;
import org.apache.uima.ducc.ws.server.DuccWebUtil;
import org.apache.uima.ducc.ws.server.Helper;
import org.apache.uima.ducc.ws.server.HelperSpecifications;
import org.apache.uima.ducc.ws.server.IWebMonitor;
import org.apache.uima.ducc.ws.sort.JobDetailsProcesses;
import org.apache.uima.ducc.ws.types.NodeId;
import org.apache.uima.ducc.ws.utils.FormatHelper;
import org.apache.uima.ducc.ws.utils.HandlersHelper;
import org.apache.uima.ducc.ws.utils.alien.AlienWorkItemStateReader;
import org.apache.uima.ducc.ws.utils.alien.EffectiveUser;
import org.apache.uima.ducc.ws.utils.alien.FileInfo;
import org.apache.uima.ducc.ws.utils.alien.FileInfoKey;
import org.apache.uima.ducc.ws.utils.alien.OsProxy;
import org.eclipse.jetty.server.Request;

public class DuccHandler
extends DuccAbstractHandler {
    private static String component = IDuccLoggerComponents.abbrv_webServer;
    private static DuccLogger duccLogger = DuccLogger.getLogger(DuccHandler.class);
    private static Messages messages = Messages.getInstance();
    private static DuccId jobid = null;
    private static IDuccHead dh = DuccHead.getInstance();
    private final String[] n = new String[]{"classpath", "service_ping_classpath", "process_executable_args", "process_jvm_args", "environment"};
    private final Set<String> hideableKeys = new HashSet<String>(Arrays.asList(this.n));
    private HelperSpecifications helperSpecifications = HelperSpecifications.getInstance();
    private DuccAuthenticator duccAuthenticator = DuccAuthenticator.getInstance();
    private String duccVersion = "/ducc-servlet/version";
    private String duccHome = "/ducc-servlet/home";
    private String duccHostname = "/ducc-servlet/hostname";
    private String duccLoginLink = "/ducc-servlet/login-link";
    private String duccLogoutLink = "/ducc-servlet/logout-link";
    private String duccAuthenticationStatus = "/ducc-servlet/authentication-status";
    private String duccAuthenticatorVersion = "/ducc-servlet/authenticator-version";
    private String duccAuthenticatorNotes = "/ducc-servlet/authenticator-notes";
    private String duccAuthenticatorPasswordChecked = "/ducc-servlet/authenticator-password-checked";
    private String duccFileContents = "/ducc-servlet/file-contents";
    private String duccJobIdData = "/ducc-servlet/job-id-data";
    private String duccJobWorkitemsCountData = "/ducc-servlet/job-workitems-count-data";
    private String duccJobProcessesData = "/ducc-servlet/job-processes-data";
    private String duccJobWorkitemsData = "/ducc-servlet/job-workitems-data";
    private String duccJobPerformanceData = "/ducc-servlet/job-performance-data";
    private String duccJobSpecificationData = "/ducc-servlet/job-specification-data";
    private String duccJobFilesData = "/ducc-servlet/job-files-data";
    private String duccJobInitializationFailData = "/ducc-servlet/job-initialization-fail-data";
    private String duccJobRuntimeFailData = "/ducc-servlet/job-runtime-fail-data";
    private String duccReservationProcessesData = "/ducc-servlet/reservation-processes-data";
    private String duccReservationSpecificationData = "/ducc-servlet/reservation-specification-data";
    private String duccReservationFilesData = "/ducc-servlet/reservation-files-data";
    private String duccServicesRecordsCeiling = "/ducc-servlet/services-records-ceiling";
    private String duccServiceDeploymentsData = "/ducc-servlet/service-deployments-data";
    private String duccServiceRegistryData = "/ducc-servlet/service-registry-data";
    private String duccServiceFilesData = "/ducc-servlet/service-files-data";
    private String duccServiceHistoryData = "/ducc-servlet/service-history-data";
    private String duccServiceSummaryData = "/ducc-servlet/service-summary-data";
    private String duccBrokerSummaryData = "/ducc-servlet/broker-summary-data";
    private String duccSystemAdminAdminData = "/ducc-servlet/system-admin-admin-data";
    private String duccSystemAdminControlData = "/ducc-servlet/system-admin-control-data";
    private String duccSystemJobsControl = "/ducc-servlet/jobs-control-request";
    private String duccClusterName = "/ducc-servlet/cluster-name";
    private String duccClusterUtilization = "/ducc-servlet/cluster-utilization";
    private String duccClusterReliableLabel = "/ducc-servlet/cluster-reliable-label";
    private String duccClusterReliableStatus = "/ducc-servlet/cluster-reliable-status";
    private String duccTimeStamp = "/ducc-servlet/timestamp";
    private String duccAlerts = "/ducc-servlet/alerts";
    private String duccBannerMessage = "/ducc-servlet/banner-message";
    private String duccJobSubmit = "/ducc-servlet/job-submit-request";
    private String duccJobCancel = "/ducc-servlet/job-cancel-request";
    private String duccReservationSubmit = "/ducc-servlet/reservation-submit-request";
    private String duccReservationCancel = "/ducc-servlet/reservation-cancel-request";
    private String duccServiceSubmit = "/ducc-servlet/service-submit-request";
    private String duccServiceCancel = "/ducc-servlet/service-cancel-request";
    private String duccServiceEnable = "/ducc-servlet/service-enable-request";
    private String duccServiceStart = "/ducc-servlet/service-start-request";
    private String duccServiceStop = "/ducc-servlet/service-stop-request";
    private String duccServiceUpdate = "/ducc-servlet/service-update-request";
    private String jsonMachinesData = "/ducc-servlet/json-machines-data";
    private String jsonSystemClassesData = "/ducc-servlet/json-system-classes-data";
    private String jsonSystemDaemonsData = "/ducc-servlet/json-system-daemons-data";
    private String duccJobSubmitButton = "/ducc-servlet/job-get-submit-button";
    private String duccReservationFormButton = "/ducc-servlet/reservation-get-form-button";
    private String duccReservationSubmitButton = "/ducc-servlet/reservation-get-submit-button";
    private String duccServiceUpdateFormButton = "/ducc-servlet/service-update-get-form-button";
    private String duccReservationSchedulingClasses = "/ducc-servlet/reservation-scheduling-classes";
    private String duccReservationInstanceMemoryUnits = "/ducc-servlet/reservation-memory-units";
    private String _window_login_logout = "_window_login_logout";
    private String _window_file_pager = "_window_file_pager";
    private String _window_reservation_request = "_window_reservation_request";
    private String _window_jconsole = "_window_jconsole";
    private long boottime = System.currentTimeMillis();
    private long maxTimeToBoot = 120000L;
    private DecimalFormat sizeFormatter = new DecimalFormat("##0.00");
    private DecimalFormat formatter = new DecimalFormat("##0.0");
    String pname_idJob = "idJob";
    String pname_idPro = "idPro";
    private static BrokerHelper brokerHelper = BrokerHelper.getInstance();
    private static DatabaseHelper databaseHelper = DatabaseHelper.getInstance();
    private String cache_disk_info = "";
    private long cache_disk_info_TOD = 0L;
    private long cache_disk_info_interval = 900000L;

    public DuccHandler(DuccWebServer duccWebServer) {
        super.init(duccWebServer);
    }

    public String getUserIdFromRequest(HttpServletRequest request) {
        String retVal = duccWebSessionManager.getUserId(request);
        return retVal;
    }

    private void handleDuccServletLoginLink(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletLoginLink";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String value = DuccPropertiesResolver.getInstance().getProperty("ducc.ws.login.enabled");
        Boolean result = new Boolean(value);
        if (!result.booleanValue()) {
            String href = "<span title=\"System is configured to disallow logins\" stylen=\"font-size:8pt;\" disabled>Login</span>";
            sb.append(href);
        } else {
            boolean userAuth = this.isAuthenticated(request, response);
            if (userAuth) {
                sb.append("<span class=\"status_on\">");
                sb.append("Logged-in");
                sb.append("<span>");
            } else {
                String link = "https://" + request.getServerName() + ":" + this.getDuccWebServer().getPortSsl() + "/";
                String href = "<a href=\"" + link + "login.html\" onclick=\"var newWin = window.open(this.href,'" + this._window_login_logout + "','height=600,width=550,scrollbars');  newWin.focus(); return false;\">Login</a>";
                sb.append(href);
            }
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletLogoutLink(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletLogoutLink";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        boolean userAuth = this.isAuthenticated(request, response);
        if (userAuth) {
            String link = "https://" + request.getServerName() + ":" + this.getDuccWebServer().getPortSsl() + "/";
            String href = "<a href=\"" + link + "logout.html\" onclick=\"var newWin = window.open(this.href,'" + this._window_login_logout + "','height=600,width=550,scrollbars');  newWin.focus(); return false;\">Logout</a>";
            sb.append(href);
        } else {
            sb.append("<span class=\"status_off\">");
            sb.append("Logged-out");
            sb.append("<span>");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletVersion(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletVersion";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String version = Version.version();
        sb.append(version);
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletHome(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletHome";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        sb.append(this.dir_home);
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletHostname(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletHostname";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        try {
            Process p = Runtime.getRuntime().exec("hostname");
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String hostname = "";
            while ((hostname = stdInput.readLine()) != null) {
                sb.append(hostname);
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletAuthenticationStatus(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletAuthenticationStatus";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        boolean userAuth = this.isAuthenticated(request, response);
        if (userAuth) {
            sb.append("<span class=\"status_on\">");
            sb.append("logged-in");
            sb.append("<span>");
        } else {
            sb.append("<span class=\"status_off\">");
            sb.append("logged-out");
            sb.append("<span>");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletAuthenticatorVersion(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletAuthenticatorVersion";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        sb.append(this.duccAuthenticator.getVersion());
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletAuthenticatorNotes(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletAuthenticatorNotes";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String uid = DuccCookies.getUid(request);
        String notes = this.duccAuthenticator.getNotes(uid);
        if (notes != null) {
            sb.append(notes);
        }
        duccLogger.debug(methodName, jobid, new Object[]{"uid:" + uid + " notes:" + notes});
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletduccAuthenticatorPasswordChecked(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletduccAuthenticatorPasswordChecked";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        if (this.duccAuthenticator.isPasswordChecked()) {
            sb.append("<input type=\"password\" name=\"password\"/>");
        } else {
            sb.append("<input name=\"password\" value=\"not used\" disabled=disabled title=\"Authenticator does not check password\"/>");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private String buildLogFileName(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType type) {
        return Helper.getLogFileName(job, process, type);
    }

    private boolean fileExists(String fileName) {
        String location = "fileExists";
        boolean retVal = false;
        try {
            File file = new File(fileName);
            retVal = file.exists();
        }
        catch (Exception e) {
            duccLogger.warn(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private String normalizeFileSize(long fileSize) {
        return Helper.normalize(fileSize);
    }

    private String getId(IDuccWorkJob job, IDuccProcess process) {
        StringBuffer sb = new StringBuffer();
        sb.append(job.getDuccId().getFriendly());
        sb.append(".");
        if (process != null) {
            sb.append(process.getDuccId().getFriendly());
        } else {
            sb.append("pending");
        }
        return sb.toString();
    }

    private String getLog(IDuccWorkJob job, IDuccProcess process, String href) {
        String pid;
        StringBuffer sb = new StringBuffer();
        if (process != null && (pid = process.getPID()) != null) {
            sb.append(href);
        }
        return sb.toString();
    }

    private String getPid(IDuccWorkJob job, IDuccProcess process) {
        return Helper.getPid(job, process);
    }

    private String getStateScheduler(IDuccWorkJob job, IDuccProcess process) {
        return Helper.getSchedulerState(job, process);
    }

    private String getReasonScheduler(IDuccWorkJob job, IDuccProcess process) {
        return Helper.getSchedulerReason(job, process);
    }

    private boolean isIdleJobProcess(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType type) {
        return Helper.isIdleJobProcess(job, process, type);
    }

    private String getStateAgent(IDuccWorkJob job, IDuccProcess process) {
        return Helper.getAgentState(job, process);
    }

    private String getReasonAgent(IDuccWorkJob job, IDuccProcess process) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            String agentReason = process.getExtendedReasonForStoppingProcess();
            if (agentReason == null) {
                agentReason = process.getReasonForStoppingProcess();
            }
            if (agentReason != null) {
                if (agentReason.equalsIgnoreCase(IDuccProcess.ReasonForStoppingProcess.KilledByDucc.toString())) {
                    agentReason = "<div title=\"" + IDuccProcess.ReasonForStoppingProcess.KilledByDucc.toString() + "\">Discontinued</div>";
                } else if (agentReason.equalsIgnoreCase(IDuccProcess.ReasonForStoppingProcess.Other.toString())) {
                    agentReason = "<div title=\"" + IDuccProcess.ReasonForStoppingProcess.Other.toString() + "\">Discontinued</div>";
                }
                sb.append(agentReason);
            }
        }
        return sb.toString();
    }

    private String getExit(IDuccWorkJob job, IDuccProcess process) {
        return Helper.getExit(job, process);
    }

    private String getTimeInit(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType type) {
        return Helper.getTimeInit(job, process, type);
    }

    private boolean isTimeInitEstimated(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType type) {
        return Helper.isTimeInitEstimated(job, process, type);
    }

    private String getTimeRun(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType type) {
        return Helper.getTimeRun(job, process, type);
    }

    private boolean isTimeRunEstimated(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType type) {
        return Helper.isTimeRunEstimated(job, process, type);
    }

    private String getTimeGC(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType type) {
        return Helper.getTimeGC(job, process, type);
    }

    private String getPgIn(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType sType) {
        return Helper.getPgIn(job, process, sType);
    }

    private String getSwap(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        boolean swapping = Helper.isSwapping(job, process, sType);
        String swap = Helper.getSwap(job, process, sType);
        String swapMax = Helper.getSwapMax(job, process, sType);
        if (swapMax != null) {
            sb.append("<span title=\"max=" + swapMax + "\" align=\"right\" >");
        }
        if (swapping) {
            sb.append("<span class=\"health_red\">");
        } else {
            sb.append("<span class=\"health_black\">");
        }
        sb.append(swap);
        sb.append("</span>");
        if (swapMax != null) {
            sb.append("</span>");
        }
        return sb.toString();
    }

    private String getPctCpuV0(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType sType) {
        String retVal = "";
        boolean rt = false;
        double pctCPU_overall = 0.0;
        String runTime = "" + process.getCpuTime();
        if (runTime != null) {
            if (runTime.contains(":")) {
                rt = true;
            } else {
                try {
                    long value = Long.parseLong(runTime);
                    if (value > 0L) {
                        rt = true;
                    }
                }
                catch (Exception value) {
                    // empty catch block
                }
            }
        }
        try {
            if (rt) {
                long msecsCPU = process.getCpuTime() * 1000L;
                long msecsRun = process.getTimeWindowRun().getElapsedMillis();
                switch (process.getProcessState()) {
                    case Running: {
                        long msecsInit = process.getTimeWindowInit().getElapsedMillis();
                        msecsRun -= msecsInit;
                        break;
                    }
                }
                double secsCPU = (double)msecsCPU * 1.0 / 1000.0;
                double secsRun = (double)msecsRun * 1.0 / 1000.0;
                double timeCPU = secsCPU;
                double timeRun = secsRun;
                pctCPU_overall = 100.0 * (timeCPU / timeRun);
                if (!Double.isNaN(pctCPU_overall)) {
                    StringBuffer sb = new StringBuffer();
                    String fmtsecsCPU = this.formatter.format(secsCPU);
                    String fmtsecsRun = this.formatter.format(secsRun);
                    String title = "title=\"seconds CPU:" + fmtsecsCPU + " run:" + fmtsecsRun + "\"";
                    sb.append("<span " + title + ">");
                    String fmtPctCPU = this.formatter.format(pctCPU_overall);
                    sb.append(fmtPctCPU);
                    sb.append("</span>");
                    retVal = sb.toString();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private String getPctCpuV1(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType sType) {
        String fmtCPU_overall = Helper.getPctCpuOverall(job, process, sType);
        String fmtCPU_current = Helper.getPctCpuCurrent(job, process, sType);
        StringBuffer sb = new StringBuffer();
        IProcessState.ProcessState ps = process.getProcessState();
        switch (ps) {
            case Running: 
            case Starting: 
            case Started: 
            case Initializing: {
                String title = "title=\"lifetime: " + fmtCPU_overall + "\"";
                sb.append("<span " + title + " class=\"health_green\">");
                sb.append(fmtCPU_current);
                sb.append("</span>");
                break;
            }
            default: {
                sb.append("<span>");
                sb.append(fmtCPU_overall);
                sb.append("</span>");
            }
        }
        String retVal = sb.toString();
        return retVal;
    }

    private String getPctCpu(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType sType) {
        String location = "getPctCpu";
        String retVal = "";
        if (process != null) {
            try {
                retVal = process.getDataVersion() < 1L ? this.getPctCpuV0(job, process, sType) : this.getPctCpuV1(job, process, sType);
            }
            catch (Exception e) {
                duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        }
        return retVal;
    }

    private String getRSS(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        String rss = Helper.getRss(job, process, sType);
        String rssMax = Helper.getRssMax(job, process, sType);
        if (rssMax != null) {
            sb.append("<span title=\"max=" + rssMax + "\" align=\"right\" >");
            sb.append(rss);
            sb.append("</span>");
        } else {
            sb.append(rss);
        }
        return sb.toString();
    }

    private String getJConsole(IDuccWorkJob job, IDuccProcess process, Helper.AllocationType sType) {
        StringBuffer sb = new StringBuffer();
        if (process != null) {
            switch (process.getProcessState()) {
                case Running: 
                case Initializing: {
                    String jmxUrl = process.getProcessJmxUrl();
                    if (jmxUrl == null) break;
                    String link = this.buildjConsoleLink(jmxUrl);
                    sb.append(link);
                    break;
                }
            }
        }
        return sb.toString();
    }

    private long getLogFileSize(String filename, Map<String, FileInfo> fileInfoMap) {
        return Helper.getFileSize(filename, fileInfoMap);
    }

    private void buildJobProcessListEntry(EffectiveUser eu, StringBuffer pb, DuccWorkJob job, IDuccProcess process, DetailsType dType, Helper.AllocationType sType, int counter, Map<String, FileInfo> fileInfoMap) {
        StringBuffer rb = new StringBuffer();
        int COLS = 26;
        switch (sType) {
            case SPC: 
            case SPU: {
                ++COLS;
                ++COLS;
                break;
            }
        }
        StringBuffer[] cbList = new StringBuffer[COLS];
        for (int i = 0; i < COLS; ++i) {
            cbList[i] = new StringBuffer();
        }
        String logsjobdir = job.getUserLogDir();
        String logfile = this.buildLogFileName((IDuccWorkJob)job, process, sType);
        String file_name = logsjobdir + logfile;
        String url = Helper.getFilePagerUrl(eu, file_name);
        String href = "<a href=\"" + url + "\" onclick=\"var newWin = window.open(this.href,'" + this._window_file_pager + "','height=800,width=1200,scrollbars');  newWin.focus(); return false;\">" + logfile + "</a>";
        String tr = this.trGet(counter);
        rb.append(tr);
        int index = -1;
        cbList[++index].append("<td align=\"right\">");
        String id = "";
        switch (sType) {
            case SPC: {
                id = this.getId((IDuccWorkJob)job, process);
                break;
            }
            case SPU: {
                id = this.getId((IDuccWorkJob)job, process);
                break;
            }
            case MR: {
                id = this.getId((IDuccWorkJob)job, process);
                break;
            }
            default: {
                id = "" + process.getDuccId().getFriendly();
            }
        }
        cbList[index].append(id);
        this.logAppend(index, "id", id);
        cbList[index].append("</td>");
        switch (sType) {
            case SPC: 
            case SPU: {
                cbList[++index].append("<td>");
                String state = job.getJobState().toString();
                cbList[index].append(state);
                this.logAppend(index, "state", state);
                cbList[index].append("</td>");
                break;
            }
        }
        switch (sType) {
            case SPC: 
            case SPU: {
                ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
                cbList[++index].append("<td valign=\"bottom\" align=\"right\">");
                String services = this.evaluateServices((IDuccWorkJob)job, servicesRegistry);
                cbList[index].append(services);
                this.logAppend(index, "services", services);
                cbList[index].append("</td>");
                break;
            }
        }
        cbList[++index].append("<td>");
        String log = this.getLog((IDuccWorkJob)job, process, href);
        cbList[index].append(log);
        this.logAppend(index, "log", log);
        cbList[index].append("</td>");
        cbList[++index].append("<td align=\"right\">");
        String fileSize = Helper.getLogFileSize((IDuccWorkJob)job, process, logfile, fileInfoMap);
        cbList[index].append(fileSize);
        this.logAppend(index, "fileSize", fileSize);
        cbList[index].append("</td>");
        cbList[++index].append("<td>");
        String hostname = Helper.getHostname((IDuccWorkJob)job, process);
        cbList[index].append(hostname);
        this.logAppend(index, "hostname", hostname);
        cbList[index].append("</td>");
        cbList[++index].append("<td align=\"right\">");
        String pid = this.getPid((IDuccWorkJob)job, process);
        cbList[index].append(pid);
        this.logAppend(index, "pid", pid);
        cbList[index].append("</td>");
        switch (sType) {
            case SPC: 
            case SPU: {
                cbList[++index].append("<td align=\"right\">");
                DuccId duccId = job.getDuccId();
                IDuccSchedulingInfo si = job.getSchedulingInfo();
                SizeBytes sizeBytes = new SizeBytes(SizeBytes.Type.Bytes, si.getMemorySizeAllocatedInBytes());
                String actual = this.getProcessMemorySize(duccId, sizeBytes);
                sizeBytes = new SizeBytes(si.getMemoryUnits().name(), Long.parseLong(si.getMemorySizeRequested()));
                String requested = this.getProcessMemorySize(duccId, sizeBytes);
                cbList[index].append("<span title=\"requested: " + requested + "\">");
                cbList[index].append(actual);
                cbList[index].append("</span>");
                this.logAppend(index, "actual", actual);
                this.logAppend(index, "requested", requested);
                break;
            }
        }
        cbList[++index].append("<td>");
        String stateScheduler = this.getStateScheduler((IDuccWorkJob)job, process);
        cbList[index].append(stateScheduler);
        this.logAppend(index, "stateScheduler", stateScheduler);
        cbList[index].append("</td>");
        cbList[++index].append("<td>");
        String reasonScheduler = this.getReasonScheduler((IDuccWorkJob)job, process);
        cbList[index].append(reasonScheduler);
        this.logAppend(index, "reasonScheduler", reasonScheduler);
        cbList[index].append("</td>");
        cbList[++index].append("<td>");
        String stateAgent = this.getStateAgent((IDuccWorkJob)job, process);
        if (this.isIdleJobProcess((IDuccWorkJob)job, process, sType)) {
            stateAgent = process.getProcessState() + ":Idle";
        }
        cbList[index].append(stateAgent);
        this.logAppend(index, "stateAgent", stateAgent);
        cbList[index].append("</td>");
        cbList[++index].append("<td>");
        String reasonAgent = this.getReasonAgent((IDuccWorkJob)job, process);
        cbList[index].append(reasonAgent);
        this.logAppend(index, "reasonAgent", reasonAgent);
        cbList[index].append("</td>");
        cbList[++index].append("<td>");
        String exit = this.getExit((IDuccWorkJob)job, process);
        cbList[index].append(exit);
        this.logAppend(index, "exit", exit);
        cbList[index].append("</td>");
        switch (sType) {
            case MR: {
                break;
            }
            default: {
                cbList[++index].append("<td align=\"right\">");
                String timeInitPrefix = "<span class=\"health_black\">";
                if (this.isTimeInitEstimated((IDuccWorkJob)job, process, sType)) {
                    timeInitPrefix = "<span class=\"health_green\">";
                }
                String timeInitBody = this.getTimeInit((IDuccWorkJob)job, process, sType);
                String timeInitSuffix = "</span>";
                String timeInit = timeInitPrefix + timeInitBody + timeInitSuffix;
                cbList[index].append(timeInit);
                this.logAppend(index, "timeInit", timeInit);
                cbList[index].append("</td>");
            }
        }
        cbList[++index].append("<td align=\"right\">");
        String timeRunPrefix = "<span class=\"health_black\">";
        if (this.isTimeRunEstimated((IDuccWorkJob)job, process, sType)) {
            timeRunPrefix = "<span class=\"health_green\">";
        }
        String timeRunBody = this.getTimeRun((IDuccWorkJob)job, process, sType);
        String timeRunSuffix = "</span>";
        String timeRun = timeRunPrefix + timeRunBody + timeRunSuffix;
        cbList[index].append(timeRun);
        this.logAppend(index, "timeRun", timeRun);
        cbList[index].append("</td>");
        switch (sType) {
            case MR: {
                break;
            }
            default: {
                cbList[++index].append("<td align=\"right\">");
                String timeGC = this.getTimeGC((IDuccWorkJob)job, process, sType);
                cbList[index].append(timeGC);
                this.logAppend(index, "timeGC", timeGC);
                cbList[index].append("</td>");
            }
        }
        switch (sType) {
            default: 
        }
        cbList[++index].append("<td align=\"right\">");
        String pgin = this.getPgIn((IDuccWorkJob)job, process, sType);
        cbList[index].append(pgin);
        this.logAppend(index, "pgin", pgin);
        cbList[index].append("</td>");
        switch (sType) {
            default: 
        }
        cbList[++index].append("<td align=\"right\">");
        String swap = this.getSwap((IDuccWorkJob)job, process, sType);
        cbList[index].append(swap);
        this.logAppend(index, "swap", swap);
        cbList[index].append("</td>");
        cbList[++index].append("<td align=\"right\">");
        String pctCPU = this.getPctCpu((IDuccWorkJob)job, process, sType);
        cbList[index].append(pctCPU);
        this.logAppend(index, "%cpu", pctCPU);
        cbList[index].append("</td>");
        cbList[++index].append("<td align=\"right\">");
        String rss = this.getRSS((IDuccWorkJob)job, process, sType);
        cbList[index].append(rss);
        this.logAppend(index, "rss", rss);
        cbList[index].append("</td>");
        switch (sType) {
            case SPC: {
                break;
            }
            case SPU: {
                break;
            }
            case MR: {
                break;
            }
            default: {
                String timeAvg = "";
                cbList[++index].append("<td align=\"right\">");
                timeAvg = Helper.getWiTimeAvg((IDuccWorkJob)job, process, sType);
                cbList[index].append(timeAvg);
                this.logAppend(index, "timeAvg", timeAvg);
                cbList[index].append("</td>");
                cbList[++index].append("<td align=\"right\">");
                String timeMax = Helper.getWiTimeMax((IDuccWorkJob)job, process, sType);
                cbList[index].append(timeMax);
                this.logAppend(index, "timeMax", timeMax);
                cbList[index].append("</td>");
                cbList[++index].append("<td align=\"right\">");
                String timeMin = Helper.getWiTimeMin((IDuccWorkJob)job, process, sType);
                cbList[index].append(timeMin);
                this.logAppend(index, "timeMin", timeMin);
                cbList[index].append("</td>");
                cbList[++index].append("<td align=\"right\">");
                String done = Helper.getWiDone((IDuccWorkJob)job, process, sType);
                cbList[index].append(done);
                this.logAppend(index, "done", done);
                cbList[index].append("</td>");
                cbList[++index].append("<td align=\"right\">");
                String error = Helper.getWiError((IDuccWorkJob)job, process, sType);
                cbList[index].append(error);
                this.logAppend(index, "error", error);
                cbList[index].append("</td>");
                switch (dType) {
                    case Job: {
                        cbList[++index].append("<td align=\"right\">");
                        String dispatch = Helper.getWiDispatch((IDuccWorkJob)job, process, sType);
                        cbList[index].append(dispatch);
                        this.logAppend(index, "dispatch", dispatch);
                        cbList[index].append("</td>");
                        break;
                    }
                }
                cbList[++index].append("<td align=\"right\">");
                String retry = Helper.getWiRetry((IDuccWorkJob)job, process, sType);
                cbList[index].append(retry);
                this.logAppend(index, "retry", retry);
                cbList[index].append("</td>");
                cbList[++index].append("<td align=\"right\">");
                String preempt = Helper.getWiPreempt((IDuccWorkJob)job, process, sType);
                cbList[index].append(preempt);
                this.logAppend(index, "exit", exit);
                cbList[index].append("</td>");
            }
        }
        switch (sType) {
            case MR: {
                break;
            }
            default: {
                cbList[++index].append("<td>");
                String jConsole = this.getJConsole((IDuccWorkJob)job, process, sType);
                cbList[index].append(jConsole);
                this.logAppend(index, "jConsole", jConsole);
                cbList[index].append("</td>");
            }
        }
        for (int i = 0; i < COLS; ++i) {
            rb.append(cbList[i]);
        }
        rb.append("</tr>");
        pb.append(rb.toString());
        switch (sType) {
            case JD: {
                String errfile = "jd.err.log";
                if (!this.fileExists(logsjobdir + errfile)) break;
                rb = new StringBuffer();
                cbList = new StringBuffer[COLS];
                for (int i = 0; i < COLS; ++i) {
                    cbList[i] = new StringBuffer();
                    cbList[i].append("<td>");
                    cbList[i].append("</td>");
                }
                index = 0;
                index = 1;
                String jd_url = Helper.getFilePagerUrl(eu, logsjobdir + errfile);
                String href2 = "<a href=\"" + jd_url + "\" onclick=\"var newWin = window.open(this.href,'" + this._window_file_pager + "','height=800,width=1200,scrollbars');  newWin.focus(); return false;\">" + errfile + "</a>";
                cbList[index] = new StringBuffer();
                cbList[index].append("<td>");
                cbList[index].append(href2);
                cbList[index].append("</td>");
                index = 2;
                cbList[index] = new StringBuffer();
                cbList[index].append("<td align=\"right\">");
                cbList[index].append(this.normalizeFileSize(this.getLogFileSize(errfile, fileInfoMap)));
                cbList[index].append("</td>");
                rb.append(tr);
                for (int i = 0; i < COLS; ++i) {
                    rb.append(cbList[i]);
                }
                rb.append("</tr>");
                pb.append(rb.toString());
                break;
            }
        }
    }

    private void logAppend(int index, String name, String value) {
        String location = "";
        duccLogger.debug(location, jobid, new Object[]{"index:" + index + " " + name + "='" + value + "'"});
    }

    private void handleDuccServletJobIdData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletJobIdData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String jobId = request.getParameter("id");
        sb.append(jobId);
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void thSep(StringBuffer sb) {
        sb.append("<th>");
        sb.append("&nbsp");
        sb.append("&nbsp");
        sb.append("</th>");
    }

    private void handleDuccServletJobWorkitemsCountData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletJobWorkitemsCountData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        sb.append("<table>");
        sb.append("<tr>");
        sb.append("<th title=\"The system assigned id for this job\">");
        sb.append("Id: ");
        String jobId = request.getParameter("id");
        sb.append(jobId);
        sb.append("</th>");
        this.thSep(sb);
        IDuccWorkJob job = this.findJob(jobId);
        sb.append("<th title=\"The current state of this job\">");
        sb.append("State: ");
        if (job != null) {
            String state;
            Object stateObject = job.getStateObject();
            if (stateObject != null) {
                state = stateObject.toString();
                sb.append(state);
            } else {
                state = IDuccState.JobState.Undefined.name();
                sb.append(state);
                duccLogger.warn(methodName, job.getDuccId(), new Object[]{state});
            }
            sb.append("</th>");
            this.thSep(sb);
            if (job.isCompleted()) {
                sb.append("<th title=\"The reason for the final state of this job, normally EndOfJob\">");
                sb.append("Reason: ");
                String reason = this.getReason(job, IWebMonitor.MonitorType.Job).toString();
                sb.append(reason);
                this.thSep(sb);
            }
            String jobWorkitemsCount = "?";
            if (job != null) {
                jobWorkitemsCount = job.getSchedulingInfo().getWorkItemsTotal();
            }
            sb.append("<th title=\"The total number of work items for this job\">");
            sb.append("Workitems: ");
            sb.append(jobWorkitemsCount);
            sb.append("</th>");
            this.thSep(sb);
            sb.append("<th title=\"The number of work items that completed successfully\">");
            sb.append("Done: ");
            String done = "0";
            try {
                done = "" + job.getSchedulingInfo().getIntWorkItemsCompleted();
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.append(done);
            sb.append("</th>");
            this.thSep(sb);
            int eCount = 0;
            try {
                eCount = job.getSchedulingInfo().getIntWorkItemsError();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String error = "" + eCount;
            sb.append("<th title=\"The number of work items that failed to complete successfully\">");
            sb.append("Error: ");
            sb.append(error);
            sb.append("</th>");
            this.thSep(sb);
            IDuccState.JobState jobState = IDuccState.JobState.Undefined;
            try {
                jobState = job.getJobState();
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (jobState) {
                case Completed: 
                case Undefined: {
                    break;
                }
                default: {
                    int dispatch = 0;
                    int unassigned = job.getSchedulingInfo().getCasQueuedMap().size();
                    try {
                        dispatch = Integer.parseInt(job.getSchedulingInfo().getWorkItemsDispatched()) - unassigned;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sb.append("<th title=\"The number of work items currently dispatched\">");
                    sb.append("Dispatch: ");
                    sb.append(dispatch);
                    sb.append("</th>");
                    this.thSep(sb);
                    break;
                }
            }
        } else {
            String state = "NotFound";
            sb.append(state);
            duccLogger.warn(methodName, jobid, new Object[]{jobId});
        }
        sb.append("</table>");
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private IDuccWorkJob findJob(String jobno) {
        DuccWorkJob job;
        block3: {
            String methodName = "findJob";
            job = null;
            try {
                IDuccWorkMap duccWorkMap = DuccData.getInstance().get();
                if (duccWorkMap.getJobKeySet().size() <= 0) break block3;
                Iterator iterator = null;
                for (DuccId jobId : duccWorkMap.getJobKeySet()) {
                    String fid = "" + jobId.getFriendly();
                    if (!jobno.equals(fid)) continue;
                    job = (DuccWorkJob)duccWorkMap.findDuccWork(jobId);
                    break;
                }
            }
            catch (Exception e) {
                duccLogger.trace(methodName, null, new Object[]{"jobno=" + jobno, e});
            }
        }
        return job;
    }

    private Map<String, FileInfo> getFileInfoMap(EffectiveUser eu, String directory) {
        return Helper.getFileInfoMap(eu, directory);
    }

    private void handleDuccServletJobProcessesData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletJobProcessesData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        EffectiveUser eu = EffectiveUser.create(request);
        StringBuffer sb = new StringBuffer();
        String jobno = request.getParameter("id");
        IDuccWorkMap duccWorkMap = DuccData.getInstance().get();
        DuccWorkJob job = null;
        if (duccWorkMap.getJobKeySet().size() > 0) {
            Iterator iterator = null;
            for (DuccId jobId : duccWorkMap.getJobKeySet()) {
                String fid = "" + jobId.getFriendly();
                if (!jobno.equals(fid)) continue;
                job = (DuccWorkJob)duccWorkMap.findDuccWork(jobId);
                break;
            }
        }
        if (job != null) {
            String directory = job.getLogDirectory() + File.separator + job.getId();
            Map<String, FileInfo> fileInfoMap = this.getFileInfoMap(eu, directory);
            Iterator iterator = null;
            iterator = job.getDriver().getProcessMap().keySet().iterator();
            int counter = 1;
            while (iterator.hasNext()) {
                DuccId processId = (DuccId)iterator.next();
                IDuccProcess process = (IDuccProcess)job.getDriver().getProcessMap().get((Object)processId);
                StringBuffer bb = new StringBuffer();
                this.buildJobProcessListEntry(eu, bb, job, process, DetailsType.Job, Helper.AllocationType.JD, counter, fileInfoMap);
                if (bb.length() <= 0) continue;
                sb.append(bb.toString());
                ++counter;
            }
            TreeMap<JobDetailsProcesses, JobDetailsProcesses> map = new TreeMap<JobDetailsProcesses, JobDetailsProcesses>();
            for (DuccId processId : job.getProcessMap().keySet()) {
                IDuccProcess process = (IDuccProcess)job.getProcessMap().get((Object)processId);
                JobDetailsProcesses jdp = new JobDetailsProcesses(process);
                map.put(jdp, jdp);
            }
            for (JobDetailsProcesses jdp : map.keySet()) {
                IDuccProcess process = jdp.getProcess();
                StringBuffer bb = new StringBuffer();
                this.buildJobProcessListEntry(eu, bb, job, process, DetailsType.Job, Helper.AllocationType.UIMA, counter, fileInfoMap);
                if (bb.length() <= 0) continue;
                sb.append(bb.toString());
                ++counter;
            }
        }
        if (sb.length() == 0) {
            sb.append("<tr>");
            sb.append("<td>");
            sb.append("not found");
            sb.append("</td>");
            sb.append("</tr>");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private DuccWorkJob getJob(String jobNo) {
        return Helper.getJob(jobNo);
    }

    private DuccWorkJob getManagedReservation(String reservationNo) {
        return Helper.getManagedReservation(reservationNo);
    }

    private long getAdjustedTime(long time, IDuccWorkJob job) {
        long t0;
        IDuccStandardInfo stdInfo;
        long t1;
        long tmax;
        long adjustedTime = time;
        if (job.isCompleted() && time > (tmax = (t1 = (stdInfo = job.getStandardInfo()).getDateOfCompletionMillis()) - (t0 = stdInfo.getDateOfSubmissionMillis()))) {
            adjustedTime = tmax;
        }
        return adjustedTime;
    }

    private void handleDuccServletJobWorkitemsData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletJobWorkitemsData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String jobNo = request.getParameter("id");
        DuccWorkJob job = this.getJob(jobNo);
        if (job != null) {
            try {
                String directory = job.getLogDirectory() + jobNo;
                EffectiveUser eu = EffectiveUser.create(request);
                long wiVersion = job.getWiVersion();
                AlienWorkItemStateReader workItemStateReader = new AlienWorkItemStateReader(eu, component, directory, wiVersion);
                ConcurrentSkipListMap<Long, IWorkItemState> map = workItemStateReader.getMap();
                if (map == null) {
                    sb.append(eu.isLoggedin() ? "(data missing or unreadable)" : "(not visible - try logging in)");
                }
                if (map.size() == 0) {
                    sb.append("(no work-items processed)");
                }
                ConcurrentSkipListMap<IWorkItemState, IWorkItemState> sortedMap = new ConcurrentSkipListMap<IWorkItemState, IWorkItemState>();
                for (Map.Entry<Long, IWorkItemState> entry : map.entrySet()) {
                    sortedMap.put(entry.getValue(), entry.getValue());
                }
                DuccMachinesData machinesData = DuccMachinesData.getInstance();
                DecimalFormat formatter = new DecimalFormat("##0.00");
                int counter = 0;
                for (Map.Entry entry : sortedMap.entrySet()) {
                    String hostName;
                    long wiStartTime;
                    long jdStartTime;
                    StringBuffer row = new StringBuffer();
                    IWorkItemState wis = (IWorkItemState)entry.getValue();
                    row.append(this.trGet(counter++));
                    if (counter > 4096) {
                        row.append("<td align=\"right\">");
                        row.append("*****");
                        row.append("<td align=\"right\">");
                        row.append("*****");
                        row.append("<td align=\"right\">");
                        row.append("display");
                        row.append("<td align=\"right\">");
                        row.append("limit");
                        row.append("<td align=\"right\">");
                        row.append("reached");
                        row.append("<td align=\"right\">");
                        row.append("*****");
                        row.append("<td align=\"right\">");
                        row.append("*****");
                        row.append("<td align=\"right\">");
                        row.append("*****");
                        row.append("<td align=\"right\">");
                        row.append("*****");
                        row.append("<td align=\"right\">");
                        row.append("*****");
                        sb.append(row);
                        duccLogger.warn(methodName, job.getDuccId(), new Object[]{"work items display max:4096"});
                    }
                    long refTime = DuccHandlerUtils.getReferenceTime((IDuccWorkJob)job, wis.getNode(), wis.getPid());
                    row.append("<td align=\"right\">");
                    row.append(wis.getSeqNo());
                    row.append("<td align=\"right\">");
                    row.append(wis.getWiId());
                    row.append("<td align=\"right\">");
                    IWorkItemState.State state = wis.getState();
                    StringBuffer status = new StringBuffer();
                    switch (state) {
                        case lost: {
                            status.append("<span title=\"Work Item was queued but never dequeued.\" >");
                            status.append(state);
                            status.append("</span>");
                            break;
                        }
                        default: {
                            status.append(state);
                        }
                    }
                    row.append(status);
                    String fmt_startTime = "";
                    IDuccProcess jd = job.getDriverProcess();
                    if (jd != null && (jdStartTime = Helper.getTimeStart(jd)) >= 0L && (wiStartTime = wis.getMillisAtStart()) > jdStartTime) {
                        double elapsedTime = wiStartTime - jdStartTime;
                        fmt_startTime = formatter.format(elapsedTime /= 1000.0);
                    }
                    row.append("<td align=\"right\">");
                    row.append(fmt_startTime);
                    double time = this.getAdjustedTime(wis.getMillisOverhead(refTime), (IDuccWorkJob)job);
                    row.append("<td align=\"right\">");
                    row.append(formatter.format(time /= 1000.0));
                    time = this.getAdjustedTime(wis.getMillisProcessing(refTime), (IDuccWorkJob)job);
                    String ptime = formatter.format(time /= 1000.0);
                    row.append("<td align=\"right\">");
                    switch (state) {
                        case start: 
                        case queued: 
                        case operating: {
                            row.append("<span class=\"health_green\">");
                            break;
                        }
                        default: {
                            row.append("<span class=\"health_black\">");
                        }
                    }
                    row.append(ptime);
                    row.append("</span>");
                    time = this.getAdjustedTime(wis.getMillisInvestment(refTime), (IDuccWorkJob)job);
                    String itime = formatter.format(time /= 1000.0);
                    row.append("<td align=\"right\">");
                    String ispan = "<span class=\"health_black\">";
                    if (time > 0.0 && !itime.equals(ptime)) {
                        ispan = "<span title=\"investment reset\" class=\"health_red\">";
                    }
                    row.append(ispan);
                    row.append(itime);
                    row.append("</span>");
                    row.append("<td>");
                    String node = wis.getNode();
                    if (node != null) {
                        row.append(node);
                    }
                    row.append("<td>");
                    if (node != null && (hostName = machinesData.getNameForIp(node)) != null) {
                        row.append(hostName);
                    }
                    row.append("<td>");
                    String pid = wis.getPid();
                    if (pid != null) {
                        row.append(pid);
                    }
                    sb.append(row);
                    duccLogger.trace(methodName, null, new Object[]{"**" + counter + "** " + row});
                }
            }
            catch (Exception e) {
                duccLogger.warn(methodName, null, new Object[]{e.getMessage()});
                duccLogger.debug(methodName, null, (Throwable)e, new Object[0]);
                sb.append("no accessible data (" + e + ")");
            }
        } else {
            sb.append("no accessible data (no job?)");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void dumpMap(PerformanceMetricsSummaryMap map) {
        String location = "dumpMap";
        if (map != null) {
            if (map.size() == 0) {
                duccLogger.debug(location, jobid, new Object[]{"map=empty"});
            } else {
                duccLogger.debug(location, jobid, new Object[]{"map.size=" + map.size()});
                for (Map.Entry entry : map.entrySet()) {
                    PerformanceMetricsSummaryItem item = (PerformanceMetricsSummaryItem)entry.getValue();
                    duccLogger.debug(location, jobid, new Object[]{"displayName=", item.getDisplayName(), "analysisTime=", item.getAnalysisTime(), "analysisTimeMin=", item.getAnalysisTimeMin(), "analysisTimeMax=", item.getAnalysisTimeMax(), "analysisTasks=", item.getAnalysisTasks()});
                }
            }
        } else {
            duccLogger.debug(location, jobid, new Object[]{"map=null"});
        }
    }

    private void handleDuccServletJobPerformanceData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletJobPerformanceData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String jobNo = request.getParameter("id");
        DuccWorkJob job = this.getJob(jobNo);
        if (job != null) {
            try {
                EffectiveUser eu = EffectiveUser.create(request);
                PerformanceSummary performanceSummary = new PerformanceSummary(job.getLogDirectory() + jobNo);
                PerformanceMetricsSummaryMap performanceMetricsSummaryMap = performanceSummary.readSummary(eu.get());
                this.dumpMap(performanceMetricsSummaryMap);
                if (performanceMetricsSummaryMap == null) {
                    sb.append(eu.isLoggedin() ? "(data missing or unreadable)" : "(not visible - try logging in)");
                }
                if (performanceMetricsSummaryMap.size() == 0) {
                    sb.append("(no performance metrics)");
                }
                int casCount = performanceMetricsSummaryMap.casCount();
                ArrayList<UimaStatistic> uimaStats = new ArrayList<UimaStatistic>();
                uimaStats.clear();
                long analysisTime = 0L;
                PerformanceMetricsSummaryItem summaryValues = null;
                for (Map.Entry entry : performanceMetricsSummaryMap.entrySet()) {
                    PerformanceMetricsSummaryItem item = (PerformanceMetricsSummaryItem)entry.getValue();
                    if (((String)entry.getKey()).isEmpty()) {
                        summaryValues = item;
                        continue;
                    }
                    String shortname = item.getDisplayName();
                    long anTime = item.getAnalysisTime();
                    long anMinTime = item.getAnalysisTimeMin();
                    long anMaxTime = item.getAnalysisTimeMax();
                    long anTasks = item.getAnalysisTasks();
                    analysisTime += anTime;
                    UimaStatistic stat = new UimaStatistic(shortname, (String)entry.getKey(), anTime, anMinTime, anMaxTime, anTasks);
                    uimaStats.add(stat);
                }
                Collections.sort(uimaStats);
                int numstats = uimaStats.size();
                DecimalFormat formatter = new DecimalFormat("##0.0");
                int counter = 0;
                sb.append(this.trGet(counter++));
                sb.append("<td>");
                sb.append("<i><b>Summary</b></i>");
                long ltime = 0L;
                sb.append("<td align=\"right\">");
                if (summaryValues != null) {
                    analysisTime = summaryValues.getAnalysisTime();
                }
                sb.append(FormatHelper.duration(analysisTime, FormatHelper.Precision.Tenths));
                sb.append("<td align=\"right\">");
                sb.append(formatter.format(100L));
                sb.append("<td align=\"right\">");
                sb.append("<span class=\"health_purple\" title=\"average processing time per completed work item\">");
                long avgMillis = 0L;
                if (casCount > 0) {
                    avgMillis = analysisTime / (long)casCount;
                }
                sb.append(FormatHelper.duration(avgMillis, FormatHelper.Precision.Tenths));
                sb.append("</span>");
                sb.append("<td align=\"right\">");
                sb.append("<span class=\"health_purple\" title=\"minimum processing time for any completed work item\">");
                ltime = summaryValues != null ? summaryValues.getAnalysisTimeMin() : job.getWiMillisMin();
                sb.append(FormatHelper.duration(ltime, FormatHelper.Precision.Tenths));
                sb.append("</span>");
                sb.append("<td align=\"right\">");
                sb.append("<span class=\"health_purple\" title=\"maximum processing time for any completed work item\">");
                ltime = summaryValues != null ? summaryValues.getAnalysisTimeMax() : job.getWiMillisMax();
                sb.append(FormatHelper.duration(ltime, FormatHelper.Precision.Tenths));
                sb.append("</span>");
                sb.append("<td align=\"right\">");
                sb.append("<span class=\"health_purple\" title=\"number of tasks per completed work item\">");
                sb.append("N/A");
                sb.append("</span>");
                for (int i = 0; i < numstats; ++i) {
                    sb.append(this.trGet(counter++));
                    String title = "title=\"" + ((UimaStatistic)uimaStats.get(i)).getLongName() + "\"";
                    sb.append("<td " + title + ">");
                    sb.append(((UimaStatistic)uimaStats.get(i)).getShortName());
                    sb.append("<td align=\"right\">");
                    double time = ((UimaStatistic)uimaStats.get(i)).getAnalysisTime();
                    ltime = (long)time;
                    sb.append(FormatHelper.duration(ltime, FormatHelper.Precision.Tenths));
                    sb.append("<td align=\"right\">");
                    double dtime = time / (double)analysisTime * 100.0;
                    sb.append(formatter.format(dtime));
                    sb.append("<td align=\"right\">");
                    ltime = (long)(time /= (double)casCount);
                    sb.append(FormatHelper.duration(ltime, FormatHelper.Precision.Tenths));
                    sb.append("<td align=\"right\">");
                    time = ((UimaStatistic)uimaStats.get(i)).getAnalysisMinTime();
                    ltime = (long)time;
                    sb.append(FormatHelper.duration(ltime, FormatHelper.Precision.Tenths));
                    sb.append("<td align=\"right\">");
                    time = ((UimaStatistic)uimaStats.get(i)).getAnalysisMaxTime();
                    ltime = (long)time;
                    sb.append(FormatHelper.duration(ltime, FormatHelper.Precision.Tenths));
                    sb.append("<td align=\"right\">");
                    long lnumTasks = ((UimaStatistic)uimaStats.get(i)).getAnalysisTasks();
                    sb.append("" + lnumTasks);
                }
            }
            catch (Exception e) {
                duccLogger.warn(methodName, null, (Throwable)e, new Object[0]);
                sb.append("no accessible data (" + e + ")");
            }
        } else {
            sb.append("no accessible data (no job?)");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void putJobSpecEntry(Properties properties, String provider, String key, String value, StringBuffer sb, int counter) {
        if (value != null) {
            sb.append(this.trGet(counter));
            sb.append("<td sorttable_customkey=\"" + provider.isEmpty() + "\">");
            sb.append(provider);
            sb.append("</td>");
            sb.append("<td>");
            sb.append(key);
            sb.append("</td>");
            sb.append("<td>");
            sb.append(value);
            sb.append("</td>");
            sb.append("</tr>");
        }
    }

    private void processSpecificationData(HttpServletRequest request, HttpServletResponse response, Properties usProperties, Properties properties, String buttonHint) throws IOException {
        String methodName = "ProcessSpecificationData";
        if (usProperties == null || properties == null) {
            String msg = this.isAuthenticated(request, response) ? "(data missing or unreadable)" : "(not visible - try logging in)";
            response.getWriter().println(msg);
            duccLogger.warn(methodName, null, new Object[]{request.getParameter("id") + " failed: " + msg});
            return;
        }
        StringBuffer sb = new StringBuffer();
        TreeSet<String> list = new TreeSet<String>(properties.stringPropertyNames());
        if (buttonHint != null) {
            list.addAll(usProperties.stringPropertyNames());
            if (!usProperties.contains("autostart")) {
                Object val = properties.remove("autostart");
                if (val != null) {
                    usProperties.put("autostart", val);
                } else {
                    duccLogger.warn(methodName, null, new Object[]{"Service " + properties.getProperty("numeric_id") + " has no autostart setting?"});
                }
            }
        }
        int i = 0;
        int counter = 0;
        for (String key : list) {
            String provider = "user";
            String value = usProperties.getProperty(key);
            if (value == null) {
                value = properties.getProperty(key);
                provider = "";
            }
            if (this.hideableKeys.contains(key) && (value = this.formatValue(value, key.endsWith("classpath"))).length() > 500) {
                String show = "<div class=\"hidedata" + i + "\"><input type=\"submit\" name=\"showcp" + i + "\" value=\"Show\" id=\"showbutton" + i + "\"/></div>";
                String hide = "<div class=\"showdata" + i + "\"><input type=\"submit\" name=\"hidecp" + i + "\" value=\"Hide\" id=\"hidebutton" + i + "\"/> " + value + "</div>";
                value = show + hide;
                ++i;
            }
            if (key.equalsIgnoreCase(IServicesRegistry.autostart) && value != null) {
                String eulav = (value = value.trim()).equals("true") ? "false" : "true";
                StringBuffer replacement = new StringBuffer();
                replacement.append("<select id=\"autostart\"" + buttonHint + ">");
                replacement.append("<option value=\"" + value + "\"  selected=\"selected\">" + value + "</option>");
                replacement.append("<option value=\"" + eulav + "\"                       >" + eulav + "</option>");
                replacement.append("</select>");
                value = replacement.toString();
            }
            if (key.equalsIgnoreCase(IServicesRegistry.instances) && value != null) {
                value = value.trim();
                StringBuffer replacement = new StringBuffer();
                replacement.append("<span id=\"instances_area\">");
                replacement.append("<input type=\"text\" size=\"5\" id=\"instances\" value=\"" + value + "\"" + buttonHint + ">");
                replacement.append("</span>");
                value = replacement.toString();
            }
            this.putJobSpecEntry(properties, provider, key, value, sb, counter++);
        }
        response.getWriter().println(sb);
    }

    private void handleDuccServletJobSpecificationData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        EffectiveUser eu;
        String reqUser;
        String resOwner;
        String methodName = "handleDuccServletJobSpecificationData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        String jobNo = request.getParameter("id");
        Map<String, Properties> map = null;
        DuccWorkJob dwj = this.getJob(jobNo);
        if (dwj != null && HandlersHelper.isResourceAuthorized(resOwner = dwj.getStandardInfo().getUser(), reqUser = (eu = EffectiveUser.create(request)).get())) {
            map = this.helperSpecifications.getJobSpecificationProperties(dwj, eu);
        }
        if (map != null) {
            Properties propertiesUser = (Properties)map.get(HelperSpecifications.PType.user.name());
            Properties propertiesSystem = (Properties)map.get(HelperSpecifications.PType.all.name());
            int usize = -1;
            if (propertiesUser != null) {
                usize = propertiesUser.size();
            }
            duccLogger.debug(methodName, jobid, new Object[]{"user=" + usize});
            int ssize = -1;
            if (propertiesSystem != null) {
                ssize = propertiesSystem.size();
            }
            duccLogger.debug(methodName, jobid, new Object[]{"system=" + ssize});
            this.processSpecificationData(request, response, propertiesUser, propertiesSystem, null);
        } else {
            String msg = "(data not found)";
            response.getWriter().println(msg);
            duccLogger.warn(methodName, null, new Object[]{request.getParameter("id") + " failed: " + msg});
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletJobFilesData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletJobFilesData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String jobNo = request.getParameter("id");
        DuccWorkJob job = this.getJob(jobNo);
        if (job != null) {
            try {
                EffectiveUser eu = EffectiveUser.create(request);
                String directory = job.getUserLogDir();
                TreeMap<String, FileInfo> map = OsProxy.getFilesInDirectory(eu, directory);
                Set keys2 = map.keySet();
                int counter = 0;
                for (String key : keys2) {
                    FileInfo fileInfo = (FileInfo)map.get(key);
                    StringBuffer row = new StringBuffer();
                    String tr = this.trGet(counter);
                    sb.append(tr);
                    row.append("<td>");
                    String url = Helper.getFilePagerUrl(eu, fileInfo.getName());
                    String href = "<a href=\"" + url + "\" onclick=\"var newWin = window.open(this.href,'" + this._window_file_pager + "','height=800,width=1200,scrollbars');  newWin.focus(); return false;\">" + fileInfo.getShortName() + "</a>";
                    row.append(href);
                    row.append("</td>");
                    row.append("<td>");
                    double size = (double)fileInfo.getLength() * 1.0 / (double)Constants.MB;
                    row.append(this.sizeFormatter.format(size));
                    row.append("</td>");
                    row.append("</tr>");
                    sb.append(row);
                    ++counter;
                }
                if (counter == 0) {
                    sb.append(eu.isLoggedin() ? "(data missing or unreadable)" : "(not visible - try logging in)");
                }
            }
            catch (Throwable t) {
                duccLogger.warn(methodName, null, t, new Object[0]);
                sb.append("no accessible data (" + t + ")");
            }
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletReservationFilesData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletReservationFilesData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String reservationNo = request.getParameter("id");
        DuccWorkJob reservation = this.getManagedReservation(reservationNo);
        if (reservation != null) {
            try {
                EffectiveUser eu = EffectiveUser.create(request);
                String directory = reservation.getUserLogDir();
                TreeMap<String, FileInfo> map = OsProxy.getFilesInDirectory(eu, directory);
                Set keys2 = map.keySet();
                int counter = 0;
                for (String key : keys2) {
                    FileInfo fileInfo = (FileInfo)map.get(key);
                    StringBuffer row = new StringBuffer();
                    String tr = this.trGet(counter);
                    sb.append(tr);
                    row.append("<td>");
                    String url = Helper.getFilePagerUrl(eu, fileInfo.getName());
                    String href = "<a href=\"" + url + "\" onclick=\"var newWin = window.open(this.href,'" + this._window_file_pager + "','height=800,width=1200,scrollbars');  newWin.focus(); return false;\">" + fileInfo.getShortName() + "</a>";
                    row.append(href);
                    row.append("</td>");
                    row.append("<td>");
                    double size = (double)fileInfo.getLength() * 1.0 / (double)Constants.MB;
                    row.append(this.sizeFormatter.format(size));
                    row.append("</td>");
                    row.append("</tr>");
                    sb.append(row);
                    ++counter;
                }
                if (counter == 0) {
                    sb.append(eu.isLoggedin() ? "(no files found)" : "(not visible - try logging in)");
                }
            }
            catch (Throwable t) {
                duccLogger.warn(methodName, null, t, new Object[0]);
                sb.append("no accessible data (" + t + ")");
            }
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void buildServiceFilesListEntry(Request baseRequest, HttpServletRequest request, StringBuffer sb, DuccWorkJob job, IDuccProcess process, Helper.AllocationType type, int counter, Map<String, FileInfo> map) {
        EffectiveUser eu = EffectiveUser.create(request);
        if (job != null) {
            try {
                Set<String> keys2 = map.keySet();
                for (String key : keys2) {
                    FileInfo fileInfo = map.get(key);
                    StringBuffer row = new StringBuffer();
                    String tr = this.trGet(counter);
                    sb.append(tr);
                    row.append("<td>");
                    row.append(job.getId() + "." + process.getDuccId());
                    row.append("</td>");
                    row.append("<td>");
                    String url = Helper.getFilePagerUrl(eu, fileInfo.getName());
                    String href = "<a href=\"" + url + "\" onclick=\"var newWin = window.open(this.href,'" + this._window_file_pager + "','height=800,width=1200,scrollbars');  newWin.focus(); return false;\">" + fileInfo.getShortName() + "</a>";
                    row.append(href);
                    row.append("</td>");
                    row.append("<td>");
                    double size = (double)fileInfo.getLength() * 1.0 / (double)Constants.MB;
                    row.append(this.sizeFormatter.format(size));
                    row.append("</td>");
                    row.append("<td>");
                    String date = fileInfo.getDate();
                    String time = fileInfo.getTime();
                    String dow = fileInfo.getDOW();
                    row.append(date + " " + time + " " + dow);
                    row.append("</td>");
                    row.append("</tr>");
                    sb.append(row);
                    ++counter;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void handleDuccServletServiceFilesData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletServiceFilesData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        try {
            String name = request.getParameter("name");
            ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
            ServicesRegistryMapPayload payload = servicesRegistry.findService(name);
            Properties properties = payload.meta;
            ArrayList<String> implementors = DuccDataHelper.parseImplementorsAsList(properties);
            DuccWorkJob service = null;
            IDuccWorkMap duccWorkMap = DuccData.getInstance().get();
            if (duccWorkMap.getServiceKeySet().size() > 0) {
                Iterator iterator = null;
                iterator = duccWorkMap.getServiceKeySet().iterator();
                int counter = 0;
                Helper.AllocationType type = Helper.AllocationType.SPU;
                String service_type = properties.getProperty(IServicesRegistry.service_type);
                if (service_type != null && service_type.equalsIgnoreCase("CUSTOM")) {
                    type = Helper.AllocationType.SPC;
                }
                EffectiveUser eu = EffectiveUser.create(request);
                while (iterator.hasNext()) {
                    DuccId serviceId = (DuccId)iterator.next();
                    String fid = "" + serviceId.getFriendly();
                    if (!implementors.contains(fid)) continue;
                    service = (DuccWorkJob)duccWorkMap.findDuccWork(serviceId);
                    IDuccProcessMap map = service.getProcessMap();
                    String directory = service.getUserLogDir();
                    TreeMap<String, FileInfo> fmap = OsProxy.getFilesInDirectory(eu, directory);
                    for (DuccId key : map.keySet()) {
                        IDuccProcess process = (IDuccProcess)map.get((Object)key);
                        this.buildServiceFilesListEntry(baseRequest, request, sb, service, process, type, ++counter, fmap);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (sb.length() == 0) {
            sb.append("<tr>");
            sb.append("<td>");
            sb.append("not found");
            sb.append("</td>");
            sb.append("</tr>");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletServiceHistoryData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletServiceHistoryData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        try {
            String name = request.getParameter("name");
            duccLogger.debug(methodName, null, new Object[]{name});
            EffectiveUser eu = EffectiveUser.create(request);
            ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
            ServicesRegistryMapPayload payload = servicesRegistry.findService(name);
            Properties properties = payload.meta;
            String numeric_id = properties.getProperty(IServicesRegistry.numeric_id);
            properties = payload.svc;
            String log_directory = properties.getProperty(IServicesRegistry.log_directory);
            TreeMap<String, FileInfo> pmap = OsProxy.getFilesInDirectory(eu, log_directory, true);
            Set keys2 = pmap.keySet();
            long sequence = 0L;
            TreeMap<FileInfoKey, FileInfo> map = new TreeMap<FileInfoKey, FileInfo>();
            for (String key : keys2) {
                FileInfo fileInfo = (FileInfo)pmap.get(key);
                FileInfoKey fik = new FileInfoKey(fileInfo.getTOD(), ++sequence);
                map.put(fik, fileInfo);
            }
            NavigableSet sortkeys = map.descendingKeySet();
            int counter = 0;
            for (FileInfoKey key : sortkeys) {
                FileInfo fileInfo = (FileInfo)map.get(key);
                StringBuffer row = new StringBuffer();
                String tr = this.trGet(counter);
                row.append(tr);
                row.append("<td>");
                row.append(numeric_id + fileInfo.getRelDir());
                row.append("</td>");
                row.append("<td>");
                String url = Helper.getFilePagerUrl(fileInfo.getName(), fileInfo.getPageCount());
                String href = "<a href=\"" + url + "\" onclick=\"var newWin = window.open(this.href,'" + this._window_file_pager + "','height=800,width=1200,scrollbars');  newWin.focus(); return false;\">" + fileInfo.getShortName() + "</a>";
                row.append(href);
                row.append("</td>");
                row.append("<td>");
                double size = (double)fileInfo.getLength() * 1.0 / (double)Constants.MB;
                row.append(this.sizeFormatter.format(size));
                row.append("</td>");
                row.append("<td>");
                String date = fileInfo.getDate();
                String time = fileInfo.getTime();
                String dow = fileInfo.getDOW();
                row.append(date + " " + time + " " + dow);
                row.append("</td>");
                row.append("</tr>");
                sb.append(row);
                ++counter;
            }
            duccLogger.debug(methodName, null, new Object[]{log_directory});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (sb.length() == 0) {
            sb.append("<tr>");
            sb.append("<td>");
            sb.append("not found");
            sb.append("</td>");
            sb.append("</tr>");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletJobInitializationFailData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletJobInitializationFailData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        EffectiveUser eu = EffectiveUser.create(request);
        StringBuffer sb = new StringBuffer();
        String jobNo = request.getParameter("id");
        DuccWorkJob job = this.getJob(jobNo);
        StringBuffer data = new StringBuffer();
        data.append("no accessible data");
        if (job != null) {
            try {
                IDuccProcessMap processMap = job.getProcessMap();
                ArrayList list = processMap.getFailedInitialization();
                int count = list.size();
                if (count > 0) {
                    data = new StringBuffer();
                    data.append("<table>");
                    Iterator processIterator = list.iterator();
                    switch (DuccCookies.getDisplayStyle(request)) {
                        case Textual: {
                            break;
                        }
                        case Visual: {
                            String key = "cap.large";
                            String capFile = DuccWebServerHelper.getImageFileName(key);
                            if (capFile == null || job.getSchedulingInfo().getLongProcessesMax() >= 0L) break;
                            data.append("<tr>");
                            data.append("<td>");
                            sb.append("<span title=\"capped at current number of running processes due to excessive initialization failures\">");
                            sb.append("<img src=\"" + capFile + "\">");
                            sb.append("</span>");
                            break;
                        }
                    }
                    while (processIterator.hasNext()) {
                        String logfile;
                        data.append("<tr>");
                        data.append("<td>");
                        DuccId processId = (DuccId)processIterator.next();
                        IDuccProcess process = (IDuccProcess)processMap.get((Object)processId);
                        String logsjobdir = job.getUserLogDir();
                        String link = logfile = this.buildLogFileName((IDuccWorkJob)job, process, Helper.AllocationType.UIMA);
                        String reason = process.getReasonForStoppingProcess();
                        if (reason != null && reason.trim().length() > 0) {
                            link = logfile + ":" + reason;
                        }
                        String url = Helper.getFilePagerUrl(eu, logsjobdir + logfile);
                        String href = "<a href=\"" + url + "\" onclick=\"var newWin = window.open(this.href,'" + this._window_file_pager + "','height=800,width=1200,scrollbars');  newWin.focus(); return false;\">" + link + "</a>";
                        data.append(href);
                    }
                    data.append("</table>");
                }
            }
            catch (Exception e) {
                duccLogger.warn(methodName, null, (Throwable)e, new Object[0]);
            }
        }
        sb.append("<html><head></head><body><span>" + data + "</span></body></html>");
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletJobRuntimeFailData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletJobRuntimeFailData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        EffectiveUser eu = EffectiveUser.create(request);
        StringBuffer sb = new StringBuffer();
        String jobNo = request.getParameter("id");
        DuccWorkJob job = this.getJob(jobNo);
        StringBuffer data = new StringBuffer();
        data.append("no accessible data");
        if (job != null) {
            try {
                IDuccProcessMap processMap = job.getProcessMap();
                ArrayList list = processMap.getFailedNotInitialization();
                int count = list.size();
                if (count > 0) {
                    data = new StringBuffer();
                    data.append("<table>");
                    Iterator processIterator = list.iterator();
                    while (processIterator.hasNext()) {
                        String logfile;
                        data.append("<tr>");
                        data.append("<td>");
                        DuccId processId = (DuccId)processIterator.next();
                        IDuccProcess process = (IDuccProcess)processMap.get((Object)processId);
                        String logsjobdir = job.getUserLogDir();
                        String link = logfile = this.buildLogFileName((IDuccWorkJob)job, process, Helper.AllocationType.UIMA);
                        String reason = process.getReasonForStoppingProcess();
                        if (reason != null && reason.trim().length() > 0) {
                            link = logfile + ":" + reason;
                        }
                        String url = Helper.getFilePagerUrl(eu, logsjobdir + logfile);
                        String href = "<a href=\"" + url + "\" onclick=\"var newWin = window.open(this.href,'" + this._window_file_pager + "','height=800,width=1200,scrollbars');  newWin.focus(); return false;\">" + link + "</a>";
                        data.append(href);
                    }
                    data.append("</table>");
                }
            }
            catch (Exception e) {
                duccLogger.warn(methodName, null, (Throwable)e, new Object[0]);
            }
        }
        sb.append("<html><head></head><body><span>" + data + "</span></body></html>");
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void buildServiceProcessListEntry(EffectiveUser eu, StringBuffer sb, DuccWorkJob job, IDuccProcess process, DetailsType dType, Helper.AllocationType sType, int counter, Map<String, FileInfo> fileInfoMap) {
        this.buildJobProcessListEntry(eu, sb, job, process, dType, sType, counter, fileInfoMap);
    }

    private void handleDuccServletReservationProcessesData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletReservationProcessesData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String reservationNo = request.getParameter("id");
        IDuccWorkMap duccWorkMap = DuccData.getInstance().get();
        DuccWorkJob managedReservation = null;
        if (duccWorkMap.getServiceKeySet().size() > 0) {
            Iterator iterator = null;
            for (DuccId jobId : duccWorkMap.getServiceKeySet()) {
                String fid = "" + jobId.getFriendly();
                if (!reservationNo.equals(fid)) continue;
                managedReservation = (DuccWorkJob)duccWorkMap.findDuccWork(jobId);
                break;
            }
        }
        if (managedReservation != null) {
            EffectiveUser eu = EffectiveUser.create(request);
            String directory = managedReservation.getUserLogDir();
            TreeMap<String, FileInfo> fileInfoMap = OsProxy.getFilesInDirectory(eu, directory);
            Iterator iterator = null;
            int counter = 0;
            for (DuccId processId : managedReservation.getProcessMap().keySet()) {
                IDuccProcess process = (IDuccProcess)managedReservation.getProcessMap().get((Object)processId);
                this.buildServiceProcessListEntry(eu, sb, managedReservation, process, DetailsType.Reservation, Helper.AllocationType.MR, ++counter, fileInfoMap);
            }
        }
        if (sb.length() == 0) {
            sb.append("<tr>");
            sb.append("<td>");
            sb.append("not found");
            sb.append("</td>");
            sb.append("</tr>");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletReservationSpecificationData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletReservationSpecificationData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        String mrNo = request.getParameter("id");
        DuccWorkJob dwj = this.getManagedReservation(mrNo);
        String resOwner = dwj.getStandardInfo().getUser();
        EffectiveUser eu = EffectiveUser.create(request);
        String reqUser = eu.get();
        Map<String, Properties> map = null;
        if (HandlersHelper.isResourceAuthorized(resOwner, reqUser)) {
            map = this.helperSpecifications.getManagedReservationSpecificationProperties(dwj, eu);
        }
        if (map != null) {
            Properties propertiesUser = map.get(HelperSpecifications.PType.user.name());
            Properties propertiesSystem = map.get(HelperSpecifications.PType.all.name());
            int usize = -1;
            if (propertiesUser != null) {
                usize = propertiesUser.size();
            }
            duccLogger.debug(methodName, jobid, new Object[]{"user=" + usize});
            int ssize = -1;
            if (propertiesSystem != null) {
                ssize = propertiesSystem.size();
            }
            duccLogger.debug(methodName, jobid, new Object[]{"system=" + ssize});
            this.processSpecificationData(request, response, propertiesUser, propertiesSystem, null);
        } else {
            String msg = "(data not found)";
            response.getWriter().println(msg);
            duccLogger.warn(methodName, null, new Object[]{request.getParameter("id") + " failed: " + msg});
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletServicesRecordsCeilingData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletServicesRecordsCeilingData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        try {
            int counter = 0;
            int ceiling = 0;
            ServicesSortCache servicesSortCache = ServicesSortCache.getInstance();
            Collection<IServiceAdapter> servicesSortedCollection = servicesSortCache.getSortedCollection();
            if (!servicesSortedCollection.isEmpty()) {
                int maxRecords = this.getServicesMax(request);
                ArrayList<String> users = this.getServicesUsers(request);
                for (IServiceAdapter service : servicesSortedCollection) {
                    boolean list = DuccWebUtil.isListable(request, users, maxRecords, counter, service);
                    if (!list) continue;
                    ++ceiling;
                }
            }
            sb.append("" + ceiling);
        }
        catch (Throwable t) {
            duccLogger.trace(methodName, jobid, t, new Object[0]);
        }
        if (sb.length() == 0) {
            sb.append("0");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletServiceDeploymentsData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletServiceDeploymentsData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        try {
            String name = request.getParameter("name");
            ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
            ServicesRegistryMapPayload payload = servicesRegistry.findService(name);
            Properties properties = payload.meta;
            ArrayList<String> implementors_current = DuccDataHelper.parseImplementorsAsList(properties);
            ArrayList<String> implementors_defunct = DuccDataHelper.parseWorkInstancesAsList(properties);
            IDuccWorkMap duccWorkMap = DuccData.getInstance().get();
            for (int i = 0; i < 2; ++i) {
                Map servicesMap = null;
                switch (i) {
                    case 0: {
                        servicesMap = duccWorkMap.getServicesMap(implementors_current);
                        break;
                    }
                    case 1: {
                        servicesMap = duccWorkMap.getServicesMap(implementors_defunct);
                    }
                }
                TreeMap inverseServicesMap = new TreeMap();
                for (Map.Entry entry : servicesMap.entrySet()) {
                    inverseServicesMap.put(0L - (Long)entry.getKey(), entry.getValue());
                }
                int counter = 0;
                Helper.AllocationType type = Helper.AllocationType.SPU;
                String service_type = properties.getProperty(IServicesRegistry.service_type);
                if (service_type != null && service_type.equalsIgnoreCase("CUSTOM")) {
                    type = Helper.AllocationType.SPC;
                }
                EffectiveUser eu = EffectiveUser.create(request);
                for (Map.Entry entry : inverseServicesMap.entrySet()) {
                    DuccWorkJob service = (DuccWorkJob)entry.getValue();
                    String directory = service.getLogDirectory() + File.separator + service.getId();
                    Map<String, FileInfo> fileInfoMap = this.getFileInfoMap(eu, directory);
                    IDuccProcessMap map = service.getProcessMap();
                    if (map.isEmpty()) {
                        this.buildServiceProcessListEntry(eu, sb, service, null, DetailsType.Service, type, ++counter, fileInfoMap);
                        continue;
                    }
                    for (DuccId key : map.keySet()) {
                        IDuccProcess process = (IDuccProcess)map.get((Object)key);
                        this.buildServiceProcessListEntry(eu, sb, service, process, DetailsType.Service, type, ++counter, fileInfoMap);
                    }
                }
            }
        }
        catch (Throwable t) {
            duccLogger.trace(methodName, jobid, t, new Object[0]);
        }
        if (sb.length() == 0) {
            sb.append("<tr>");
            sb.append("<td>");
            sb.append("not found");
            sb.append("</td>");
            sb.append("</tr>");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletServiceRegistryData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletServiceRegistryData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        try {
            HandlersHelper.DataAccessPermission dap = HandlersHelper.getServiceAuthorization(baseRequest);
            switch (dap) {
                case Read: 
                case Write: {
                    String name = request.getParameter("name");
                    ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
                    ServicesRegistryMapPayload payload = servicesRegistry.findService(name);
                    String hint = this.getLoginRefreshHint(request, response);
                    String enable_or_disable = this.getEnabledOrDisabled(request, response);
                    if (payload != null) {
                        Properties properties = payload.meta;
                        String resourceOwnerUserId = properties.getProperty(IServicesRegistry.user).trim();
                        if (!HandlersHelper.isUserAuthorized(request, resourceOwnerUserId) && hint.length() == 0) {
                            HandlersHelper.AuthorizationStatus authorizationStatus = HandlersHelper.getAuthorizationStatus(request, resourceOwnerUserId);
                            switch (authorizationStatus) {
                                case LoggedInOwner: 
                                case LoggedInAdministrator: {
                                    break;
                                }
                                case LoggedInNotOwner: 
                                case LoggedInNotAdministrator: {
                                    enable_or_disable = "disabled=\"disabled\"";
                                    String userid = DuccWebSessionManager.getInstance().getUserId(request);
                                    boolean administrator = DuccWebAdministrators.getInstance().isAdministrator(userid);
                                    if (administrator) {
                                        hint = "title=\"Hint: use Preferences -> Role [Administrator] to activate button\"";
                                        break;
                                    }
                                    hint = "title=\"Hint: not authorized\"";
                                    break;
                                }
                                case NotLoggedIn: {
                                    break;
                                }
                            }
                        }
                        hint = enable_or_disable + " " + hint;
                        this.processSpecificationData(request, response, payload.svc, payload.meta, hint);
                        break;
                    }
                    sb.append("<tr>");
                    sb.append("<td>");
                    sb.append("not found");
                    sb.append("</td>");
                    sb.append("<td>");
                    sb.append("</td>");
                    sb.append("</tr>");
                    break;
                }
                default: {
                    sb.append("<tr>");
                    sb.append("<td>");
                    sb.append("not authorized");
                    sb.append("</td>");
                    sb.append("<td>");
                    sb.append("</td>");
                    sb.append("</tr>");
                    break;
                }
            }
        }
        catch (Exception e) {
            duccLogger.warn(methodName, null, (Throwable)e, new Object[0]);
            sb.append("no accessible data (" + e + ")");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletServiceSummaryData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletServiceSummaryData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        sb.append("<table>");
        sb.append("<tr>");
        String id = "?";
        String name = request.getParameter("name");
        String instances = "?";
        String deployments = "?";
        ServiceInterpreter.StartState startState = ServiceInterpreter.StartState.Unknown;
        boolean disabled = false;
        String disableReason = "";
        try {
            ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
            ServicesRegistryMapPayload payload = servicesRegistry.findService(name);
            if (payload != null) {
                Properties meta = payload.meta;
                Properties svc = payload.svc;
                ServiceInterpreter si = new ServiceInterpreter(svc, meta);
                id = "" + si.getId();
                instances = "" + si.getInstances();
                deployments = "" + si.getDeployments();
                startState = si.getStartState();
                disabled = si.isDisabled();
                disableReason = si.getDisableReason();
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
        sb.append("<th title=\"The system assigned id for this service\">");
        sb.append("Id: ");
        sb.append(id);
        sb.append("&nbsp");
        sb.append("<th title=\"The name for this service\">");
        sb.append("Name: ");
        sb.append(name);
        sb.append("&nbsp");
        sb.append("<th title=\"The configured number of instances for this service\">");
        sb.append("Instances: ");
        sb.append(instances);
        sb.append("&nbsp");
        sb.append("<th title=\"The number of active deployments for this service\">");
        sb.append("Deployments: ");
        sb.append(deployments);
        sb.append("&nbsp");
        sb.append("<th>");
        sb.append("StartState: ");
        sb.append(startState.name());
        sb.append("&nbsp");
        if (disabled) {
            sb.append("<th title=\"" + disableReason + "\">");
            sb.append("StartControl: ");
            sb.append("disabled");
            sb.append("&nbsp");
        }
        sb.append("</table>");
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletBrokerSummaryData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletBrokerSummaryData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        int MB = 0x100000;
        String brokerHost = "?";
        String brokerPort = "?";
        String brokerVersion = "?";
        String uptime = "?";
        Long memoryUsed = new Long(0L);
        Long memoryMax = new Long(0L);
        int threadsLive = 0;
        int threadsPeak = 0;
        double systemLoadAverage = 0.0;
        try {
            BrokerHelper brokerHelper = BrokerHelper.getInstance();
            systemLoadAverage = brokerHelper.getSystemLoadAverage();
            threadsLive = brokerHelper.getThreadsLive();
            threadsPeak = brokerHelper.getThreadsPeak();
            memoryMax = brokerHelper.getMemoryMax();
            memoryUsed = brokerHelper.getMemoryUsed();
            uptime = brokerHelper.getBrokerUptime();
            brokerVersion = brokerHelper.getBrokerVersion();
            brokerPort = "" + brokerHelper.getPort();
            brokerHost = brokerHelper.getHost();
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
        sb.append("<table>");
        StringBuffer row1 = new StringBuffer();
        StringBuffer row2 = new StringBuffer();
        StringBuffer row3 = new StringBuffer();
        row1.append("<tr>");
        row2.append("<tr>");
        row3.append("<tr>");
        String thl = "<th align=\"left\"  style=\"font-family: monospace;\">";
        String thr = "<th align=\"right\" style=\"font-family: monospace;\">";
        row1.append(thl);
        row1.append("Host: ");
        row1.append(thl);
        row1.append(brokerHost);
        row1.append("&nbsp");
        row2.append(thl);
        row2.append("Port: ");
        row2.append(thl);
        row2.append(brokerPort);
        row2.append("&nbsp");
        row3.append(thl);
        row3.append("");
        row3.append(thl);
        row3.append("");
        row3.append("&nbsp");
        row1.append(thl);
        row1.append("BrokerVersion: ");
        row1.append(thl);
        row1.append(brokerVersion);
        row1.append("&nbsp");
        row2.append(thl);
        row2.append("Uptime: ");
        row2.append(thl);
        row2.append(uptime);
        row2.append("&nbsp");
        row3.append(thl);
        row3.append("");
        row3.append(thl);
        row3.append("");
        row3.append("&nbsp");
        row1.append(thl);
        row1.append("MemoryUsed(MB): ");
        row1.append(thr);
        row1.append(memoryUsed / (long)MB);
        row1.append("&nbsp");
        row2.append(thl);
        row2.append("MemoryMax(MB): ");
        row2.append(thr);
        row2.append(memoryMax / (long)MB);
        row2.append("&nbsp");
        row3.append(thl);
        row3.append("");
        row3.append(thl);
        row3.append("");
        row3.append("&nbsp");
        row1.append(thl);
        row1.append("ThreadsLive: ");
        row1.append(thr);
        row1.append(threadsLive);
        row1.append("&nbsp");
        row2.append(thl);
        row2.append("ThreadsPeak: ");
        row2.append(thr);
        row2.append(threadsPeak);
        row2.append("&nbsp");
        row3.append(thl);
        row3.append("");
        row3.append(thl);
        row3.append("");
        row3.append("&nbsp");
        row1.append(thl);
        row1.append("SystemLoadAverage: ");
        row1.append(thr);
        row1.append(systemLoadAverage);
        row1.append("&nbsp");
        row2.append(thl);
        row2.append("");
        row2.append(thr);
        row2.append("");
        row2.append("&nbsp");
        row3.append(thl);
        row3.append("");
        row3.append(thl);
        row3.append("");
        row3.append("&nbsp");
        sb.append(row1);
        sb.append(row2);
        sb.append(row3);
        sb.append("</table>");
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonMachinesData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        List<ProcessInfo> alienPidsList;
        MachineInfo machineInfo;
        String methodName = "handleJsonServletMachinesData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        sb.append("{ ");
        sb.append("\"aaData\": [ ");
        DuccMachinesData instance = DuccMachinesData.getInstance();
        Map<MachineInfo, NodeId> sortedMachines = instance.getSortedMachines();
        Iterator<MachineInfo> iterator = sortedMachines.keySet().iterator();
        long memTotal = 0L;
        long swapInuse = 0L;
        long swapFree = 0L;
        long alienPids = 0L;
        while (iterator.hasNext()) {
            machineInfo = iterator.next();
            try {
                memTotal += Long.parseLong(machineInfo.getMemTotal());
            }
            catch (Exception e) {
                duccLogger.trace(methodName, jobid, (Throwable)e, new Object[0]);
            }
            try {
                swapInuse += Long.parseLong(machineInfo.getSwapInuse());
            }
            catch (Exception e) {
                duccLogger.trace(methodName, jobid, (Throwable)e, new Object[0]);
            }
            try {
                swapFree += Long.parseLong(machineInfo.getSwapFree());
            }
            catch (Exception e) {
                duccLogger.trace(methodName, jobid, (Throwable)e, new Object[0]);
            }
            try {
                alienPidsList = machineInfo.getAlienPids();
                if (alienPidsList == null) continue;
                alienPids += (long)alienPidsList.size();
            }
            catch (Exception e) {
                duccLogger.trace(methodName, jobid, (Throwable)e, new Object[0]);
            }
        }
        iterator = sortedMachines.keySet().iterator();
        sb.append("[");
        sb.append(this.quote("Total"));
        sb.append(",");
        sb.append(this.quote(""));
        sb.append(",");
        sb.append(this.quote(""));
        sb.append(",");
        sb.append(this.quote("" + memTotal));
        sb.append(",");
        sb.append(this.quote("" + swapInuse));
        sb.append(",");
        sb.append(this.quote("" + swapFree));
        sb.append(",");
        sb.append(this.quote("" + alienPids));
        sb.append(",");
        sb.append(this.quote(""));
        sb.append("]");
        while (iterator.hasNext()) {
            sb.append(",");
            sb.append("[");
            machineInfo = iterator.next();
            sb.append(this.quote(machineInfo.getStatus()));
            sb.append(",");
            sb.append(this.quote(machineInfo.getIp()));
            sb.append(",");
            sb.append(this.quote(machineInfo.getName()));
            sb.append(",");
            sb.append(this.quote(machineInfo.getMemTotal()));
            sb.append(",");
            sb.append(this.quote(machineInfo.getSwapInuse()));
            sb.append(",");
            sb.append(this.quote(machineInfo.getSwapFree()));
            sb.append(",");
            alienPidsList = machineInfo.getAlienPids();
            String alienPidsDisplay = "";
            if (alienPidsList != null) {
                int size = alienPidsList.size();
                if (size > 0) {
                    String entry;
                    StringBuffer aliens = new StringBuffer();
                    for (ProcessInfo processInfo : alienPidsList) {
                        String pid = processInfo.getPid();
                        String uid = processInfo.getUid();
                        aliens.append(pid + ":" + uid + " ");
                    }
                    alienPidsDisplay = entry = "<span title=\\\"" + aliens.toString().trim() + "\\\">" + size + "</span>";
                } else {
                    alienPidsDisplay = "" + size;
                }
            }
            sb.append(this.quote(alienPidsDisplay));
            sb.append(",");
            sb.append(this.quote(machineInfo.getElapsed()));
            sb.append("]");
        }
        sb.append(" ]");
        sb.append(" }");
        duccLogger.debug(methodName, null, new Object[]{sb});
        response.getWriter().println(sb);
        response.setContentType("application/json");
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletSystemAdminAdminData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletSystemAdminAdminData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        Iterator iterator = DuccWebAdministrators.getInstance().getSortedAuthorizedUserids();
        if (!iterator.hasNext()) {
            sb.append("none");
        } else {
            sb.append("<table>");
            while (iterator.hasNext()) {
                sb.append("<tr>");
                sb.append("<td>");
                sb.append((String)iterator.next());
            }
            sb.append("</table>");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletSystemAdminControlData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletSystemAdminControlData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        boolean authorized = HandlersHelper.isUserAuthorized(request, null);
        boolean accept = SystemState.getInstance().isAcceptJobs();
        String acceptMode = "disabled=disabled";
        String blockMode = "disabled=disabled";
        if (!accept) {
            if (authorized) {
                acceptMode = "";
            }
        } else if (authorized) {
            blockMode = "";
        }
        sb.append("<table>");
        sb.append("<tr>");
        sb.append("<td>");
        sb.append("<input type=\"button\" onclick=\"ducc_confirm_accept_jobs()\" value=\"Accept\" " + acceptMode + "/>");
        sb.append("<td>");
        sb.append("<input type=\"button\" onclick=\"ducc_confirm_block_jobs()\" value=\"Block\" " + blockMode + "/>");
        sb.append("<td>");
        sb.append("Jobs: ");
        sb.append("<td>");
        if (accept) {
            sb.append("<span title=\"job submit is enabled\" class=\"status_on\">");
            sb.append("accept");
            sb.append("<span>");
        } else {
            sb.append("<span title=\"job submit is disabled\" class=\"status_off\">");
            sb.append("block");
            sb.append("<span>");
        }
        sb.append("</table>");
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletSystemJobsControl(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletSystemJobsControl";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        boolean authorized = HandlersHelper.isUserAuthorized(request, null);
        if (authorized) {
            String userId = this.getUserIdFromRequest(request);
            String name = "type";
            String value = request.getParameter(name).trim();
            duccLogger.info(methodName, null, new Object[]{messages.fetchLabel("user") + userId + " " + messages.fetchLabel("type") + value});
            if (value != null) {
                if (value.equals("block")) {
                    SystemState.getInstance().resetAcceptJobs(userId);
                } else if (value.equals("accept")) {
                    SystemState.getInstance().setAcceptJobs();
                }
            }
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleServletJsonSystemClassesData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleJsonServletSystemClassesData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        sb.append("{ ");
        sb.append("\"aaData\": [ ");
        DuccSchedulerClasses schedulerClasses = DuccSchedulerClasses.getInstance();
        Map clmap = schedulerClasses.getClasses();
        boolean first = true;
        if (clmap != null) {
            DuccProperties[] class_set = clmap.values().toArray(new DuccProperties[clmap.size()]);
            Arrays.sort(class_set, new NodeConfiguration.ClassSorter());
            for (DuccProperties cl : class_set) {
                String class_name = cl.getProperty("name");
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append("[");
                sb.append(this.quote(class_name));
                sb.append(",");
                String policy = cl.getProperty("policy");
                sb.append(this.quote(policy));
                sb.append(",");
                sb.append(this.quote(cl.getStringProperty("weight", "-")));
                sb.append(",");
                sb.append(this.quote(cl.getProperty("priority")));
                String val = cl.getStringProperty("cap", "0");
                if (val == null || val.equals("0")) {
                    sb.append(",");
                    sb.append(this.quote("-"));
                    sb.append(",");
                    sb.append(this.quote("-"));
                } else if (val.endsWith("%")) {
                    sb.append(",");
                    sb.append(this.quote(val));
                    sb.append(",");
                    sb.append(this.quote("-"));
                } else {
                    sb.append(",");
                    sb.append(this.quote("-"));
                    sb.append(",");
                    sb.append(this.quote(val));
                }
                if (policy.equals("FAIR_SHARE")) {
                    val = cl.getStringProperty("initialization-cap", System.getProperty("ducc.rm.initialization.cap"));
                    if (val == null) {
                        val = "2";
                    }
                    sb.append(",");
                    sb.append(this.quote(val));
                    boolean bval = cl.getBooleanProperty("expand-by-doubling", true);
                    Boolean b = new Boolean(bval);
                    sb.append(",");
                    sb.append(this.quote(b.toString()));
                    val = cl.getStringProperty("use-prediction", System.getProperty("ducc.rm.prediction"));
                    if (val == null) {
                        val = "true";
                    }
                    sb.append(",");
                    sb.append(this.quote(val));
                    val = cl.getStringProperty("prediction-fudge", System.getProperty("ducc.rm.prediction.fudge"));
                    if (val == null) {
                        val = "10000";
                    }
                    sb.append(",");
                    sb.append(this.quote(val));
                } else {
                    sb.append(",-,-,-,-");
                }
                if (policy.equals("RESERVE")) {
                    val = cl.getProperty("max-machines");
                    if (val == null || val.equals("0")) {
                        val = "-";
                    }
                } else if (policy.equals("FIXED_SHARE")) {
                    val = cl.getStringProperty("max-properties");
                    if (val == null || val.equals("0")) {
                        val = "-";
                    }
                } else {
                    val = "-";
                }
                sb.append(",");
                sb.append(this.quote(val));
                val = cl.getStringProperty("nodepool");
                sb.append(",");
                sb.append(this.quote(val));
                sb.append("]");
            }
        }
        sb.append(" ]");
        sb.append(" }");
        duccLogger.debug(methodName, null, new Object[]{sb});
        response.getWriter().println(sb);
        response.setContentType("application/json");
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private String buildjSonjConsoleLink(String service) {
        String location = "buildjConsoleLink";
        String href = "<a href=\\\"/ducc-servlet/jconsole-link.jnlp?service=" + service + "\\\" onclick=\\\"var newWin = window.open(this.href,'" + this._window_jconsole + "','height=800,width=1200,scrollbars');  newWin.focus(); return false;\\\">" + service + "</a>";
        duccLogger.trace(location, null, new Object[]{href});
        return href;
    }

    private void handleServletJsonSystemDaemonsData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleJsonServletSystemDaemonsData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        sb.append("{ ");
        sb.append("\"aaData\": [ ");
        boolean first = true;
        for (DuccDaemonRuntimeProperties.DaemonName daemonName : DuccDaemonRuntimeProperties.daemonNames) {
            String status = "unknown";
            String heartbeat = "-1";
            String heartmax = "-1";
            Properties properties = DuccDaemonRuntimeProperties.getInstance().get(daemonName);
            switch (daemonName) {
                case Webserver: {
                    status = "up";
                    heartbeat = "0";
                    heartmax = "0";
                    break;
                }
                case Broker: {
                    boolean brokerAlive = brokerHelper.isAlive();
                    status = brokerAlive ? "up" : "down";
                    heartbeat = "0";
                    heartmax = "0";
                    break;
                }
                case Database: {
                    status = databaseHelper.isAlive() ? "up" : "down";
                    heartbeat = "0";
                    heartmax = "0";
                    break;
                }
                default: {
                    status = "unknown";
                    String hb = DuccDaemonsData.getInstance().getHeartbeat(daemonName);
                    try {
                        Long.parseLong(hb);
                        heartbeat = hb;
                        long timeout = DuccWebProperties.get_ducc_ws_monitored_daemon_down_millis_expiry() / 1000L;
                        if (timeout > 0L) {
                            long overtime = timeout - Long.parseLong(hb);
                            status = overtime < 0L ? "down" : "up";
                        }
                    }
                    catch (Throwable timeout) {
                        // empty catch block
                    }
                    String hx = DuccDaemonsData.getInstance().getMaxHeartbeat(daemonName);
                    try {
                        Long.parseLong(hx);
                        heartmax = hx;
                        break;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            String heartmaxTOD = TimeStamp.simpleFormat((String)DuccDaemonsData.getInstance().getMaxHeartbeatTOD(daemonName));
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("[");
            sb.append(this.quote(status));
            sb.append(",");
            sb.append(this.quote(this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyDaemonName, daemonName.toString())));
            sb.append(",");
            sb.append(this.quote(this.getTimeStamp(DuccCookies.getDateStyle(request), this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyBootTime, ""))));
            sb.append(",");
            sb.append(this.quote(this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeIpAddress, "")));
            sb.append(",");
            sb.append(this.quote(this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeName, "")));
            sb.append(",");
            sb.append(this.quote(this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyPid, "")));
            sb.append(",");
            Long pubSize = DuccDaemonsData.getInstance().getEventSize(daemonName);
            sb.append(this.quote("" + pubSize));
            sb.append(",");
            Long pubSizeMax = DuccDaemonsData.getInstance().getEventSizeMax(daemonName);
            sb.append(this.quote("" + pubSizeMax));
            sb.append(",");
            sb.append(this.quote(heartbeat));
            sb.append(",");
            sb.append(this.quote(heartmax));
            sb.append(",");
            try {
                heartmaxTOD = this.getTimeStamp(DuccCookies.getDateStyle(request), heartmaxTOD);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.append(this.quote(heartmaxTOD));
            sb.append(",");
            String jmxUrl = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyJmxUrl, "");
            if (jmxUrl != null) {
                sb.append(this.quote(this.buildjSonjConsoleLink(jmxUrl)));
            }
            sb.append("]");
        }
        String cookie = DuccCookies.getCookie(request, "DUCCagents");
        if (cookie.equals("show")) {
            duccLogger.trace(methodName, jobid, new Object[]{"== show: " + cookie});
            Map<MachineInfo, NodeId> machines = DuccMachinesData.getInstance().getMachines();
            for (MachineInfo machineInfo : machines.keySet()) {
                Properties properties = DuccDaemonRuntimeProperties.getInstance().getAgent(machineInfo.getShortName());
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append("[");
                String machineStatus = machineInfo.getStatus();
                String status = machineStatus.equals("down") ? machineStatus : (machineStatus.equals("up") ? machineStatus : "unknown");
                sb.append(this.quote(status));
                sb.append(",");
                String daemonName = "Agent";
                sb.append(this.quote(daemonName));
                sb.append(",");
                String bootTime = this.getTimeStamp(DuccCookies.getDateStyle(request), this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyBootTime, ""));
                sb.append(this.quote(bootTime));
                sb.append(",");
                String hostIP = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyNodeIpAddress, "");
                sb.append(this.quote(hostIP));
                sb.append(",");
                String hostName = machineInfo.getName();
                sb.append(this.quote(hostName));
                sb.append(",");
                String pid = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyPid, "");
                sb.append(this.quote(pid));
                sb.append(",");
                String publicationSizeLast = machineInfo.getPublicationSizeLast();
                sb.append(this.quote(publicationSizeLast));
                sb.append(",");
                String publicationSizeMax = machineInfo.getPublicationSizeMax();
                sb.append(this.quote(publicationSizeMax));
                sb.append(",");
                String heartbeatLast = machineInfo.getHeartbeatLast();
                sb.append(this.quote(heartbeatLast));
                sb.append(",");
                String fmtHeartbeatMax = "";
                long heartbeatMax = machineInfo.getHeartbeatMax();
                if (heartbeatMax > 0L) {
                    fmtHeartbeatMax = fmtHeartbeatMax + heartbeatMax;
                }
                sb.append(this.quote(fmtHeartbeatMax));
                sb.append(",");
                String fmtHeartbeatMaxTOD = "";
                long heartbeatMaxTOD = machineInfo.getHeartbeatMaxTOD();
                if (heartbeatMaxTOD > 0L) {
                    fmtHeartbeatMaxTOD = TimeStamp.simpleFormat((String)("" + heartbeatMaxTOD));
                    try {
                        fmtHeartbeatMaxTOD = this.getTimeStamp(DuccCookies.getDateStyle(request), fmtHeartbeatMaxTOD);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                sb.append(this.quote(fmtHeartbeatMaxTOD));
                sb.append(",");
                String fmtJmxUrl = "";
                String jmxUrl = this.getPropertiesValue(properties, DuccDaemonRuntimeProperties.keyJmxUrl, "");
                if (jmxUrl != null) {
                    fmtJmxUrl = this.buildjSonjConsoleLink(jmxUrl);
                }
                sb.append(this.quote(fmtJmxUrl));
                sb.append("]");
            }
        } else {
            duccLogger.trace(methodName, jobid, new Object[]{"!= show: " + cookie});
        }
        sb.append(" ]");
        sb.append(" }");
        duccLogger.debug(methodName, null, new Object[]{sb});
        response.getWriter().println(sb);
        response.setContentType("application/json");
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletClusterName(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletClusterName";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        IDuccWorkMap duccWorkMap = DuccData.getInstance().get();
        if (duccWorkMap.size() > 0) {
            sb.append("<span>");
            sb.append(this.getDuccWebServer().getClusterName());
            sb.append("</span>");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletClusterUtilization(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletClusterUtilization";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        DecimalFormat percentageFormatter = new DecimalFormat("##0.0");
        String utilization = "0%";
        SizeBytes sbReserve = Helper.getSummaryReserve();
        long memReserve = sbReserve.getGBytes();
        long bytesInuseJobs = DuccData.getInstance().getLive().getMemoryInuseJobs();
        long bytesInuseServices = DuccData.getInstance().getLive().getMemoryInuseServices();
        long bytesInuseReservations = DuccData.getInstance().getLive().getMemoryInuseReservations();
        SizeBytes sbInuseJobs = new SizeBytes(SizeBytes.Type.Bytes, bytesInuseJobs);
        SizeBytes sbInuseServices = new SizeBytes(SizeBytes.Type.Bytes, bytesInuseServices);
        SizeBytes sbInuseReservations = new SizeBytes(SizeBytes.Type.Bytes, bytesInuseReservations);
        long memInuseJobs = sbInuseJobs.getGBytes();
        long memInuseServices = sbInuseServices.getGBytes();
        long memInuseReservations = sbInuseReservations.getGBytes();
        long memInuseAll = memInuseJobs + memInuseServices + memInuseReservations;
        duccLogger.trace(methodName, jobid, new Object[]{"Jobs:" + memInuseJobs + " Services:" + memInuseServices + " Reservations:" + memInuseReservations});
        duccLogger.trace(methodName, jobid, new Object[]{"Inuse:" + memInuseAll + " Reserve:" + memReserve});
        long sumInuse = DuccData.getInstance().getLive().getMemoryInuse();
        SizeBytes sbInuse = new SizeBytes(SizeBytes.Type.Bytes, sumInuse);
        long memInuse = sbInuse.getGBytes();
        if (memReserve > 0L) {
            double percentage = 1.0 * (double)memInuse / (1.0 * (double)memReserve) * 100.0;
            utilization = percentageFormatter.format(percentage) + "%";
        }
        sb.append(utilization);
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletClusterReliableStatus(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletClusterReliableStatus";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String status = dh.get_ducc_head_mode();
        String head = "head=" + DuccPropertiesHelper.getDuccHead();
        String local = "local=" + InetHelper.getHostName();
        String hover = head + ' ' + local;
        if (dh.is_ducc_head_master()) {
            String text = "<span title=\"" + hover + "\">" + status + "</span>";
            sb.append(text);
        } else {
            String text = "<span>" + status + "</span>";
            sb.append(text);
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletClusterReliableLabel(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletClusterReliableLabel";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String label = "reliable:";
        if (dh.is_ducc_head_backup()) {
            String hover = "Click to visit master";
            String text = "<span title=\"" + hover + "\">" + label + "</span>";
            String host = DuccPropertiesHelper.getDuccHead();
            String link = "http://" + host + ":" + this.getDuccWebServer().getPort() + "/";
            String href = "<a href=\"" + link + "\" target=\"_ducc_master\"  >" + text + "</a>";
            sb.append(href);
        } else {
            String text = "<span>" + label + "</span>";
            sb.append(text);
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletTimeStamp(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletTimeStamp";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        DuccId jobid = null;
        StringBuffer sb = new StringBuffer(this.getTimeStamp(request, jobid, DuccData.getInstance().getPublished()));
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void addDownDaemon(StringBuffer sb, String name) {
        if (sb.length() == 0) {
            sb.append("ALERT - critical component(s) unresponsive: " + name);
        } else {
            sb.append(", " + name);
        }
    }

    private void record_disk_info(String disk_info) {
        String methodName = "record_disk_info";
        if (disk_info != null) {
            long now = System.currentTimeMillis();
            if (disk_info.equals(this.cache_disk_info)) {
                long elapsed = now - this.cache_disk_info_TOD;
                if (elapsed > this.cache_disk_info_interval) {
                    this.cache_disk_info_TOD = now;
                    duccLogger.info(methodName, jobid, new Object[]{disk_info});
                }
            } else {
                this.cache_disk_info = disk_info;
                this.cache_disk_info_TOD = now;
                duccLogger.info(methodName, jobid, new Object[]{disk_info});
            }
        }
    }

    private void handleDuccServletAlerts(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long now;
        long lifetime;
        String methodName = "handleDuccServletAlerts";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String additionalInfo = null;
        block7: for (DuccDaemonRuntimeProperties.DaemonName daemonName : DuccDaemonRuntimeProperties.daemonNames) {
            switch (daemonName) {
                case Database: {
                    String disk_info = DiagnosticsHelper.get_ducc_disk_info();
                    this.record_disk_info(disk_info);
                    if (databaseHelper.isDisabled() || databaseHelper.isAlive()) continue block7;
                    this.addDownDaemon(sb, daemonName.name());
                    additionalInfo = DiagnosticsHelper.get_ducc_disk_info();
                    continue block7;
                }
                case Broker: {
                    if (brokerHelper.isAlive()) continue block7;
                    this.addDownDaemon(sb, daemonName.name());
                    continue block7;
                }
                case Orchestrator: 
                case ProcessManager: 
                case ResourceManager: 
                case ServiceManager: {
                    long timeout = DuccWebProperties.get_ducc_ws_monitored_daemon_down_millis_expiry() / 1000L;
                    if (timeout <= 0L) continue block7;
                    try {
                        long heartbeatLast = Long.parseLong(DuccDaemonsData.getInstance().getHeartbeat(daemonName));
                        long overtime = timeout - heartbeatLast;
                        if (overtime >= 0L) continue block7;
                        this.addDownDaemon(sb, daemonName.name());
                    }
                    catch (Exception e) {
                        this.addDownDaemon(sb, daemonName.name());
                    }
                    continue block7;
                }
            }
        }
        if (additionalInfo != null && additionalInfo.trim().length() > 0) {
            sb.append("<br>");
            sb.append(additionalInfo);
        }
        String text = sb.toString();
        if (sb.length() > 0 && (lifetime = (now = System.currentTimeMillis()) - this.boottime) < this.maxTimeToBoot) {
            long timeLeft = (this.maxTimeToBoot - lifetime) / 1000L;
            text = "Webserver booting...maximum time remaining for daemons to check-in: " + timeLeft + " seconds.";
            duccLogger.debug(methodName, null, new Object[]{text});
        }
        response.getWriter().println(text);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletBannerMessage(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String message;
        String methodName = "handleDuccServletBannerMessage";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String key = "ducc.ws.banner.message";
        String value = DuccPropertiesResolver.getInstance().getFileProperty(key);
        if (value != null && (message = value.trim()).length() > 0) {
            sb.append(message);
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletReservationSchedulingClasses(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleDuccServletReservationSchedulingClasses";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        sb.append("<select id=\"scheduling_class\">");
        DuccSchedulerClasses schedulerClasses = DuccSchedulerClasses.getInstance();
        String[] class_array = schedulerClasses.getReserveClasses();
        String defaultName = schedulerClasses.getReserveClassDefaultName();
        for (int i = 0; i < class_array.length; ++i) {
            String name = class_array[i];
            if (name.equals(defaultName)) {
                sb.append("<option value=\"" + name + "\" selected=\"selected\">" + name + "</option>");
                continue;
            }
            sb.append("<option value=\"" + name + "\">" + name + "</option>");
        }
        sb.append("</select>");
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletReservationInstanceMemoryUnits(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletReservationInstanceMemoryUnits";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        sb.append("<select id=\"memory_units\">");
        sb.append("<option value=\"GB\" selected=\"selected\">GB</option>");
        sb.append("</select>");
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletReservationFormButton(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletReservationFormButton";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String button = "<button style=\"font-size:8pt; background-color:green; color:ffffff;\" onclick=\"var newWin = window.open('submit.reservation.html','" + this._window_reservation_request + "','height=600,width=550,scrollbars'); newWin.focus(); return false;\">Request<br>Reservation</button>";
        String value = DuccPropertiesResolver.getInstance().getProperty("ducc.orchestrator.unmanaged.reservations.accepted");
        Boolean result = new Boolean(value);
        if (!result.booleanValue()) {
            button = "<button title=\"System is configured to disallow reservations\" style=\"font-size:8pt;\" disabled>Request<br>Reservation</button>";
        } else if (!this.isAuthenticated(request, response)) {
            button = "<button title=\"Login to enable\" style=\"font-size:8pt;\" disabled>Request<br>Reservation</button>";
        }
        sb.append(button);
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private String getLoginRefreshHint(HttpServletRequest request, HttpServletResponse response) {
        String retVal = "";
        DuccCookies.RefreshMode refreshMode = DuccCookies.getRefreshMode(request);
        if (!this.isAuthenticated(request, response)) {
            switch (refreshMode) {
                default: {
                    retVal = "title=\"Hint: use Login to activate button and switch to Refresh = Manual\"";
                    break;
                }
                case Manual: {
                    retVal = "title=\"Hint: use Login to activate button\"";
                    break;
                }
            }
        } else {
            switch (refreshMode) {
                default: {
                    retVal = "title=\"Hint: switch to Refresh = Manual\"";
                }
                case Manual: 
            }
        }
        return retVal;
    }

    private String getDisabled() {
        String retVal = "disabled=\"disabled\"";
        return retVal;
    }

    private String getEnabledOrDisabled(HttpServletRequest request, HttpServletResponse response) {
        String retVal = "";
        DuccCookies.RefreshMode refreshMode = DuccCookies.getRefreshMode(request);
        if (!this.isAuthenticated(request, response)) {
            switch (refreshMode) {
                default: {
                    retVal = this.getDisabled();
                    break;
                }
                case Manual: {
                    retVal = this.getDisabled();
                    break;
                }
            }
        } else {
            switch (refreshMode) {
                default: {
                    retVal = this.getDisabled();
                }
                case Manual: 
            }
        }
        return retVal;
    }

    private void handleDuccServletServiceUpdateFormButton(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletServiceUpdateFormButton";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        String name = request.getParameter("name");
        StringBuffer sb = new StringBuffer();
        String hint = this.getLoginRefreshHint(request, response);
        String enable_or_disable = this.getDisabled();
        HandlersHelper.DataAccessPermission dap = HandlersHelper.getServiceAuthorization(baseRequest);
        switch (dap) {
            case Write: {
                enable_or_disable = this.getEnabledOrDisabled(request, response);
                break;
            }
        }
        String button = "<button id=\"update_button\" " + hint + " onclick=\"ducc_update_service('" + name + "')\" style=\"font-size:8pt; background-color:green; color:ffffff;\">Update</button>";
        if (enable_or_disable.length() > 0) {
            button = "<button id=\"update_button\" " + enable_or_disable + " " + hint + " style=\"font-size:8pt;\">Update</button>";
        }
        sb.append(button);
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletReservationSubmitButton(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletReservationSubmitButton";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String disabled = "disabled=\"disabled\"";
        if (this.isAuthenticated(request, response)) {
            disabled = "";
        }
        String button = "<input id=\"submit_button\" type=\"button\" onclick=\"ducc_submit_reservation()\" value=\"Submit\" " + disabled + "/>";
        sb.append(button);
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletJobSubmitButton(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletJobSubmitButton";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        String disabled = "disabled=\"disabled\"";
        if (this.isAuthenticated(request, response)) {
            disabled = "";
        }
        String button = "<input type=\"button\" onclick=\"ducc_confirm_submit_job()\" value=\"Submit\" " + disabled + "/>";
        sb.append(button);
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletFileContents(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletFileContents";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        String fname = request.getParameter("fname");
        String page = request.getParameter("page");
        StringBuffer sb = new StringBuffer();
        EffectiveUser eu = EffectiveUser.create(request);
        String newline = "\n";
        String colon = ":";
        try {
            int index;
            String[] lines;
            String file_name = fname;
            AlienTextFile atf = new AlienTextFile(eu, file_name);
            int pageCount = atf.getPageCount();
            int pageNo = 0;
            try {
                pageNo = Integer.parseInt(page);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pageNo == 0) {
                pageNo = pageCount;
            }
            if (--pageNo < 0) {
                pageNo = 0;
            }
            String prepend = "";
            String chunk = atf.getPage(pageNo);
            String postpend = "";
            if (pageNo > 0) {
                String previous = atf.getPage(pageNo - 1);
                if (previous.contains(newline)) {
                    lines = previous.split(newline);
                    index = lines.length - 1;
                    prepend = lines[index];
                } else if (previous.contains(colon)) {
                    lines = previous.split(colon);
                    index = lines.length - 1;
                    prepend = lines[index];
                }
            }
            if (pageNo < pageCount - 1) {
                String next = atf.getPage(pageNo + 1);
                if (next.contains(newline)) {
                    lines = next.split(newline);
                    index = 0;
                    postpend = lines[index];
                }
                if (next.contains(colon)) {
                    lines = next.split(colon);
                    index = 0;
                    postpend = lines[index];
                }
            }
            String aggregate = prepend + chunk + postpend;
            sb.append("<pre>");
            sb.append(aggregate);
            sb.append("</pre>");
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
            sb = new StringBuffer();
            sb.append("Error processing file");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDuccServletLogData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletLogData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<link rel=\"shortcut icon\" href=\"../ducc.ico\" />");
        sb.append("<title>ducc-mon</title>");
        sb.append("<meta http-equiv=\"CACHE-CONTROL\" content=\"NO-CACHE\">");
        String loc = request.getParameter("loc");
        if (loc != null && loc.equals("bot")) {
            String js = "<script src=\"../js/scroll-to-bottom.js\"></script>";
            sb.append(js);
        }
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<h3>");
        String fname = request.getParameter("fname");
        sb.append(fname);
        sb.append("</h3>");
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String logLine;
            EffectiveUser eu = EffectiveUser.create(request);
            isr = DuccFile.getInputStreamReader(eu, fname);
            br = new BufferedReader(isr);
            while ((logLine = br.readLine()) != null) {
                sb.append(logLine + "<br>");
            }
        }
        catch (FileNotFoundException e) {
            sb.append("File not found");
        }
        catch (Throwable t) {
            sb.append("Error accessing file");
        }
        finally {
            try {
                br.close();
            }
            catch (Throwable e) {}
            try {
                isr.close();
            }
            catch (Throwable e) {}
        }
        sb.append("</body>");
        sb.append("</html>");
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletJpInitSummary(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletJpInitSummary";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        String idJob = request.getParameter(this.pname_idJob);
        String idPro = request.getParameter(this.pname_idPro);
        StringBuffer sb = new StringBuffer();
        sb.append("<b>");
        sb.append("Id[job]:");
        sb.append(" ");
        sb.append(idJob);
        sb.append(" ");
        sb.append("Id[process]:");
        sb.append(" ");
        sb.append(idPro);
        sb.append("</b>");
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletJpInitData(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        List upcList;
        IDuccProcess process;
        String methodName = "handleDuccServletJpInitData";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        String idJob = request.getParameter(this.pname_idJob);
        String idPro = request.getParameter(this.pname_idPro);
        StringBuffer sb = new StringBuffer();
        IDuccWorkMap duccWorkMap = DuccData.getInstance().get();
        DuccWorkJob job = null;
        if (duccWorkMap.getJobKeySet().size() > 0) {
            Iterator iterator = null;
            for (DuccId jobId : duccWorkMap.getJobKeySet()) {
                String fid = "" + jobId.getFriendly();
                if (!idJob.equals(fid)) continue;
                job = (DuccWorkJob)duccWorkMap.findDuccWork(jobId);
                break;
            }
        }
        if (job != null && (process = job.getProcess(idPro)) != null && (upcList = process.getUimaPipelineComponents()) != null && !upcList.isEmpty()) {
            for (IUimaPipelineAEComponent upc : upcList) {
                String iName = upc.getAeName();
                String iState = upc.getAeState().toString();
                String iTime = FormatHelper.duration(upc.getInitializationTime(), FormatHelper.Precision.Whole);
                sb.append("<tr>");
                sb.append("<td>" + iName);
                sb.append("<td>" + iState);
                sb.append("<td align=\"right\">" + iTime);
            }
        }
        if (sb.length() == 0) {
            sb.append("<tr>");
            sb.append("<td>no accessible data (not logged in?)");
            sb.append("<td>");
            sb.append("<td>");
        }
        response.getWriter().println(sb);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletjConsoleLink(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String location = "handleDuccServletjConsoleLink";
        String host = "" + request.getLocalAddr();
        String port = "" + request.getLocalPort();
        String service = request.getParameter("service");
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<jnlp spec=\"1.0+\" codebase=\"http://" + host + ":" + port + "/lib/webstart\">");
        sb.append("  <information>");
        sb.append("    <title>JConsole</title>");
        sb.append("    <vendor>DUCC</vendor>");
        sb.append("  </information>");
        sb.append("  <security>");
        sb.append("    <all-permissions/>");
        sb.append("  </security>");
        sb.append("  <resources>");
        sb.append("    <j2se version=\"1.6+\" />");
        sb.append("    <jar href=\"jconsole-wrapper-signed.jar\" main=\"true\"/>");
        sb.append("  </resources>");
        sb.append("  <application-desc main-class=\"org.apache.uima.ducc.ws.jconsole.JConsoleWrapper\">");
        sb.append("    <argument>" + service + "</argument>");
        sb.append("  </application-desc>");
        sb.append("</jnlp>");
        duccLogger.trace(location, null, new Object[]{sb});
        response.getWriter().println(sb);
        response.setContentType("application/x-java-jnlp-file");
    }

    private void handleDuccServletJobSubmit(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletJobSubmit";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        if (this.isAuthenticated(request, response)) {
            duccLogger.info(methodName, null, new Object[]{messages.fetch("function not supported")});
        } else {
            duccLogger.warn(methodName, null, new Object[]{messages.fetch("user not authenticated")});
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletJobCancel(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletJobCancel";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        try {
            String name = "id";
            String value = request.getParameter(name).trim();
            duccLogger.info(methodName, null, new Object[]{messages.fetchLabel("cancel") + value});
            DuccData duccData = DuccData.getInstance();
            IDuccWorkMap duccWorkMap = duccData.get();
            IDuccWorkJob duccWorkJob = (IDuccWorkJob)duccWorkMap.findDuccWork(IDuccTypes.DuccType.Job, value);
            if (duccWorkJob != null) {
                String resourceOwnerUserId = duccWorkJob.getStandardInfo().getUser().trim();
                if (HandlersHelper.isUserAuthorized(request, resourceOwnerUserId)) {
                    String arg1 = "-" + name;
                    String arg2 = value;
                    String arg3 = "--" + SpecificationProperties.key_reason;
                    String reason = CancelReasons.CancelReason.TerminateButtonPressed.getText();
                    String arg4 = "\"" + reason + "\"";
                    String userId = this.getUserIdFromRequest(request);
                    String cp = System.getProperty("java.class.path");
                    String java = "/bin/java";
                    String jclass = "org.apache.uima.ducc.cli.DuccJobCancel";
                    String jhome = System.getProperty("java.home");
                    DuccCookies.RequestRole requestRole = DuccCookies.getRole(request);
                    switch (requestRole) {
                        case Administrator: {
                            String arg5 = "--" + SpecificationProperties.key_role_administrator;
                            String[] arglistAdministrator = new String[]{"-u", userId, "--", jhome + java, "-cp", cp, jclass, arg1, arg2, arg3, arg4, arg5};
                            String result = DuccAsUser.duckling(userId, arglistAdministrator);
                            response.getWriter().println(result);
                            break;
                        }
                        default: {
                            String[] arglistUser = new String[]{"-u", userId, "--", jhome + java, "-cp", cp, jclass, arg1, arg2, arg3, arg4};
                            String result = DuccAsUser.duckling(userId, arglistUser);
                            response.getWriter().println(result);
                        }
                    }
                }
            } else {
                String text = "job " + value + " not found";
                duccLogger.debug(methodName, null, new Object[]{messages.fetch(text)});
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletReservationSubmit(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletReservationSubmit";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        if (this.isAuthenticated(request, response)) {
            String scheduling_class = request.getParameter("scheduling_class");
            duccLogger.debug(methodName, null, new Object[]{"scheduling_class:" + scheduling_class});
            String memory_size = request.getParameter("memory_size");
            duccLogger.debug(methodName, null, new Object[]{"memory_size:" + memory_size});
            String memory_units = request.getParameter("memory_units");
            duccLogger.debug(methodName, null, new Object[]{"memory_units:" + memory_units});
            String description = request.getParameter("description");
            duccLogger.debug(methodName, null, new Object[]{"description:" + description});
            String arg1 = "";
            String arg2 = "";
            if (scheduling_class != null) {
                arg1 = "--scheduling_class";
                arg2 = scheduling_class;
            }
            String arg3 = "";
            String arg4 = "";
            if (memory_size != null) {
                arg3 = "--memory_size";
                arg4 = memory_units != null ? memory_size + memory_units : memory_size;
            }
            String arg5a = "--wait_for_completion";
            String arg5b = "false";
            String arg6a = "--cancel_on_interrupt";
            String arg6b = "false";
            String arg7 = "";
            String arg8 = "";
            if (description != null) {
                arg7 = "--description";
                arg8 = description;
            }
            try {
                String userId = this.getUserIdFromRequest(request);
                String cp = System.getProperty("java.class.path");
                String java = "/bin/java";
                String jclass = "org.apache.uima.ducc.cli.DuccReservationSubmit";
                String jhome = System.getProperty("java.home");
                String[] arglist = new String[]{"-u", userId, "--", jhome + java, "-cp", cp, jclass, arg1, arg2, arg3, arg4, arg5a, arg5b, arg6a, arg6b, arg7, arg8};
                String result = DuccAsUser.duckling(userId, arglist);
                response.getWriter().println(result);
            }
            catch (Exception e) {
                duccLogger.error(methodName, null, (Throwable)e, new Object[0]);
            }
        } else {
            duccLogger.warn(methodName, null, new Object[]{messages.fetch("user not authenticated")});
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletReservationCancel(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletReservationCancel";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        try {
            String name = "id";
            String value = request.getParameter(name).trim();
            duccLogger.info(methodName, null, new Object[]{messages.fetchLabel("cancel") + value});
            DuccData duccData = DuccData.getInstance();
            IDuccWork dw = duccData.getReservation(value);
            if (dw != null) {
                String resourceOwnerUserId = dw.getStandardInfo().getUser().trim();
                if (HandlersHelper.isUserAuthorized(request, resourceOwnerUserId)) {
                    String arg1 = "-" + name;
                    String arg2 = value;
                    String userId = this.getUserIdFromRequest(request);
                    String cp = System.getProperty("java.class.path");
                    String java = "/bin/java";
                    String jclass = "org.apache.uima.ducc.cli.DuccReservationCancel";
                    if (dw instanceof IDuccWorkJob) {
                        jclass = "org.apache.uima.ducc.cli.DuccManagedReservationCancel";
                    }
                    String jhome = System.getProperty("java.home");
                    DuccCookies.RequestRole requestRole = DuccCookies.getRole(request);
                    switch (requestRole) {
                        case Administrator: {
                            String arg3 = "--" + SpecificationProperties.key_role_administrator;
                            String[] arglistAdministrator = new String[]{"-u", userId, "--", jhome + java, "-cp", cp, jclass, arg1, arg2, arg3};
                            String result = DuccAsUser.duckling(userId, arglistAdministrator);
                            response.getWriter().println(result);
                            break;
                        }
                        default: {
                            String[] arglistUser = new String[]{"-u", userId, "--", jhome + java, "-cp", cp, jclass, arg1, arg2};
                            String result = DuccAsUser.duckling(userId, arglistUser);
                            response.getWriter().println(result);
                        }
                    }
                }
            } else {
                String text = "reservation " + value + " not found";
                duccLogger.debug(methodName, null, new Object[]{messages.fetch(text)});
                response.getWriter().println(text);
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletServiceSubmit(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletServiceSubmit";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        if (!this.isAuthenticated(request, response)) {
            duccLogger.warn(methodName, null, new Object[]{messages.fetch("user not authenticated")});
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletServiceCancel(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName;
        block9: {
            methodName = "handleDuccServletServiceCancel";
            duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
            if (this.isAuthenticated(request, response)) {
                try {
                    String name = "id";
                    String value = request.getParameter(name).trim();
                    duccLogger.info(methodName, null, new Object[]{messages.fetchLabel("cancel") + value});
                    DuccData duccData = DuccData.getInstance();
                    IDuccWorkMap duccWorkMap = duccData.get();
                    IDuccWorkJob duccWorkJob = (IDuccWorkJob)duccWorkMap.findDuccWork(IDuccTypes.DuccType.Service, value);
                    if (duccWorkJob != null) {
                        String resourceOwnerUserId = duccWorkJob.getStandardInfo().getUser().trim();
                        if (HandlersHelper.isUserAuthorized(request, resourceOwnerUserId)) {
                            String arg1 = "-" + name;
                            String arg2 = value;
                            String userId = this.getUserIdFromRequest(request);
                            String cp = System.getProperty("java.class.path");
                            String java = "/bin/java";
                            String jclass = "org.apache.uima.ducc.cli.DuccServiceCancel";
                            String jhome = System.getProperty("java.home");
                            DuccCookies.RequestRole requestRole = DuccCookies.getRole(request);
                            switch (requestRole) {
                                case Administrator: {
                                    String arg3 = "--" + SpecificationProperties.key_role_administrator;
                                    String[] arglistAdministrator = new String[]{"-u", userId, "--", jhome + java, "-cp", cp, jclass, arg1, arg2, arg3};
                                    String result = DuccAsUser.duckling(userId, arglistAdministrator);
                                    response.getWriter().println(result);
                                    break;
                                }
                                default: {
                                    String[] arglistUser = new String[]{"-u", userId, "--", jhome + java, "-cp", cp, jclass, arg1, arg2};
                                    String result = DuccAsUser.duckling(userId, arglistUser);
                                    response.getWriter().println(result);
                                }
                            }
                        }
                        break block9;
                    }
                    String text = "job " + value + " not found";
                    duccLogger.debug(methodName, null, new Object[]{messages.fetch(text)});
                }
                catch (Exception e) {
                    duccLogger.error(methodName, null, (Throwable)e, new Object[0]);
                }
            } else {
                duccLogger.warn(methodName, null, new Object[]{messages.fetch("user not authenticated")});
            }
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void duccServletServiceCommand(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response, String command, ArrayList<String> parms) {
        String methodName = "duccServletServiceCommand";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        try {
            String name = "id";
            String value = request.getParameter(name).trim();
            duccLogger.info(methodName, null, new Object[]{command + " " + messages.fetchLabel("name:") + value});
            name = value.trim();
            ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
            ServicesRegistryMapPayload payload = servicesRegistry.findService(name);
            if (payload != null) {
                Properties properties = payload.meta;
                String id = properties.getProperty(IServicesRegistry.numeric_id);
                String resourceOwnerUserId = servicesRegistry.findServiceUser(id);
                if (resourceOwnerUserId != null) {
                    if (HandlersHelper.isUserAuthorized(request, resourceOwnerUserId)) {
                        String arg1 = "--" + command;
                        String arg2 = id;
                        String userId = this.getUserIdFromRequest(request);
                        String cp = System.getProperty("java.class.path");
                        String java = "/bin/java";
                        String jclass = "org.apache.uima.ducc.cli.DuccServiceApi";
                        String jhome = System.getProperty("java.home");
                        DuccCookies.RequestRole requestRole = DuccCookies.getRole(request);
                        ArrayList<String> arglist = new ArrayList<String>();
                        arglist.add("-u");
                        arglist.add(userId);
                        arglist.add("--");
                        arglist.add(jhome + java);
                        arglist.add("-cp");
                        arglist.add(cp);
                        arglist.add(jclass);
                        switch (requestRole) {
                            case Administrator: {
                                String arg0 = "--" + SpecificationProperties.key_role_administrator;
                                arglist.add(arg0);
                                break;
                            }
                        }
                        arglist.add(arg1);
                        arglist.add(arg2);
                        for (String parm : parms) {
                            arglist.add(parm);
                        }
                        String[] arglistUser = arglist.toArray(new String[0]);
                        String result = DuccAsUser.duckling(userId, arglistUser);
                        response.getWriter().println(result);
                    }
                } else {
                    String text = "name " + value + " not found";
                    duccLogger.debug(methodName, null, new Object[]{messages.fetch(text)});
                }
            } else {
                String text;
                String result = text = "name " + value + " not found";
                duccLogger.debug(methodName, null, new Object[]{messages.fetch(text)});
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private String duccServletServiceCommand(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response, String command) {
        String methodName = "duccServletServiceCommand";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        String result = null;
        try {
            String name = "id";
            String value = request.getParameter(name).trim();
            duccLogger.info(methodName, null, new Object[]{command + " " + messages.fetchLabel("id:") + value});
            String id = value.trim();
            String userId = this.getUserIdFromRequest(request);
            String serviceId = id;
            if (HandlersHelper.isLoggedIn(request)) {
                if (HandlersHelper.isServiceController(userId, serviceId)) {
                    String arg1 = "--" + command;
                    String arg2 = id;
                    String cp = System.getProperty("java.class.path");
                    String java = "/bin/java";
                    String jclass = "org.apache.uima.ducc.cli.DuccServiceApi";
                    String jhome = System.getProperty("java.home");
                    DuccCookies.RequestRole requestRole = DuccCookies.getRole(request);
                    switch (requestRole) {
                        case Administrator: {
                            String arg3 = "--" + SpecificationProperties.key_role_administrator;
                            CharSequence[] arglistAdministrator = new String[]{"-u", userId, "--", jhome + java, "-cp", cp, jclass, arg1, arg2, arg3};
                            duccLogger.debug(methodName, null, new Object[]{String.join((CharSequence)" ", arglistAdministrator)});
                            result = DuccAsUser.duckling(userId, (String[])arglistAdministrator);
                            duccLogger.debug(methodName, null, new Object[]{result});
                            response.getWriter().println(result);
                            break;
                        }
                        default: {
                            CharSequence[] arglistUser = new String[]{"-u", userId, "--", jhome + java, "-cp", cp, jclass, arg1, arg2};
                            duccLogger.debug(methodName, null, new Object[]{String.join((CharSequence)" ", arglistUser)});
                            result = DuccAsUser.duckling(userId, (String[])arglistUser);
                            duccLogger.debug(methodName, null, new Object[]{result});
                            response.getWriter().println(result);
                            break;
                        }
                    }
                } else {
                    duccLogger.debug(methodName, null, new Object[]{"not logged in"});
                }
            } else {
                duccLogger.debug(methodName, null, new Object[]{"not service controller"});
            }
        }
        catch (Exception e) {
            duccLogger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
        return result;
    }

    private void handleDuccServletServiceEnable(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletServiceEnable";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        String result = this.duccServletServiceCommand(target, baseRequest, request, response, "enable");
        boolean updateCache = true;
        if (updateCache && result != null && result.contains("success")) {
            String name = "id";
            String id = request.getParameter(name).trim();
            Integer sid = Integer.valueOf(id);
            ServicesSortCache.getInstance().setEnabled(sid);
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletServiceStart(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletServiceStart";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        this.duccServletServiceCommand(target, baseRequest, request, response, "start");
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletServiceStop(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletServiceStop";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        this.duccServletServiceCommand(target, baseRequest, request, response, "stop");
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccServletServiceUpdate(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleDuccServletServiceUpdate";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        String instances = request.getParameter("instances");
        String autostart = request.getParameter("autostart");
        ArrayList<String> parms = new ArrayList<String>();
        parms.add("--instances");
        parms.add(instances);
        parms.add("--autostart");
        parms.add(autostart);
        this.duccServletServiceCommand(target, baseRequest, request, response, "modify", parms);
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccRequest(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleDuccRequest";
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        duccLogger.debug(methodName, null, new Object[]{request.toString()});
        duccLogger.debug(methodName, null, new Object[]{"getRequestURI():" + request.getRequestURI()});
        String reqURI = request.getRequestURI() + "";
        if (reqURI.startsWith("/ducc-servlet")) {
            response.setContentType("text/html;charset=utf-8");
            response.setStatus(200);
            baseRequest.setHandled(true);
            if (reqURI.startsWith(this.duccVersion)) {
                this.handleDuccServletVersion(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.duccHome)) {
                this.handleDuccServletHome(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.duccHostname)) {
                this.handleDuccServletHostname(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.duccAuthenticationStatus)) {
                this.handleDuccServletAuthenticationStatus(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccAuthenticatorVersion)) {
                this.handleDuccServletAuthenticatorVersion(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.duccAuthenticatorNotes)) {
                this.handleDuccServletAuthenticatorNotes(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccAuthenticatorPasswordChecked)) {
                this.handleDuccServletduccAuthenticatorPasswordChecked(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.duccLoginLink)) {
                this.handleDuccServletLoginLink(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.duccLogoutLink)) {
                this.handleDuccServletLogoutLink(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.duccClusterReliableStatus)) {
                this.handleDuccServletClusterReliableStatus(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.duccClusterReliableLabel)) {
                this.handleDuccServletClusterReliableLabel(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.duccJobIdData)) {
                this.handleDuccServletJobIdData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccJobWorkitemsCountData)) {
                this.handleDuccServletJobWorkitemsCountData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccJobProcessesData)) {
                this.handleDuccServletJobProcessesData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccJobWorkitemsData)) {
                this.handleDuccServletJobWorkitemsData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccJobPerformanceData)) {
                this.handleDuccServletJobPerformanceData(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.duccJobSpecificationData)) {
                this.handleDuccServletJobSpecificationData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccJobFilesData)) {
                this.handleDuccServletJobFilesData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccReservationFilesData)) {
                this.handleDuccServletReservationFilesData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccServiceFilesData)) {
                this.handleDuccServletServiceFilesData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccServiceHistoryData)) {
                this.handleDuccServletServiceHistoryData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccJobInitializationFailData)) {
                this.handleDuccServletJobInitializationFailData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccJobRuntimeFailData)) {
                this.handleDuccServletJobRuntimeFailData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccReservationProcessesData)) {
                this.handleDuccServletReservationProcessesData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccReservationSpecificationData)) {
                this.handleDuccServletReservationSpecificationData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccServicesRecordsCeiling)) {
                this.handleDuccServletServicesRecordsCeilingData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccServiceDeploymentsData)) {
                this.handleDuccServletServiceDeploymentsData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccServiceRegistryData)) {
                this.handleDuccServletServiceRegistryData(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.duccServiceSummaryData)) {
                this.handleDuccServletServiceSummaryData(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.duccBrokerSummaryData)) {
                this.handleDuccServletBrokerSummaryData(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.jsonMachinesData)) {
                this.handleServletJsonMachinesData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccSystemAdminAdminData)) {
                this.handleDuccServletSystemAdminAdminData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccSystemAdminControlData)) {
                this.handleDuccServletSystemAdminControlData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccSystemJobsControl)) {
                this.handleDuccServletSystemJobsControl(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.jsonSystemClassesData)) {
                this.handleServletJsonSystemClassesData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.jsonSystemDaemonsData)) {
                this.handleServletJsonSystemDaemonsData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccClusterName)) {
                this.handleDuccServletClusterName(target, baseRequest, request, response);
            } else if (reqURI.startsWith(this.duccClusterUtilization)) {
                this.handleDuccServletClusterUtilization(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccTimeStamp)) {
                this.handleDuccServletTimeStamp(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccAlerts)) {
                this.handleDuccServletAlerts(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccBannerMessage)) {
                this.handleDuccServletBannerMessage(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccJobSubmit)) {
                duccLogger.info(methodName, null, new Object[]{"getRequestURI():" + request.getRequestURI()});
                this.handleDuccServletJobSubmit(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccJobCancel)) {
                duccLogger.info(methodName, null, new Object[]{"getRequestURI():" + request.getRequestURI()});
                this.handleDuccServletJobCancel(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccReservationSubmit)) {
                duccLogger.info(methodName, null, new Object[]{"getRequestURI():" + request.getRequestURI()});
                this.handleDuccServletReservationSubmit(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccReservationCancel)) {
                duccLogger.info(methodName, null, new Object[]{"getRequestURI():" + request.getRequestURI()});
                this.handleDuccServletReservationCancel(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccServiceSubmit)) {
                duccLogger.info(methodName, null, new Object[]{"getRequestURI():" + request.getRequestURI()});
                this.handleDuccServletServiceSubmit(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccServiceCancel)) {
                duccLogger.info(methodName, null, new Object[]{"getRequestURI():" + request.getRequestURI()});
                this.handleDuccServletServiceCancel(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccServiceEnable)) {
                duccLogger.info(methodName, null, new Object[]{"getRequestURI():" + request.getRequestURI()});
                this.handleDuccServletServiceEnable(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccServiceStart)) {
                duccLogger.info(methodName, null, new Object[]{"getRequestURI():" + request.getRequestURI()});
                this.handleDuccServletServiceStart(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccServiceStop)) {
                duccLogger.info(methodName, null, new Object[]{"getRequestURI():" + request.getRequestURI()});
                this.handleDuccServletServiceStop(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccServiceUpdate)) {
                duccLogger.info(methodName, null, new Object[]{"getRequestURI():" + request.getRequestURI()});
                this.handleDuccServletServiceUpdate(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccReservationSchedulingClasses)) {
                this.handleDuccServletReservationSchedulingClasses(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccReservationInstanceMemoryUnits)) {
                this.handleDuccServletReservationInstanceMemoryUnits(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccJobSubmitButton)) {
                this.handleDuccServletJobSubmitButton(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccReservationSubmitButton)) {
                this.handleDuccServletReservationSubmitButton(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccReservationFormButton)) {
                this.handleDuccServletReservationFormButton(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccServiceUpdateFormButton)) {
                this.handleDuccServletServiceUpdateFormButton(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith("/ducc-servlet/log-data")) {
                this.handleDuccServletLogData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith(this.duccFileContents)) {
                this.handleDuccServletFileContents(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith("/ducc-servlet/uima-initialization-report-summary")) {
                this.handleDuccServletJpInitSummary(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith("/ducc-servlet/uima-initialization-report-data")) {
                this.handleDuccServletJpInitData(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            } else if (reqURI.startsWith("/ducc-servlet/jconsole-link.jnlp")) {
                this.handleDuccServletjConsoleLink(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            }
        }
        duccLogger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handle";
        try {
            this.handleDuccRequest(target, baseRequest, request, response);
        }
        catch (Throwable t) {
            if (this.isIgnorable(t)) {
                duccLogger.debug(methodName, jobid, t, new Object[0]);
            }
            duccLogger.info(methodName, jobid, new Object[]{"", t.getMessage(), t});
            duccLogger.error(methodName, jobid, t, new Object[0]);
        }
    }

    private static enum DetailsType {
        Job,
        Reservation,
        Service;

    }
}

