/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.helper;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.uima.ducc.common.db.DbHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.db.DbQuery;
import org.apache.uima.ducc.ws.helper.JmxHelper;

public class DatabaseHelper
extends JmxHelper {
    private static DuccLogger logger = DuccLogger.getLogger(DatabaseHelper.class);
    private static DuccId jobid = null;
    private static DatabaseHelper instance = null;
    protected boolean enabled = false;
    protected String[] host_list = null;

    public static DatabaseHelper getInstance() {
        if (instance == null) {
            instance = new DatabaseHelper();
        }
        return instance;
    }

    private DatabaseHelper() {
        this.init();
    }

    private void init() {
        String location = "init";
        try {
            this.host_list = DbHelper.getHostList();
            this.enabled = DbHelper.isDbEnabled();
            if (this.enabled) {
                String jmx_host = DbHelper.getJxmHostString();
                this.setJmxHost(jmx_host);
                Integer jmx_port = DbHelper.getJxmPortInteger();
                this.setJmxPort(jmx_port);
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    public String getHostListString() {
        StringBuffer sb = new StringBuffer();
        for (String host : this.host_list) {
            sb.append(host);
            sb.append(" ");
        }
        String retVal = sb.toString().trim();
        return retVal;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public boolean isAlive() {
        boolean retVal = DbQuery.getInstance().isUp();
        return retVal;
    }

    public Long getStartTime() {
        String location = "getStartTime";
        Long retVal = new Long(0L);
        Object o = null;
        MBeanServerConnection mbsc = null;
        try {
            mbsc = this.getMBSC();
            o = mbsc.getAttribute(new ObjectName("java.lang:type=Runtime"), "StartTime");
            retVal = (Long)o;
        }
        catch (Exception e) {
            try {
                this.connect();
                mbsc = this.getMBSC();
                o = mbsc.getAttribute(new ObjectName("java.lang:type=Runtime"), "StartTime");
                this.disconnect();
                retVal = (Long)o;
            }
            catch (Exception e2) {
                logger.error(location, jobid, (Throwable)e2, new Object[0]);
            }
        }
        return retVal;
    }
}

