/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.common.boot.DuccDaemonRuntimeProperties;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.transport.event.AbstractDuccEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.ws.server.DuccWebProperties;

public class DuccDaemonsData {
    private static DuccLogger duccLogger = DuccLogger.getLogger(DuccDaemonsData.class);
    private static DuccDaemonsData duccDaemonsData = new DuccDaemonsData();
    private static ConcurrentHashMap<DuccDaemonRuntimeProperties.DaemonName, String> mapCurr = new ConcurrentHashMap();
    private static ConcurrentHashMap<DuccDaemonRuntimeProperties.DaemonName, String> mapPrev = new ConcurrentHashMap();
    private static ConcurrentHashMap<DuccDaemonRuntimeProperties.DaemonName, String> mapMax = new ConcurrentHashMap();
    private static ConcurrentHashMap<DuccDaemonRuntimeProperties.DaemonName, String> mapMaxTOD = new ConcurrentHashMap();
    private static ConcurrentHashMap<DuccDaemonRuntimeProperties.DaemonName, Long> eventSize = new ConcurrentHashMap();
    private static ConcurrentHashMap<DuccDaemonRuntimeProperties.DaemonName, Long> eventSizeMax = new ConcurrentHashMap();
    private static ConcurrentHashMap<DuccDaemonRuntimeProperties.DaemonName, String> eventSizeMaxTOD = new ConcurrentHashMap();

    public static DuccDaemonsData getInstance() {
        return duccDaemonsData;
    }

    public void put(AbstractDuccEvent duccEvent) {
        DuccEvent.EventType eventType = duccEvent.getEventType();
        switch (eventType) {
            case ORCHESTRATOR_STATE: {
                DuccDaemonRuntimeProperties.DaemonName key = DuccDaemonRuntimeProperties.DaemonName.Orchestrator;
                this.putHeartbeat(key);
                this.putEventSize(key, duccEvent);
                break;
            }
            case PM_STATE: {
                DuccDaemonRuntimeProperties.DaemonName key = DuccDaemonRuntimeProperties.DaemonName.ProcessManager;
                this.putHeartbeat(key);
                this.putEventSize(key, duccEvent);
                break;
            }
            case RM_STATE: {
                DuccDaemonRuntimeProperties.DaemonName key = DuccDaemonRuntimeProperties.DaemonName.ResourceManager;
                this.putHeartbeat(key);
                this.putEventSize(key, duccEvent);
                break;
            }
            case SM_STATE: 
            case SM_HEARTBEAT: {
                DuccDaemonRuntimeProperties.DaemonName key = DuccDaemonRuntimeProperties.DaemonName.ServiceManager;
                this.putHeartbeat(key);
                this.putEventSize(key, duccEvent);
                break;
            }
            case WEBSERVER_STATE: {
                DuccDaemonRuntimeProperties.DaemonName key = DuccDaemonRuntimeProperties.DaemonName.Webserver;
                this.putHeartbeat(key);
                this.putEventSize(key, duccEvent);
                break;
            }
        }
    }

    public void putEventSize(DuccDaemonRuntimeProperties.DaemonName key, AbstractDuccEvent duccEvent) {
        Long size = duccEvent.getEventSize();
        eventSize.put(key, size);
        Long prev = eventSizeMax.containsKey(key) ? eventSizeMax.get(key) : new Long(0L);
        if (size > prev) {
            eventSizeMax.put(key, size);
            String timestamp = TimeStamp.getCurrentMillis();
            eventSizeMaxTOD.put(key, timestamp);
        }
    }

    public Long getEventSize(DuccDaemonRuntimeProperties.DaemonName key) {
        Long retVal = new Long(0L);
        if (eventSize.containsKey(key)) {
            retVal = eventSize.get(key);
        }
        return retVal;
    }

    public Long getEventSizeMax(DuccDaemonRuntimeProperties.DaemonName key) {
        Long retVal = new Long(0L);
        if (eventSizeMax.containsKey(key)) {
            retVal = eventSizeMax.get(key);
        }
        return retVal;
    }

    public String getEventSizeMaxTOD(DuccDaemonRuntimeProperties.DaemonName key) {
        String retVal = "";
        if (mapMaxTOD.containsKey(key)) {
            retVal = eventSizeMaxTOD.get(key);
        }
        return retVal;
    }

    public void putHeartbeat(DuccDaemonRuntimeProperties.DaemonName key) {
        String timestamp = TimeStamp.getCurrentMillis();
        if (mapPrev.containsKey(key)) {
            String t0 = mapPrev.get(key);
            String t1 = timestamp;
            long millis = TimeStamp.diffMillis((String)t1, (String)t0);
            if (mapMax.containsKey(key)) {
                long max = Long.parseLong(mapMax.get(key));
                if (millis > max) {
                    mapMax.put(key, "" + millis);
                    mapMaxTOD.put(key, t1);
                }
            } else {
                mapMax.put(key, "" + millis);
                mapMaxTOD.put(key, t1);
            }
        }
        if (mapCurr.containsKey(key)) {
            mapPrev.put(key, mapCurr.get(key));
        }
        mapCurr.put(key, timestamp);
    }

    public String getHeartbeat(DuccDaemonRuntimeProperties.DaemonName key) {
        String retVal = "";
        if (mapCurr.containsKey(key)) {
            String t1 = TimeStamp.getCurrentMillis();
            String t0 = mapCurr.get(key);
            long millis = TimeStamp.diffMillis((String)t1, (String)t0);
            retVal = "" + millis / 1000L;
        }
        return retVal;
    }

    public String getMaxHeartbeat(DuccDaemonRuntimeProperties.DaemonName key) {
        String retVal = "";
        if (mapMax.containsKey(key)) {
            long max = Long.parseLong(mapMax.get(key));
            retVal = "" + max / 1000L;
        }
        return retVal;
    }

    public String getMaxHeartbeatTOD(DuccDaemonRuntimeProperties.DaemonName key) {
        String retVal = "";
        if (mapMaxTOD.containsKey(key)) {
            retVal = mapMaxTOD.get(key);
        }
        return retVal;
    }

    private long getWsTod() {
        long retVal = Long.MAX_VALUE;
        DuccDaemonRuntimeProperties.DaemonName key = DuccDaemonRuntimeProperties.DaemonName.Webserver;
        if (mapCurr.containsKey(key)) {
            long millis;
            String t1 = TimeStamp.getCurrentMillis();
            String t0 = mapCurr.get(key);
            retVal = millis = TimeStamp.diffMillis((String)t1, (String)t0);
        }
        return retVal;
    }

    private long getMillisMIA() {
        String methodName = "getMillisMIA";
        long secondsMIA = -1L;
        Properties properties = DuccWebProperties.get();
        String ws_rate = properties.getProperty("ducc.ws.state.publish.rate");
        String ws_ratio = "1";
        try {
            long rate = Long.parseLong(ws_rate.trim());
            long ratio = Long.parseLong(ws_ratio.trim());
            secondsMIA = 3L * rate * ratio;
        }
        catch (Throwable t) {
            duccLogger.debug(methodName, null, t, new Object[0]);
        }
        return secondsMIA;
    }

    public boolean isWsPublicationOntime() {
        boolean retVal = true;
        long expiry = this.getMillisMIA();
        if (this.getWsTod() > expiry) {
            retVal = false;
        }
        return retVal;
    }
}

