/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.persistence.services;

import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.persistence.services.IStateServices;
import org.apache.uima.ducc.common.persistence.services.NullStateServices;
import org.apache.uima.ducc.common.utils.DuccLogger;

public class StateServicesFactory {
    private static IStateServices instance = null;

    private static IStateServices getInstanceInternal(String callerClass, String component) {
        String methodName = "getInstance";
        int ndx = callerClass.lastIndexOf(".");
        String stem = callerClass.substring(0, ndx);
        String clname = System.getProperty("ducc.service.persistence.impl");
        if (clname == null) {
            DuccLogger logger = DuccService.getDuccLogger();
            logger.warn(methodName, null, "Service persistence manager is not configured.  Returning null instance.");
            return new NullStateServices();
        }
        ndx = clname.lastIndexOf(".");
        String clfile = clname.substring(ndx + 1);
        DuccLogger logger = DuccLogger.getLogger(stem + "." + clfile, "DB");
        IStateServices ret = null;
        try {
            Class<?> iss = Class.forName(clname);
            ret = (IStateServices)iss.newInstance();
            ret.init(logger);
        }
        catch (Throwable t) {
            logger.error(methodName, null, "Cannot instantiate service persistence class", clname, ":", t);
            ret = new NullStateServices();
        }
        return ret;
    }

    public static IStateServices getInstance(String callerClass, String component) {
        if (instance == null) {
            instance = StateServicesFactory.getInstanceInternal(callerClass, component);
        }
        return instance;
    }
}

