/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.persistence.rm;

import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.persistence.rm.IRmPersistence;
import org.apache.uima.ducc.common.persistence.rm.NullRmStatePersistence;
import org.apache.uima.ducc.common.utils.DuccLogger;

public class RmPersistenceFactory {
    private static IRmPersistence instance = null;

    private static IRmPersistence getInstanceInternal(String callerClass, String component) {
        String methodName = "getInstance";
        int ndx = callerClass.lastIndexOf(".");
        String stem = callerClass.substring(0, ndx);
        String clname = System.getProperty("ducc.rm.persistence.impl");
        if (clname == null) {
            DuccLogger logger = DuccService.getDuccLogger();
            if (logger == null) {
                System.out.println("RM persistence manager is not configured.  Returning null instance.");
            } else {
                logger.warn(methodName, null, "RM persistence manager is not configured.  Returning null instance.");
            }
            return new NullRmStatePersistence();
        }
        ndx = clname.lastIndexOf(".");
        String clfile = clname.substring(ndx + 1);
        DuccLogger logger = DuccLogger.getLogger(stem + "." + clfile, "DB");
        IRmPersistence ret = null;
        try {
            Class<?> iss = Class.forName(clname);
            ret = (IRmPersistence)iss.newInstance();
            ret.init(logger);
        }
        catch (Throwable t) {
            logger.error(methodName, null, "Cannot instantiate RM persistence class", clname, ":", t, "Using NullRmStatePersistance as default.");
            ret = new NullRmStatePersistence();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRmPersistence getInstance(String callerClass, String component) {
        Class<RmPersistenceFactory> clazz = RmPersistenceFactory.class;
        synchronized (RmPersistenceFactory.class) {
            if (instance == null) {
                instance = RmPersistenceFactory.getInstanceInternal(callerClass, component);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }
}

