/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.cli.JobRequestProperties;
import org.apache.uima.ducc.transport.event.cli.JobSpecificationProperties;
import org.apache.uima.ducc.user.common.QuotedOptions;

public class JobFactoryHelper {
    private static final DuccLogger logger = DuccLogger.getLogger(JobFactoryHelper.class);
    private static final DuccId jobid = null;
    public static long KB = 1024L;
    public static long MB = 1024L * KB;
    public static long GB = 1024L * MB;
    public static long defaultBytesSizeJobProcess = 1L * GB;
    public static long defaultBytesSizeJobDriver = 300L * MB;
    private static AtomicLong jdSize = new AtomicLong(0L);

    public static long getDefaultByteSizeJobProcess() {
        return defaultBytesSizeJobProcess;
    }

    public static long getByteSizeJobProcess(String process_memory_size) {
        String location = "getByteSizeJobProcess";
        long retVal = JobFactoryHelper.getDefaultByteSizeJobProcess();
        if (process_memory_size != null) {
            String memory_size = process_memory_size.trim();
            if (memory_size.length() > 0) {
                try {
                    retVal = Long.parseLong(process_memory_size);
                }
                catch (Exception e) {
                    logger.error(location, jobid, (Throwable)e, new Object[0]);
                }
            } else {
                logger.info(location, jobid, new Object[]{"memory size: empty"});
            }
        } else {
            logger.info(location, jobid, new Object[]{"memory size: null"});
        }
        logger.debug(location, jobid, new Object[]{retVal});
        return retVal;
    }

    public static long getDefaultByteSizeJobDriver() {
        return defaultBytesSizeJobDriver;
    }

    public static long getByteSizeJobDriver() {
        String location = "getByteSizeJobDriver";
        long retVal = JobFactoryHelper.getDefaultByteSizeJobDriver();
        try {
            String ducc_jd_share_quantum = DuccPropertiesResolver.getInstance().getFileProperty("ducc.jd.share.quantum");
            long sizeNew = Long.parseLong(ducc_jd_share_quantum) * MB;
            if (sizeNew > 0L) {
                long sizeOld = jdSize.get();
                if (sizeNew != sizeOld) {
                    jdSize.set(sizeNew);
                    logger.info(location, jobid, new Object[]{"old: " + sizeOld + " new: " + sizeNew});
                }
                retVal = sizeNew;
            } else {
                logger.warn(location, jobid, new Object[]{"ducc.jd.share.quantum=" + ducc_jd_share_quantum + " invalid"});
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        logger.debug(location, jobid, new Object[]{retVal});
        return retVal;
    }

    public static Map<String, String> getEnvMap(DuccId jobid, JobRequestProperties jobSpec) {
        String location = "getEnvMap";
        Map<String, String> retVal = new HashMap<String, String>();
        if (jobSpec != null) {
            String environmentVariables = jobSpec.getProperty(JobSpecificationProperties.key_environment);
            if (environmentVariables != null) {
                ArrayList envVarList = QuotedOptions.tokenizeList((String)environmentVariables, (boolean)true);
                try {
                    Map envMap = QuotedOptions.parseAssignments((List)envVarList, (int)0);
                    if (envMap != null) {
                        retVal = envMap;
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.warn(location, jobid, new Object[]{"Invalid environment syntax in: " + environmentVariables});
                }
            } else {
                logger.trace(location, jobid, new Object[]{"environmentVariables=" + environmentVariables});
            }
        } else {
            logger.debug(location, jobid, new Object[]{"jobSpec=" + jobSpec});
        }
        return retVal;
    }

    public static String getEnvVal(DuccId jobid, JobRequestProperties jobSpec, String envKey) {
        String location = "getEnvVal";
        String retVal = null;
        if (envKey != null) {
            Map<String, String> envMap = JobFactoryHelper.getEnvMap(jobid, jobSpec);
            retVal = envMap.get(envKey);
            logger.debug(location, jobid, new Object[]{"envKey=" + envKey + " envVal=" + retVal});
        } else {
            logger.debug(location, jobid, new Object[]{"envKey=" + envKey});
        }
        return retVal;
    }

    public static String getEnvVal(DuccId jobid, JobRequestProperties jobSpec, String envKey, String envVal) {
        String location = "getEnvVal";
        String retVal = JobFactoryHelper.getEnvVal(jobid, jobSpec, envKey);
        if (retVal == null) {
            retVal = envVal;
            logger.debug(location, jobid, new Object[]{"envKey=" + envKey + " envVal=" + retVal + " (default)"});
        }
        return retVal;
    }
}

