/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.event;

import java.util.HashMap;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;
import org.apache.uima.ducc.transport.event.NodeInventoryUpdateDuccEvent;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;

public class NodeInventoryEventLogger {
    private static final DuccLogger logger = DuccLogger.getLogger(NodeInventoryEventLogger.class);
    private static final OrchestratorCommonArea orchestratorCommonArea = OrchestratorCommonArea.getInstance();
    private static final Messages messages = orchestratorCommonArea.getSystemMessages();

    public static void receiver(NodeInventoryUpdateDuccEvent nodeInventoryUpdateDuccEvent) {
        String methodName = "receiver";
        logger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        HashMap processMap = nodeInventoryUpdateDuccEvent.getProcesses();
        if (processMap != null) {
            logger.debug(methodName, null, new Object[]{processMap.size()});
            for (DuccId processId : processMap.keySet()) {
                DuccId jobId = orchestratorCommonArea.getProcessAccounting().getJobId(processId);
                IDuccProcess process = (IDuccProcess)processMap.get(processId);
                String processState = "" + process.getProcessState();
                String nodeIdentity = "" + process.getNodeIdentity();
                String PID = "" + process.getPID();
                String resourceState = "" + process.getResourceState();
                logger.debug(methodName, jobId, processId, new Object[]{processState + " " + resourceState + " " + nodeIdentity + " " + PID});
            }
        }
        logger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }
}

