/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;

public class OrchestratorState {
    private static final DuccLogger logger = DuccLogger.getLogger(OrchestratorState.class);
    private static OrchestratorCommonArea orchestratorCommonArea = OrchestratorCommonArea.getInstance();
    private static String fileName = orchestratorCommonArea.getStateDirectory() + File.separator + "orchestrator-state.json";
    private static Gson gson = new Gson();
    private static OrchestratorState instance = null;
    private static DuccId jobid = null;
    private AtomicLong sequenceNumberState = new AtomicLong(-1L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrchestratorState getInstance() {
        String location = "getInstance";
        Class<OrchestratorState> clazz = OrchestratorState.class;
        synchronized (OrchestratorState.class) {
            logger.debug(location, jobid, new Object[]{"" + instance});
            if (instance == null) {
                instance = new OrchestratorState();
                instance.initialize();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private void initialize() {
        String location = "initialize";
        logger.debug(location, jobid, new Object[]{"" + instance});
        this.importState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextSequenceNumberState() {
        String location = "getNextSequenceNumberState";
        OrchestratorState orchestratorState = this;
        synchronized (orchestratorState) {
            long value = this.sequenceNumberState.incrementAndGet();
            this.exportState();
            logger.debug(location, jobid, new Object[]{"" + this.sequenceNumberState});
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextSequenceNumberState(long value) {
        String location = "setNextSequenceNumberState";
        OrchestratorState orchestratorState = this;
        synchronized (orchestratorState) {
            this.sequenceNumberState.set(value);
            this.exportState();
            logger.debug(location, jobid, new Object[]{"" + value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextSequenceNumberStateIfGreater(NodeIdentity nodeIdentity, long value) {
        String location = "setNextSequenceNumberStateIfGreater";
        OrchestratorState orchestratorState = this;
        synchronized (orchestratorState) {
            long currentValue;
            String node = "?";
            if (nodeIdentity != null) {
                node = nodeIdentity.getCanonicalName();
            }
            if (value > (currentValue = this.sequenceNumberState.get())) {
                this.setNextSequenceNumberState(value);
                logger.warn(location, jobid, new Object[]{"agent:" + node + " value:" + value + " or:" + currentValue});
            } else {
                logger.trace(location, jobid, new Object[]{"agent:" + node + " value:" + value + " or:" + currentValue});
            }
        }
    }

    private void copy(OrchestratorState importedState) {
        String location = "copy";
        if (importedState != null) {
            this.setNextSequenceNumberState(importedState.getNextSequenceNumberState());
        } else {
            logger.warn(location, jobid, new Object[]{"no previous state found"});
        }
    }

    private void importState() {
        String location = "importState";
        try {
            this.importer();
        }
        catch (Exception e) {
            logger.warn(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importer() throws IOException {
        String location = "importer";
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            logger.debug(location, jobid, new Object[]{fileName});
            fr = new FileReader(fileName);
            br = new BufferedReader(fr);
            Type typeOfMap = new TypeToken<OrchestratorState>(){}.getType();
            OrchestratorState importedState = (OrchestratorState)gson.fromJson((Reader)br, typeOfMap);
            br.close();
            fr.close();
            this.copy(importedState);
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
    }

    private void exportState() {
        String location = "exportState";
        try {
            this.exporter();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exporter() throws IOException {
        String location = "exporter";
        try (OutputStreamWriter fw = null;){
            logger.debug(location, jobid, new Object[]{fileName});
            String json = gson.toJson((Object)this);
            fw = new FileWriter(fileName);
            fw.write(json);
            fw.close();
        }
    }
}

