/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator;

import java.util.Map;
import java.util.Properties;
import org.apache.uima.ducc.common.NodeConfiguration;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.jd.scheduler.JdScheduler;
import org.apache.uima.ducc.transport.event.SubmitJobDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitReservationDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitServiceDuccEvent;
import org.apache.uima.ducc.transport.event.cli.JobRequestProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationRequestProperties;
import org.apache.uima.ducc.transport.event.cli.ServiceRequestProperties;
import org.apache.uima.ducc.transport.event.common.DuccWorkPopDriver;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public class OrchestratorHelper {
    private static DuccLogger logger = DuccLogger.getLogger(OrchestratorHelper.class);
    public static DuccId jobid = null;
    public static String DUCC_HOME = "DUCC_HOME";
    public static String resources = "resources";
    public static String scheduler = "scheduler";
    public static String classes = "classes";
    public static String name = "name";

    private static NodeConfiguration getNodeConfiguration() {
        String location = "getNodeConfiguration";
        NodeConfiguration nc = null;
        String class_definitions = null;
        try {
            class_definitions = System.getProperty(DUCC_HOME) + "/" + resources + "/" + SystemPropertyResolver.getStringProperty((String)"ducc.rm.class.definitions", (String)(scheduler + "." + classes));
            nc = new NodeConfiguration(class_definitions, null, null, logger);
            nc.readConfiguration();
        }
        catch (Throwable t) {
            logger.error(location, jobid, t, new Object[0]);
            logger.error(location, jobid, new Object[]{class_definitions});
        }
        return nc;
    }

    private static String getDefaultFairShareClass() {
        String location = "getDefaultFairShareClass";
        String defaultReserveName = null;
        try {
            NodeConfiguration nc = OrchestratorHelper.getNodeConfiguration();
            DuccProperties rp = nc.getDefaultFairShareClass();
            defaultReserveName = rp.getProperty(name);
        }
        catch (Throwable t) {
            logger.error(location, jobid, t, new Object[0]);
        }
        return defaultReserveName;
    }

    protected static void assignDefaultFairShareClass(Properties properties, String key) {
        String location = "assignDefaultFairShareClass";
        try {
            String value = properties.getProperty(key);
            if (value == null) {
                value = OrchestratorHelper.getDefaultFairShareClass();
                properties.setProperty(key, value);
                logger.info(location, jobid, new Object[]{key + "=" + value});
            }
        }
        catch (Throwable t) {
            logger.error(location, jobid, t, new Object[0]);
        }
    }

    private static String getDefaultFixedClass() {
        String location = "getDefaultFixedClass";
        String defaultFixedName = null;
        try {
            NodeConfiguration nc = OrchestratorHelper.getNodeConfiguration();
            DuccProperties rp = nc.getDefaultFixedClass();
            defaultFixedName = rp.getProperty(name);
        }
        catch (Throwable t) {
            logger.error(location, jobid, t, new Object[0]);
        }
        return defaultFixedName;
    }

    protected static void assignDefaultFixedClass(Properties properties, String key) {
        String location = "assignDefaultFixedClass";
        try {
            String value = properties.getProperty(key);
            if (value == null) {
                value = OrchestratorHelper.getDefaultFixedClass();
                properties.setProperty(key, value);
                logger.info(location, jobid, new Object[]{key + "=" + value});
            }
        }
        catch (Throwable t) {
            logger.error(location, jobid, t, new Object[0]);
        }
    }

    private static String getDefaultReserveClass() {
        String location = "getDefaultReserveClass";
        String defaultReserveName = null;
        try {
            NodeConfiguration nc = OrchestratorHelper.getNodeConfiguration();
            DuccProperties rp = nc.getDefaultReserveClass();
            defaultReserveName = rp.getProperty(name);
        }
        catch (Throwable t) {
            logger.error(location, jobid, t, new Object[0]);
        }
        return defaultReserveName;
    }

    protected static void assignDefaultReserveClass(Properties properties, String key) {
        String location = "assignDefaultReserveClass";
        try {
            String value = properties.getProperty(key);
            if (value == null) {
                value = OrchestratorHelper.getDefaultReserveClass();
                properties.setProperty(key, value);
                logger.info(location, jobid, new Object[]{key + "=" + value});
            }
        }
        catch (Throwable t) {
            logger.error(location, jobid, t, new Object[0]);
        }
    }

    public static void assignDefaults(SubmitJobDuccEvent duccEvent) {
        Properties properties = duccEvent.getProperties();
        String key = JobRequestProperties.key_scheduling_class;
        OrchestratorHelper.assignDefaultFairShareClass(properties, key);
    }

    public static void assignDefaults(SubmitReservationDuccEvent duccEvent) {
        Properties properties = duccEvent.getProperties();
        String key = ReservationRequestProperties.key_scheduling_class;
        OrchestratorHelper.assignDefaultReserveClass(properties, key);
    }

    public static void assignDefaults(SubmitServiceDuccEvent duccEvent) {
        Properties properties = duccEvent.getProperties();
        String key = ServiceRequestProperties.key_scheduling_class;
        OrchestratorHelper.assignDefaultFixedClass(properties, key);
    }

    public static void jdDeallocate(IDuccWorkJob job, IDuccProcess jdProcess) {
        String location = "jdDeallocate";
        if (job != null) {
            DuccId jobIdentity = job.getDuccId();
            if (jdProcess != null) {
                DuccId driverIdentity = jdProcess.getDuccId();
                JdScheduler jdScheduler = JdScheduler.getInstance();
                IProcessState.ProcessState processState = jdProcess.getProcessState();
                if (processState != null) {
                    switch (processState) {
                        case LaunchFailed: 
                        case Failed: 
                        case FailedInitialization: 
                        case Stopped: 
                        case Killed: 
                        case Abandoned: {
                            jdScheduler.deallocate(jobIdentity, driverIdentity);
                            logger.debug(location, driverIdentity, new Object[]{"state: " + processState});
                            break;
                        }
                        default: {
                            logger.debug(location, jobIdentity, new Object[]{"state: " + processState});
                            break;
                        }
                    }
                } else {
                    logger.debug(location, jobIdentity, new Object[]{"state: " + processState});
                }
            } else {
                logger.debug(location, jobIdentity, new Object[]{"jdProcess: " + jdProcess});
            }
        } else {
            logger.debug(location, null, new Object[]{"job: " + job});
        }
    }

    public static void jdDeallocate(IDuccWorkJob job) {
        String location = "jdDeallocate";
        JdScheduler jdScheduler = JdScheduler.getInstance();
        if (job != null) {
            DuccId jobIdentity = job.getDuccId();
            DuccWorkPopDriver driver = job.getDriver();
            if (driver != null) {
                IDuccProcessMap processMap = job.getDriver().getProcessMap();
                if (processMap != null) {
                    block3: for (Map.Entry entry : processMap.entrySet()) {
                        IDuccProcess jd = (IDuccProcess)entry.getValue();
                        IProcessState.ProcessState processState = jd.getProcessState();
                        if (processState != null) {
                            switch (processState) {
                                case LaunchFailed: 
                                case Failed: 
                                case FailedInitialization: 
                                case Stopped: 
                                case Killed: 
                                case Abandoned: {
                                    DuccId driverIdentity = (DuccId)entry.getKey();
                                    jdScheduler.deallocate(jobIdentity, driverIdentity);
                                    continue block3;
                                }
                            }
                            logger.debug(location, jobIdentity, new Object[]{"state: " + processState});
                            continue;
                        }
                        logger.debug(location, jobIdentity, new Object[]{"state: " + processState});
                    }
                } else {
                    logger.debug(location, jobIdentity, new Object[]{"map: " + processMap});
                }
            } else {
                logger.debug(location, jobIdentity, new Object[]{"driver: " + driver});
            }
        } else {
            logger.debug(location, null, new Object[]{"job: " + job});
        }
    }
}

