/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.admin.event.DuccAdminEvent;
import org.apache.uima.ducc.common.admin.event.RmAdminReply;
import org.apache.uima.ducc.common.boot.DuccDaemonRuntimeProperties;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.crypto.Crypto;
import org.apache.uima.ducc.common.crypto.CryptoException;
import org.apache.uima.ducc.common.head.IDuccHead;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.main.DuccRmAdmin;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.persistence.or.IDbDuccWorks;
import org.apache.uima.ducc.common.persistence.or.ITypedProperties;
import org.apache.uima.ducc.common.persistence.or.TypedProperties;
import org.apache.uima.ducc.common.system.SystemState;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.IDuccLoggerComponents;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.DuccHead;
import org.apache.uima.ducc.orchestrator.OrUtil;
import org.apache.uima.ducc.orchestrator.Orchestrator;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;
import org.apache.uima.ducc.orchestrator.OrchestratorConstants;
import org.apache.uima.ducc.orchestrator.OrchestratorHelper;
import org.apache.uima.ducc.orchestrator.Reason;
import org.apache.uima.ducc.orchestrator.ReservationFactory;
import org.apache.uima.ducc.orchestrator.StateJobAccounting;
import org.apache.uima.ducc.orchestrator.StateManager;
import org.apache.uima.ducc.orchestrator.Validate;
import org.apache.uima.ducc.orchestrator.WorkMapHelper;
import org.apache.uima.ducc.orchestrator.authentication.DuccWebAdministrators;
import org.apache.uima.ducc.orchestrator.ckpt.OrchestratorCheckpoint;
import org.apache.uima.ducc.orchestrator.database.OrDbDuccWorks;
import org.apache.uima.ducc.orchestrator.database.OrDbOrchestratorProperties;
import org.apache.uima.ducc.orchestrator.exceptions.ResourceUnavailableForJobDriverException;
import org.apache.uima.ducc.orchestrator.factory.IJobFactory;
import org.apache.uima.ducc.orchestrator.factory.JobFactory;
import org.apache.uima.ducc.orchestrator.jd.scheduler.JdScheduler;
import org.apache.uima.ducc.orchestrator.maintenance.MaintenanceThread;
import org.apache.uima.ducc.orchestrator.maintenance.NodeAccounting;
import org.apache.uima.ducc.orchestrator.state.OrchestratorState;
import org.apache.uima.ducc.orchestrator.system.events.log.SystemEventsLogger;
import org.apache.uima.ducc.orchestrator.utilities.TrackSync;
import org.apache.uima.ducc.transport.event.AgentProcessLifecycleReportDuccEvent;
import org.apache.uima.ducc.transport.event.CancelJobDuccEvent;
import org.apache.uima.ducc.transport.event.CancelReservationDuccEvent;
import org.apache.uima.ducc.transport.event.CancelServiceDuccEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.DuccWorkRequestEvent;
import org.apache.uima.ducc.transport.event.IDuccContext;
import org.apache.uima.ducc.transport.event.JdRequestEvent;
import org.apache.uima.ducc.transport.event.NodeInventoryUpdateDuccEvent;
import org.apache.uima.ducc.transport.event.OrchestratorStateDuccEvent;
import org.apache.uima.ducc.transport.event.RmStateDuccEvent;
import org.apache.uima.ducc.transport.event.SmHeartbeatDuccEvent;
import org.apache.uima.ducc.transport.event.SmStateDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitJobDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitReservationDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitServiceDuccEvent;
import org.apache.uima.ducc.transport.event.cli.JobReplyProperties;
import org.apache.uima.ducc.transport.event.cli.JobRequestProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationReplyProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationRequestProperties;
import org.apache.uima.ducc.transport.event.cli.ServiceRequestProperties;
import org.apache.uima.ducc.transport.event.cli.SpecificationProperties;
import org.apache.uima.ducc.transport.event.common.DuccProcessMap;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccCompletionType;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.transport.event.common.IResourceState;
import org.apache.uima.ducc.transport.event.common.ITimeWindow;
import org.apache.uima.ducc.transport.event.common.Rationale;
import org.apache.uima.ducc.transport.event.jd.IDriverStatusReport;
import org.apache.uima.ducc.transport.event.sm.ServiceMap;

public class OrchestratorComponent
extends AbstractDuccComponent
implements Orchestrator {
    private static final DuccLogger logger = DuccLogger.getLogger(OrchestratorComponent.class);
    private static DuccId jobid = null;
    private OrchestratorCommonArea orchestratorCommonArea = OrchestratorCommonArea.getInstance();
    private Messages messages = this.orchestratorCommonArea.getSystemMessages();
    private StateManager stateManager = StateManager.getInstance();
    private IJobFactory jobFactory = JobFactory.getInstance();
    private ReservationFactory reservationFactory = ReservationFactory.getInstance();
    private JdScheduler jdScheduler = this.orchestratorCommonArea.getJdScheduler();
    private StateJobAccounting stateJobAccounting = StateJobAccounting.getInstance();
    private DuccPropertiesResolver dpr = DuccPropertiesResolver.getInstance();
    private IDbDuccWorks dbDuccWorks = null;
    private IDuccHead dh = null;
    private AtomicBoolean stateNodeInventory = new AtomicBoolean(true);
    private String RMAdminRoute = "RMAdminRoute";

    public OrchestratorComponent(CamelContext context) {
        super("Orchestrator", context);
        this.init();
    }

    private void init() {
        String location = "init";
        try {
            this.dbDuccWorks = new OrDbDuccWorks();
            this.dbDuccWorks.dbInit();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        OrDbOrchestratorProperties.getInstance();
    }

    private boolean rejectNotMaster(Properties properties) {
        String location = "rejectIfNotMaster";
        boolean retVal = false;
        if (!this.getDuccHead().is_ducc_head_virtual_master()) {
            String error_message = this.messages.fetch(" type=ducchead error, text=not the master.");
            logger.error(location, null, new Object[]{error_message});
            this.submitError(properties, error_message);
            retVal = true;
        }
        return retVal;
    }

    public void onDuccAdminKillEvent(DuccAdminEvent event) throws Exception {
        String location = "onDuccAdminKillEvent";
        OrchestratorCheckpoint.getInstance().saveState();
        try {
            long delay = 10000L;
            logger.info(location, jobid, new Object[]{"delay:" + delay});
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        SystemEventsLogger.warn(IDuccLoggerComponents.abbrv_orchestrator, DuccEvent.EventType.SHUTDOWN.name(), "");
        super.onDuccAdminKillEvent(event);
    }

    private void force(IDuccWorkJob job, IRationale rationale) {
        String methodName = "force";
        if (!job.isCompleted()) {
            this.stateJobAccounting.stateChange(job, IDuccState.JobState.Completed);
            job.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
            this.stateJobAccounting.complete(job, IDuccCompletionType.JobCompletionType.CanceledBySystem, rationale);
            OrchestratorCommonArea.getInstance().getProcessAccounting().deallocateAndStop(job, IResourceState.ProcessDeallocationType.JobCanceled);
            logger.info(methodName, job.getDuccId(), new Object[]{IDuccCompletionType.JobCompletionType.CanceledBySystem});
        }
    }

    private void cancel(IDuccWorkReservation reservation) {
        String methodName = "cancel";
        reservation.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
        reservation.stateChange(IDuccState.ReservationState.Completed);
        reservation.complete(IDuccCompletionType.ReservationCompletionType.CanceledBySystem);
        logger.info(methodName, reservation.getDuccId(), new Object[]{IDuccCompletionType.ReservationCompletionType.CanceledBySystem});
    }

    private OrchestratorConstants.StartType getStartTypeProperty() {
        String methodName = "getStartTypeProperty";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        OrchestratorConstants.StartType startType = OrchestratorConstants.StartType.warm;
        String property = this.dpr.getProperty("ducc.orchestrator.start.type");
        if (property != null) {
            String startTypeProperty = property.trim().toLowerCase();
            if (startTypeProperty.equals("cold")) {
                startType = OrchestratorConstants.StartType.cold;
            } else if (startTypeProperty.equals("warm")) {
                startType = OrchestratorConstants.StartType.warm;
            } else {
                logger.warn(methodName, null, new Object[]{"ducc.orchestrator.start.type value in ducc.properties not recognized: " + property});
            }
        } else {
            logger.warn(methodName, null, new Object[]{"ducc.orchestrator.start.type not found in ducc.properties"});
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return startType;
    }

    private void resolveSignatureRequired() throws CryptoException {
        String methodName = "resolveSignatureRequired";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        String property = this.dpr.getProperty("ducc.signature.required");
        if (property != null) {
            String signatureRequiredProperty = property.trim().toLowerCase();
            if (signatureRequiredProperty.equals("on")) {
                this.orchestratorCommonArea.setSignatureRequired();
                logger.info(methodName, null, new Object[]{"ducc.signature.required: " + property});
            } else if (signatureRequiredProperty.equals("off")) {
                this.orchestratorCommonArea.resetSignatureRequired();
                logger.info(methodName, null, new Object[]{"ducc.signature.required: " + property});
            } else {
                logger.warn(methodName, null, new Object[]{"ducc.signature.required value in ducc.properties not recognized: " + property});
            }
        } else {
            logger.warn(methodName, null, new Object[]{"ducc.signature.required not found in ducc.properties"});
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private OrchestratorConstants.StartType getStartTypeOverride(String[] args) {
        String methodName = "getStartTypeOverride";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        OrchestratorConstants.StartType startType = null;
        if (args != null) {
            for (String arg : args) {
                logger.debug(methodName, null, new Object[]{"arg: " + arg});
                String flag = arg.trim();
                while (flag.startsWith("-")) {
                    flag = flag.replaceFirst("-", "");
                }
                if (flag.equals(OrchestratorConstants.StartType.cold.toString())) {
                    startType = OrchestratorConstants.StartType.cold;
                    continue;
                }
                if (flag.equals(OrchestratorConstants.StartType.warm.toString())) {
                    startType = OrchestratorConstants.StartType.warm;
                    continue;
                }
                logger.warn(methodName, null, new Object[]{"unrecognized arg: " + arg});
            }
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return startType;
    }

    private OrchestratorConstants.StartType getStartType(String[] args) {
        String methodName = "getStartType";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        OrchestratorConstants.StartType startType = OrchestratorConstants.startTypeDefault;
        OrchestratorConstants.StartType property = this.getStartTypeProperty();
        OrchestratorConstants.StartType override = this.getStartTypeOverride(args);
        StringBuffer sb = new StringBuffer();
        sb.append("start type: ");
        if (override != null) {
            startType = override;
            sb.append((Object)startType);
            sb.append(", override");
        } else if (property != null) {
            startType = property;
            sb.append((Object)startType);
            sb.append(", property");
        } else {
            sb.append((Object)startType);
            sb.append((Object)startType);
            sb.append(", default");
        }
        logger.info(methodName, null, new Object[]{sb});
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return startType;
    }

    public DuccLogger getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(DuccService service, String[] args) throws Exception {
        String methodName = "start";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        try {
            DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
            OrchestratorConstants.StartType startType = this.getStartType(args);
            logger.info(methodName, null, new Object[]{"##### " + (Object)((Object)startType) + " #####"});
            String key = "ducc.broker.url";
            String value = System.getProperty(key);
            logger.debug(methodName, null, new Object[]{key + "=" + value});
            boolean saveState = false;
            TrackSync ts = TrackSync.await(workMap, this.getClass(), methodName);
            DuccWorkMap duccWorkMap = workMap;
            synchronized (duccWorkMap) {
                ts.using();
                for (IDuccWork duccWork : workMap.values()) {
                    block3 : switch (duccWork.getDuccType()) {
                        case Job: 
                        case Service: {
                            IDuccWorkJob job = (IDuccWorkJob)duccWork;
                            switch (startType) {
                                case cold: {
                                    this.force(job, (IRationale)new Rationale("system cold start"));
                                    saveState = true;
                                    break block3;
                                }
                            }
                            break;
                        }
                        case Reservation: {
                            IDuccWorkReservation reservation = (IDuccWorkReservation)duccWork;
                            switch (startType) {
                                case cold: {
                                    this.cancel(reservation);
                                    saveState = true;
                                    break block3;
                                }
                            }
                            break;
                        }
                    }
                }
            }
            ts.ended();
            if (saveState) {
                OrchestratorCheckpoint.getInstance().saveState();
            }
            switch (startType) {
                case cold: {
                    this.jdScheduler = JdScheduler.getInstance();
                    break;
                }
                case warm: {
                    this.jdScheduler = JdScheduler.getInstance();
                    this.jdScheduler.restore();
                }
            }
            this.resolveSignatureRequired();
            MaintenanceThread.getInstance().start();
        }
        catch (Throwable t) {
            logger.error(methodName, null, t, new Object[0]);
        }
        super.start(service, args);
        String adminEndpoint = System.getProperty("ducc.rm.via.or.admin.endpoint");
        if (adminEndpoint == null) {
            logger.warn(methodName, null, new Object[]{"No admin endpoint configured.  Not starting admin channel."});
        } else {
            this.startRmAdminChannel(adminEndpoint, this);
        }
        DuccDaemonRuntimeProperties.getInstance().boot(DuccDaemonRuntimeProperties.DaemonName.Orchestrator, this.getProcessJmxUrl());
        SystemEventsLogger.warn(IDuccLoggerComponents.abbrv_orchestrator, DuccEvent.EventType.BOOT.name(), "");
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    @Override
    public void reconcileDwState(DuccWorkRequestEvent duccEvent) {
        String methodName = "reconcileDwState";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        if (duccEvent != null) {
            DuccId duccId = duccEvent.getDuccId();
            if (duccId != null) {
                if (workMap != null) {
                    IDuccWork dw = workMap.findDuccWork(duccId);
                    duccEvent.setDw(dw);
                    if (dw == null) {
                        logger.warn(methodName, duccId, new Object[]{"dw==null"});
                    }
                } else {
                    logger.warn(methodName, duccId, new Object[]{"workMap==null"});
                }
            } else {
                logger.warn(methodName, jobid, new Object[]{"duccId==null"});
            }
        } else {
            logger.warn(methodName, jobid, new Object[]{"duccEvent==null"});
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    @Override
    public void reconcileJdState(JdRequestEvent duccEvent) {
        boolean is_master;
        String methodName = "reconcileJdState";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        IDriverStatusReport dsr = duccEvent.getDriverStatusReport();
        DuccId duccId = null;
        if (dsr != null) {
            duccId = dsr.getDuccId();
        }
        if (!(is_master = this.getDuccHead().is_ducc_head_virtual_master())) {
            duccEvent.setDuccHeadMaster(false);
            logger.info(methodName, duccId, new Object[]{"not master"});
        } else {
            duccEvent.setDuccHeadMaster(true);
            logger.info(methodName, duccId, new Object[]{"master"});
            DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
            if (dsr != null) {
                logger.info(methodName, duccId, new Object[]{dsr.getLogReport()});
                this.stateManager.reconcileState(dsr);
                String sid = "" + duccId.getFriendly();
                DuccWorkJob duccWorkJob = (DuccWorkJob)WorkMapHelper.cloneDuccWork(workMap, sid, this, methodName);
                if (duccWorkJob != null) {
                    IDuccProcessMap processMap = duccWorkJob.getProcessMap();
                    duccEvent.setProcessMap((IDuccProcessMap)new DuccProcessMap(processMap));
                } else {
                    String text = "not found in map";
                    duccEvent.setKillDriverReason(text);
                    logger.warn(methodName, duccId, new Object[]{text});
                }
            }
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    @Override
    public void reconcileRmState(RmStateDuccEvent duccEvent) {
        String methodName = "reconcileRmState";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        Map resourceMap = duccEvent.getJobState();
        try {
            this.stateManager.reconcileState(resourceMap);
            this.jdScheduler.handle((IDuccWorkMap)workMap);
        }
        catch (Exception e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    @Override
    public void reconcileSmState(SmStateDuccEvent duccEvent) {
        String methodName = "reconcileSmState";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        ServiceMap serviceMap = duccEvent.getServiceMap();
        this.stateManager.reconcileState(serviceMap);
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    @Override
    public void reconcileSmHeartbeat(SmHeartbeatDuccEvent duccEvent) {
        String methodName = "reconcileSmHeartbeat";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private boolean isAcceptNodeInventory() {
        String methodName = "isAcceptNodeInventory";
        boolean retVal = true;
        if (this.getDuccHead().is_ducc_head_virtual_master()) {
            if (!this.stateNodeInventory.get()) {
                retVal = true;
                this.stateNodeInventory.set(retVal);
                logger.info(methodName, jobid, new Object[]{retVal});
            }
        } else if (this.stateNodeInventory.get()) {
            retVal = false;
            this.stateNodeInventory.set(retVal);
            logger.info(methodName, jobid, new Object[]{retVal});
        }
        return retVal;
    }

    @Override
    public void reconcileNodeInventory(NodeInventoryUpdateDuccEvent duccEvent) {
        String methodName = "reconcileNodeInventory";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        if (this.isAcceptNodeInventory()) {
            HashMap processMap = duccEvent.getProcesses();
            this.stateManager.reconcileState(processMap);
            NodeAccounting.getInstance().heartbeat(processMap);
            this.adjustPublicationSequenceNumber(duccEvent);
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private void adjustPublicationSequenceNumber(NodeInventoryUpdateDuccEvent duccEvent) {
        NodeIdentity nodeIdentity = duccEvent.getNodeIdentity();
        long seqNo = duccEvent.getSequence();
        OrchestratorState.getInstance().setNextPublicationSequenceNumberIfGreater(seqNo, nodeIdentity);
    }

    private String getNode(AgentProcessLifecycleReportDuccEvent duccEvent) {
        String node = "?";
        NodeIdentity nodeIdentity = duccEvent.getNodeIdentity();
        if (nodeIdentity != null) {
            node = nodeIdentity.getCanonicalName();
        }
        return node;
    }

    private AgentProcessLifecycleReportDuccEvent.LifecycleEvent getLifecycleEvent(AgentProcessLifecycleReportDuccEvent duccEvent) {
        AgentProcessLifecycleReportDuccEvent.LifecycleEvent lifecycleEvent = duccEvent.getLifecycleEvent();
        if (lifecycleEvent == null) {
            lifecycleEvent = AgentProcessLifecycleReportDuccEvent.LifecycleEvent.Undefined;
        }
        return lifecycleEvent;
    }

    private DuccId getProcessDuccId(AgentProcessLifecycleReportDuccEvent duccEvent) {
        DuccId duccid = null;
        IDuccProcess process = duccEvent.getProcess();
        if (process != null) {
            duccid = process.getDuccId();
        }
        return duccid;
    }

    private String getProcessId(AgentProcessLifecycleReportDuccEvent duccEvent) {
        String id = null;
        DuccId duccid = this.getProcessDuccId(duccEvent);
        if (duccid != null) {
            id = duccid.toString();
        }
        return id;
    }

    private IDuccProcessType.ProcessType getProcessType(AgentProcessLifecycleReportDuccEvent duccEvent) {
        IDuccProcessType.ProcessType processType = null;
        IDuccProcess process = duccEvent.getProcess();
        if (process != null) {
            processType = process.getProcessType();
        }
        return processType;
    }

    @Override
    public void reconcileAgentProcessLifecycleReport(AgentProcessLifecycleReportDuccEvent duccEvent) {
        String location = "reconcileAgentProcessLifecycleReport";
        StringBuffer sb = new StringBuffer();
        String id = this.getProcessId(duccEvent);
        String node = this.getNode(duccEvent);
        AgentProcessLifecycleReportDuccEvent.LifecycleEvent lifecycleEvent = this.getLifecycleEvent(duccEvent);
        IDuccProcessType.ProcessType processType = this.getProcessType(duccEvent);
        IDuccProcess process = duccEvent.getProcess();
        DuccId processDuccId = this.getProcessDuccId(duccEvent);
        logger.debug(location, processDuccId, new Object[]{"process"});
        DuccId dwId = OrchestratorCommonArea.getInstance().getProcessAccounting().getJobId(processDuccId);
        if (process == null) {
            sb.append("process:" + process + " ");
            sb.append("node:" + node + " ");
            sb.append("lifefcycleEvent:" + lifecycleEvent.name() + " ");
            logger.error(location, jobid, new Object[]{sb.toString()});
        } else if (id == null) {
            sb.append("id:" + id + " ");
            sb.append("node:" + node + " ");
            sb.append("lifefcycleEvent:" + lifecycleEvent.name() + " ");
            logger.error(location, jobid, new Object[]{sb.toString()});
        } else if (node == null) {
            sb.append("id:" + id + " ");
            sb.append("node:" + node + " ");
            sb.append("lifefcycleEvent:" + lifecycleEvent.name() + " ");
            logger.error(location, jobid, new Object[]{sb.toString()});
        } else if (lifecycleEvent == AgentProcessLifecycleReportDuccEvent.LifecycleEvent.Undefined) {
            sb.append("id:" + id + " ");
            sb.append("node:" + node + " ");
            sb.append("lifefcycleEvent:" + lifecycleEvent.name() + " ");
            logger.error(location, jobid, new Object[]{sb.toString()});
        } else if (processType == null) {
            sb.append("id:" + id + " ");
            sb.append("node:" + node + " ");
            sb.append("lifefcycleEvent:" + lifecycleEvent.name() + " ");
            sb.append("processType:" + processType + " ");
            logger.error(location, jobid, new Object[]{sb.toString()});
        } else if (dwId == null) {
            sb.append("id:" + id + " ");
            sb.append("node:" + node + " ");
            sb.append("lifefcycleEvent:" + lifecycleEvent.name() + " ");
            sb.append("processType:" + processType + " ");
            sb.append("dwId:" + dwId + " ");
            logger.error(location, jobid, new Object[]{sb.toString()});
        } else {
            DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
            IDuccWork dw = workMap.findDuccWork(dwId);
            IDuccTypes.DuccType dwType = dw.getDuccType();
            sb.append("dwId:" + dwId + " ");
            sb.append("dwType:" + dwType + " ");
            sb.append("id:" + id + " ");
            sb.append("node:" + node + " ");
            sb.append("lifefcycleEvent:" + lifecycleEvent.name() + " ");
            sb.append("processType:" + processType.name() + " ");
            logger.debug(location, jobid, new Object[]{sb.toString()});
            SystemEventsLogger.info(dw, process, node, lifecycleEvent, processType);
        }
    }

    private IDuccHead getDuccHead() {
        if (this.dh == null) {
            this.dh = DuccHead.getInstance();
            if (this.dh.is_ducc_head_backup()) {
                SystemEventsLogger.warn(IDuccLoggerComponents.abbrv_orchestrator, DuccEvent.EventType.INIT_AS_BACKUP.name(), "");
            } else {
                SystemEventsLogger.warn(IDuccLoggerComponents.abbrv_orchestrator, DuccEvent.EventType.INIT_AS_MASTER.name(), "");
            }
        }
        return this.dh;
    }

    @Override
    public OrchestratorStateDuccEvent getState() {
        String methodName = "getState";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        OrchestratorStateDuccEvent orchestratorStateDuccEvent = new OrchestratorStateDuccEvent(logger);
        IDuccHead.DuccHeadTransition dh_transition = this.getDuccHead().transition();
        logger.debug(methodName, jobid, new Object[]{dh_transition});
        switch (dh_transition) {
            case master_to_backup: {
                OrchestratorCommonArea.getInstance().restart();
                SystemEventsLogger.warn(IDuccLoggerComponents.abbrv_orchestrator, DuccEvent.EventType.SWITCH_TO_BACKUP.name(), "");
                orchestratorStateDuccEvent.setDuccHeadState(IDuccHead.DuccHeadState.backup);
                logger.warn(methodName, jobid, new Object[]{"ducc head -> backup"});
                break;
            }
            case backup_to_master: {
                OrchestratorCommonArea.getInstance().restart();
                SystemEventsLogger.warn(IDuccLoggerComponents.abbrv_orchestrator, DuccEvent.EventType.SWITCH_TO_MASTER.name(), "");
                orchestratorStateDuccEvent.setDuccHeadState(IDuccHead.DuccHeadState.master);
                logger.warn(methodName, jobid, new Object[]{"ducc head -> master"});
                break;
            }
            case master_to_master: {
                orchestratorStateDuccEvent.setDuccHeadState(IDuccHead.DuccHeadState.master);
                logger.debug(methodName, jobid, new Object[]{"ducc head == master"});
                break;
            }
            case backup_to_backup: {
                orchestratorStateDuccEvent.setDuccHeadState(IDuccHead.DuccHeadState.backup);
                logger.debug(methodName, jobid, new Object[]{"ducc head == backup"});
                break;
            }
            default: {
                logger.debug(methodName, jobid, new Object[]{"ducc head == unspecified"});
            }
        }
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        try {
            DuccWorkMap workMapCopy = WorkMapHelper.deepCopy(workMap, this, methodName);
            int activeJobs = workMapCopy.getJobCount();
            int activeReservations = workMapCopy.getReservationCount();
            int activeServices = workMapCopy.getServiceCount();
            logger.debug(methodName, null, new Object[]{this.messages.fetch("publishing state") + " " + this.messages.fetchLabel("active job count") + activeJobs + " " + this.messages.fetchLabel("active reservation count") + activeReservations + " " + this.messages.fetchLabel("active service count") + activeServices});
            if (this.jdScheduler.isMinimalAllocateRequirementMet()) {
                workMapCopy.setJobDriverMinimalAllocateRequirementMet();
            } else {
                workMapCopy.resetJobDriverMinimalAllocateRequirementMet();
            }
            logger.debug(methodName, jobid, new Object[]{"isJobDriverMinimalAllocateRequirementMet=" + workMapCopy.isJobDriverMinimalAllocateRequirementMet()});
            orchestratorStateDuccEvent.setWorkMap((IDuccWorkMap)workMapCopy);
        }
        catch (Throwable t) {
            logger.error(methodName, null, t, new Object[0]);
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return orchestratorStateDuccEvent;
    }

    private void submitError(Properties properties, String error_message) {
        String key = SpecificationProperties.key_submit_errors;
        ArrayList<String> value_submit_errors = (ArrayList<String>)properties.get(key);
        if (value_submit_errors == null) {
            value_submit_errors = new ArrayList<String>();
            properties.put(key, value_submit_errors);
        }
        value_submit_errors.add(error_message);
    }

    private boolean isSignatureValid(Properties properties) {
        String methodName = "isSignatureValid";
        boolean retVal = true;
        try {
            if (this.orchestratorCommonArea.isSignatureRequired()) {
                String user = properties.getProperty(SpecificationProperties.key_user);
                byte[] signature = (byte[])properties.get(SpecificationProperties.key_signature);
                Crypto crypto = new Crypto(user);
                retVal = crypto.isValid(signature);
            }
        }
        catch (Throwable t) {
            logger.error(methodName, null, t, new Object[0]);
        }
        return retVal;
    }

    private String getRole(Properties properties) {
        String methodName = "isAuthorized";
        String role = SpecificationProperties.key_role_user;
        try {
            if (properties.containsKey(SpecificationProperties.key_role_administrator)) {
                role = SpecificationProperties.key_role_administrator;
            }
        }
        catch (Exception e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        return role;
    }

    private boolean isAuthorized(DuccId duccId, String reqUser, String tgtUser, String role) {
        String methodName = "isAuthorized";
        boolean retVal = false;
        try {
            if (reqUser.equals(tgtUser)) {
                logger.info(methodName, duccId, new Object[]{reqUser + " is " + tgtUser});
                retVal = true;
            } else if (role.equals(SpecificationProperties.key_role_administrator)) {
                DuccWebAdministrators dwa = DuccWebAdministrators.getInstance();
                if (dwa.isAdministrator(reqUser)) {
                    logger.info(methodName, duccId, new Object[]{reqUser + " is " + SpecificationProperties.key_role_administrator});
                    retVal = true;
                }
            } else {
                logger.info(methodName, duccId, new Object[]{"role is not " + SpecificationProperties.key_role_administrator});
            }
        }
        catch (Exception e) {
            logger.error(methodName, duccId, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    @Override
    public void startJob(SubmitJobDuccEvent duccEvent) {
        String methodName = "startJob";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        try {
            OrchestratorHelper.assignDefaults(duccEvent);
            JobRequestProperties properties = (JobRequestProperties)duccEvent.getProperties();
            if (!this.rejectNotMaster((Properties)properties)) {
                if (!this.isSignatureValid((Properties)properties)) {
                    String error_message = this.messages.fetch(" type=authentication error, text=signature not valid.");
                    logger.error(methodName, null, new Object[]{error_message});
                    this.submitError((Properties)properties, error_message);
                } else if (!SystemState.getInstance().isAcceptJobs()) {
                    String error_message = this.messages.fetch(" type=system error, text=system is not accepting new work at this time.");
                    logger.error(methodName, null, new Object[]{error_message});
                    this.submitError((Properties)properties, error_message);
                } else if (Validate.request(duccEvent)) {
                    try {
                        IDuccWorkJob duccWorkJob = this.jobFactory.createJob(properties);
                        WorkMapHelper.addDuccWork(workMap, (IDuccWork)duccWorkJob, this, methodName);
                        this.stateJobAccounting.stateChange(duccWorkJob, IDuccState.JobState.Received);
                        OrchestratorCheckpoint.getInstance().saveState();
                        this.stateJobAccounting.stateChange(duccWorkJob, IDuccState.JobState.WaitingForDriver);
                        OrchestratorCheckpoint.getInstance().saveState();
                        properties.put((Object)JobRequestProperties.key_id, (Object)duccWorkJob.getId());
                        duccEvent.setProperties((Properties)properties);
                        TypedProperties tp = new TypedProperties();
                        for (Map.Entry entry : properties.entrySet()) {
                            String name = (String)entry.getKey();
                            if (name.equals("signature")) continue;
                            String type = ITypedProperties.PropertyType.system.name();
                            if (properties.isUserProvided(name)) {
                                type = ITypedProperties.PropertyType.user.name();
                            }
                            tp.add(type, entry.getKey(), entry.getValue());
                        }
                        String specificationType = ITypedProperties.SpecificationType.Job.name();
                        Long id = duccWorkJob.getDuccId().getFriendly();
                        this.dbDuccWorks.upsertSpecification(specificationType, id.longValue(), (ITypedProperties)tp);
                    }
                    catch (ResourceUnavailableForJobDriverException e) {
                        String error_message = this.messages.fetch(" type=system error, text=job driver node unavailable.");
                        logger.error(methodName, null, new Object[]{error_message});
                        this.submitError((Properties)properties, error_message);
                    }
                } else {
                    logger.info(methodName, null, new Object[]{this.messages.fetch("TODO") + " prepare error reply"});
                }
            }
        }
        catch (Throwable t) {
            logger.error(methodName, null, new Object[]{this.messages.fetch("TODO") + " prepare error reply", t});
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    @Override
    public void stopJob(CancelJobDuccEvent duccEvent) {
        String methodName = "stopJob";
        DuccId dwid = null;
        logger.trace(methodName, dwid, new Object[]{this.messages.fetch("enter")});
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        Properties properties = duccEvent.getProperties();
        if (!this.rejectNotMaster(properties)) {
            if (!this.isSignatureValid(properties)) {
                String error_message = this.messages.fetch(" type=authentication error, text=signature not valid.");
                logger.error(methodName, dwid, new Object[]{error_message});
                this.submitError(properties, error_message);
            } else if (Validate.request(duccEvent)) {
                String jobId = properties.getProperty(JobRequestProperties.key_id);
                logger.info(methodName, jobid, new Object[]{JobRequestProperties.key_id + "=" + jobId});
                long t0 = System.currentTimeMillis();
                DuccWorkJob duccWorkJob = (DuccWorkJob)WorkMapHelper.findDuccWork(workMap, IDuccTypes.DuccType.Job, jobId, this, methodName);
                long t1 = System.currentTimeMillis();
                long elapsed = t1 - t0;
                if (elapsed > 100L) {
                    logger.debug(methodName, dwid, new Object[]{"elapsed msecs: " + elapsed});
                }
                if (duccWorkJob != null) {
                    dwid = duccWorkJob.getDuccId();
                    String reqUser = properties.getProperty(JobRequestProperties.key_user).trim();
                    String reqRole = this.getRole(properties);
                    String tgtUser = duccWorkJob.getStandardInfo().getUser().trim();
                    if (this.isAuthorized(dwid, reqUser, tgtUser, reqRole)) {
                        logger.debug(methodName, dwid, new Object[]{"reqUser:" + reqUser + " reqRole:" + reqRole + " tgtUser:" + tgtUser});
                        String givenReason = properties.getProperty(SpecificationProperties.key_reason);
                        Reason reason = new Reason(dwid, reqUser, reqRole, givenReason);
                        Rationale rationale = new Rationale(reason.toString());
                        IDuccCompletionType.JobCompletionType jobCompletionType = IDuccCompletionType.JobCompletionType.CanceledByUser;
                        if (reqRole.equals(SpecificationProperties.key_role_administrator)) {
                            jobCompletionType = IDuccCompletionType.JobCompletionType.CanceledByAdministrator;
                        }
                        this.stateManager.jobTerminate((IDuccWorkJob)duccWorkJob, jobCompletionType, (IRationale)rationale, IResourceState.ProcessDeallocationType.JobCanceled);
                        OrchestratorCheckpoint.getInstance().saveState();
                        properties.put(JobReplyProperties.key_message, JobReplyProperties.msg_canceled);
                        duccEvent.setProperties(properties);
                        logger.info(methodName, dwid, new Object[]{this.messages.fetchLabel("job state") + duccWorkJob.getJobState()});
                    } else {
                        properties.put(JobReplyProperties.key_message, JobReplyProperties.msg_user_not_authorized);
                        duccEvent.setProperties(properties);
                        logger.info(methodName, dwid, new Object[]{jobId + " : " + this.messages.fetch(JobReplyProperties.msg_user_not_authorized)});
                    }
                } else {
                    properties.put(JobReplyProperties.key_message, JobReplyProperties.msg_job_not_found);
                    duccEvent.setProperties(properties);
                    logger.info(methodName, dwid, new Object[]{jobId + " : " + this.messages.fetch(JobReplyProperties.msg_job_not_found)});
                }
            } else {
                logger.info(methodName, dwid, new Object[]{this.messages.fetch("TODO") + " prepare error reply"});
            }
        }
        logger.trace(methodName, dwid, new Object[]{this.messages.fetch("exit")});
    }

    @Override
    public void stopJobProcess(CancelJobDuccEvent duccEvent) {
        String methodName = "stopJobProcess";
        DuccId dwid = null;
        logger.trace(methodName, dwid, new Object[]{this.messages.fetch("enter")});
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        Properties properties = duccEvent.getProperties();
        if (!this.rejectNotMaster(properties)) {
            if (!this.isSignatureValid(properties)) {
                String error_message = this.messages.fetch(" type=authentication error, text=signature not valid.");
                logger.error(methodName, dwid, new Object[]{error_message});
                this.submitError(properties, error_message);
            } else if (Validate.request(duccEvent)) {
                String dpid = null;
                String jobId = properties.getProperty(JobRequestProperties.key_id);
                DuccWorkJob duccWorkJob = (DuccWorkJob)WorkMapHelper.findDuccWork(workMap, IDuccTypes.DuccType.Job, jobId, this, methodName);
                if (duccWorkJob != null) {
                    dwid = duccWorkJob.getDuccId();
                    String reqUser = properties.getProperty(JobRequestProperties.key_user).trim();
                    String reqRole = this.getRole(properties);
                    String tgtUser = duccWorkJob.getStandardInfo().getUser().trim();
                    if (this.isAuthorized(dwid, reqUser, tgtUser, reqRole)) {
                        logger.debug(methodName, dwid, new Object[]{"reqUser:" + reqUser + " reqRole:" + reqRole + " tgtUser:" + tgtUser});
                        dpid = properties.getProperty(JobReplyProperties.key_dpid);
                        IDuccProcess idp = duccWorkJob.getProcess(dpid);
                        if (idp != null) {
                            switch (idp.getProcessState()) {
                                case Starting: 
                                case Started: 
                                case Initializing: 
                                case Running: {
                                    ITimeWindow twr;
                                    OrUtil.setResourceState((IDuccWorkJob)duccWorkJob, idp, IResourceState.ResourceState.Deallocated);
                                    idp.setProcessState(IProcessState.ProcessState.Abandoned);
                                    idp.setProcessDeallocationType(IResourceState.ProcessDeallocationType.Canceled);
                                    idp.setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.UserInitiated.toString());
                                    if (reqRole != null && reqRole.equalsIgnoreCase(SpecificationProperties.key_role_administrator)) {
                                        idp.setReasonForStoppingProcess(IDuccProcess.ReasonForStoppingProcess.AdministratorInitiated.toString());
                                    }
                                    long now = System.currentTimeMillis();
                                    ITimeWindow twi = idp.getTimeWindowInit();
                                    if (twi != null && twi.getStartLong() > 0L) {
                                        twi.setEndLong(now);
                                    }
                                    if ((twr = idp.getTimeWindowRun()) != null && twr.getStartLong() > 0L) {
                                        twr.setEndLong(now);
                                    }
                                    properties.put(JobReplyProperties.key_message, JobReplyProperties.msg_process_canceled);
                                    duccEvent.setProperties(properties);
                                    logger.info(methodName, dwid, new Object[]{dpid, this.messages.fetch(JobReplyProperties.msg_process_canceled)});
                                    break;
                                }
                                default: {
                                    properties.put(JobReplyProperties.key_message, JobReplyProperties.msg_process_not_active);
                                    duccEvent.setProperties(properties);
                                    logger.info(methodName, dwid, new Object[]{dpid, this.messages.fetch(JobReplyProperties.msg_process_not_active)});
                                    break;
                                }
                            }
                        } else {
                            properties.put(JobReplyProperties.key_message, JobReplyProperties.msg_process_not_found);
                            duccEvent.setProperties(properties);
                            logger.info(methodName, dwid, new Object[]{dpid, this.messages.fetch(JobReplyProperties.msg_process_not_found)});
                        }
                    } else {
                        properties.put(JobReplyProperties.key_message, JobReplyProperties.msg_user_not_authorized);
                        duccEvent.setProperties(properties);
                        logger.info(methodName, dwid, new Object[]{jobId + " : " + this.messages.fetch(JobReplyProperties.msg_user_not_authorized)});
                    }
                } else {
                    properties.put(JobReplyProperties.key_message, JobReplyProperties.msg_job_not_found);
                    duccEvent.setProperties(properties);
                    logger.info(methodName, dwid, new Object[]{dpid, this.messages.fetch(JobReplyProperties.msg_job_not_found)});
                }
            } else {
                logger.info(methodName, dwid, new Object[]{this.messages.fetch("TODO") + " prepare error reply"});
            }
        }
        logger.trace(methodName, dwid, new Object[]{this.messages.fetch("exit")});
    }

    @Override
    public void startReservation(SubmitReservationDuccEvent duccEvent) {
        String methodName;
        block12: {
            methodName = "startReservation";
            logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
            DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
            try {
                OrchestratorHelper.assignDefaults(duccEvent);
                Properties properties = duccEvent.getProperties();
                if (this.rejectNotMaster(properties)) break block12;
                if (!this.isSignatureValid(properties)) {
                    String error_message = this.messages.fetch(" type=authentication error, text=signature not valid.");
                    logger.error(methodName, null, new Object[]{error_message});
                    this.submitError(properties, error_message);
                    break block12;
                }
                if (!Validate.accept(duccEvent)) {
                    String error_message = this.messages.fetch("Request was not accepted: System is configured to refuse reservations.");
                    logger.error(methodName, null, new Object[]{error_message});
                    this.submitError(properties, error_message);
                    break block12;
                }
                if (Validate.request(duccEvent)) {
                    DuccWorkReservation duccWorkReservation = this.reservationFactory.create((ReservationRequestProperties)properties);
                    WorkMapHelper.addDuccWork(workMap, (IDuccWork)duccWorkReservation, this, methodName);
                    duccWorkReservation.stateChange(IDuccState.ReservationState.Received);
                    OrchestratorCheckpoint.getInstance().saveState();
                    duccWorkReservation.stateChange(IDuccState.ReservationState.WaitingForResources);
                    OrchestratorCheckpoint.getInstance().saveState();
                    if (duccWorkReservation.isWaitForAssignment()) {
                        int counter = 0;
                        while (duccWorkReservation.isPending()) {
                            if (++counter > 5) {
                                counter = 0;
                                logger.info(methodName, duccWorkReservation.getDuccId(), new Object[]{"waiting for allocation..."});
                            }
                            Thread.sleep(1000L);
                        }
                        try {
                            properties.put(ReservationReplyProperties.key_message, duccWorkReservation.getCompletionRationale().getText());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    properties.put(ReservationRequestProperties.key_id, duccWorkReservation.getId());
                    properties.put(ReservationRequestProperties.key_node_list, "");
                    if (!duccWorkReservation.getReservationMap().isEmpty()) {
                        StringBuffer sb = new StringBuffer();
                        IDuccReservationMap map = duccWorkReservation.getReservationMap();
                        for (DuccId key : map.keySet()) {
                            IDuccReservation value = (IDuccReservation)duccWorkReservation.getReservationMap().get((Object)key);
                            String node = value.getNodeIdentity().getCanonicalName();
                            sb.append(node);
                            sb.append(" ");
                        }
                        properties.put(ReservationRequestProperties.key_node_list, sb.toString().trim());
                    }
                    duccEvent.setProperties(properties);
                    break block12;
                }
                logger.info(methodName, null, new Object[]{this.messages.fetch("TODO") + " prepare error reply"});
            }
            catch (Exception e) {
                logger.error(methodName, null, new Object[]{this.messages.fetch("TODO") + " prepare error reply", e});
            }
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    @Override
    public void stopReservation(CancelReservationDuccEvent duccEvent) {
        String methodName = "stopReservation";
        DuccId dwid = null;
        logger.trace(methodName, dwid, new Object[]{this.messages.fetch("enter")});
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        Properties properties = duccEvent.getProperties();
        if (!this.rejectNotMaster(properties)) {
            if (!this.isSignatureValid(properties)) {
                String error_message = this.messages.fetch(" type=authentication error, text=signature not valid.");
                logger.error(methodName, dwid, new Object[]{error_message});
                this.submitError(properties, error_message);
            } else {
                String id = properties.getProperty(ReservationRequestProperties.key_id);
                logger.info(methodName, jobid, new Object[]{ReservationRequestProperties.key_id + "=" + id});
                long t0 = System.currentTimeMillis();
                DuccWorkReservation duccWorkReservation = (DuccWorkReservation)WorkMapHelper.findDuccWork(workMap, IDuccTypes.DuccType.Reservation, id, this, methodName);
                long t1 = System.currentTimeMillis();
                long elapsed = t1 - t0;
                if (elapsed > 100L) {
                    logger.debug(methodName, dwid, new Object[]{"elapsed msecs: " + elapsed});
                }
                if (duccWorkReservation != null) {
                    if (Validate.request(duccEvent, duccWorkReservation)) {
                        dwid = duccWorkReservation.getDuccId();
                        String reqUser = properties.getProperty(JobRequestProperties.key_user).trim();
                        String reqRole = this.getRole(properties);
                        String tgtUser = duccWorkReservation.getStandardInfo().getUser().trim();
                        if (this.isAuthorized(dwid, reqUser, tgtUser, reqRole)) {
                            logger.debug(methodName, dwid, new Object[]{"reqUser:" + reqUser + " reqRole:" + reqRole + " tgtUser:" + tgtUser});
                            duccWorkReservation.getStandardInfo().setCancelUser(reqUser);
                            duccWorkReservation.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
                            duccWorkReservation.stateChange(IDuccState.ReservationState.Completed);
                            duccWorkReservation.complete(IDuccCompletionType.ReservationCompletionType.CanceledByUser);
                            String u1 = duccWorkReservation.getStandardInfo().getUser();
                            String u2 = duccWorkReservation.getStandardInfo().getCancelUser();
                            if (u1 != null && u2 != null && !u1.equals(u2)) {
                                duccWorkReservation.complete(IDuccCompletionType.ReservationCompletionType.CanceledByAdmin);
                            }
                            OrchestratorCheckpoint.getInstance().saveState();
                            properties.put(ReservationReplyProperties.key_message, ReservationReplyProperties.msg_canceled);
                            duccEvent.setProperties(properties);
                            logger.info(methodName, dwid, new Object[]{this.messages.fetchLabel("reservation state") + duccWorkReservation.getReservationState()});
                        } else {
                            properties.put(ReservationReplyProperties.key_message, ReservationReplyProperties.msg_user_not_authorized);
                            duccEvent.setProperties(properties);
                            logger.info(methodName, dwid, new Object[]{dwid + " : " + this.messages.fetch(ReservationReplyProperties.msg_user_not_authorized)});
                        }
                    } else {
                        properties.put(ReservationReplyProperties.key_message, ReservationReplyProperties.msg_user_not_authorized);
                        duccEvent.setProperties(properties);
                        logger.info(methodName, dwid, new Object[]{id + " : " + this.messages.fetch("not authorized")});
                    }
                } else {
                    properties.put(ReservationReplyProperties.key_message, ReservationReplyProperties.msg_not_found);
                    duccEvent.setProperties(properties);
                    logger.info(methodName, dwid, new Object[]{id + " : " + this.messages.fetch("reservation not found")});
                }
            }
        }
        logger.trace(methodName, dwid, new Object[]{this.messages.fetch("exit")});
    }

    @Override
    public void startService(SubmitServiceDuccEvent duccEvent) {
        String methodName;
        block11: {
            methodName = "startService";
            logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
            DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
            try {
                OrchestratorHelper.assignDefaults(duccEvent);
                JobRequestProperties properties = (JobRequestProperties)duccEvent.getProperties();
                if (this.rejectNotMaster((Properties)properties)) break block11;
                if (!this.isSignatureValid((Properties)properties)) {
                    String error_message = this.messages.fetch(" type=authentication error, text=signature not valid.");
                    logger.error(methodName, null, new Object[]{error_message});
                    this.submitError((Properties)properties, error_message);
                    break block11;
                }
                if (!SystemState.getInstance().isAcceptJobs()) {
                    String error_message = this.messages.fetch(" type=system error, text=system is not accepting new work at this time.");
                    logger.error(methodName, null, new Object[]{error_message});
                    this.submitError((Properties)properties, error_message);
                    break block11;
                }
                if (Validate.request(duccEvent)) {
                    String specificationType;
                    IDuccWorkJob duccWorkJob = this.jobFactory.createService(properties);
                    WorkMapHelper.addDuccWork(workMap, (IDuccWork)duccWorkJob, this, methodName);
                    this.stateJobAccounting.stateChange(duccWorkJob, IDuccState.JobState.Received);
                    OrchestratorCheckpoint.getInstance().saveState();
                    IDuccState.JobState nextState = IDuccState.JobState.WaitingForServices;
                    if (duccWorkJob.getServiceDependencies() == null) {
                        String message = this.messages.fetch("bypass") + " " + nextState;
                        logger.debug(methodName, duccWorkJob.getDuccId(), new Object[]{message});
                        nextState = IDuccState.JobState.WaitingForResources;
                    }
                    this.stateJobAccounting.stateChange(duccWorkJob, nextState);
                    OrchestratorCheckpoint.getInstance().saveState();
                    properties.put((Object)JobRequestProperties.key_id, (Object)duccWorkJob.getId());
                    duccEvent.setProperties((Properties)properties);
                    TypedProperties tp = new TypedProperties();
                    for (Map.Entry entry : properties.entrySet()) {
                        String name = (String)entry.getKey();
                        if (name.equals("signature")) continue;
                        String type = ITypedProperties.PropertyType.system.name();
                        if (properties.isUserProvided(name)) {
                            type = ITypedProperties.PropertyType.user.name();
                        }
                        tp.add(type, entry.getKey(), entry.getValue());
                    }
                    long id = duccWorkJob.getDuccId().getFriendly();
                    if (properties.containsKey((Object)ServiceRequestProperties.key_service_type_other)) {
                        specificationType = ITypedProperties.SpecificationType.ManagedReservation.name();
                        this.dbDuccWorks.upsertSpecification(specificationType, id, (ITypedProperties)tp);
                        logger.trace(methodName, duccWorkJob.getDuccId(), new Object[]{"type=" + specificationType});
                        break block11;
                    }
                    specificationType = ITypedProperties.SpecificationType.Service.name();
                    long instance_id = 0L;
                    try {
                        String value = properties.getProperty("id");
                        instance_id = Long.valueOf(value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    logger.trace(methodName, duccWorkJob.getDuccId(), new Object[]{"type=" + specificationType, "instance_id=" + instance_id});
                    break block11;
                }
                logger.info(methodName, null, new Object[]{this.messages.fetch("TODO") + " prepare error reply"});
            }
            catch (Throwable t) {
                logger.error(methodName, null, new Object[]{this.messages.fetch("TODO") + " prepare error reply", t});
            }
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    @Override
    public void stopService(CancelServiceDuccEvent duccEvent) {
        String methodName = "stopService";
        DuccId dwid = null;
        logger.trace(methodName, dwid, new Object[]{this.messages.fetch("enter")});
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        Properties properties = duccEvent.getProperties();
        if (!this.rejectNotMaster(properties)) {
            if (!this.isSignatureValid(properties)) {
                String error_message = this.messages.fetch(" type=authentication error, text=signature not valid.");
                logger.error(methodName, dwid, new Object[]{error_message});
                this.submitError(properties, error_message);
            } else if (Validate.request(duccEvent)) {
                String jobId = properties.getProperty(JobRequestProperties.key_id);
                logger.info(methodName, jobid, new Object[]{JobRequestProperties.key_id + "=" + jobId});
                long t0 = System.currentTimeMillis();
                DuccWorkJob duccWorkJob = (DuccWorkJob)WorkMapHelper.findDuccWork(workMap, IDuccTypes.DuccType.Service, jobId, this, methodName);
                long t1 = System.currentTimeMillis();
                long elapsed = t1 - t0;
                if (elapsed > 100L) {
                    logger.debug(methodName, dwid, new Object[]{"elapsed msecs: " + elapsed});
                }
                IDuccContext.DuccContext context = duccEvent.getContext();
                if (duccWorkJob != null) {
                    dwid = duccWorkJob.getDuccId();
                    String reqUser = properties.getProperty(JobRequestProperties.key_user).trim();
                    String reqRole = this.getRole(properties);
                    String tgtUser = duccWorkJob.getStandardInfo().getUser().trim();
                    if (this.isAuthorized(dwid, reqUser, tgtUser, reqRole)) {
                        String type;
                        logger.debug(methodName, dwid, new Object[]{"reqUser:" + reqUser + " reqRole:" + reqRole + " tgtUser:" + tgtUser});
                        switch (context) {
                            case ManagedReservation: {
                                type = "managed reservation";
                                break;
                            }
                            default: {
                                type = "service";
                            }
                        }
                        String givenReason = properties.getProperty(SpecificationProperties.key_reason);
                        Reason reason = new Reason(dwid, reqUser, reqRole, givenReason);
                        Rationale rationale = new Rationale(reason.toString());
                        IDuccCompletionType.JobCompletionType jobCompletionType = IDuccCompletionType.JobCompletionType.CanceledByUser;
                        if (reqRole.equals(SpecificationProperties.key_role_administrator)) {
                            jobCompletionType = IDuccCompletionType.JobCompletionType.CanceledByAdministrator;
                        }
                        this.stateManager.jobTerminate((IDuccWorkJob)duccWorkJob, jobCompletionType, (IRationale)rationale, IResourceState.ProcessDeallocationType.ServiceStopped);
                        OrchestratorCheckpoint.getInstance().saveState();
                        properties.put(JobReplyProperties.key_message, JobReplyProperties.msg_canceled);
                        duccEvent.setProperties(properties);
                        logger.info(methodName, dwid, new Object[]{this.messages.fetchLabel(type + " state") + duccWorkJob.getJobState()});
                    } else {
                        properties.put(JobReplyProperties.key_message, JobReplyProperties.msg_user_not_authorized);
                        duccEvent.setProperties(properties);
                        logger.info(methodName, dwid, new Object[]{jobId + " : " + this.messages.fetch(JobReplyProperties.msg_user_not_authorized)});
                    }
                } else {
                    String message;
                    switch (context) {
                        case ManagedReservation: {
                            message = JobReplyProperties.msg_managed_reservation_not_found;
                            break;
                        }
                        default: {
                            message = JobReplyProperties.msg_service_not_found;
                        }
                    }
                    properties.put(JobReplyProperties.key_message, message);
                    duccEvent.setProperties(properties);
                    logger.info(methodName, dwid, new Object[]{jobId + " : " + this.messages.fetch(message)});
                }
            } else {
                logger.info(methodName, dwid, new Object[]{this.messages.fetch("TODO") + " prepare error reply"});
            }
        }
        logger.trace(methodName, dwid, new Object[]{this.messages.fetch("exit")});
    }

    private void startRmAdminChannel(final String endpoint, final AbstractDuccComponent delegate) throws Exception {
        String methodName = "startRmAdminChannel";
        this.getContext().addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                String methodName = "startRmAdminChannel.configure";
                if (logger != null) {
                    logger.info(methodName, null, new Object[]{"Admin Channel Configure on endpoint:" + endpoint});
                }
                this.onException(Exception.class).handled(true).process((Processor)new AbstractDuccComponent.ErrorProcessor((AbstractDuccComponent)OrchestratorComponent.this));
                this.from(endpoint).routeId(OrchestratorComponent.this.RMAdminRoute).unmarshal().xstream().process((Processor)new RmAdminEventProcessor(delegate));
            }
        });
        this.getContext().startRoute(this.RMAdminRoute);
        if (logger != null) {
            logger.info(methodName, null, new Object[]{"Admin Channel Activated on endpoint:" + endpoint});
        }
    }

    class RmAdminEventProcessor
    implements Processor {
        final AbstractDuccComponent delegate;
        private DuccRmAdmin admin = new DuccRmAdmin((CamelContext)new DefaultCamelContext(), "ducc.rm.admin.endpoint");

        public RmAdminEventProcessor(AbstractDuccComponent delegate) {
            this.delegate = delegate;
        }

        public void process(Exchange exchange) throws Exception {
            String location = "RmAdminEventProcessor.process";
            Object body = exchange.getIn().getBody();
            logger.info(location, jobid, new Object[]{"Received Admin Message of Type:", body.getClass().getName()});
            RmAdminReply reply = null;
            if (body instanceof DuccAdminEvent) {
                DuccAdminEvent dae = (DuccAdminEvent)body;
                try {
                    logger.debug(location, jobid, new Object[]{"dispatch"});
                    SystemEventsLogger.info(IDuccLoggerComponents.abbrv_resourceManager, dae);
                    reply = this.admin.dispatchAndWaitForReply(dae);
                    logger.debug(location, jobid, new Object[]{"dispatch completed"});
                    SystemEventsLogger.info(IDuccLoggerComponents.abbrv_resourceManager, dae, reply);
                }
                catch (Exception e) {
                    logger.error(location, jobid, (Throwable)e, new Object[0]);
                }
            } else {
                logger.info(location, jobid, new Object[]{"Invalid RM event:", body.getClass().getName()});
                reply = new RmAdminReply();
                reply.setMessage("Unrecognized RM event.");
            }
            exchange.getIn().setBody(reply);
        }
    }
}

