/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.SerializationUtils;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.ComponentHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.common.utils.id.IDuccIdFactory;
import org.apache.uima.ducc.orchestrator.OrchestratorRecovery;
import org.apache.uima.ducc.orchestrator.ProcessAccounting;
import org.apache.uima.ducc.orchestrator.ProcessToJobMap;
import org.apache.uima.ducc.orchestrator.ckpt.OrchestratorCheckpoint;
import org.apache.uima.ducc.orchestrator.jd.scheduler.JdScheduler;
import org.apache.uima.ducc.orchestrator.state.DuccWorkIdFactory;
import org.apache.uima.ducc.orchestrator.utilities.Checkpointable;
import org.apache.uima.ducc.orchestrator.utilities.TrackSync;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.history.HistoryFactory;
import org.apache.uima.ducc.transport.event.common.history.IHistoryPersistenceManager;

public class OrchestratorCommonArea {
    private static OrchestratorCommonArea orchestratorCommonArea = null;
    private static final DuccLogger logger = DuccLogger.getLogger(OrchestratorCommonArea.class);
    private static final DuccId jobid = null;
    private static DuccPropertiesResolver dpr = DuccPropertiesResolver.getInstance();
    private IHistoryPersistenceManager historyPersistenceManager = null;
    private IDuccIdFactory duccIdFactory = null;
    private ProcessAccounting processAccounting = null;
    private DuccWorkMap workMap = null;
    private Messages systemMessages = Messages.getInstance();
    private Messages userMessages = Messages.getInstance();
    private JdScheduler jdScheduler = null;
    private boolean signatureRequired = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrchestratorCommonArea getInstance() {
        Class<OrchestratorCommonArea> clazz = OrchestratorCommonArea.class;
        synchronized (OrchestratorCommonArea.class) {
            if (orchestratorCommonArea == null) {
                orchestratorCommonArea = new OrchestratorCommonArea();
                orchestratorCommonArea.init();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return orchestratorCommonArea;
        }
    }

    private OrchestratorCommonArea() {
    }

    public void restart() {
        String location = "restart";
        this.init();
        logger.debug(location, jobid, new Object[]{"jobs:" + this.workMap.getJobCount()});
        logger.debug(location, jobid, new Object[]{"reservations:" + this.workMap.getReservationCount()});
        logger.debug(location, jobid, new Object[]{"services:" + this.workMap.getServiceCount()});
        Set serviceKeys = this.workMap.getServiceKeySet();
        if (serviceKeys != null) {
            for (DuccId duccId : serviceKeys) {
                logger.info(location, duccId, new Object[]{""});
            }
        }
    }

    private void init() {
        String methodName = "init";
        Boolean use_lock_file = new Boolean(dpr.getProperty("ducc.orchestrator.use.lock.file"));
        if (use_lock_file.booleanValue()) {
            ComponentHelper.oneInstance((String)IDuccEnv.DUCC_STATE_DIR, (String)"orchestrator");
        }
        this.setDuccIdFactory(new DuccWorkIdFactory());
        this.workMap = new DuccWorkMap();
        this.processAccounting = new ProcessAccounting();
        OrchestratorCheckpoint.getInstance().restoreState();
        OrchestratorCheckpoint.getInstance().saveState();
        this.jdScheduler = JdScheduler.getInstance();
        try {
            this.historyPersistenceManager = HistoryFactory.getInstance((String)this.getClass().getName());
        }
        catch (Exception e) {
            logger.error(methodName, null, new Object[]{"Cannot acquire the history manager", e});
            System.exit(1);
        }
        logger.info(methodName, null, new Object[]{"Got history manager of class", this.historyPersistenceManager.getClass().getName()});
        OrchestratorRecovery orchestratorRecovery = new OrchestratorRecovery(this.historyPersistenceManager);
        long historicSeqNo = orchestratorRecovery.recoverSeqNo();
        long previousSeqNo = this.getDuccIdFactory().setIfMax(historicSeqNo);
        if (previousSeqNo != historicSeqNo) {
            logger.warn(methodName, jobid, new Object[]{"properties:" + previousSeqNo + " historic:" + historicSeqNo});
        }
    }

    public String getStateDirectory() {
        return IDuccEnv.DUCC_STATE_DIR;
    }

    private void setDuccIdFactory(IDuccIdFactory instance) {
        this.duccIdFactory = instance;
    }

    public IDuccIdFactory getDuccIdFactory() {
        return this.duccIdFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Checkpointable getCheckpointable() {
        ConcurrentHashMap<DuccId, DuccId> ckptProcessToJobMap;
        DuccWorkMap ckptWorkMap;
        String methodName = "getCheckpointable";
        TrackSync ts = TrackSync.await(this.workMap, this.getClass(), methodName);
        OrchestratorCommonArea orchestratorCommonArea = this;
        synchronized (orchestratorCommonArea) {
            ts.using();
            ckptWorkMap = (DuccWorkMap)SerializationUtils.clone((Serializable)this.workMap);
            ckptProcessToJobMap = ProcessToJobMap.getInstance().getMap();
        }
        ts.ended();
        return new Checkpointable(ckptWorkMap, ckptProcessToJobMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckpointable(Checkpointable checkpointable) {
        String methodName = "setCheckpointable";
        TrackSync ts = TrackSync.await(this.workMap, this.getClass(), methodName);
        OrchestratorCommonArea orchestratorCommonArea = this;
        synchronized (orchestratorCommonArea) {
            ts.using();
            this.workMap = checkpointable.getWorkMap();
            ProcessToJobMap.getInstance().putMap(checkpointable.getProcessToJobMap());
        }
        ts.ended();
    }

    public ProcessAccounting getProcessAccounting() {
        return this.processAccounting;
    }

    public DuccWorkMap getWorkMap() {
        return this.workMap;
    }

    public void setWorkMap(DuccWorkMap workMap) {
        this.workMap = workMap;
    }

    public void initSystemMessages(String language, String country) {
        this.systemMessages = Messages.getInstance((String)language, (String)country);
    }

    public void initUserMessages(String language, String country) {
        this.userMessages = Messages.getInstance((String)language, (String)country);
    }

    public Messages getSystemMessages() {
        return this.systemMessages;
    }

    public Messages getUserMessages() {
        return this.userMessages;
    }

    public JdScheduler getJdScheduler() {
        return this.jdScheduler;
    }

    public IHistoryPersistenceManager getHistoryPersistencemanager() {
        return this.historyPersistenceManager;
    }

    public void setSignatureRequired() {
        this.signatureRequired = true;
    }

    public void resetSignatureRequired() {
        this.signatureRequired = false;
    }

    public boolean isSignatureRequired() {
        return this.signatureRequired;
    }
}

