/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.regex.CaseVariants;
import net.sf.saxon.regex.RegexData;
import net.sf.saxon.regex.RegexSyntaxException;
import net.sf.saxon.regex.RegexTranslator;
import net.sf.saxon.value.Whitespace;

public class JDK15RegexTranslator
extends RegexTranslator {
    public static final CharClass[] categoryCharClasses = new CharClass["LMNPZSC".length()];
    public static final CharClass[] subCategoryCharClasses = new CharClass["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    public static final CharClass[] specialBlockCharClasses = new CharClass[]{new CharRange(66304, 66351), new CharRange(66352, 66383), new CharRange(66560, 66639), new CharRange(118784, 119039), new CharRange(119040, 119295), new CharRange(119808, 120831), new CharRange(131072, 173782), new CharRange(194560, 195103), new CharRange(917504, 917631), new Union(new CharClass[]{new CharRange(57344, 63743), new CharRange(983040, 1048573), new CharRange(0x100000, 1114109)}), Empty.getInstance(), Empty.getInstance(), Empty.getInstance()};
    private static final CharClass DOT_SCHEMA = new Complement(new Union(new CharClass[]{new SingleChar(10), new SingleChar(13)}));
    private static final CharClass ESC_d = new Property("Nd");
    private static final CharClass ESC_D = new Complement(ESC_d);
    private static final CharClass ESC_W = new Union(new CharClass[]{JDK15RegexTranslator.computeCategoryCharClass('P'), JDK15RegexTranslator.computeCategoryCharClass('Z'), JDK15RegexTranslator.computeCategoryCharClass('C')});
    private static final CharClass ESC_w = new Complement(ESC_W);
    private static final CharClass ESC_s = new Union(new CharClass[]{new SingleChar(32), new SingleChar(10), new SingleChar(13), new SingleChar(9)});
    private static final CharClass ESC_S = new Complement(ESC_s);
    private static final CharClass ESC_i = JDK15RegexTranslator.makeCharClass("LlLuLoLtNl", ":_\u02bb\u02bc\u02bd\u02be\u02bf\u02c0\u02c1\u0559\u06e5\u06e6\u212e", "\u00aa\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02ad\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u048c\u048f\u04ec\u04ed\u0587\u0587\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07a5\u0950\u0950\u0ad0\u0ad0\u0d85\u0dc6\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u1055\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a8\u207f\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final CharClass ESC_I = new Complement(ESC_i);
    private static final CharClass ESC_c = JDK15RegexTranslator.makeCharClass("LlLuLoLtNlMcMeMnLmNd", "-.:_\u00b7\u0387\u06dd\u212e", "\u00aa\u00b5\u00ba\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02b8\u02e0\u02ee\u0346\u034e\u0362\u037a\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u0488\u048f\u04ec\u04ed\u0587\u0587\u0653\u0655\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07b0\u0950\u0950\u0ad0\u0ad0\u0d82\u0df3\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u0f6a\u0f96\u0f96\u0fae\u0fb0\u0fb8\u0fb8\u0fba\u1059\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a9\u207f\u207f\u20dd\u20e0\u20e2\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u2183\u3006\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final CharClass ESC_C = new Complement(ESC_c);

    private JDK15RegexTranslator(CharSequence charSequence) {
        this.regExp = charSequence;
        this.length = charSequence.length();
    }

    public static String translate(CharSequence charSequence, boolean bl, boolean bl2, boolean bl3) throws RegexSyntaxException {
        JDK15RegexTranslator jDK15RegexTranslator = new JDK15RegexTranslator(charSequence);
        jDK15RegexTranslator.isXPath = bl;
        jDK15RegexTranslator.ignoreWhitespace = bl2;
        jDK15RegexTranslator.caseBlind = bl3;
        jDK15RegexTranslator.advance();
        jDK15RegexTranslator.translateTop();
        return jDK15RegexTranslator.result.toString();
    }

    protected boolean translateAtom() throws RegexSyntaxException {
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
            }
            case ')': 
            case '*': 
            case '+': 
            case '?': 
            case ']': 
            case '{': 
            case '|': 
            case '}': {
                return false;
            }
            case '(': {
                this.copyCurChar();
                int n = ++this.currentCapture;
                this.translateRegExp();
                this.expect(')');
                this.captures.add(n);
                this.copyCurChar();
                return true;
            }
            case '\\': {
                this.advance();
                this.parseEsc().output(this.result);
                return true;
            }
            case '[': {
                this.inCharClassExpr = true;
                this.advance();
                this.parseCharClassExpr().output(this.result);
                return true;
            }
            case '.': {
                if (this.isXPath) break;
                DOT_SCHEMA.output(this.result);
                this.advance();
                return true;
            }
            case '$': 
            case '^': {
                if (this.isXPath) {
                    this.copyCurChar();
                    return true;
                }
                this.result.append('\\');
                break;
            }
            default: {
                int n;
                int[] nArray;
                if (!this.caseBlind || (nArray = CaseVariants.getCaseVariants(n = this.absorbSurrogatePair())).length <= 0) break;
                CharClass[] charClassArray = new CharClass[nArray.length + 1];
                charClassArray[0] = new SingleChar(n);
                for (int i = 0; i < nArray.length; ++i) {
                    charClassArray[i + 1] = new SingleChar(nArray[i]);
                }
                Union union = new Union(charClassArray);
                union.output(this.result);
                this.advance();
                return true;
            }
        }
        this.copyCurChar();
        return true;
    }

    private static CharClass makeCharClass(String string, String string2, String string3) {
        int n;
        int n2;
        ArrayList<SimpleCharClass> arrayList = new ArrayList<SimpleCharClass>(5);
        int n3 = string.length();
        for (n2 = 0; n2 < n3; n2 += 2) {
            arrayList.add(new Property(string.substring(n2, n2 + 2)));
        }
        n3 = string2.length();
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = n2 + 1; n < n3 && string2.charAt(n) - string2.charAt(n2) == n - n2; ++n) {
            }
            if (n2 == --n - 1) {
                --n;
            }
            if (n2 == n) {
                arrayList.add(new SingleChar(string2.charAt(n2)));
            } else {
                arrayList.add(new CharRange(string2.charAt(n2), string2.charAt(n)));
            }
            n2 = n;
        }
        ArrayList<SimpleCharClass> arrayList2 = new ArrayList<SimpleCharClass>(5);
        n = string3.length();
        for (n3 = 0; n3 < n; n3 += 2) {
            char c;
            char c2 = string3.charAt(n3);
            if (c2 == (c = string3.charAt(n3 + 1))) {
                arrayList2.add(new SingleChar(c2));
                continue;
            }
            if (c2 == c - '\u0001') {
                arrayList2.add(new SingleChar(c2));
                arrayList2.add(new SingleChar(c));
                continue;
            }
            arrayList2.add(new CharRange(c2, c));
        }
        return new Subtraction(new Union(arrayList), new Union(arrayList2));
    }

    private CharClass parseEsc() throws RegexSyntaxException {
        switch (this.curChar) {
            case 'n': {
                this.advance();
                return new SingleChar(10);
            }
            case 'r': {
                this.advance();
                return new SingleChar(13);
            }
            case 't': {
                this.advance();
                return new SingleChar(9);
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                break;
            }
            case 's': {
                this.advance();
                return ESC_s;
            }
            case 'S': {
                this.advance();
                return ESC_S;
            }
            case 'i': {
                this.advance();
                return ESC_i;
            }
            case 'I': {
                this.advance();
                return ESC_I;
            }
            case 'c': {
                this.advance();
                return ESC_c;
            }
            case 'C': {
                this.advance();
                return ESC_C;
            }
            case 'd': {
                this.advance();
                return ESC_d;
            }
            case 'D': {
                this.advance();
                return ESC_D;
            }
            case 'w': {
                this.advance();
                return ESC_w;
            }
            case 'W': {
                this.advance();
                return ESC_W;
            }
            case 'p': {
                this.advance();
                return this.parseProp();
            }
            case 'P': {
                this.advance();
                return new Complement(this.parseProp());
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.isXPath) {
                    char c = this.curChar;
                    int n = c - 48;
                    this.advance();
                    int n2 = "0123456789".indexOf(this.curChar);
                    if (n2 >= 0) {
                        int n3 = n * 10 + n2;
                        this.advance();
                        if (this.captures.contains(n3)) {
                            return new BackReference(n3);
                        }
                        this.recede();
                    }
                    if (this.captures.contains(n)) {
                        return new BackReference(n);
                    }
                    return new BackReference(-1);
                }
                throw this.makeException("digit not allowed after \\");
            }
            case '$': {
                if (this.isXPath) break;
            }
            default: {
                throw this.makeException("invalid escape sequence");
            }
        }
        SingleChar singleChar = new SingleChar(this.curChar);
        this.advance();
        return singleChar;
    }

    private CharClass parseProp() throws RegexSyntaxException {
        this.expect('{');
        int n = this.pos;
        while (true) {
            this.advance();
            if (this.curChar == '}') break;
            if (JDK15RegexTranslator.isAsciiAlnum(this.curChar) || this.curChar == '-') continue;
            this.expect('}');
        }
        CharSequence charSequence = this.regExp.subSequence(n, this.pos - 1);
        if (this.ignoreWhitespace && !this.inCharClassExpr) {
            charSequence = Whitespace.removeAllWhitespace(charSequence);
        }
        String string = ((Object)charSequence).toString();
        this.advance();
        switch (string.length()) {
            case 0: {
                throw this.makeException("empty property name");
            }
            case 2: {
                int n2 = "LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".indexOf(string);
                if (n2 < 0 || n2 % 2 == 1) {
                    throw this.makeException("unknown category");
                }
                return JDK15RegexTranslator.getSubCategoryCharClass(n2 / 2);
            }
            case 1: {
                int n3 = "LMNPZSC".indexOf(string.charAt(0));
                if (n3 < 0) {
                    throw this.makeException("unknown category", string);
                }
                return JDK15RegexTranslator.getCategoryCharClass(n3);
            }
        }
        if (string.startsWith("Is")) {
            String string2 = string.substring(2);
            for (int i = 0; i < RegexData.specialBlockNames.length; ++i) {
                if (!string2.equals(RegexData.specialBlockNames[i])) continue;
                return specialBlockCharClasses[i];
            }
            if (!JDK15RegexTranslator.isBlock(string2)) {
                throw this.makeException("invalid block name", string2);
            }
            return new Property("In" + string2);
        }
        throw this.makeException("invalid property name", string);
    }

    private CharClass parseCharClassExpr() throws RegexSyntaxException {
        CharClass charClass;
        boolean bl;
        if (this.curChar == '^') {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        ArrayList<CharClass> arrayList = new ArrayList<CharClass>(10);
        do {
            charClass = this.parseCharClassEscOrXmlChar(true);
            arrayList.add(charClass);
            if (this.curChar == ']' || this.eos) {
                this.addCaseVariant(charClass, arrayList);
                break;
            }
            if (this.curChar == '-') {
                char c = this.regExp.charAt(this.pos);
                if (c == '[') {
                    this.addCaseVariant(charClass, arrayList);
                    this.advance();
                    break;
                }
                if (c == ']') {
                    this.addCaseVariant(charClass, arrayList);
                    continue;
                }
                this.advance();
                CharClass charClass2 = this.parseCharClassEscOrXmlChar(true);
                if (charClass.getSingleChar() < 0 || charClass2.getSingleChar() < 0) {
                    throw this.makeException("multi_range");
                }
                if (charClass.getSingleChar() > charClass2.getSingleChar()) {
                    throw this.makeException("invalid range (start > end)");
                }
                arrayList.set(arrayList.size() - 1, new CharRange(charClass.getSingleChar(), charClass2.getSingleChar()));
                if (this.caseBlind) {
                    int n;
                    if (charClass.getSingleChar() == 97 && charClass2.getSingleChar() == 122) {
                        arrayList.add(new CharRange(65, 90));
                        for (n = 0; n < CaseVariants.ROMAN_VARIANTS.length; ++n) {
                            arrayList.add(new SingleChar(CaseVariants.ROMAN_VARIANTS[n]));
                        }
                    } else if (charClass.getSingleChar() == 65 && charClass2.getSingleChar() == 90) {
                        arrayList.add(new CharRange(97, 122));
                        for (n = 0; n < CaseVariants.ROMAN_VARIANTS.length; ++n) {
                            arrayList.add(new SingleChar(CaseVariants.ROMAN_VARIANTS[n]));
                        }
                    } else {
                        for (n = charClass.getSingleChar(); n <= charClass2.getSingleChar(); ++n) {
                            int[] nArray = CaseVariants.getCaseVariants(n);
                            for (int i = 0; i < nArray.length; ++i) {
                                arrayList.add(new SingleChar(nArray[i]));
                            }
                        }
                    }
                }
                if (this.curChar != '-' || this.regExp.charAt(this.pos) != '[') continue;
                this.advance();
                break;
            }
            this.addCaseVariant(charClass, arrayList);
        } while (this.curChar != ']');
        if (this.eos) {
            this.expect(']');
        }
        charClass = arrayList.size() == 1 ? (CharClass)arrayList.get(0) : new Union(arrayList);
        if (bl) {
            charClass = new Complement(charClass);
        }
        if (this.curChar == '[') {
            this.advance();
            charClass = new Subtraction(charClass, this.parseCharClassExpr());
            this.expect(']');
        }
        this.inCharClassExpr = false;
        this.advance();
        return charClass;
    }

    private void addCaseVariant(CharClass charClass, List list) {
        if (this.caseBlind) {
            int[] nArray = CaseVariants.getCaseVariants(charClass.getSingleChar());
            for (int i = 0; i < nArray.length; ++i) {
                list.add(new SingleChar(nArray[i]));
            }
        }
    }

    private boolean isLastInGroup() {
        char c = this.regExp.charAt(this.pos);
        return c == ']' || c == '[';
    }

    private CharClass parseCharClassEscOrXmlChar(boolean bl) throws RegexSyntaxException {
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
                this.expect(']');
                break;
            }
            case '\\': {
                this.advance();
                return this.parseEsc();
            }
            case '[': 
            case ']': {
                throw this.makeException("character must be escaped", new String(new char[]{this.curChar}));
            }
        }
        SingleChar singleChar = new SingleChar(this.absorbSurrogatePair());
        this.advance();
        return singleChar;
    }

    private static synchronized CharClass getCategoryCharClass(int n) {
        if (categoryCharClasses[n] == null) {
            JDK15RegexTranslator.categoryCharClasses[n] = JDK15RegexTranslator.computeCategoryCharClass("LMNPZSC".charAt(n));
        }
        return categoryCharClasses[n];
    }

    private static synchronized CharClass getSubCategoryCharClass(int n) {
        if (subCategoryCharClasses[n] == null) {
            JDK15RegexTranslator.subCategoryCharClasses[n] = JDK15RegexTranslator.computeSubCategoryCharClass("LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".substring(n * 2, (n + 1) * 2));
        }
        return subCategoryCharClasses[n];
    }

    private static CharClass computeCategoryCharClass(char c) {
        int n;
        ArrayList<CharClass> arrayList = new ArrayList<CharClass>(5);
        arrayList.add(new Property(new String(new char[]{c})));
        int n2 = "NoLoMnCfLlNlPoLuMcNdSoSmCo".indexOf(c);
        while (n2 >= 0) {
            int[] nArray = RegexData.CATEGORY_RANGES[n2 / 2];
            for (n = 0; n < nArray.length; n += 2) {
                arrayList.add(new CharRange(nArray[n], nArray[n + 1]));
            }
            n2 = "NoLoMnCfLlNlPoLuMcNdSoSmCo".indexOf(c, n2 + 1);
        }
        if (c == 'P') {
            arrayList.add(JDK15RegexTranslator.makeCharClass("\u00ab\u2018\u201b\u201c\u201f\u2039\u00bb\u2019\u201d\u203a"));
        }
        if (c == 'L') {
            arrayList.add(new SingleChar(1013));
            arrayList.add(new SingleChar(1012));
        }
        if (c == 'C') {
            arrayList.add(new Subtraction(new Property("Cn"), new Union(new CharClass[]{new SingleChar(1012), new SingleChar(1013)})));
            ArrayList<CharRange> arrayList2 = new ArrayList<CharRange>(5);
            for (int i = 0; i < RegexData.CATEGORY_RANGES.length; ++i) {
                for (n = 0; n < RegexData.CATEGORY_RANGES[i].length; n += 2) {
                    arrayList2.add(new CharRange(RegexData.CATEGORY_RANGES[i][n], RegexData.CATEGORY_RANGES[i][n + 1]));
                }
            }
            arrayList.add(new Subtraction(new CharRange(65536, 0x10FFFF), new Union(arrayList2)));
        }
        if (arrayList.size() == 1) {
            return (CharClass)arrayList.get(0);
        }
        return new Union(arrayList);
    }

    private static CharClass computeSubCategoryCharClass(String string) {
        Property property = new Property(string);
        int n = "NoLoMnCfLlNlPoLuMcNdSoSmCo".indexOf(string);
        if (n < 0) {
            if (string.equals("Cn")) {
                ArrayList<SimpleCharClass> arrayList = new ArrayList<SimpleCharClass>(5);
                arrayList.add(new SingleChar(1012));
                arrayList.add(new SingleChar(1013));
                for (int i = 0; i < RegexData.CATEGORY_RANGES.length; ++i) {
                    for (int j = 0; j < RegexData.CATEGORY_RANGES[i].length; j += 2) {
                        arrayList.add(new CharRange(RegexData.CATEGORY_RANGES[i][j], RegexData.CATEGORY_RANGES[i][j + 1]));
                    }
                }
                return new Subtraction(new Union(new CharClass[]{property, new CharRange(65536, 0x10FFFF)}), new Union(arrayList));
            }
            if (string.equals("Pi")) {
                return JDK15RegexTranslator.makeCharClass("\u00ab\u2018\u201b\u201c\u201f\u2039");
            }
            if (string.equals("Pf")) {
                return JDK15RegexTranslator.makeCharClass("\u00bb\u2019\u201d\u203a");
            }
            return property;
        }
        ArrayList<SimpleCharClass> arrayList = new ArrayList<SimpleCharClass>(5);
        arrayList.add(property);
        int[] nArray = RegexData.CATEGORY_RANGES[n / 2];
        for (int i = 0; i < nArray.length; i += 2) {
            arrayList.add(new CharRange(nArray[i], nArray[i + 1]));
        }
        if (string.equals("Lu")) {
            arrayList.add(new SingleChar(1012));
        } else if (string.equals("Ll")) {
            arrayList.add(new SingleChar(1013));
        } else if (string.equals("Nl")) {
            arrayList.add(new CharRange(5870, 5872));
        } else if (string.equals("No")) {
            return new Subtraction(new Union(arrayList), new CharRange(5870, 5872));
        }
        return new Union(arrayList);
    }

    private static CharClass makeCharClass(String string) {
        ArrayList<SingleChar> arrayList = new ArrayList<SingleChar>(5);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new SingleChar(string.charAt(i)));
        }
        return new Union(arrayList);
    }

    public static void main(String[] stringArray) throws RegexSyntaxException {
        String string = JDK15RegexTranslator.translate(stringArray[0], stringArray[1].equals("xpath"), false, true);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '~') {
                System.err.print(c);
                continue;
            }
            System.err.print("\\u");
            for (int j = 12; j >= 0; j -= 4) {
                System.err.print("0123456789ABCDEF".charAt(c >> j & 0xF));
            }
        }
        try {
            Pattern.compile(string);
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
        }
        System.err.println();
    }

    static class Complement
    extends CharClass {
        private final CharClass cc;

        Complement(CharClass charClass) {
            this.cc = charClass;
        }

        void output(FastStringBuffer fastStringBuffer) {
            this.cc.outputComplement(fastStringBuffer);
        }

        void outputComplement(FastStringBuffer fastStringBuffer) {
            this.cc.output(fastStringBuffer);
        }
    }

    static class BackReference
    extends CharClass {
        private final int i;

        BackReference(int n) {
            this.i = n;
        }

        void output(FastStringBuffer fastStringBuffer) {
            this.inClassOutput(fastStringBuffer);
        }

        void outputComplement(FastStringBuffer fastStringBuffer) {
            this.inClassOutput(fastStringBuffer);
        }

        void inClassOutput(FastStringBuffer fastStringBuffer) {
            if (this.i != -1) {
                fastStringBuffer.append("(?:\\" + this.i + ")");
            } else {
                fastStringBuffer.append("(?:)");
            }
        }
    }

    static class Union
    extends CharClass {
        private final List members;

        Union(CharClass[] charClassArray) {
            this(Union.toList(charClassArray));
        }

        private static List toList(CharClass[] charClassArray) {
            ArrayList<CharClass> arrayList = new ArrayList<CharClass>(5);
            for (int i = 0; i < charClassArray.length; ++i) {
                arrayList.add(charClassArray[i]);
            }
            return arrayList;
        }

        Union(List list) {
            this.members = list;
        }

        void output(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append('[');
            int n = this.members.size();
            for (int i = 0; i < n; ++i) {
                CharClass charClass = (CharClass)this.members.get(i);
                charClass.output(fastStringBuffer);
            }
            fastStringBuffer.append(']');
        }

        void outputComplement(FastStringBuffer fastStringBuffer) {
            CharClass charClass;
            int n;
            boolean bl = true;
            int n2 = this.members.size();
            for (n = 0; n < n2; ++n) {
                charClass = (CharClass)this.members.get(n);
                if (!(charClass instanceof SimpleCharClass)) continue;
                if (bl) {
                    fastStringBuffer.append("[^");
                    bl = false;
                }
                ((SimpleCharClass)charClass).inClassOutput(fastStringBuffer);
            }
            for (n = 0; n < n2; ++n) {
                charClass = (CharClass)this.members.get(n);
                if (charClass instanceof SimpleCharClass) continue;
                if (bl) {
                    fastStringBuffer.append('[');
                    bl = false;
                } else {
                    fastStringBuffer.append("&&");
                }
                charClass.outputComplement(fastStringBuffer);
            }
            if (bl) {
                fastStringBuffer.append("[\u0001-");
                fastStringBuffer.appendWideChar(0x10FFFF);
                fastStringBuffer.append("]");
            } else {
                fastStringBuffer.append(']');
            }
        }
    }

    static class Subtraction
    extends CharClass {
        private final CharClass cc1;
        private final CharClass cc2;

        Subtraction(CharClass charClass, CharClass charClass2) {
            this.cc1 = charClass;
            this.cc2 = charClass2;
        }

        void output(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append('[');
            this.cc1.output(fastStringBuffer);
            fastStringBuffer.append("&&");
            this.cc2.outputComplement(fastStringBuffer);
            fastStringBuffer.append(']');
        }

        void outputComplement(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append('[');
            this.cc1.outputComplement(fastStringBuffer);
            this.cc2.output(fastStringBuffer);
            fastStringBuffer.append(']');
        }
    }

    static class Property
    extends SimpleCharClass {
        private final String name;

        Property(String string) {
            this.name = string;
        }

        void inClassOutput(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("\\p{");
            fastStringBuffer.append(this.name);
            fastStringBuffer.append('}');
        }

        void outputComplement(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("\\P{");
            fastStringBuffer.append(this.name);
            fastStringBuffer.append('}');
        }
    }

    static class CharRange
    extends SimpleCharClass {
        private final int lower;
        private final int upper;

        CharRange(int n, int n2) {
            this.lower = n;
            this.upper = n2;
        }

        void inClassOutput(FastStringBuffer fastStringBuffer) {
            if (JDK15RegexTranslator.isJavaMetaChar(this.lower)) {
                fastStringBuffer.append('\\');
            }
            fastStringBuffer.appendWideChar(this.lower);
            fastStringBuffer.append('-');
            if (JDK15RegexTranslator.isJavaMetaChar(this.upper)) {
                fastStringBuffer.append('\\');
            }
            fastStringBuffer.appendWideChar(this.upper);
        }
    }

    static class Empty
    extends SimpleCharClass {
        private static final Empty instance = new Empty();

        private Empty() {
        }

        static Empty getInstance() {
            return instance;
        }

        void output(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("\\x00");
        }

        void outputComplement(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("[^\\x00]");
        }

        void inClassOutput(FastStringBuffer fastStringBuffer) {
            throw new RuntimeException("BMP output botch");
        }
    }

    static class SingleChar
    extends SimpleCharClass {
        private final int c;

        SingleChar(int n) {
            this.c = n;
        }

        int getSingleChar() {
            return this.c;
        }

        void output(FastStringBuffer fastStringBuffer) {
            this.inClassOutput(fastStringBuffer);
        }

        void inClassOutput(FastStringBuffer fastStringBuffer) {
            if (JDK15RegexTranslator.isJavaMetaChar(this.c)) {
                fastStringBuffer.append('\\');
                fastStringBuffer.append((char)this.c);
            } else {
                switch (this.c) {
                    case 13: {
                        fastStringBuffer.append("\\r");
                        break;
                    }
                    case 10: {
                        fastStringBuffer.append("\\n");
                        break;
                    }
                    case 9: {
                        fastStringBuffer.append("\\t");
                        break;
                    }
                    case 32: {
                        fastStringBuffer.append("\\x20");
                        break;
                    }
                    default: {
                        fastStringBuffer.appendWideChar(this.c);
                    }
                }
            }
        }
    }

    static abstract class SimpleCharClass
    extends CharClass {
        SimpleCharClass() {
        }

        void output(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append('[');
            this.inClassOutput(fastStringBuffer);
            fastStringBuffer.append(']');
        }

        void outputComplement(FastStringBuffer fastStringBuffer) {
            fastStringBuffer.append("[^");
            this.inClassOutput(fastStringBuffer);
            fastStringBuffer.append(']');
        }

        abstract void inClassOutput(FastStringBuffer var1);
    }

    static abstract class CharClass {
        protected CharClass() {
        }

        abstract void output(FastStringBuffer var1);

        abstract void outputComplement(FastStringBuffer var1);

        int getSingleChar() {
            return -1;
        }
    }
}

