/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class TracingFilter
extends ProxyReceiver {
    private static int id = 0;
    private String indent = "";

    public TracingFilter() {
        ++id;
    }

    public TracingFilter(Receiver receiver) {
        ++id;
        this.setUnderlyingReceiver(receiver);
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " ATTRIBUTE " + this.getNamePool().getDisplayName(n));
        this.nextReceiver.attribute(n, n2, charSequence, n3, n4);
    }

    public void characters(CharSequence charSequence, int n, int n2) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " CHARACTERS " + (Whitespace.isWhite(charSequence) ? "(whitespace)" : ""));
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() * 3);
        for (int i = 0; i < charSequence.length(); ++i) {
            fastStringBuffer.append(charSequence.charAt(i) + " ");
        }
        System.err.println("    \"" + fastStringBuffer + '\"');
        this.nextReceiver.characters(charSequence, n, n2);
    }

    public void close() throws XPathException {
        System.err.println("RCVR " + id + this.indent + " CLOSE");
        this.nextReceiver.close();
    }

    public void comment(CharSequence charSequence, int n, int n2) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " COMMENT");
        this.nextReceiver.comment(charSequence, n, n2);
    }

    public void endDocument() throws XPathException {
        System.err.println("RCVR " + id + this.indent + " END DOCUMENT");
        this.nextReceiver.endDocument();
    }

    public void endElement() throws XPathException {
        this.indent = this.indent.substring(2);
        System.err.println("RCVR " + id + this.indent + " END ELEMENT");
        this.nextReceiver.endElement();
    }

    public void namespace(int n, int n2) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " NAMESPACE " + this.getNamePool().getPrefixFromNamespaceCode(n) + "=" + this.getNamePool().getURIFromNamespaceCode(n));
        this.nextReceiver.namespace(n, n2);
    }

    public void open() throws XPathException {
        System.err.println("RCVR " + id + this.indent + " OPEN");
        if (this.nextReceiver == null) {
            this.nextReceiver = new Sink();
        }
        this.nextReceiver.open();
    }

    public void processingInstruction(String string, CharSequence charSequence, int n, int n2) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " PROCESSING INSTRUCTION");
        this.nextReceiver.processingInstruction(string, charSequence, n, n2);
    }

    public void startContent() throws XPathException {
        System.err.println("RCVR " + id + this.indent + " START CONTENT");
        this.nextReceiver.startContent();
    }

    public void startDocument(int n) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " START DOCUMENT");
        this.nextReceiver.startDocument(n);
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " START ELEMENT " + this.getNamePool().getDisplayName(n));
        System.err.println("RCVR " + id + this.indent + "   (Loc: sysId=" + this.getPipelineConfiguration().getLocationProvider().getSystemId(n3) + " line=" + this.getPipelineConfiguration().getLocationProvider().getLineNumber(n3) + ")");
        this.indent = this.indent + "  ";
        this.nextReceiver.startElement(n, n2, n3, n4);
    }
}

